/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.IdentityEqualityType;
import com.fasterxml.jackson.databind.type.ResolvedRecursiveType;
import com.fasterxml.jackson.databind.type.TypeBindings$AsKey;
import com.fasterxml.jackson.databind.type.TypeBindings$TypeParamStash;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TypeBindings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] NO_STRINGS = new String[0];
    private static final JavaType[] NO_TYPES = new JavaType[0];
    private static final TypeBindings EMPTY = new TypeBindings(NO_STRINGS, NO_TYPES, null);
    private final String[] _names;
    private final JavaType[] _types;
    private final String[] _unboundVariables;
    private final int _hashCode;

    private TypeBindings(String[] stringArray, JavaType[] javaTypeArray, String[] stringArray2) {
        this._names = stringArray == null ? NO_STRINGS : stringArray;
        JavaType[] javaTypeArray2 = this._types = javaTypeArray == null ? NO_TYPES : javaTypeArray;
        if (this._names.length != this._types.length) {
            throw new IllegalArgumentException("Mismatching names (" + this._names.length + "), types (" + this._types.length + ")");
        }
        this._unboundVariables = stringArray2;
        this._hashCode = Arrays.hashCode(this._types);
    }

    public static TypeBindings emptyBindings() {
        return EMPTY;
    }

    protected Object readResolve() {
        if (this._names == null || this._names.length == 0) {
            return EMPTY;
        }
        return this;
    }

    public static TypeBindings create(Class<?> clazz, List<JavaType> javaTypeArray) {
        javaTypeArray = javaTypeArray == null || javaTypeArray.isEmpty() ? NO_TYPES : javaTypeArray.toArray(NO_TYPES);
        return TypeBindings.create(clazz, javaTypeArray);
    }

    public static TypeBindings create(Class<?> clazz, JavaType[] javaTypeArray) {
        String[] stringArray;
        if (javaTypeArray == null) {
            javaTypeArray = NO_TYPES;
        } else {
            switch (javaTypeArray.length) {
                case 1: {
                    return TypeBindings.create(clazz, javaTypeArray[0]);
                }
                case 2: {
                    return TypeBindings.create(clazz, javaTypeArray[0], javaTypeArray[1]);
                }
            }
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray == null || typeVariableArray.length == 0) {
            stringArray = NO_STRINGS;
        } else {
            int n2 = typeVariableArray.length;
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = typeVariableArray[i2].getName();
            }
        }
        if (stringArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with " + javaTypeArray.length + " type parameter" + (javaTypeArray.length == 1 ? "" : "s") + ": class expects " + stringArray.length);
        }
        return new TypeBindings(stringArray, javaTypeArray, null);
    }

    public static TypeBindings create(Class<?> clazz, JavaType javaType) {
        TypeVariable<?>[] typeVariableArray = TypeBindings$TypeParamStash.paramsFor1(clazz);
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 != 1) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 1 type parameter: class expects " + n2);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName()}, new JavaType[]{javaType}, null);
    }

    public static TypeBindings create(Class<?> clazz, JavaType javaType, JavaType javaType2) {
        TypeVariable<?>[] typeVariableArray = TypeBindings$TypeParamStash.paramsFor2(clazz);
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 != 2) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 2 type parameters: class expects " + n2);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName(), typeVariableArray[1].getName()}, new JavaType[]{javaType, javaType2}, null);
    }

    public static TypeBindings create(List<String> list, List<JavaType> list2) {
        if (list == null || list.isEmpty() || list2 == null || list2.isEmpty()) {
            return EMPTY;
        }
        return new TypeBindings(list.toArray(NO_STRINGS), list2.toArray(NO_TYPES), null);
    }

    public static TypeBindings createIfNeeded(Class<?> clazz, JavaType javaType) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 == 0) {
            return EMPTY;
        }
        if (n2 != 1) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 1 type parameter: class expects " + n2);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName()}, new JavaType[]{javaType}, null);
    }

    public static TypeBindings createIfNeeded(Class<?> clazz, JavaType[] javaTypeArray) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray == null || typeVariableArray.length == 0) {
            return EMPTY;
        }
        if (javaTypeArray == null) {
            javaTypeArray = NO_TYPES;
        }
        int n2 = typeVariableArray.length;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = typeVariableArray[i2].getName();
        }
        if (stringArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with " + javaTypeArray.length + " type parameter" + (javaTypeArray.length == 1 ? "" : "s") + ": class expects " + stringArray.length);
        }
        return new TypeBindings(stringArray, javaTypeArray, null);
    }

    public TypeBindings withUnboundVariable(String string) {
        int n2 = this._unboundVariables == null ? 0 : this._unboundVariables.length;
        String[] stringArray = n2 == 0 ? new String[1] : Arrays.copyOf(this._unboundVariables, n2 + 1);
        String[] stringArray2 = stringArray;
        stringArray[n2] = string;
        return new TypeBindings(this._names, this._types, stringArray2);
    }

    public TypeBindings withoutVariable(String string) {
        int n2 = Arrays.asList(this._names).indexOf(string);
        if (n2 == -1) {
            return this;
        }
        JavaType[] javaTypeArray = (JavaType[])this._types.clone();
        JavaType[] javaTypeArray2 = javaTypeArray;
        javaTypeArray[n2] = null;
        return new TypeBindings(this._names, javaTypeArray2, this._unboundVariables);
    }

    public JavaType findBoundType(String object) {
        int n2 = this._names.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((String)object).equals(this._names[i2])) continue;
            object = this._types[i2];
            if (object instanceof ResolvedRecursiveType) {
                JavaType javaType = (ResolvedRecursiveType)object;
                if ((javaType = javaType.getSelfReferencedType()) != null) {
                    object = javaType;
                }
            }
            return object;
        }
        return null;
    }

    private boolean invalidCacheKey() {
        JavaType[] javaTypeArray = this._types;
        int n2 = this._types.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType javaType = javaTypeArray[i2];
            if (!(javaType instanceof IdentityEqualityType)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this._types.length == 0;
    }

    public int size() {
        return this._types.length;
    }

    public String getBoundName(int n2) {
        if (n2 < 0 || n2 >= this._names.length) {
            return null;
        }
        return this._names[n2];
    }

    public JavaType getBoundType(int n2) {
        if (n2 < 0 || n2 >= this._types.length) {
            return null;
        }
        JavaType javaType = this._types[n2];
        if (javaType == null) {
            javaType = TypeFactory.unknownType();
        }
        return javaType;
    }

    public JavaType getBoundTypeOrNull(int n2) {
        if (n2 < 0 || n2 >= this._types.length) {
            return null;
        }
        return this._types[n2];
    }

    public List<JavaType> getTypeParameters() {
        if (this._types.length == 0) {
            return Collections.emptyList();
        }
        List<JavaType> list = Arrays.asList(this._types);
        if (list.contains(null)) {
            list = new ArrayList<JavaType>(list);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2) != null) continue;
                list.set(i2, TypeFactory.unknownType());
            }
        }
        return list;
    }

    public boolean hasUnbound(String string) {
        if (this._unboundVariables != null) {
            int n2 = this._unboundVariables.length;
            while (--n2 >= 0) {
                if (!string.equals(this._unboundVariables[n2])) continue;
                return true;
            }
        }
        return false;
    }

    public Object asKey(Class<?> clazz) {
        if (this.invalidCacheKey()) {
            return null;
        }
        return new TypeBindings$AsKey(clazz, this._types, this._hashCode);
    }

    public String toString() {
        if (this._types.length == 0) {
            return "<>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        int n2 = this._types.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType javaType;
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            if ((javaType = this._types[i2]) == null) {
                stringBuilder.append("?");
                continue;
            }
            stringBuilder.append(javaType.getGenericSignature());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        object = (TypeBindings)object;
        return this._hashCode == ((TypeBindings)object)._hashCode && Arrays.equals(this._types, ((TypeBindings)object)._types);
    }

    protected JavaType[] typeParameterArray() {
        return this._types;
    }
}

