/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeParser$MyTokenizer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TypeParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int MAX_TYPE_LENGTH = 64000;
    protected static final int MAX_TYPE_NESTING = 1000;
    protected final TypeFactory _factory;

    public TypeParser(TypeFactory typeFactory) {
        this._factory = typeFactory;
    }

    public TypeParser withFactory(TypeFactory typeFactory) {
        if (typeFactory == this._factory) {
            return this;
        }
        return new TypeParser(typeFactory);
    }

    public JavaType parse(String object) throws IllegalArgumentException {
        if (((String)object).length() > 64000) {
            throw new IllegalArgumentException(String.format("Failed to parse type %s: too long (%d characters), maximum length allowed: %d", TypeParser._quoteTruncated((String)object), ((String)object).length(), 64000));
        }
        object = new TypeParser$MyTokenizer(((String)object).trim());
        JavaType javaType = this.parseType((TypeParser$MyTokenizer)object, 1000);
        if (((TypeParser$MyTokenizer)object).hasMoreTokens()) {
            throw this._problem((TypeParser$MyTokenizer)object, "Unexpected tokens after complete type");
        }
        return javaType;
    }

    protected JavaType parseType(TypeParser$MyTokenizer object, int n2) throws IllegalArgumentException {
        if (!((TypeParser$MyTokenizer)object).hasMoreTokens()) {
            throw this._problem((TypeParser$MyTokenizer)object, "Unexpected end-of-string");
        }
        Class<?> clazz = this.findClass(((TypeParser$MyTokenizer)object).nextToken(), (TypeParser$MyTokenizer)object);
        if (((TypeParser$MyTokenizer)object).hasMoreTokens()) {
            String string = ((TypeParser$MyTokenizer)object).nextToken();
            if ("<".equals(string)) {
                object = this.parseTypes((TypeParser$MyTokenizer)object, n2 - 1);
                object = TypeBindings.create(clazz, (List<JavaType>)object);
                return this._factory._fromClass(null, clazz, (TypeBindings)object);
            }
            ((TypeParser$MyTokenizer)object).pushBack(string);
        }
        return this._factory._fromClass(null, clazz, TypeBindings.emptyBindings());
    }

    protected List<JavaType> parseTypes(TypeParser$MyTokenizer typeParser$MyTokenizer, int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw this._problem(typeParser$MyTokenizer, "too deeply nested; exceeds maximum of 1000 nesting levels");
        }
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        while (typeParser$MyTokenizer.hasMoreTokens()) {
            arrayList.add(this.parseType(typeParser$MyTokenizer, n2));
            if (!typeParser$MyTokenizer.hasMoreTokens()) break;
            String string = typeParser$MyTokenizer.nextToken();
            if (">".equals(string)) {
                return arrayList;
            }
            if (",".equals(string)) continue;
            throw this._problem(typeParser$MyTokenizer, "Unexpected token '" + string + "', expected ',' or '>')");
        }
        throw this._problem(typeParser$MyTokenizer, "Unexpected end-of-string");
    }

    protected Class<?> findClass(String string, TypeParser$MyTokenizer typeParser$MyTokenizer) {
        try {
            return this._factory.findClass(string);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ClassUtil.throwIfRTE(exception);
            throw this._problem(typeParser$MyTokenizer, "Cannot locate class '" + string + "', problem: " + exception2.getMessage());
        }
    }

    protected IllegalArgumentException _problem(TypeParser$MyTokenizer typeParser$MyTokenizer, String string) {
        return new IllegalArgumentException(String.format("Failed to parse type %s (remaining: %s): %s", TypeParser._quoteTruncated(typeParser$MyTokenizer.getAllInput()), TypeParser._quoteTruncated(typeParser$MyTokenizer.getRemainingInput()), string));
    }

    private static String _quoteTruncated(String string) {
        if (string.length() <= 1000) {
            return "'" + string + "'";
        }
        return String.format("'%s...'[truncated %d charaters]", string.substring(0, 1000), string.length() - 1000);
    }
}

