/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;

public final class EnumValues
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;
    private transient EnumMap<?, SerializableString> _asMap;

    private EnumValues(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        this._enumClass = clazz;
        this._values = clazz.getEnumConstants();
        this._textual = serializableStringArray;
    }

    public static EnumValues construct(SerializationConfig serializationConfig, AnnotatedClass annotatedClass) {
        if (serializationConfig.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            return EnumValues.constructFromToString(serializationConfig, annotatedClass);
        }
        return EnumValues.constructFromName(serializationConfig, annotatedClass);
    }

    @Deprecated
    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        String[] stringArray = ClassUtil.findEnumType(clazz);
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Enum<?>[] enumArray = stringArray.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        stringArray = mapperConfig.getAnnotationIntrospector().findEnumValues((Class<?>)stringArray, enumArray, new String[enumArray.length]);
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = EnumValues._findNameToUse(stringArray[i2], enumArray[i2].name(), bl2);
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, AnnotatedClass stringArray) {
        SerializableString[] serializableStringArray = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Enum<?>[] enumArray = stringArray.getRawType();
        Class<Enum<?>> clazz = EnumValues._enumClass(enumArray);
        enumArray = EnumValues._enumConstants(enumArray);
        stringArray = serializableStringArray.findEnumValues(mapperConfig, (AnnotatedClass)stringArray, enumArray, new String[enumArray.length]);
        serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = EnumValues._findNameToUse(stringArray[i2], enum_.name(), bl2);
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, AnnotatedClass serializableStringArray) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Enum<?>[] enumArray = serializableStringArray.getRawType();
        Class<Enum<?>> clazz = EnumValues._enumClass(enumArray);
        enumArray = EnumValues._enumConstants(enumArray);
        String[] stringArray = new String[enumArray.length];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(mapperConfig, (AnnotatedClass)serializableStringArray, enumArray, stringArray);
        }
        serializableStringArray = new SerializableString[enumArray.length];
        for (int i2 = 0; i2 < enumArray.length; ++i2) {
            String string = enumArray[i2].toString();
            string = string == null ? "" : string;
            string = EnumValues._findNameToUse(stringArray[i2], string, bl2);
            serializableStringArray[i2] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    @Deprecated
    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz);
        if ((enumArray = enumArray.getEnumConstants()) == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum<?> enum_ : enumArray) {
            arrayList.add(enum_.toString());
        }
        return EnumValues.construct(mapperConfig, clazz, arrayList);
    }

    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass serializableStringArray, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Enum<?>[] enumArray = serializableStringArray.getRawType();
        Class<Enum<?>> clazz = EnumValues._enumClass(enumArray);
        enumArray = EnumValues._enumConstants(enumArray);
        String[] stringArray = new String[enumArray.length];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(mapperConfig, (AnnotatedClass)serializableStringArray, enumArray, stringArray);
        }
        serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = enumArray[i2];
            object = EnumValues._findNameToUse(stringArray[i2], enumNamingStrategy.convertEnumToExternalName(((Enum)object).name()), bl2);
            serializableStringArray[i2] = mapperConfig.compileString((String)object);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    @Deprecated
    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, EnumNamingStrategy enumNamingStrategy) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz);
        if ((enumArray = enumArray.getEnumConstants()) == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum<?> enum_ : enumArray) {
            arrayList.add(enumNamingStrategy.convertEnumToExternalName(enum_.name()));
        }
        return EnumValues.construct(mapperConfig, clazz, arrayList);
    }

    public static EnumValues construct(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, List<String> list) {
        int n2 = list.size();
        SerializableString[] serializableStringArray = new SerializableString[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            serializableStringArray[i2] = mapperConfig.compileString(list.get(i2));
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues construct(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        return new EnumValues(clazz, serializableStringArray);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    protected static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz).getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        return enumArray;
    }

    protected static String _findNameToUse(String string, String string2, boolean bl2) {
        if (string != null) {
            return string;
        }
        if (bl2) {
            return string2.toLowerCase();
        }
        return string2;
    }

    public final SerializableString serializedValueFor(Enum<?> enum_) {
        return this._textual[enum_.ordinal()];
    }

    public final Collection<SerializableString> values() {
        return Arrays.asList(this._textual);
    }

    public final List<Enum<?>> enums() {
        return Arrays.asList(this._values);
    }

    public final EnumMap<?, SerializableString> internalMap() {
        AbstractMap abstractMap = this._asMap;
        if (abstractMap == null) {
            abstractMap = new LinkedHashMap();
            Enum<?>[] enumArray = this._values;
            int n2 = this._values.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Enum<?> enum_ = enumArray[i2];
                abstractMap.put(enum_, (SerializableString)this._textual[enum_.ordinal()]);
            }
            abstractMap = new EnumMap(abstractMap);
            this._asMap = abstractMap;
        }
        return abstractMap;
    }

    public final Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

