/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonParser$NumberTypeFP;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.TokenBuffer$Segment;
import com.fasterxml.jackson.databind.util.TokenBufferReadContext;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class TokenBuffer$Parser
extends ParserMinimalBase {
    protected ObjectCodec _codec;
    protected final boolean _hasNativeTypeIds;
    protected final boolean _hasNativeObjectIds;
    protected final boolean _hasNativeIds;
    protected TokenBuffer$Segment _segment;
    protected int _segmentPtr;
    protected TokenBufferReadContext _parsingContext;
    protected boolean _closed;
    protected transient ByteArrayBuilder _byteBuilder;
    protected JsonLocation _location = null;

    @Deprecated
    public TokenBuffer$Parser(TokenBuffer$Segment segment, ObjectCodec objectCodec, boolean bl2, boolean bl3) {
        this(segment, objectCodec, bl2, bl3, null);
    }

    @Deprecated
    public TokenBuffer$Parser(TokenBuffer$Segment segment, ObjectCodec objectCodec, boolean bl2, boolean bl3, JsonStreamContext jsonStreamContext) {
        this(segment, objectCodec, bl2, bl3, jsonStreamContext, StreamReadConstraints.defaults());
    }

    public TokenBuffer$Parser(TokenBuffer$Segment segment, ObjectCodec objectCodec, boolean bl2, boolean bl3, JsonStreamContext jsonStreamContext, StreamReadConstraints streamReadConstraints) {
        super(streamReadConstraints);
        this._segment = segment;
        this._segmentPtr = -1;
        this._codec = objectCodec;
        this._parsingContext = TokenBufferReadContext.createRootContext(jsonStreamContext);
        this._hasNativeTypeIds = bl2;
        this._hasNativeObjectIds = bl3;
        this._hasNativeIds = bl2 || bl3;
    }

    public final void setLocation(JsonLocation jsonLocation) {
        this._location = jsonLocation;
    }

    @Override
    public final ObjectCodec getCodec() {
        return this._codec;
    }

    @Override
    public final void setCodec(ObjectCodec objectCodec) {
        this._codec = objectCodec;
    }

    @Override
    public final Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public final JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public final StreamReadConstraints streamReadConstraints() {
        return this._streamReadConstraints;
    }

    public final JsonToken peekNextToken() throws IOException {
        if (this._closed) {
            return null;
        }
        TokenBuffer$Segment tokenBuffer$Segment = this._segment;
        int n2 = this._segmentPtr + 1;
        if (n2 >= 16) {
            n2 = 0;
            TokenBuffer$Segment tokenBuffer$Segment2 = tokenBuffer$Segment = tokenBuffer$Segment == null ? null : tokenBuffer$Segment.next();
        }
        if (tokenBuffer$Segment == null) {
            return null;
        }
        return tokenBuffer$Segment.type(n2);
    }

    @Override
    public final void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
        }
    }

    @Override
    public final JsonToken nextToken() throws IOException {
        if (this._closed || this._segment == null) {
            return null;
        }
        if (++this._segmentPtr >= 16) {
            this._segmentPtr = 0;
            this._segment = this._segment.next();
            if (this._segment == null) {
                return null;
            }
        }
        TokenBuffer$Parser tokenBuffer$Parser = this;
        tokenBuffer$Parser._updateToken(tokenBuffer$Parser._segment.type(this._segmentPtr));
        if (this._currToken == JsonToken.FIELD_NAME) {
            Object object = this._currentObject();
            object = object instanceof String ? (String)object : object.toString();
            this._parsingContext.setCurrentName((String)object);
        } else if (this._currToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext();
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext();
        } else if (this._currToken == JsonToken.END_OBJECT || this._currToken == JsonToken.END_ARRAY) {
            this._parsingContext = this._parsingContext.parentOrCopy();
        } else {
            this._parsingContext.updateForValue();
        }
        return this._currToken;
    }

    @Override
    public final String nextFieldName() throws IOException {
        if (this._closed || this._segment == null) {
            return null;
        }
        int n2 = this._segmentPtr + 1;
        if (n2 < 16 && this._segment.type(n2) == JsonToken.FIELD_NAME) {
            this._segmentPtr = n2;
            this._updateToken(JsonToken.FIELD_NAME);
            Object object = this._segment.get(n2);
            object = object instanceof String ? (String)object : object.toString();
            this._parsingContext.setCurrentName((String)object);
            return object;
        }
        if (((JsonParser)this).nextToken() == JsonToken.FIELD_NAME) {
            return ((JsonParser)this).currentName();
        }
        return null;
    }

    @Override
    public final boolean isClosed() {
        return this._closed;
    }

    @Override
    public final JsonStreamContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public final JsonLocation currentLocation() {
        if (this._location == null) {
            return JsonLocation.NA;
        }
        return this._location;
    }

    @Override
    public final JsonLocation currentTokenLocation() {
        return ((JsonParser)this).currentLocation();
    }

    @Override
    @Deprecated
    public final JsonLocation getTokenLocation() {
        return ((JsonParser)this).currentTokenLocation();
    }

    @Override
    @Deprecated
    public final JsonLocation getCurrentLocation() {
        return ((JsonParser)this).currentLocation();
    }

    @Override
    public final String currentName() {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            JsonStreamContext jsonStreamContext = ((JsonStreamContext)this._parsingContext).getParent();
            return jsonStreamContext.getCurrentName();
        }
        return ((JsonStreamContext)this._parsingContext).getCurrentName();
    }

    @Override
    public final void overrideCurrentName(String string) {
        JsonStreamContext jsonStreamContext = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            jsonStreamContext = jsonStreamContext.getParent();
        }
        if (jsonStreamContext instanceof TokenBufferReadContext) {
            try {
                ((TokenBufferReadContext)jsonStreamContext).setCurrentName(string);
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    @Deprecated
    public final String getCurrentName() {
        return ((JsonParser)this).currentName();
    }

    @Override
    public final String getText() {
        if (this._currToken == JsonToken.VALUE_STRING || this._currToken == JsonToken.FIELD_NAME) {
            Object object = this._currentObject();
            if (object instanceof String) {
                return (String)object;
            }
            return ClassUtil.nullOrToString(object);
        }
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return ClassUtil.nullOrToString(this._currentObject());
            }
        }
        return this._currToken.asString();
    }

    @Override
    public final char[] getTextCharacters() {
        String string = ((JsonParser)this).getText();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    @Override
    public final int getTextLength() {
        String string = ((JsonParser)this).getText();
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    @Override
    public final int getTextOffset() {
        return 0;
    }

    @Override
    public final boolean hasTextCharacters() {
        return false;
    }

    @Override
    public final boolean isNaN() {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            Object object = this._currentObject();
            if (object instanceof Double) {
                double d2 = (Double)object;
                return !Double.isFinite(d2);
            }
            if (object instanceof Float) {
                float f2 = ((Float)object).floatValue();
                return !Double.isFinite(f2);
            }
        }
        return false;
    }

    @Override
    public final BigInteger getBigIntegerValue() throws IOException {
        Number number = this.getNumberValue(true);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            number = (BigDecimal)number;
            ((JsonParser)this).streamReadConstraints().validateBigIntegerScale(((BigDecimal)number).scale());
            return ((BigDecimal)number).toBigInteger();
        }
        return BigInteger.valueOf(number.longValue());
    }

    @Override
    public final BigDecimal getDecimalValue() throws IOException {
        Number number = this.getNumberValue(true);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Integer) {
            return BigDecimal.valueOf(number.intValue());
        }
        if (number instanceof Long) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return BigDecimal.valueOf(number.doubleValue());
    }

    @Override
    public final double getDoubleValue() throws IOException {
        return ((JsonParser)this).getNumberValue().doubleValue();
    }

    @Override
    public final float getFloatValue() throws IOException {
        return ((JsonParser)this).getNumberValue().floatValue();
    }

    @Override
    public final int getIntValue() throws IOException {
        Number number = this.getNumberValue(false);
        if (number instanceof Integer || this._smallerThanInt(number)) {
            return number.intValue();
        }
        return this._convertNumberToInt(number);
    }

    @Override
    public final long getLongValue() throws IOException {
        Number number = this.getNumberValue(false);
        if (number instanceof Long || this._smallerThanLong(number)) {
            return number.longValue();
        }
        return this._convertNumberToLong(number);
    }

    @Override
    public final JsonParser$NumberType getNumberType() throws IOException {
        Object object = ((JsonParser)this).getNumberValueDeferred();
        if (object instanceof Integer) {
            return JsonParser$NumberType.INT;
        }
        if (object instanceof Long) {
            return JsonParser$NumberType.LONG;
        }
        if (object instanceof Double) {
            return JsonParser$NumberType.DOUBLE;
        }
        if (object instanceof BigDecimal) {
            return JsonParser$NumberType.BIG_DECIMAL;
        }
        if (object instanceof BigInteger) {
            return JsonParser$NumberType.BIG_INTEGER;
        }
        if (object instanceof Float) {
            return JsonParser$NumberType.FLOAT;
        }
        if (object instanceof Short) {
            return JsonParser$NumberType.INT;
        }
        if (object instanceof String) {
            if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                return JsonParser$NumberType.BIG_DECIMAL;
            }
            return JsonParser$NumberType.BIG_INTEGER;
        }
        return null;
    }

    @Override
    public final JsonParser$NumberTypeFP getNumberTypeFP() throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            Object object = this._currentObject();
            if (object instanceof Double) {
                return JsonParser$NumberTypeFP.DOUBLE64;
            }
            if (object instanceof BigDecimal) {
                return JsonParser$NumberTypeFP.BIG_DECIMAL;
            }
            if (object instanceof Float) {
                return JsonParser$NumberTypeFP.FLOAT32;
            }
        }
        return JsonParser$NumberTypeFP.UNKNOWN;
    }

    @Override
    public final Number getNumberValue() throws IOException {
        return this.getNumberValue(false);
    }

    @Override
    public final Object getNumberValueDeferred() throws IOException {
        this._checkIsNumber();
        return this._currentObject();
    }

    private Number getNumberValue(boolean bl2) throws IOException {
        this._checkIsNumber();
        Object object = this._currentObject();
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            object = (String)object;
            int n2 = ((String)object).length();
            if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
                if (bl2 || n2 >= 19) {
                    return NumberInput.parseBigInteger((String)object, this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                }
                if (n2 >= 10) {
                    return NumberInput.parseLong((String)object);
                }
                return NumberInput.parseInt((String)object);
            }
            if (bl2) {
                BigDecimal bigDecimal = NumberInput.parseBigDecimal((String)object, this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                if (bigDecimal == null) {
                    throw new IllegalStateException("Internal error: failed to parse number '" + (String)object + "'");
                }
                return bigDecimal;
            }
            return NumberInput.parseDouble((String)object, this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
        }
        throw new IllegalStateException("Internal error: entry should be a Number, but is of type " + ClassUtil.classNameOf(object));
    }

    private final boolean _smallerThanInt(Number number) {
        return number instanceof Short || number instanceof Byte;
    }

    private final boolean _smallerThanLong(Number number) {
        return number instanceof Integer || number instanceof Short || number instanceof Byte;
    }

    protected final int _convertNumberToInt(Number number) throws IOException {
        if (number instanceof Long) {
            long l2 = number.longValue();
            int n2 = (int)l2;
            if ((long)n2 != l2) {
                this.reportOverflowInt();
            }
            return n2;
        }
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            if (BI_MIN_INT.compareTo(bigInteger) > 0 || BI_MAX_INT.compareTo(bigInteger) < 0) {
                this.reportOverflowInt();
            }
        } else {
            if (number instanceof Double || number instanceof Float) {
                double d2 = number.doubleValue();
                if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                    this.reportOverflowInt();
                }
                return (int)d2;
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)number;
                if (BD_MIN_INT.compareTo(bigDecimal) > 0 || BD_MAX_INT.compareTo(bigDecimal) < 0) {
                    this.reportOverflowInt();
                }
            } else {
                this._throwInternal();
            }
        }
        return number.intValue();
    }

    protected final long _convertNumberToLong(Number number) throws IOException {
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            if (BI_MIN_LONG.compareTo(bigInteger) > 0 || BI_MAX_LONG.compareTo(bigInteger) < 0) {
                this.reportOverflowLong();
            }
        } else {
            if (number instanceof Double || number instanceof Float) {
                double d2 = number.doubleValue();
                if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                    this.reportOverflowLong();
                }
                return (long)d2;
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)number;
                if (BD_MIN_LONG.compareTo(bigDecimal) > 0 || BD_MAX_LONG.compareTo(bigDecimal) < 0) {
                    this.reportOverflowLong();
                }
            } else {
                this._throwInternal();
            }
        }
        return number.longValue();
    }

    @Override
    public final Object getEmbeddedObject() {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._currentObject();
        }
        return null;
    }

    @Override
    public final byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        Object object;
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && (object = this._currentObject()) instanceof byte[]) {
            return (byte[])object;
        }
        if (this._currToken != JsonToken.VALUE_STRING) {
            throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), cannot access as binary");
        }
        object = ((JsonParser)this).getText();
        if (object == null) {
            return null;
        }
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(100);
        } else {
            this._byteBuilder.reset();
        }
        this._decodeBase64((String)object, byteArrayBuilder, base64Variant);
        return byteArrayBuilder.toByteArray();
    }

    @Override
    public final int readBinaryValue(Base64Variant object, OutputStream outputStream) throws IOException {
        byte[] byArray = ((JsonParser)this).getBinaryValue((Base64Variant)object);
        object = byArray;
        if (byArray != null) {
            outputStream.write((byte[])object, 0, ((Object)object).length);
            return ((Object)object).length;
        }
        return 0;
    }

    @Override
    public final boolean canReadObjectId() {
        return this._hasNativeObjectIds;
    }

    @Override
    public final boolean canReadTypeId() {
        return this._hasNativeTypeIds;
    }

    @Override
    public final Object getTypeId() {
        return this._segment.findTypeId(this._segmentPtr);
    }

    @Override
    public final Object getObjectId() {
        return this._segment.findObjectId(this._segmentPtr);
    }

    protected final Object _currentObject() {
        return this._segment.get(this._segmentPtr);
    }

    protected final void _checkIsNumber() throws JacksonException {
        if (this._currToken == null || !this._currToken.isNumeric()) {
            throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, cannot use numeric value accessors");
        }
    }

    @Override
    protected final void _handleEOF() {
        this._throwInternal();
    }
}

