/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util.internal;

import com.fasterxml.jackson.databind.util.internal.LinkedDeque;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$AddTask;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$Builder;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$DrainStatus;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$EntrySet;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$KeySet;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$Node;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$RemovalTask;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$SerializationProxy;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$UpdateTask;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$Values;
import com.fasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap$WeightedValue;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class PrivateMaxEntriesMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = Math.min(4, PrivateMaxEntriesMap.ceilingNextPowerOfTwo(NCPU));
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 4;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 8;
    static final int READ_BUFFER_SIZE = 16;
    static final int READ_BUFFER_INDEX_MASK = 15;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    final ConcurrentMap<K, PrivateMaxEntriesMap$Node<K, V>> data;
    final int concurrencyLevel;
    final long[] readBufferReadCount;
    final LinkedDeque<PrivateMaxEntriesMap$Node<K, V>> evictionDeque;
    final AtomicLong weightedSize;
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLongArray readBufferWriteCount;
    final AtomicLongArray readBufferDrainAtWriteCount;
    final AtomicReferenceArray<PrivateMaxEntriesMap$Node<K, V>> readBuffers;
    final AtomicReference<PrivateMaxEntriesMap$DrainStatus> drainStatus;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private static int readBufferIndex(int n2, int n3) {
        return n2 * 16 + n3;
    }

    PrivateMaxEntriesMap(PrivateMaxEntriesMap$Builder<K, V> privateMaxEntriesMap$Builder) {
        this.concurrencyLevel = privateMaxEntriesMap$Builder.concurrencyLevel;
        this.capacity = new AtomicLong(Math.min(privateMaxEntriesMap$Builder.capacity, 9223372034707292160L));
        this.data = new ConcurrentHashMap<K, PrivateMaxEntriesMap$Node<K, V>>(privateMaxEntriesMap$Builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.evictionLock = new ReentrantLock();
        this.weightedSize = new AtomicLong();
        this.evictionDeque = new LinkedDeque();
        this.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        this.drainStatus = new AtomicReference<PrivateMaxEntriesMap$DrainStatus>(PrivateMaxEntriesMap$DrainStatus.IDLE);
        this.readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
        this.readBufferWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBufferDrainAtWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBuffers = new AtomicReferenceArray(NUMBER_OF_READ_BUFFERS << 4);
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public final long capacity() {
        return this.capacity.get();
    }

    public final void setCapacity(long l2) {
        PrivateMaxEntriesMap.checkArgument(l2 >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            this.drainBuffers();
            this.evict();
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    final boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    final void evict() {
        while (this.hasOverflowed()) {
            PrivateMaxEntriesMap$Node privateMaxEntriesMap$Node = (PrivateMaxEntriesMap$Node)this.evictionDeque.poll();
            if (privateMaxEntriesMap$Node == null) {
                return;
            }
            this.data.remove(privateMaxEntriesMap$Node.key, privateMaxEntriesMap$Node);
            this.makeDead(privateMaxEntriesMap$Node);
        }
    }

    final void afterRead(PrivateMaxEntriesMap$Node<K, V> privateMaxEntriesMap$Node) {
        int n2 = PrivateMaxEntriesMap.readBufferIndex();
        long l2 = this.recordRead(n2, privateMaxEntriesMap$Node);
        this.drainOnReadIfNeeded(n2, l2);
    }

    static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    final long recordRead(int n2, PrivateMaxEntriesMap$Node<K, V> privateMaxEntriesMap$Node) {
        long l2 = this.readBufferWriteCount.get(n2);
        this.readBufferWriteCount.lazySet(n2, l2 + 1L);
        int n3 = (int)(l2 & 0xFL);
        this.readBuffers.lazySet(PrivateMaxEntriesMap.readBufferIndex(n2, n3), privateMaxEntriesMap$Node);
        return l2;
    }

    final void drainOnReadIfNeeded(int n2, long l2) {
        long l3 = l2 - this.readBufferDrainAtWriteCount.get(n2);
        n2 = l3 < 4L ? 1 : 0;
        PrivateMaxEntriesMap$DrainStatus privateMaxEntriesMap$DrainStatus = this.drainStatus.get();
        if (privateMaxEntriesMap$DrainStatus.shouldDrainBuffers(n2 != 0)) {
            this.tryToDrainBuffers();
        }
    }

    final void afterWrite(Runnable runnable) {
        this.writeBuffer.add(runnable);
        this.drainStatus.lazySet(PrivateMaxEntriesMap$DrainStatus.REQUIRED);
        this.tryToDrainBuffers();
    }

    final void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(PrivateMaxEntriesMap$DrainStatus.PROCESSING);
                this.drainBuffers();
                return;
            }
            finally {
                this.drainStatus.compareAndSet(PrivateMaxEntriesMap$DrainStatus.PROCESSING, PrivateMaxEntriesMap$DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    final void drainBuffers() {
        this.drainReadBuffers();
        this.drainWriteBuffer();
    }

    final void drainReadBuffers() {
        int n2 = (int)Thread.currentThread().getId();
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        while (n2 < n3) {
            this.drainReadBuffer(n2 & READ_BUFFERS_MASK);
            ++n2;
        }
    }

    final void drainReadBuffer(int n2) {
        long l2 = this.readBufferWriteCount.get(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = (int)(this.readBufferReadCount[n2] & 0xFL);
            PrivateMaxEntriesMap$Node<K, V> privateMaxEntriesMap$Node = this.readBuffers.get(n3 = PrivateMaxEntriesMap.readBufferIndex(n2, n3));
            if (privateMaxEntriesMap$Node == null) break;
            this.readBuffers.lazySet(n3, null);
            this.applyRead(privateMaxEntriesMap$Node);
            int n4 = n2;
            this.readBufferReadCount[n4] = this.readBufferReadCount[n4] + 1L;
        }
        this.readBufferDrainAtWriteCount.lazySet(n2, l2);
    }

    final void applyRead(PrivateMaxEntriesMap$Node<K, V> privateMaxEntriesMap$Node) {
        if (this.evictionDeque.contains(privateMaxEntriesMap$Node)) {
            this.evictionDeque.moveToBack(privateMaxEntriesMap$Node);
        }
    }

    final void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    final boolean tryToRetire(PrivateMaxEntriesMap$Node<K, V> privateMaxEntriesMap$Node, PrivateMaxEntriesMap$WeightedValue<V> privateMaxEntriesMap$WeightedValue) {
        if (privateMaxEntriesMap$WeightedValue.isAlive()) {
            PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue2 = new PrivateMaxEntriesMap$WeightedValue(privateMaxEntriesMap$WeightedValue.value, -privateMaxEntriesMap$WeightedValue.weight);
            return privateMaxEntriesMap$Node.compareAndSet(privateMaxEntriesMap$WeightedValue, privateMaxEntriesMap$WeightedValue2);
        }
        return false;
    }

    final void makeRetired(PrivateMaxEntriesMap$Node<K, V> privateMaxEntriesMap$Node) {
        PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue;
        PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue2;
        do {
            if ((privateMaxEntriesMap$WeightedValue2 = (PrivateMaxEntriesMap$WeightedValue)privateMaxEntriesMap$Node.get()).isAlive()) continue;
            return;
        } while (!privateMaxEntriesMap$Node.compareAndSet(privateMaxEntriesMap$WeightedValue2, privateMaxEntriesMap$WeightedValue = new PrivateMaxEntriesMap$WeightedValue(privateMaxEntriesMap$WeightedValue2.value, -privateMaxEntriesMap$WeightedValue2.weight)));
    }

    final void makeDead(PrivateMaxEntriesMap$Node<K, V> privateMaxEntriesMap$Node) {
        PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue;
        PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue2;
        while (!privateMaxEntriesMap$Node.compareAndSet(privateMaxEntriesMap$WeightedValue2 = (PrivateMaxEntriesMap$WeightedValue)privateMaxEntriesMap$Node.get(), privateMaxEntriesMap$WeightedValue = new PrivateMaxEntriesMap$WeightedValue(privateMaxEntriesMap$WeightedValue2.value, 0))) {
        }
        this.weightedSize.lazySet(this.weightedSize.get() - (long)Math.abs(privateMaxEntriesMap$WeightedValue2.weight));
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final void clear() {
        this.evictionLock.lock();
        try {
            Runnable runnable;
            PrivateMaxEntriesMap$Node privateMaxEntriesMap$Node;
            while ((privateMaxEntriesMap$Node = (PrivateMaxEntriesMap$Node)this.evictionDeque.poll()) != null) {
                this.data.remove(privateMaxEntriesMap$Node.key, privateMaxEntriesMap$Node);
                this.makeDead(privateMaxEntriesMap$Node);
            }
            for (int i2 = 0; i2 < this.readBuffers.length(); ++i2) {
                this.readBuffers.lazySet(i2, null);
            }
            while ((runnable = this.writeBuffer.poll()) != null) {
                runnable.run();
            }
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        PrivateMaxEntriesMap.checkNotNull(object);
        for (PrivateMaxEntriesMap$Node privateMaxEntriesMap$Node : this.data.values()) {
            if (!privateMaxEntriesMap$Node.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object object) {
        if ((object = (PrivateMaxEntriesMap$Node)this.data.get(object)) == null) {
            return null;
        }
        this.afterRead((PrivateMaxEntriesMap$Node<K, V>)object);
        return ((PrivateMaxEntriesMap$Node)object).getValue();
    }

    @Override
    public final V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public final V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    final V put(K object, V object2, boolean bl2) {
        PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue;
        PrivateMaxEntriesMap$Node<K, PrivateMaxEntriesMap$WeightedValue> privateMaxEntriesMap$Node;
        PrivateMaxEntriesMap.checkNotNull(object);
        PrivateMaxEntriesMap.checkNotNull(object2);
        object2 = new PrivateMaxEntriesMap$WeightedValue<V>(object2, 1);
        object = new PrivateMaxEntriesMap$Node(object, object2);
        block0: while (true) {
            if ((privateMaxEntriesMap$Node = this.data.putIfAbsent(((PrivateMaxEntriesMap$Node)object).key, object)) == null) {
                this.afterWrite(new PrivateMaxEntriesMap$AddTask(this, object, 1));
                return null;
            }
            if (bl2) {
                this.afterRead(privateMaxEntriesMap$Node);
                return privateMaxEntriesMap$Node.getValue();
            }
            do {
                if (!(privateMaxEntriesMap$WeightedValue = (PrivateMaxEntriesMap$WeightedValue)privateMaxEntriesMap$Node.get()).isAlive()) continue block0;
            } while (!privateMaxEntriesMap$Node.compareAndSet(privateMaxEntriesMap$WeightedValue, (PrivateMaxEntriesMap$WeightedValue)object2));
            break;
        }
        int n2 = 1 - privateMaxEntriesMap$WeightedValue.weight;
        if (n2 == 0) {
            this.afterRead(privateMaxEntriesMap$Node);
        } else {
            this.afterWrite(new PrivateMaxEntriesMap$UpdateTask(this, privateMaxEntriesMap$Node, n2));
        }
        return privateMaxEntriesMap$WeightedValue.value;
    }

    @Override
    public final V remove(Object object) {
        if ((object = (PrivateMaxEntriesMap$Node)this.data.remove(object)) == null) {
            return null;
        }
        this.makeRetired((PrivateMaxEntriesMap$Node<K, V>)object);
        this.afterWrite(new PrivateMaxEntriesMap$RemovalTask(this, object));
        return ((PrivateMaxEntriesMap$Node)object).getValue();
    }

    @Override
    public final boolean remove(Object object, Object object2) {
        PrivateMaxEntriesMap$Node privateMaxEntriesMap$Node = (PrivateMaxEntriesMap$Node)this.data.get(object);
        if (privateMaxEntriesMap$Node == null || object2 == null) {
            return false;
        }
        PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue = (PrivateMaxEntriesMap$WeightedValue)privateMaxEntriesMap$Node.get();
        while (privateMaxEntriesMap$WeightedValue.contains(object2)) {
            if (this.tryToRetire(privateMaxEntriesMap$Node, privateMaxEntriesMap$WeightedValue)) {
                if (!this.data.remove(object, privateMaxEntriesMap$Node)) break;
                this.afterWrite(new PrivateMaxEntriesMap$RemovalTask(this, privateMaxEntriesMap$Node));
                return true;
            }
            privateMaxEntriesMap$WeightedValue = (PrivateMaxEntriesMap$WeightedValue)privateMaxEntriesMap$Node.get();
            if (privateMaxEntriesMap$WeightedValue.isAlive()) continue;
        }
        return false;
    }

    @Override
    public final V replace(K object, V object2) {
        PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue;
        PrivateMaxEntriesMap.checkNotNull(object);
        PrivateMaxEntriesMap.checkNotNull(object2);
        object2 = new PrivateMaxEntriesMap$WeightedValue<V>(object2, 1);
        object = (PrivateMaxEntriesMap$Node)this.data.get(object);
        if (object == null) {
            return null;
        }
        do {
            if ((privateMaxEntriesMap$WeightedValue = (PrivateMaxEntriesMap$WeightedValue)((AtomicReference)object).get()).isAlive()) continue;
            return null;
        } while (!((AtomicReference)object).compareAndSet(privateMaxEntriesMap$WeightedValue, object2));
        int n2 = 1 - privateMaxEntriesMap$WeightedValue.weight;
        if (n2 == 0) {
            this.afterRead((PrivateMaxEntriesMap$Node<K, V>)object);
        } else {
            this.afterWrite(new PrivateMaxEntriesMap$UpdateTask(this, object, n2));
        }
        return privateMaxEntriesMap$WeightedValue.value;
    }

    @Override
    public final boolean replace(K object, V v2, V object2) {
        PrivateMaxEntriesMap$WeightedValue privateMaxEntriesMap$WeightedValue;
        PrivateMaxEntriesMap.checkNotNull(object);
        PrivateMaxEntriesMap.checkNotNull(v2);
        PrivateMaxEntriesMap.checkNotNull(object2);
        object2 = new PrivateMaxEntriesMap$WeightedValue<V>(object2, 1);
        object = (PrivateMaxEntriesMap$Node)this.data.get(object);
        if (object == null) {
            return false;
        }
        do {
            if ((privateMaxEntriesMap$WeightedValue = (PrivateMaxEntriesMap$WeightedValue)((AtomicReference)object).get()).isAlive() && privateMaxEntriesMap$WeightedValue.contains(v2)) continue;
            return false;
        } while (!((AtomicReference)object).compareAndSet(privateMaxEntriesMap$WeightedValue, object2));
        int n2 = 1 - privateMaxEntriesMap$WeightedValue.weight;
        if (n2 == 0) {
            this.afterRead((PrivateMaxEntriesMap$Node<K, V>)object);
        } else {
            this.afterWrite(new PrivateMaxEntriesMap$UpdateTask(this, object, n2));
        }
        return true;
    }

    @Override
    public final Set<K> keySet() {
        Set<K> set = this.keySet;
        if (set == null) {
            this.keySet = new PrivateMaxEntriesMap$KeySet(this);
            return this.keySet;
        }
        return set;
    }

    @Override
    public final Collection<V> values() {
        Collection<V> collection = this.values;
        if (collection == null) {
            this.values = new PrivateMaxEntriesMap$Values(this);
            return this.values;
        }
        return collection;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            this.entrySet = new PrivateMaxEntriesMap$EntrySet(this);
            return this.entrySet;
        }
        return set;
    }

    final Object writeReplace() {
        return new PrivateMaxEntriesMap$SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }
}

