/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.google.gson.internal.Excluder$1;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    public static final double IGNORE_VERSIONS = -1.0;
    public static final Excluder DEFAULT = new Excluder();
    public double version = -1.0;
    public int modifiers = 136;
    public boolean serializeInnerClasses = true;
    public boolean requireExpose;
    public List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    public List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    protected final Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public final Excluder withVersion(double d2) {
        Excluder excluder = this.clone();
        this.clone().version = d2;
        return excluder;
    }

    public final Excluder withModifiers(int ... nArray) {
        Excluder excluder = this.clone();
        this.clone().modifiers = 0;
        for (int n2 : nArray) {
            excluder.modifiers |= n2;
        }
        return excluder;
    }

    public final Excluder disableInnerClassSerialization() {
        Excluder excluder = this.clone();
        this.clone().serializeInnerClasses = false;
        return excluder;
    }

    public final Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder excluder = this.clone();
        this.clone().requireExpose = true;
        return excluder;
    }

    public final Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean bl2, boolean bl3) {
        Excluder excluder = this.clone();
        if (bl2) {
            excluder.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            excluder.serializationStrategies.add(exclusionStrategy);
        }
        if (bl3) {
            excluder.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            excluder.deserializationStrategies.add(exclusionStrategy);
        }
        return excluder;
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        boolean bl2 = this.excludeClass(clazz, true);
        boolean bl3 = this.excludeClass(clazz, false);
        if (!bl2 && !bl3) {
            return null;
        }
        return new Excluder$1(this, bl3, bl2, gson, typeToken);
    }

    public final boolean excludeField(Field object, boolean bl2) {
        Object object2;
        if ((this.modifiers & ((Field)object).getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(((Field)object).getAnnotation(Since.class), ((Field)object).getAnnotation(Until.class))) {
            return true;
        }
        if (((Field)object).isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((object2 = ((Field)object).getAnnotation(Expose.class)) == null || (bl2 ? !object2.serialize() : !object2.deserialize()))) {
            return true;
        }
        if (this.excludeClass(((Field)object).getType(), bl2)) {
            return true;
        }
        object2 = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        if (!object2.isEmpty()) {
            object = new FieldAttributes((Field)object);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = (ExclusionStrategy)iterator.next();
                if (!object2.shouldSkipField((FieldAttributes)object)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean excludeClass(Class<?> clazz, boolean bl2) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && Excluder.isInnerClass(clazz)) {
            return true;
        }
        if (!bl2 && !Enum.class.isAssignableFrom(clazz) && ReflectionHelper.isAnonymousOrNonStaticLocal(clazz)) {
            return true;
        }
        Object object = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        object = object.iterator();
        while (object.hasNext()) {
            ExclusionStrategy exclusionStrategy = (ExclusionStrategy)object.next();
            if (!exclusionStrategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !ReflectionHelper.isStatic(clazz);
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since since) {
        if (since != null) {
            double d2 = since.value();
            return this.version >= d2;
        }
        return true;
    }

    private boolean isValidUntil(Until until) {
        if (until != null) {
            double d2 = until.value();
            return this.version < d2;
        }
        return true;
    }
}

