/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.GsonTypes;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

final class GsonTypes$ParameterizedTypeImpl
implements Serializable,
ParameterizedType {
    private final Type ownerType;
    private final Type rawType;
    private final Type[] typeArguments;
    private static final long serialVersionUID = 0L;

    GsonTypes$ParameterizedTypeImpl(Type type, Class<?> clazz, Type ... typeArray) {
        Objects.requireNonNull(clazz);
        if (type == null && GsonTypes.requiresOwnerType(clazz)) {
            throw new IllegalArgumentException("Must specify owner type for " + clazz);
        }
        this.ownerType = type == null ? null : GsonTypes.canonicalize(type);
        this.rawType = GsonTypes.canonicalize(clazz);
        this.typeArguments = (Type[])typeArray.clone();
        int n2 = this.typeArguments.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Objects.requireNonNull(this.typeArguments[i2]);
            GsonTypes.checkNotPrimitive(this.typeArguments[i2]);
            this.typeArguments[i2] = GsonTypes.canonicalize(this.typeArguments[i2]);
        }
    }

    @Override
    public final Type[] getActualTypeArguments() {
        return (Type[])this.typeArguments.clone();
    }

    @Override
    public final Type getRawType() {
        return this.rawType;
    }

    @Override
    public final Type getOwnerType() {
        return this.ownerType;
    }

    public final boolean equals(Object object) {
        return object instanceof ParameterizedType && GsonTypes.equals(this, (ParameterizedType)object);
    }

    private static int hashCodeOrZero(Object object) {
        if (object != null) {
            return object.hashCode();
        }
        return 0;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ GsonTypes$ParameterizedTypeImpl.hashCodeOrZero(this.ownerType);
    }

    public final String toString() {
        int n2 = this.typeArguments.length;
        if (n2 == 0) {
            return GsonTypes.typeToString(this.rawType);
        }
        StringBuilder stringBuilder = new StringBuilder(30 * (n2 + 1));
        stringBuilder.append(GsonTypes.typeToString(this.rawType)).append("<").append(GsonTypes.typeToString(this.typeArguments[0]));
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append(", ").append(GsonTypes.typeToString(this.typeArguments[i2]));
        }
        return stringBuilder.append(">").toString();
    }
}

