/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.internal.LinkedTreeMap$1;
import com.google.gson.internal.LinkedTreeMap$EntrySet;
import com.google.gson.internal.LinkedTreeMap$KeySet;
import com.google.gson.internal.LinkedTreeMap$Node;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class LinkedTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER = new LinkedTreeMap$1();
    private final Comparator<? super K> comparator;
    private final boolean allowNullValues;
    LinkedTreeMap$Node<K, V> root;
    int size = 0;
    int modCount = 0;
    final LinkedTreeMap$Node<K, V> header;
    private LinkedTreeMap$EntrySet entrySet;
    private LinkedTreeMap$KeySet keySet;

    public LinkedTreeMap() {
        this(NATURAL_ORDER, true);
    }

    public LinkedTreeMap(boolean bl2) {
        this(NATURAL_ORDER, bl2);
    }

    public LinkedTreeMap(Comparator<? super K> comparator, boolean bl2) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
        this.allowNullValues = bl2;
        this.header = new LinkedTreeMap$Node(bl2);
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final V get(Object linkedTreeMap$Node) {
        if ((linkedTreeMap$Node = this.findByObject(linkedTreeMap$Node)) != null) {
            return linkedTreeMap$Node.value;
        }
        return null;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    @CanIgnoreReturnValue
    public final V put(K object, V v2) {
        if (object == null) {
            throw new NullPointerException("key == null");
        }
        if (v2 == null && !this.allowNullValues) {
            throw new NullPointerException("value == null");
        }
        object = this.find(object, true);
        Object v3 = ((LinkedTreeMap$Node)object).value;
        ((LinkedTreeMap$Node)object).value = v2;
        return v3;
    }

    @Override
    public final void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node = this.header;
        linkedTreeMap$Node.prev = linkedTreeMap$Node;
        this.header.next = linkedTreeMap$Node.prev;
    }

    @Override
    public final V remove(Object linkedTreeMap$Node) {
        if ((linkedTreeMap$Node = this.removeInternalByKey(linkedTreeMap$Node)) != null) {
            return linkedTreeMap$Node.value;
        }
        return null;
    }

    final LinkedTreeMap$Node<K, V> find(K k2, boolean bl2) {
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node;
        Object object;
        Comparator<K> comparator = this.comparator;
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node2 = this.root;
        int n2 = 0;
        if (linkedTreeMap$Node2 != null) {
            object = comparator == NATURAL_ORDER ? (Comparable)k2 : null;
            while (true) {
                if ((n2 = object != null ? object.compareTo(linkedTreeMap$Node2.key) : comparator.compare(k2, linkedTreeMap$Node2.key)) == 0) {
                    return linkedTreeMap$Node2;
                }
                linkedTreeMap$Node = n2 < 0 ? linkedTreeMap$Node2.left : linkedTreeMap$Node2.right;
                if (linkedTreeMap$Node == null) break;
                linkedTreeMap$Node2 = linkedTreeMap$Node;
            }
        }
        if (!bl2) {
            return null;
        }
        object = this.header;
        if (linkedTreeMap$Node2 == null) {
            if (comparator == NATURAL_ORDER && !(k2 instanceof Comparable)) {
                throw new ClassCastException(k2.getClass().getName() + " is not Comparable");
            }
            Object object2 = object;
            linkedTreeMap$Node = new LinkedTreeMap$Node<K, V>(this.allowNullValues, linkedTreeMap$Node2, k2, object2, ((LinkedTreeMap$Node)object2).prev);
            this.root = linkedTreeMap$Node;
        } else {
            Object object3 = object;
            linkedTreeMap$Node = new LinkedTreeMap$Node<K, V>(this.allowNullValues, linkedTreeMap$Node2, k2, object3, ((LinkedTreeMap$Node)object3).prev);
            if (n2 < 0) {
                linkedTreeMap$Node2.left = linkedTreeMap$Node;
            } else {
                linkedTreeMap$Node2.right = linkedTreeMap$Node;
            }
            this.rebalance(linkedTreeMap$Node2, true);
        }
        ++this.size;
        ++this.modCount;
        return linkedTreeMap$Node;
    }

    final LinkedTreeMap$Node<K, V> findByObject(Object object) {
        try {
            if (object != null) {
                return this.find(object, false);
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    final LinkedTreeMap$Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node = this.findByObject(entry.getKey());
        boolean bl2 = linkedTreeMap$Node != null && LinkedTreeMap.equal(linkedTreeMap$Node.value, entry.getValue());
        if (bl2) {
            return linkedTreeMap$Node;
        }
        return null;
    }

    private static boolean equal(Object object, Object object2) {
        return Objects.equals(object, object2);
    }

    final void removeInternal(LinkedTreeMap$Node<K, V> linkedTreeMap$Node, boolean bl2) {
        if (bl2) {
            linkedTreeMap$Node.prev.next = linkedTreeMap$Node.next;
            linkedTreeMap$Node.next.prev = linkedTreeMap$Node.prev;
        }
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node.parent;
        if (linkedTreeMap$Node2 != null && linkedTreeMap$Node3 != null) {
            linkedTreeMap$Node4 = linkedTreeMap$Node2.height > linkedTreeMap$Node3.height ? linkedTreeMap$Node2.last() : linkedTreeMap$Node3.first();
            this.removeInternal(linkedTreeMap$Node4, false);
            int n2 = 0;
            linkedTreeMap$Node2 = linkedTreeMap$Node.left;
            if (linkedTreeMap$Node2 != null) {
                n2 = linkedTreeMap$Node2.height;
                linkedTreeMap$Node4.left = linkedTreeMap$Node2;
                linkedTreeMap$Node2.parent = linkedTreeMap$Node4;
                linkedTreeMap$Node.left = null;
            }
            int n3 = 0;
            linkedTreeMap$Node3 = linkedTreeMap$Node.right;
            if (linkedTreeMap$Node3 != null) {
                n3 = linkedTreeMap$Node3.height;
                linkedTreeMap$Node4.right = linkedTreeMap$Node3;
                linkedTreeMap$Node3.parent = linkedTreeMap$Node4;
                linkedTreeMap$Node.right = null;
            }
            linkedTreeMap$Node4.height = Math.max(n2, n3) + 1;
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node4);
            return;
        }
        if (linkedTreeMap$Node2 != null) {
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node2);
            linkedTreeMap$Node.left = null;
        } else if (linkedTreeMap$Node3 != null) {
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node3);
            linkedTreeMap$Node.right = null;
        } else {
            this.replaceInParent(linkedTreeMap$Node, null);
        }
        this.rebalance(linkedTreeMap$Node4, false);
        --this.size;
        ++this.modCount;
    }

    final LinkedTreeMap$Node<K, V> removeInternalByKey(Object linkedTreeMap$Node) {
        if ((linkedTreeMap$Node = this.findByObject(linkedTreeMap$Node)) != null) {
            this.removeInternal(linkedTreeMap$Node, true);
        }
        return linkedTreeMap$Node;
    }

    private void replaceInParent(LinkedTreeMap$Node<K, V> linkedTreeMap$Node, LinkedTreeMap$Node<K, V> linkedTreeMap$Node2) {
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.parent;
        linkedTreeMap$Node.parent = null;
        if (linkedTreeMap$Node2 != null) {
            linkedTreeMap$Node2.parent = linkedTreeMap$Node3;
        }
        if (linkedTreeMap$Node3 != null) {
            if (linkedTreeMap$Node3.left == linkedTreeMap$Node) {
                linkedTreeMap$Node3.left = linkedTreeMap$Node2;
                return;
            }
            assert (linkedTreeMap$Node3.right == linkedTreeMap$Node);
            linkedTreeMap$Node3.right = linkedTreeMap$Node2;
            return;
        }
        this.root = linkedTreeMap$Node2;
    }

    private void rebalance(LinkedTreeMap$Node<K, V> linkedTreeMap$Node, boolean bl2) {
        while (linkedTreeMap$Node != null) {
            LinkedTreeMap$Node linkedTreeMap$Node2;
            int n2;
            LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.left;
            int n3 = linkedTreeMap$Node3 != null ? linkedTreeMap$Node3.height : 0;
            int n4 = n3 - (n2 = (linkedTreeMap$Node2 = linkedTreeMap$Node.right) != null ? linkedTreeMap$Node2.height : 0);
            if (n4 == -2) {
                LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node2.left;
                LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node2.right;
                n2 = linkedTreeMap$Node5 != null ? linkedTreeMap$Node5.height : 0;
                n3 = linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0;
                if ((n3 = n3 - n2) == -1 || n3 == 0 && !bl2) {
                    this.rotateLeft(linkedTreeMap$Node);
                } else {
                    assert (n3 == 1);
                    this.rotateRight(linkedTreeMap$Node2);
                    this.rotateLeft(linkedTreeMap$Node);
                }
                if (bl2) break;
            } else if (n4 == 2) {
                LinkedTreeMap$Node linkedTreeMap$Node6 = linkedTreeMap$Node3.left;
                LinkedTreeMap$Node linkedTreeMap$Node7 = linkedTreeMap$Node3.right;
                n2 = linkedTreeMap$Node7 != null ? linkedTreeMap$Node7.height : 0;
                n3 = linkedTreeMap$Node6 != null ? linkedTreeMap$Node6.height : 0;
                if ((n3 = n3 - n2) == 1 || n3 == 0 && !bl2) {
                    this.rotateRight(linkedTreeMap$Node);
                } else {
                    assert (n3 == -1);
                    this.rotateLeft(linkedTreeMap$Node3);
                    this.rotateRight(linkedTreeMap$Node);
                }
                if (bl2) break;
            } else if (n4 == 0) {
                linkedTreeMap$Node.height = n3 + 1;
                if (bl2) {
                    return;
                }
            } else {
                assert (n4 == -1 || n4 == 1);
                linkedTreeMap$Node.height = Math.max(n3, n2) + 1;
                if (!bl2) break;
            }
            linkedTreeMap$Node = linkedTreeMap$Node.parent;
        }
    }

    private void rotateLeft(LinkedTreeMap$Node<K, V> linkedTreeMap$Node) {
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node3.left;
        LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node3.right;
        linkedTreeMap$Node.right = linkedTreeMap$Node4;
        if (linkedTreeMap$Node4 != null) {
            linkedTreeMap$Node4.parent = linkedTreeMap$Node;
        }
        this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node3);
        linkedTreeMap$Node3.left = linkedTreeMap$Node;
        linkedTreeMap$Node.parent = linkedTreeMap$Node3;
        linkedTreeMap$Node.height = Math.max(linkedTreeMap$Node2 != null ? linkedTreeMap$Node2.height : 0, linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0) + 1;
        linkedTreeMap$Node3.height = Math.max(linkedTreeMap$Node.height, linkedTreeMap$Node5 != null ? linkedTreeMap$Node5.height : 0) + 1;
    }

    private void rotateRight(LinkedTreeMap$Node<K, V> linkedTreeMap$Node) {
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node2.left;
        LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node2.right;
        linkedTreeMap$Node.left = linkedTreeMap$Node5;
        if (linkedTreeMap$Node5 != null) {
            linkedTreeMap$Node5.parent = linkedTreeMap$Node;
        }
        this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node2);
        linkedTreeMap$Node2.right = linkedTreeMap$Node;
        linkedTreeMap$Node.parent = linkedTreeMap$Node2;
        linkedTreeMap$Node.height = Math.max(linkedTreeMap$Node3 != null ? linkedTreeMap$Node3.height : 0, linkedTreeMap$Node5 != null ? linkedTreeMap$Node5.height : 0) + 1;
        linkedTreeMap$Node2.height = Math.max(linkedTreeMap$Node.height, linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0) + 1;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        LinkedTreeMap$EntrySet linkedTreeMap$EntrySet = this.entrySet;
        if (linkedTreeMap$EntrySet == null) {
            linkedTreeMap$EntrySet = this.entrySet = new LinkedTreeMap$EntrySet(this);
        }
        return linkedTreeMap$EntrySet;
    }

    @Override
    public final Set<K> keySet() {
        LinkedTreeMap$KeySet linkedTreeMap$KeySet = this.keySet;
        if (linkedTreeMap$KeySet == null) {
            linkedTreeMap$KeySet = this.keySet = new LinkedTreeMap$KeySet(this);
        }
        return linkedTreeMap$KeySet;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Deserialization is unsupported");
    }
}

