/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.bind.EnumTypeAdapter$1;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    static final TypeAdapterFactory FACTORY = new EnumTypeAdapter$1();
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<String, T> stringToConstant = new HashMap<String, T>();
    private final Map<T, String> constantToName = new HashMap<T, String>();

    private EnumTypeAdapter(Class<T> object) {
        try {
            object = ((Class)object).getDeclaredFields();
            int n3 = 0;
            for (Object object2 : object) {
                if (!((Field)object2).isEnumConstant()) continue;
                object[n3++] = object2;
            }
            object = (Field[])Arrays.copyOf(object, n3);
            AccessibleObject.setAccessible((AccessibleObject[])object, true);
            for (Object object2 : object) {
                object = (Enum)((Field)object2).get(null);
                String string = ((Enum)object).name();
                String string2 = ((Enum)object).toString();
                SerializedName serializedName = ((Field)object2).getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    string = serializedName.value();
                    for (String string3 : serializedName.alternate()) {
                        this.nameToConstant.put(string3, object);
                    }
                }
                this.nameToConstant.put(string, object);
                this.stringToConstant.put(string2, object);
                this.constantToName.put(object, string);
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    @Override
    public T read(JsonReader object) throws IOException {
        if (((JsonReader)object).peek() == JsonToken.NULL) {
            ((JsonReader)object).nextNull();
            return null;
        }
        Enum enum_ = (Enum)this.nameToConstant.get(object = ((JsonReader)object).nextString());
        if (enum_ == null) {
            return (T)((Enum)this.stringToConstant.get(object));
        }
        return (T)enum_;
    }

    @Override
    public void write(JsonWriter jsonWriter, T t2) throws IOException {
        jsonWriter.value(t2 == null ? null : this.constantToName.get(t2));
    }

    /* synthetic */ EnumTypeAdapter(Class clazz, EnumTypeAdapter$1 enumTypeAdapter$1) {
        this(clazz);
    }
}

