/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$Adapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$BoundField;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$FieldsData;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class ReflectiveTypeAdapterFactory$RecordAdapter<T>
extends ReflectiveTypeAdapterFactory$Adapter<T, Object[]> {
    static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = ReflectiveTypeAdapterFactory$RecordAdapter.primitiveDefaults();
    private final Constructor<T> constructor;
    private final Object[] constructorArgsDefaults;
    private final Map<String, Integer> componentIndices = new HashMap<String, Integer>();

    ReflectiveTypeAdapterFactory$RecordAdapter(Class<T> stringArray, ReflectiveTypeAdapterFactory$FieldsData reflectiveTypeAdapterFactory$FieldsData, boolean bl2) {
        super(reflectiveTypeAdapterFactory$FieldsData);
        this.constructor = ReflectionHelper.getCanonicalRecordConstructor(stringArray);
        if (bl2) {
            ReflectiveTypeAdapterFactory.access$000(null, this.constructor);
        } else {
            ReflectionHelper.makeAccessible(this.constructor);
        }
        stringArray = ReflectionHelper.getRecordComponentNames(stringArray);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.componentIndices.put(stringArray[i2], i2);
        }
        Class<?>[] classArray = this.constructor.getParameterTypes();
        this.constructorArgsDefaults = new Object[classArray.length];
        for (int i3 = 0; i3 < classArray.length; ++i3) {
            this.constructorArgsDefaults[i3] = PRIMITIVE_DEFAULTS.get(classArray[i3]);
        }
    }

    private static Map<Class<?>, Object> primitiveDefaults() {
        HashMap hashMap = new HashMap();
        hashMap.put(Byte.TYPE, (byte)0);
        hashMap.put(Short.TYPE, (short)0);
        hashMap.put(Integer.TYPE, 0);
        hashMap.put(Long.TYPE, 0L);
        hashMap.put(Float.TYPE, Float.valueOf(0.0f));
        hashMap.put(Double.TYPE, 0.0);
        hashMap.put(Character.TYPE, Character.valueOf('\u0000'));
        hashMap.put(Boolean.TYPE, Boolean.FALSE);
        return hashMap;
    }

    @Override
    final Object[] createAccumulator() {
        return (Object[])this.constructorArgsDefaults.clone();
    }

    @Override
    final void readField(Object[] objectArray, JsonReader jsonReader, ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField) throws IOException {
        Integer n2 = this.componentIndices.get(reflectiveTypeAdapterFactory$BoundField.fieldName);
        if (n2 == null) {
            throw new IllegalStateException("Could not find the index in the constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' for field with name '" + reflectiveTypeAdapterFactory$BoundField.fieldName + "', unable to determine which argument in the constructor the field corresponds to. This is unexpected behavior, as we expect the RecordComponents to have the same names as the fields in the Java class, and that the order of the RecordComponents is the same as the order of the canonical constructor parameters.");
        }
        reflectiveTypeAdapterFactory$BoundField.readIntoArray(jsonReader, n2, objectArray);
    }

    @Override
    final T finalize(Object[] objectArray) {
        try {
            return this.constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessException illegalAccessException2 = illegalAccessException;
            throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
        }
        catch (IllegalArgumentException | InstantiationException exception) {
            throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(objectArray), exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(objectArray), invocationTargetException.getCause());
        }
    }
}

