/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapParseException;
import com.sun.activation.registries.MailcapTokenizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MailcapFile {
    private Map type_hash = new HashMap();
    private Map fallback_hash = new HashMap();
    private Map native_commands = new HashMap();
    private static boolean addReverse = false;

    public MailcapFile(String string) throws IOException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: file " + string);
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            this.parse(new BufferedReader(fileReader));
        }
        catch (Throwable throwable) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            fileReader.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public MailcapFile(InputStream inputStream) throws IOException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: InputStream");
        }
        this.parse(new BufferedReader(new InputStreamReader(inputStream, "iso-8859-1")));
    }

    public MailcapFile() {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: default");
        }
    }

    public Map getMailcapList(String object) {
        Object object2 = (Map)this.type_hash.get(object);
        int n2 = ((String)object).indexOf(47);
        String string = ((String)object).substring(n2 + 1);
        if (!string.equals("*")) {
            object = ((String)object).substring(0, n2 + 1) + "*";
            if ((object = (Map)this.type_hash.get(object)) != null) {
                object2 = object2 != null ? this.mergeResults((Map)object2, (Map)object) : object;
            }
        }
        return object2;
    }

    public Map getMailcapFallbackList(String object) {
        Object object2 = (Map)this.fallback_hash.get(object);
        int n2 = ((String)object).indexOf(47);
        String string = ((String)object).substring(n2 + 1);
        if (!string.equals("*")) {
            object = ((String)object).substring(0, n2 + 1) + "*";
            if ((object = (Map)this.fallback_hash.get(object)) != null) {
                object2 = object2 != null ? this.mergeResults((Map)object2, (Map)object) : object;
            }
        }
        return object2;
    }

    public String[] getMimeTypes() {
        HashSet hashSet = new HashSet(this.type_hash.keySet());
        hashSet.addAll(this.fallback_hash.keySet());
        hashSet.addAll(this.native_commands.keySet());
        String[] stringArray = new String[hashSet.size()];
        stringArray = hashSet.toArray(stringArray);
        return stringArray;
    }

    public String[] getNativeCommands(String object) {
        String[] stringArray = null;
        if ((object = (List)this.native_commands.get(((String)object).toLowerCase(Locale.ENGLISH))) != null) {
            stringArray = new String[object.size()];
            stringArray = object.toArray(stringArray);
        }
        return stringArray;
    }

    private Map mergeResults(Map hashMap, Map map) {
        Iterator iterator = map.keySet().iterator();
        hashMap = new HashMap(hashMap);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            if (arrayList == null) {
                hashMap.put(string, map.get(string));
                continue;
            }
            List list = (List)map.get(string);
            arrayList = new ArrayList(arrayList);
            arrayList.addAll(list);
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    public void appendToMailcap(String string) {
        if (LogSupport.isLoggable()) {
            LogSupport.log("appendToMailcap: " + string);
        }
        try {
            this.parse(new StringReader(string));
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void parse(Reader reader) throws IOException {
        String string;
        reader = new BufferedReader(reader);
        String string2 = null;
        while ((string = ((BufferedReader)reader).readLine()) != null) {
            string = string.trim();
            try {
                if (string.charAt(0) == '#') continue;
                String string3 = string;
                if (string3.charAt(string3.length() - 1) == '\\') {
                    if (string2 != null) {
                        string2 = string2 + string.substring(0, string.length() - 1);
                        continue;
                    }
                    string2 = string.substring(0, string.length() - 1);
                    continue;
                }
                if (string2 != null) {
                    string2 = string2 + string;
                    try {
                        this.parseLine(string2);
                    }
                    catch (MailcapParseException mailcapParseException) {}
                    string2 = null;
                    continue;
                }
                try {
                    this.parseLine(string);
                }
                catch (MailcapParseException mailcapParseException) {
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseLine(String object) throws MailcapParseException, IOException {
        Object object22;
        int n2;
        Object object3 = new MailcapTokenizer((String)object);
        ((MailcapTokenizer)object3).setIsAutoquoting(false);
        if (LogSupport.isLoggable()) {
            LogSupport.log("parse: " + (String)object);
        }
        if ((n2 = ((MailcapTokenizer)object3).nextToken()) != 2) {
            MailcapFile.reportParseError(2, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
        }
        Object object4 = ((MailcapTokenizer)object3).getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
        Object object5 = "*";
        n2 = ((MailcapTokenizer)object3).nextToken();
        if (n2 != 47 && n2 != 59) {
            MailcapFile.reportParseError(47, 59, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
        }
        if (n2 == 47) {
            n2 = ((MailcapTokenizer)object3).nextToken();
            if (n2 != 2) {
                MailcapFile.reportParseError(2, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
            }
            object5 = ((MailcapTokenizer)object3).getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
            n2 = ((MailcapTokenizer)object3).nextToken();
        }
        object4 = (String)object4 + "/" + (String)object5;
        if (LogSupport.isLoggable()) {
            LogSupport.log("  Type: " + (String)object4);
        }
        object5 = new LinkedHashMap();
        if (n2 != 59) {
            MailcapFile.reportParseError(59, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
        }
        ((MailcapTokenizer)object3).setIsAutoquoting(true);
        n2 = ((MailcapTokenizer)object3).nextToken();
        ((MailcapTokenizer)object3).setIsAutoquoting(false);
        if (n2 != 2 && n2 != 59) {
            MailcapFile.reportParseError(2, 59, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
        }
        if (n2 == 2) {
            ArrayList arrayList = (ArrayList)this.native_commands.get(object4);
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.add(object);
                this.native_commands.put(object4, arrayList);
            } else {
                arrayList.add(object);
            }
        }
        if (n2 != 59) {
            n2 = ((MailcapTokenizer)object3).nextToken();
        }
        if (n2 != 59) {
            if (n2 == 5) return;
            MailcapFile.reportParseError(5, 59, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
            return;
        }
        boolean bl2 = false;
        do {
            if ((n2 = ((MailcapTokenizer)object3).nextToken()) != 2) {
                MailcapFile.reportParseError(2, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
            }
            object = ((MailcapTokenizer)object3).getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
            n2 = ((MailcapTokenizer)object3).nextToken();
            if (n2 != 61 && n2 != 59 && n2 != 5) {
                MailcapFile.reportParseError(61, 59, 5, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
            }
            if (n2 != 61) continue;
            ((MailcapTokenizer)object3).setIsAutoquoting(true);
            n2 = ((MailcapTokenizer)object3).nextToken();
            ((MailcapTokenizer)object3).setIsAutoquoting(false);
            if (n2 != 2) {
                MailcapFile.reportParseError(2, n2, ((MailcapTokenizer)object3).getCurrentTokenValue());
            }
            String string = ((MailcapTokenizer)object3).getCurrentTokenValue();
            if (((String)object).startsWith("x-java-")) {
                if (((String)(object = ((String)object).substring(7))).equals("fallback-entry") && string.equalsIgnoreCase("true")) {
                    bl2 = true;
                } else {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("    Command: " + object + ", Class: " + string);
                    }
                    if ((object22 = (List)object5.get(object)) == null) {
                        object22 = new ArrayList<String>();
                        object5.put(object, object22);
                    }
                    if (addReverse) {
                        object22.add(0, string);
                    } else {
                        object22.add(string);
                    }
                }
            }
            n2 = ((MailcapTokenizer)object3).nextToken();
        } while (n2 == 59);
        object = bl2 ? this.fallback_hash : this.type_hash;
        Map map = (Map)object.get(object4);
        if (map == null) {
            object.put(object4, object5);
            return;
        }
        if (LogSupport.isLoggable()) {
            LogSupport.log("Merging commands for type " + (String)object4);
        }
        for (Object object22 : map.keySet()) {
            object3 = (List)map.get(object22);
            object4 = (List)object5.get(object22);
            if (object4 == null) continue;
            object4 = object4.iterator();
            while (object4.hasNext()) {
                String string = (String)object4.next();
                if (object3.contains(string)) continue;
                if (addReverse) {
                    object3.add(0, string);
                    continue;
                }
                object3.add(string);
            }
        }
        object = object5.keySet().iterator();
        while (object.hasNext()) {
            object22 = (String)object.next();
            if (map.containsKey(object22)) continue;
            object3 = (List)object5.get(object22);
            map.put(object22, object3);
        }
    }

    protected static void reportParseError(int n2, int n3, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n3) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n2) + " token.");
    }

    protected static void reportParseError(int n2, int n3, int n4, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n4) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n2) + " or a " + MailcapTokenizer.nameForToken(n3) + " token.");
    }

    protected static void reportParseError(int n2, int n3, int n4, int n5, String string) throws MailcapParseException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("PARSE ERROR: Encountered a " + MailcapTokenizer.nameForToken(n5) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n2) + ", a " + MailcapTokenizer.nameForToken(n3) + ", or a " + MailcapTokenizer.nameForToken(n4) + " token.");
        }
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n5) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n2) + ", a " + MailcapTokenizer.nameForToken(n3) + ", or a " + MailcapTokenizer.nameForToken(n4) + " token.");
    }

    static {
        try {
            addReverse = Boolean.getBoolean("jakarta.activation.addreverse") || Boolean.getBoolean("javax.activation.addreverse");
        }
        catch (Throwable throwable) {}
    }
}

