/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.EventLoop$State;
import java.util.ArrayDeque;
import java.util.Deque;

public final class EventLoop {
    private static final Deque<EventLoop> stack = new ArrayDeque<EventLoop>();
    private EventLoop$State state = EventLoop$State.IDLE;
    private Object returnValue;

    EventLoop() {
        Application.checkEventThread();
    }

    public final EventLoop$State getState() {
        Application.checkEventThread();
        return this.state;
    }

    public final Object enter() {
        Application.checkEventThread();
        if (!this.state.equals((Object)EventLoop$State.IDLE)) {
            throw new IllegalStateException("The event loop object isn't idle");
        }
        this.state = EventLoop$State.ACTIVE;
        stack.push(this);
        try {
            Object object = Application.enterNestedEventLoop();
            assert (object == this) : "Internal inconsistency - wrong EventLoop";
            assert (stack.peek() == this) : "Internal inconsistency - corrupted event loops stack";
            assert (this.state.equals((Object)EventLoop$State.LEAVING)) : "The event loop isn't leaving";
            object = this.returnValue;
            return object;
        }
        finally {
            this.returnValue = null;
            this.state = EventLoop$State.IDLE;
            stack.pop();
            if (!stack.isEmpty() && EventLoop.stack.peek().state.equals((Object)EventLoop$State.LEAVING)) {
                Application.invokeLater(() -> {
                    EventLoop eventLoop = stack.peek();
                    if (eventLoop != null && eventLoop.state.equals((Object)EventLoop$State.LEAVING)) {
                        Application.leaveNestedEventLoop(eventLoop);
                    }
                });
            }
        }
    }

    public final void leave(Object object) {
        Application.checkEventThread();
        if (!this.state.equals((Object)EventLoop$State.ACTIVE)) {
            throw new IllegalStateException("The event loop object isn't active");
        }
        this.state = EventLoop$State.LEAVING;
        this.returnValue = object;
        if (stack.peek() == this) {
            Application.leaveNestedEventLoop(this);
        }
    }
}

