/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.image.PixelUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import javafx.stage.Screen;

public abstract class GlassRobot {
    public static final int MOUSE_LEFT_BTN = 1;
    public static final int MOUSE_RIGHT_BTN = 2;
    public static final int MOUSE_MIDDLE_BTN = 4;
    public static final int MOUSE_BACK_BTN = 8;
    public static final int MOUSE_FORWARD_BTN = 16;

    public abstract void create();

    public abstract void destroy();

    public abstract void keyPress(KeyCode var1);

    public abstract void keyRelease(KeyCode var1);

    public abstract double getMouseX();

    public abstract double getMouseY();

    public abstract void mouseMove(double var1, double var3);

    public abstract void mousePress(MouseButton ... var1);

    public abstract void mouseRelease(MouseButton ... var1);

    public abstract void mouseWheel(int var1);

    public abstract Color getPixelColor(double var1, double var3);

    public void getScreenCapture(int n2, int n3, int n4, int n5, int[] nArray, boolean bl2) {
        throw new InternalError("not implemented");
    }

    /*
     * Enabled aggressive block sorting
     */
    public WritableImage getScreenCapture(WritableImage writableImage, double d2, double d3, double d4, double d5, boolean bl2) {
        int n2;
        int n3;
        int[] nArray;
        int n4 = (int)d4;
        int n5 = (int)d5;
        if (n4 <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n5 <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        if (n4 >= Integer.MAX_VALUE / n5) {
            throw new IllegalArgumentException("invalid capture size");
        }
        Screen screen = Screen.getPrimary();
        Objects.requireNonNull(screen);
        double d6 = screen.getOutputScaleX();
        double d7 = screen.getOutputScaleY();
        if (d6 == 1.0 && d7 == 1.0) {
            nArray = new int[n4 * n5];
            this.getScreenCapture((int)d2, (int)d3, n4, n5, nArray, bl2);
        } else {
            int n6 = (int)Math.floor(d2 * d6);
            int n7 = (int)Math.floor(d3 * d7);
            int n8 = (int)Math.ceil((d2 + d4) * d6);
            n3 = (int)Math.ceil((d3 + d5) * d7);
            int n9 = n8 - n6;
            int n10 = n3 - n7;
            if (n9 <= 0) {
                throw new IllegalArgumentException("invalid width");
            }
            if (n10 <= 0) {
                throw new IllegalArgumentException("invalid height");
            }
            if (n9 >= Integer.MAX_VALUE / n10) {
                throw new IllegalArgumentException("invalid capture size");
            }
            int[] nArray2 = new int[n9 * n10];
            this.getScreenCapture(n6, n7, n9, n10, nArray2, bl2);
            n3 = n9;
            n2 = n10;
            if (!bl2) {
                nArray = nArray2;
                return GlassRobot.convertFromPixels(writableImage, Application.GetApplication().createPixels(n3, n2, IntBuffer.wrap(nArray)));
            }
            nArray = new int[n4 * n5];
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                double d8 = (d3 + (double)n2 + 0.5) * d7 - (double)((float)n7 + 0.5f);
                int n11 = (int)Math.floor(d8);
                int n12 = (int)((d8 - (double)n11) * 256.0);
                for (int i2 = 0; i2 < n4; ++i2) {
                    double d9 = (d2 + (double)i2 + 0.5) * d6 - (double)((float)n6 + 0.5f);
                    int n13 = (int)Math.floor(d9);
                    int n14 = (int)((d9 - (double)n13) * 256.0);
                    nArray[n3++] = GlassRobot.interp(nArray2, n13, n11, n9, n10, n14, n12);
                }
            }
        }
        n3 = n4;
        n2 = n5;
        return GlassRobot.convertFromPixels(writableImage, Application.GetApplication().createPixels(n3, n2, IntBuffer.wrap(nArray)));
    }

    public static int convertToRobotMouseButton(MouseButton[] mouseButtonArray) {
        int n2 = 0;
        block7: for (MouseButton mouseButton : mouseButtonArray) {
            switch (mouseButton) {
                case PRIMARY: {
                    n2 |= 1;
                    continue block7;
                }
                case SECONDARY: {
                    n2 |= 2;
                    continue block7;
                }
                case MIDDLE: {
                    n2 |= 4;
                    continue block7;
                }
                case BACK: {
                    n2 |= 8;
                    continue block7;
                }
                case FORWARD: {
                    n2 |= 0x10;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("MouseButton: " + String.valueOf((Object)mouseButton) + " not supported by Robot");
                }
            }
        }
        return n2;
    }

    public static Color convertFromIntArgb(int n2) {
        int n3 = n2 >>> 24;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        return new Color((double)n4 / 255.0, (double)n5 / 255.0, (double)(n2 &= 0xFF) / 255.0, (double)n3 / 255.0);
    }

    protected static WritableImage convertFromPixels(WritableImage writableImage, Pixels object) {
        Objects.requireNonNull(object);
        int n2 = ((Pixels)object).getWidth();
        int n3 = ((Pixels)object).getHeight();
        if (writableImage == null || writableImage.getWidth() != (double)n2 || writableImage.getHeight() != (double)n3) {
            writableImage = new WritableImage(n2, n3);
        }
        if ((n2 = ((Pixels)object).getBytesPerComponent()) == 4) {
            object = (IntBuffer)((Pixels)object).getPixels();
            GlassRobot.writeIntBufferToImage((IntBuffer)object, writableImage);
        } else if (n2 == 1) {
            object = (ByteBuffer)((Pixels)object).getPixels();
            GlassRobot.writeByteBufferToImage((ByteBuffer)object, writableImage);
        } else {
            throw new IllegalArgumentException("bytesPerComponent must be either 4 or 1 but was: " + n2);
        }
        return writableImage;
    }

    private static void writeIntBufferToImage(IntBuffer intBuffer, WritableImage writableImage) {
        Objects.requireNonNull(writableImage);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        double d2 = writableImage.getWidth();
        double d3 = writableImage.getHeight();
        int n2 = 0;
        while ((double)n2 < d3) {
            int n3 = 0;
            while ((double)n3 < d2) {
                int n4 = intBuffer.get();
                pixelWriter.setArgb(n3, n2, n4);
                ++n3;
            }
            ++n2;
        }
    }

    private static void writeByteBufferToImage(ByteBuffer byteBuffer, WritableImage writableImage) {
        Objects.requireNonNull(writableImage);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        double d2 = writableImage.getWidth();
        double d3 = writableImage.getHeight();
        int n2 = Pixels.getNativeFormat();
        int n3 = 0;
        while ((double)n3 < d3) {
            int n4 = 0;
            while ((double)n4 < d2) {
                if (n2 == 1) {
                    pixelWriter.setArgb(n4, n3, PixelUtils.PretoNonPre(GlassRobot.bgraPreToRgbaPre(byteBuffer.getInt())));
                } else if (n2 == 2) {
                    pixelWriter.setArgb(n4, n3, byteBuffer.getInt());
                } else {
                    throw new IllegalArgumentException("format must be either BYTE_BGRA_PRE or BYTE_ARGB");
                }
                ++n4;
            }
            ++n3;
        }
    }

    private static int bgraPreToRgbaPre(int n2) {
        return Integer.reverseBytes(n2);
    }

    private static int interp(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = 256 - n6;
        int n10 = 256 - n7;
        int n11 = n3 * n4 + n2;
        int n12 = n8 = n2 < 0 || n3 < 0 || n2 >= n4 || n3 >= n5 ? 0 : nArray[n11];
        if (n7 == 0) {
            if (n6 == 0) {
                return n8;
            }
            int n13 = n3 < 0 || n2 + 1 >= n4 || n3 >= n5 ? 0 : nArray[n11 + 1];
            return GlassRobot.interp(n8, n13, n9, n6);
        }
        if (n6 == 0) {
            int n14 = n2 < 0 || n2 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4];
            return GlassRobot.interp(n8, n14, n10, n7);
        }
        int n15 = n3 < 0 || n2 + 1 >= n4 || n3 >= n5 ? 0 : nArray[n11 + 1];
        int n16 = n2 < 0 || n2 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4];
        int n17 = n2 + 1 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4 + 1];
        return GlassRobot.interp(GlassRobot.interp(n8, n15, n9, n6), GlassRobot.interp(n16, n17, n9, n6), n10, n7);
    }

    private static int interp(int n2, int n3, int n4, int n5) {
        int n6 = n2 >>> 24;
        int n7 = n2 >> 16 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        n2 &= 0xFF;
        int n9 = n3 >>> 24;
        int n10 = n3 >> 16 & 0xFF;
        int n11 = n3 >> 8 & 0xFF;
        n6 = n6 * n4 + n9 * n5 >> 8;
        n7 = n7 * n4 + n10 * n5 >> 8;
        n8 = n8 * n4 + n11 * n5 >> 8;
        n2 = n2 * n4 + (n3 &= 0xFF) * n5 >> 8;
        return n6 << 24 | n7 << 16 | n8 << 8 | n2;
    }
}

