/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.InvokeLaterDispatcher$Future;
import com.sun.glass.ui.InvokeLaterDispatcher$InvokeLaterSubmitter;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public final class InvokeLaterDispatcher
extends Thread {
    private final BlockingDeque<Runnable> deque = new LinkedBlockingDeque<Runnable>();
    private final Object LOCK = new StringBuilder("InvokeLaterLock");
    private boolean nestedEventLoopEntered = false;
    private volatile boolean leavingNestedEventLoop = false;
    private final InvokeLaterDispatcher$InvokeLaterSubmitter invokeLaterSubmitter;

    public InvokeLaterDispatcher(InvokeLaterDispatcher$InvokeLaterSubmitter invokeLaterDispatcher$InvokeLaterSubmitter) {
        super("InvokeLaterDispatcher");
        this.setDaemon(true);
        this.invokeLaterSubmitter = invokeLaterDispatcher$InvokeLaterSubmitter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        try {
            while (true) {
                Object object = this.deque.takeFirst();
                if (this.leavingNestedEventLoop) {
                    this.deque.addFirst((Runnable)object);
                    object = this.LOCK;
                    synchronized (object) {
                        while (this.leavingNestedEventLoop) {
                            this.LOCK.wait();
                        }
                        continue;
                    }
                }
                object = new InvokeLaterDispatcher$Future(this, (Runnable)object);
                this.invokeLaterSubmitter.submitForLaterInvocation((Runnable)object);
                Object object2 = this.LOCK;
                synchronized (object2) {
                    try {
                        while (!((InvokeLaterDispatcher$Future)object).isDone() && !this.nestedEventLoopEntered) {
                            this.LOCK.wait();
                        }
                    }
                    finally {
                        this.nestedEventLoopEntered = false;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public final void invokeAndWait(Runnable runnable) {
        runnable = new InvokeLaterDispatcher$Future(this, runnable);
        this.invokeLaterSubmitter.submitForLaterInvocation(runnable);
        Object object = this.LOCK;
        synchronized (object) {
            try {
                while (!((InvokeLaterDispatcher$Future)runnable).isDone()) {
                    this.LOCK.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }

    public final void invokeLater(Runnable runnable) {
        this.deque.addLast(runnable);
    }

    public final void notifyEnteringNestedEventLoop() {
        Object object = this.LOCK;
        synchronized (object) {
            this.nestedEventLoopEntered = true;
            this.LOCK.notifyAll();
            return;
        }
    }

    public final void notifyLeavingNestedEventLoop() {
        Object object = this.LOCK;
        synchronized (object) {
            this.leavingNestedEventLoop = true;
            this.LOCK.notifyAll();
            return;
        }
    }

    public final void notifyLeftNestedEventLoop() {
        Object object = this.LOCK;
        synchronized (object) {
            this.leavingNestedEventLoop = false;
            this.LOCK.notifyAll();
            return;
        }
    }
}

