/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs$ExtensionFilter;
import com.sun.glass.ui.CommonDialogs$FileChooserResult;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.InvokeLaterDispatcher$InvokeLaterSubmitter;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.mac.MacAccessible;
import com.sun.glass.ui.mac.MacApplication$1;
import com.sun.glass.ui.mac.MacApplication$2;
import com.sun.glass.ui.mac.MacApplication$3;
import com.sun.glass.ui.mac.MacApplication$4;
import com.sun.glass.ui.mac.MacCommonDialogs;
import com.sun.glass.ui.mac.MacCursor;
import com.sun.glass.ui.mac.MacPixels;
import com.sun.glass.ui.mac.MacRobot;
import com.sun.glass.ui.mac.MacTimer;
import com.sun.glass.ui.mac.MacView;
import com.sun.glass.ui.mac.MacWindow;
import com.sun.javafx.util.Logging;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

final class MacApplication
extends Application
implements InvokeLaterDispatcher$InvokeLaterSubmitter {
    private boolean isTaskbarApplication = false;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private Menu appleMenu;
    private final CountDownLatch reactivationLatch = new CountDownLatch(1);
    private boolean firstDidResignActive = false;

    private static native void _initIDs(boolean var0);

    static native int _getMacKey(int var0);

    MacApplication() {
        boolean bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (!bl2) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
            return;
        }
        this.invokeLaterDispatcher = null;
    }

    final native void _runLoop(ClassLoader var1, Runnable var2, boolean var3);

    @Override
    protected final void runLoop(Runnable runnable) {
        boolean bl2;
        runnable = () -> {
            if (this.isTriggerReactivation()) {
                this.waitForReactivation();
            }
            runnable.run();
        };
        this.isTaskbarApplication = bl2 = AccessController.doPrivileged(() -> {
            String string = System.getProperty("glass.taskbarApplication");
            return !"false".equalsIgnoreCase(string);
        }).booleanValue();
        ClassLoader classLoader = MacApplication.class.getClassLoader();
        this._runLoop(classLoader, runnable, this.isTaskbarApplication);
    }

    final void waitForReactivation() {
        EventLoop eventLoop = this.createEventLoop();
        Thread thread = new Thread(() -> {
            try {
                if (!this.reactivationLatch.await(5L, TimeUnit.SECONDS)) {
                    Logging.getJavaFXLogger().warning("Timeout while waiting for app reactivation");
                }
            }
            catch (InterruptedException interruptedException) {
                Logging.getJavaFXLogger().warning("Exception while waiting for app reactivation: " + String.valueOf(interruptedException));
            }
            Application.invokeLater(() -> eventLoop.leave(null));
        });
        thread.setDaemon(true);
        thread.start();
        eventLoop.enter();
    }

    private native void _finishTerminating();

    @Override
    protected final void finishTerminating() {
        this._finishTerminating();
        super.finishTerminating();
    }

    private void notifyApplicationDidTerminate() {
        MacApplication.setEventThread(null);
    }

    @Override
    protected final void notifyDidResignActive() {
        this.firstDidResignActive = true;
        super.notifyDidResignActive();
    }

    @Override
    protected final void notifyDidBecomeActive() {
        if (this.firstDidResignActive) {
            this.reactivationLatch.countDown();
        }
        super.notifyDidBecomeActive();
    }

    private void setEventThread() {
        MacApplication.setEventThread(Thread.currentThread());
    }

    private native Object _enterNestedEventLoopImpl();

    @Override
    protected final Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            Object object = this._enterNestedEventLoopImpl();
            return object;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    private native void _leaveNestedEventLoopImpl(Object var1);

    @Override
    protected final void _leaveNestedEventLoop(Object object) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this._leaveNestedEventLoopImpl(object);
    }

    private native void _hide();

    private native void _hideOtherApplications();

    private native void _unhideAllApplications();

    public final void installAppleMenu(MenuBar menuBar) {
        this.appleMenu = this.createMenu("Apple");
        MacApplication macApplication = this;
        MenuItem menuItem = macApplication.createMenuItem("Hide " + macApplication.getName(), new MacApplication$1(this), 104, 16);
        this.appleMenu.add(menuItem);
        menuItem = this.createMenuItem("Hide Others", new MacApplication$2(this), 104, 24);
        this.appleMenu.add(menuItem);
        menuItem = this.createMenuItem("Show All", new MacApplication$3(this));
        this.appleMenu.add(menuItem);
        this.appleMenu.add(MenuItem.Separator);
        MacApplication macApplication2 = this;
        menuItem = macApplication2.createMenuItem("Quit " + macApplication2.getName(), new MacApplication$4(this), 113, 16);
        this.appleMenu.add(menuItem);
        menuBar.add(this.appleMenu);
    }

    public final Menu getAppleMenu() {
        return this.appleMenu;
    }

    @Override
    public final void installDefaultMenus(MenuBar menuBar) {
        this.installAppleMenu(menuBar);
    }

    @Override
    public final Window createWindow(Window window, Screen screen, int n2) {
        return new MacWindow(window, screen, n2);
    }

    @Override
    public final View createView() {
        return new MacView();
    }

    @Override
    public final Cursor createCursor(int n2) {
        return new MacCursor(n2);
    }

    @Override
    public final Cursor createCursor(int n2, int n3, Pixels pixels) {
        return new MacCursor(n2, n3, pixels);
    }

    @Override
    protected final void staticCursor_setVisible(boolean bl2) {
        MacCursor.setVisible_impl(bl2);
    }

    @Override
    protected final Size staticCursor_getBestSize(int n2, int n3) {
        return MacCursor.getBestSize_impl(n2, n3);
    }

    @Override
    public final Pixels createPixels(int n2, int n3, ByteBuffer byteBuffer) {
        return new MacPixels(n2, n3, byteBuffer);
    }

    @Override
    public final Pixels createPixels(int n2, int n3, ByteBuffer byteBuffer, float f2, float f3) {
        return new MacPixels(n2, n3, byteBuffer, f2, f3);
    }

    @Override
    public final Pixels createPixels(int n2, int n3, IntBuffer intBuffer) {
        return new MacPixels(n2, n3, intBuffer);
    }

    @Override
    public final Pixels createPixels(int n2, int n3, IntBuffer intBuffer, float f2, float f3) {
        return new MacPixels(n2, n3, intBuffer, f2, f3);
    }

    @Override
    protected final int staticPixels_getNativeFormat() {
        return MacPixels.getNativeFormat_impl();
    }

    @Override
    public final GlassRobot createRobot() {
        return new MacRobot();
    }

    @Override
    protected final native double staticScreen_getVideoRefreshPeriod();

    @Override
    protected final native Screen[] staticScreen_getScreens();

    @Override
    public final Timer createTimer(Runnable runnable) {
        return new MacTimer(runnable);
    }

    @Override
    protected final int staticTimer_getMinPeriod() {
        return MacTimer.getMinPeriod_impl();
    }

    @Override
    protected final int staticTimer_getMaxPeriod() {
        return MacTimer.getMaxPeriod_impl();
    }

    @Override
    public final Accessible createAccessible() {
        return new MacAccessible();
    }

    @Override
    protected final CommonDialogs$FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n2, boolean bl2, CommonDialogs$ExtensionFilter[] commonDialogs$ExtensionFilterArray, int n3) {
        return MacCommonDialogs.showFileChooser_impl(window, string, string2, string3, n2, bl2, commonDialogs$ExtensionFilterArray, n3);
    }

    @Override
    protected final File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return MacCommonDialogs.showFolderChooser_impl(window, string, string2);
    }

    @Override
    protected final long staticView_getMultiClickTime() {
        return MacView.getMultiClickTime_impl();
    }

    @Override
    protected final int staticView_getMultiClickMaxX() {
        return MacView.getMultiClickMaxX_impl();
    }

    @Override
    protected final int staticView_getMultiClickMaxY() {
        return MacView.getMultiClickMaxY_impl();
    }

    @Override
    protected final native void _invokeAndWait(Runnable var1);

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public final void submitForLaterInvocation(Runnable runnable) {
        this._submitForLaterInvocation(runnable);
    }

    @Override
    protected final void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
            return;
        }
        this.submitForLaterInvocation(runnable);
    }

    @Override
    protected final boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected final boolean _supportsTransparentWindows() {
        return true;
    }

    @Override
    protected final boolean _supportsUnifiedWindows() {
        return true;
    }

    @Override
    protected final native boolean _supportsSystemMenu();

    private native boolean _isTriggerReactivation();

    final boolean isTriggerReactivation() {
        return this._isTriggerReactivation();
    }

    private native String _getDataDirectory();

    @Override
    public final String getDataDirectory() {
        MacApplication.checkEventThread();
        String string = this._getDataDirectory();
        if (string == null || string.length() == 0) {
            return super.getDataDirectory();
        }
        return string + File.separator + this.name + File.separator;
    }

    @Override
    protected final native int _getKeyCodeForChar(char var1);

    @Override
    protected final native int _isKeyLocked(int var1);

    static {
        AccessController.doPrivileged(() -> {
            Application.loadNativeLibrary();
            return null;
        });
        boolean bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("glass.disableSyncRendering"));
        MacApplication._initIDs(bl2);
    }
}

