/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.TreeSet;

final class MacView
extends View {
    private static final long multiClickTime;
    private static final int multiClickMaxX;
    private static final int multiClickMaxY;

    MacView() {
    }

    private static native void _initIDs();

    private static native long _getMultiClickTime_impl();

    private static native int _getMultiClickMaxX_impl();

    private static native int _getMultiClickMaxY_impl();

    static long getMultiClickTime_impl() {
        return multiClickTime;
    }

    static int getMultiClickMaxX_impl() {
        return multiClickMaxX;
    }

    static int getMultiClickMaxY_impl() {
        return multiClickMaxY;
    }

    @Override
    protected final native int _getNativeFrameBuffer(long var1);

    @Override
    protected final native long _create(Map var1);

    @Override
    protected final native int _getX(long var1);

    @Override
    protected final native int _getY(long var1);

    @Override
    protected final native void _setParent(long var1, long var3);

    @Override
    protected final native boolean _close(long var1);

    @Override
    protected final native void _scheduleRepaint(long var1);

    @Override
    protected final native void _begin(long var1);

    @Override
    protected final native void _end(long var1);

    @Override
    protected final native boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    @Override
    protected final native void _exitFullscreen(long var1, boolean var3);

    @Override
    protected final native void _enableInputMethodEvents(long var1, boolean var3);

    @Override
    protected final void _uploadPixels(long l2, Pixels pixels) {
        Buffer buffer = pixels.getPixels();
        if (buffer.isDirect()) {
            this._uploadPixelsDirect(l2, buffer, pixels.getWidth(), pixels.getHeight(), pixels.getScaleX(), pixels.getScaleY());
            return;
        }
        if (buffer.hasArray()) {
            if (pixels.getBytesPerComponent() == 1) {
                buffer = (ByteBuffer)buffer;
                this._uploadPixelsByteArray(l2, ((ByteBuffer)buffer).array(), ((ByteBuffer)buffer).arrayOffset(), pixels.getWidth(), pixels.getHeight(), pixels.getScaleX(), pixels.getScaleY());
                return;
            }
            buffer = (IntBuffer)buffer;
            this._uploadPixelsIntArray(l2, ((IntBuffer)buffer).array(), ((IntBuffer)buffer).arrayOffset(), pixels.getWidth(), pixels.getHeight(), pixels.getScaleX(), pixels.getScaleY());
            return;
        }
        this._uploadPixelsDirect(l2, pixels.asByteBuffer(), pixels.getWidth(), pixels.getHeight(), pixels.getScaleX(), pixels.getScaleY());
    }

    private native void _uploadPixelsDirect(long var1, Buffer var3, int var4, int var5, float var6, float var7);

    private native void _uploadPixelsByteArray(long var1, byte[] var3, int var4, int var5, int var6, float var7, float var8);

    private native void _uploadPixelsIntArray(long var1, int[] var3, int var4, int var5, int var6, float var7, float var8);

    @Override
    protected final void notifyResize(int n2, int n3) {
        Window window = this.getWindow();
        float f2 = window == null ? 1.0f : window.getPlatformScaleX();
        float f3 = window == null ? 1.0f : window.getPlatformScaleY();
        n2 = Math.round((float)n2 * f2);
        n3 = Math.round((float)n3 * f3);
        super.notifyResize(n2, n3);
    }

    @Override
    protected final void notifyMouse(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2, boolean bl3) {
        Window window = this.getWindow();
        float f2 = window == null ? 1.0f : window.getPlatformScaleX();
        float f3 = window == null ? 1.0f : window.getPlatformScaleY();
        n4 = Math.round((float)n4 * f2);
        n5 = Math.round((float)n5 * f3);
        n6 = Math.round((float)n6 * f2);
        n7 = Math.round((float)n7 * f3);
        super.notifyMouse(n2, n3, n4, n5, n6, n7, n8, bl2, bl3);
    }

    @Override
    protected final long _getNativeView(long l2) {
        return l2;
    }

    protected final native long _getNativeLayer(long var1);

    public final long getNativeLayer() {
        MacView macView = this;
        return macView._getNativeLayer(macView.getNativeView());
    }

    protected final void notifyInputMethodMac(String string, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n2;
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray2[1] = n3;
        if (n2 == 4) {
            this.notifyInputMethod(string, null, nArray2, byArray2, n3, n4, 0);
            return;
        }
        if (n6 > 0 && string != null && string.length() > 0 && n5 >= 0 && n6 + n5 <= string.length()) {
            Object object = new TreeSet<Integer>();
            ((TreeSet)object).add(0);
            ((TreeSet)object).add(n5);
            ((TreeSet)object).add(n5 + n6);
            ((TreeSet)object).add(string.length());
            int[] nArray3 = new int[((TreeSet)object).size()];
            n6 = 0;
            object = ((TreeSet)object).iterator();
            while (object.hasNext()) {
                int n7;
                nArray3[n6] = n7 = ((Integer)object.next()).intValue();
                ++n6;
            }
            object = new byte[nArray3.length - 1];
            for (n6 = 0; n6 < nArray3.length - 1; ++n6) {
                object[n6] = nArray3[n6] == n5 ? 1 : 2;
            }
            this.notifyInputMethod(string, nArray3, nArray3, (byte[])object, 0, n4, 0);
            return;
        }
        this.notifyInputMethod(string, null, nArray2, byArray2, 0, n4, 0);
    }

    static {
        MacView._initIDs();
        multiClickTime = MacView._getMultiClickTime_impl();
        multiClickMaxX = MacView._getMultiClickMaxX_impl();
        multiClickMaxY = MacView._getMultiClickMaxY_impl();
    }
}

