/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.utils;

import com.sun.javafx.PlatformUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean verbose = false;
    private static File libDir = null;
    private static String libPrefix = "";
    private static String libSuffix = "";

    public static synchronized void loadLibrary(String string) {
        if (!loaded.contains(string)) {
            Object object = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
            object = ((StackWalker)object).getCallerClass();
            NativeLibLoader.loadLibraryInternal(string, null, (Class)object);
            loaded.add(string);
        }
    }

    public static synchronized void loadLibrary(String string, List<String> list) {
        if (!loaded.contains(string)) {
            Object object = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
            object = ((StackWalker)object).getCallerClass();
            NativeLibLoader.loadLibraryInternal(string, list, (Class)object);
            loaded.add(string);
        }
    }

    private static String[] initializePath(String string) {
        string = System.getProperty(string, "");
        String string2 = File.pathSeparator;
        int n2 = string.length();
        int n3 = string.indexOf(string2);
        int n4 = 0;
        while (n3 >= 0) {
            ++n4;
            n3 = string.indexOf(string2, n3 + 1);
        }
        String[] stringArray = new String[n4 + 1];
        n3 = 0;
        n4 = 0;
        int n5 = string.indexOf(string2);
        while (n5 >= 0) {
            if (n5 - n3 > 0) {
                stringArray[n4++] = string.substring(n3, n5);
            } else if (n5 - n3 == 0) {
                stringArray[n4++] = ".";
            }
            n3 = n5 + 1;
            n5 = string.indexOf(string2, n3);
        }
        stringArray[n4] = string.substring(n3, n2);
        return stringArray;
    }

    private static void loadLibraryInternal(String string, List<String> stringArray, Class clazz) {
        try {
            NativeLibLoader.loadLibraryFullPath(string);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (verbose) {
                System.err.println("WARNING: " + String.valueOf(unsatisfiedLinkError));
            }
            if (NativeLibLoader.loadLibraryFromResource(string, stringArray, clazz)) {
                return;
            }
            stringArray = NativeLibLoader.initializePath("java.library.path");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    Object object = stringArray[i2];
                    if (!((String)object).endsWith(File.separator)) {
                        object = (String)object + File.separator;
                    }
                    String string2 = System.mapLibraryName(string);
                    object = new File((String)object + string2);
                    System.load(((File)object).getAbsolutePath());
                    if (verbose) {
                        System.err.println("Loaded " + ((File)object).getAbsolutePath() + " from java.library.path");
                    }
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    continue;
                }
            }
            try {
                System.loadLibrary(string);
                if (verbose) {
                    System.err.println("System.loadLibrary(" + string + ") succeeded");
                }
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                if (PlatformUtil.isIOS() && string.contains("-")) {
                    string = string.replace("-", "_");
                    try {
                        System.loadLibrary(string);
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError4) {
                        UnsatisfiedLinkError unsatisfiedLinkError5 = unsatisfiedLinkError4;
                        throw unsatisfiedLinkError4;
                    }
                }
                throw unsatisfiedLinkError3;
            }
        }
    }

    private static boolean loadLibraryFromResource(String string, List<String> list, Class clazz) {
        return NativeLibLoader.installLibraryFromResource(string, list, clazz, true);
    }

    private static boolean installLibraryFromResource(String string, List<String> object, Class object2, boolean bl2) {
        try {
            Object object3;
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    object3 = (String)object.next();
                    NativeLibLoader.installLibraryFromResource((String)object3, null, (Class)object2, false);
                }
            }
            if ((object3 = ((Class)object2).getResourceAsStream((String)(object = "/" + System.mapLibraryName(string)))) != null) {
                object2 = NativeLibLoader.cacheLibrary((InputStream)object3, (String)object, (Class)object2);
                if (bl2) {
                    System.load((String)object2);
                    if (verbose) {
                        System.err.println("Loaded library " + (String)object + " from resource");
                    }
                } else if (verbose) {
                    System.err.println("Unpacked library " + (String)object + " from resource");
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            System.err.println("Loading library " + string + " from resource failed: " + String.valueOf(throwable));
            throwable.printStackTrace();
        }
        return false;
    }

    private static String cacheLibrary(InputStream inputStream, String object, Class clazz) throws IOException {
        Object object2;
        Closeable closeable;
        Object object3 = System.getProperty("javafx.runtime.version", "versionless");
        Object object4 = System.getProperty("javafx.cachedir", "");
        Object object5 = System.getProperty("os.arch");
        if (((String)object4).isEmpty()) {
            object4 = System.getProperty("user.home") + "/.openjfx/cache/" + (String)object3 + "/" + (String)object5;
        }
        object4 = new File((String)object4);
        boolean bl2 = true;
        if (((File)object4).exists()) {
            if (!((File)object4).isDirectory()) {
                System.err.println("Cache exists but is not a directory: " + String.valueOf(object4));
                bl2 = false;
            }
        } else if (!((File)object4).mkdirs()) {
            System.err.println("Can not create cache at " + String.valueOf(object4));
            bl2 = false;
        }
        if (!((File)object4).canRead()) {
            bl2 = false;
        }
        if (!bl2) {
            String string = System.getProperty("user.name", "anonymous");
            object3 = System.getProperty("java.io.tmpdir") + "/.openjfx_" + string + "/cache/" + (String)object3 + "/" + (String)object5;
            object4 = new File((String)object3);
            if (((File)object4).exists()) {
                if (!((File)object4).isDirectory()) {
                    throw new IOException("Cache exists but is not a directory: " + String.valueOf(object4));
                }
            } else if (!((File)object4).mkdirs()) {
                throw new IOException("Can not create cache at " + String.valueOf(object4));
            }
        }
        File file = new File((File)object4, (String)object);
        boolean bl3 = true;
        if (file.exists()) {
            try {
                closeable = new DigestInputStream(inputStream, MessageDigest.getInstance("MD5"));
                ((DigestInputStream)closeable).getMessageDigest().reset();
                object2 = new byte[4096];
                while (((FilterInputStream)closeable).read((byte[])object2) != -1) {
                }
                object5 = ((DigestInputStream)closeable).getMessageDigest().digest();
                inputStream.close();
                inputStream = clazz.getResourceAsStream((String)object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                object5 = new byte[1];
            }
            object = NativeLibLoader.calculateCheckSum(file);
            if (!Arrays.equals((byte[])object5, (byte[])object)) {
                Files.delete(file.toPath());
            } else {
                bl3 = false;
            }
        }
        if (bl3) {
            object5 = file.toPath();
            object = new File((File)object4, ".lock");
            try {
                closeable = new RandomAccessFile((File)object, "rw");
                try {
                    object2 = ((RandomAccessFile)closeable).getChannel();
                    try {
                        object = ((FileChannel)object2).lock();
                        try {
                            try {
                                if (!Files.exists((Path)object5, new LinkOption[0])) {
                                    Files.copy(inputStream, (Path)object5, new CopyOption[0]);
                                }
                            }
                            finally {
                                if (object != null) {
                                    ((FileLock)object).release();
                                }
                            }
                        }
                        finally {
                            if (object != null) {
                                ((FileLock)object).close();
                            }
                        }
                    }
                    finally {
                        if (object2 != null) {
                            ((AbstractInterruptibleChannel)object2).close();
                        }
                    }
                }
                finally {
                    ((RandomAccessFile)closeable).close();
                }
            }
            catch (IOException iOException) {
                throw new IOException("Error copying library " + String.valueOf(object5) + " to cache: " + iOException.getMessage(), iOException);
            }
        }
        object5 = file.getAbsolutePath();
        return object5;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateCheckSum(File object) {
        try {
            object = new FileInputStream((File)object);
            try {
                byte[] byArray;
                try (DigestInputStream digestInputStream = new DigestInputStream((InputStream)object, MessageDigest.getInstance("MD5"));){
                    digestInputStream.getMessageDigest().reset();
                    byte[] byArray2 = new byte[4096];
                    while (digestInputStream.read(byArray2) != -1) {
                    }
                    byArray = digestInputStream.getMessageDigest().digest();
                }
                return byArray;
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception) {
            return new byte[0];
        }
    }

    private static File libDirForJRT() {
        String string = System.getProperty("java.home");
        if (string == null || string.isEmpty()) {
            throw new UnsatisfiedLinkError("Cannot find java.home");
        }
        String string2 = null;
        if (PlatformUtil.isWindows()) {
            string2 = "bin/javafx";
        } else if (PlatformUtil.isMac()) {
            string2 = "lib";
        } else if (PlatformUtil.isLinux()) {
            string2 = "lib";
        }
        return new File(string + "/" + string2);
    }

    private static File libDirForJarFile(String object) throws Exception {
        object = ((String)object).substring(4, ((String)object).lastIndexOf(33));
        int n2 = Math.max(((String)object).lastIndexOf(47), ((String)object).lastIndexOf(92));
        String string = null;
        if (PlatformUtil.isWindows()) {
            string = "../bin";
        } else if (PlatformUtil.isMac()) {
            string = ".";
        } else if (PlatformUtil.isLinux()) {
            string = ".";
        }
        object = ((String)object).substring(0, n2) + "/" + string;
        return new File(new URI((String)object).getPath());
    }

    private static void loadLibraryFullPath(String string) {
        try {
            Object object;
            Object object2;
            if (libDir == null) {
                object2 = "NativeLibLoader.class";
                object = NativeLibLoader.class;
                if (((String)(object2 = NativeLibLoader.class.getResource((String)object2).toString())).startsWith("jrt:")) {
                    libDir = NativeLibLoader.libDirForJRT();
                } else if (((String)object2).startsWith("jar:file:") && ((String)object2).indexOf(33) > 0) {
                    libDir = NativeLibLoader.libDirForJarFile((String)object2);
                } else {
                    throw new UnsatisfiedLinkError("Invalid URL for class: " + (String)object2);
                }
                if (PlatformUtil.isWindows()) {
                    libPrefix = "";
                    libSuffix = ".dll";
                } else if (PlatformUtil.isMac()) {
                    libPrefix = "lib";
                    libSuffix = ".dylib";
                } else if (PlatformUtil.isLinux()) {
                    libPrefix = "lib";
                    libSuffix = ".so";
                }
            }
            object2 = new File(libDir, libPrefix + string + libSuffix);
            object = ((File)object2).getCanonicalPath();
            try {
                System.load((String)object);
                if (verbose) {
                    System.err.println("Loaded " + ((File)object2).getAbsolutePath() + " from relative path");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                object2 = unsatisfiedLinkError;
                throw unsatisfiedLinkError;
            }
        }
        catch (Exception exception) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(exception);
        }
    }

    static {
        AccessController.doPrivileged(() -> {
            verbose = Boolean.getBoolean("javafx.verbose");
            return null;
        });
    }
}

