/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Locale;
import java.util.Properties;

public class PlatformUtil {
    private static final String os;
    private static final String version;
    private static final boolean embedded;
    private static final String embeddedType;
    private static final boolean useEGL;
    private static final boolean doEGLCompositing;
    private static String javafxPlatform;
    private static final boolean ANDROID;
    private static final boolean WINDOWS;
    private static final boolean WINDOWS_VISTA_OR_LATER;
    private static final boolean WINDOWS_7_OR_LATER;
    private static final boolean MAC;
    private static final boolean LINUX;
    private static final boolean SOLARIS;
    private static final boolean IOS;
    private static final boolean STATIC_BUILD;

    private static boolean versionNumberGreaterThanOrEqualTo(float f2) {
        try {
            return Float.parseFloat(version) >= f2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static boolean isWinVistaOrLater() {
        return WINDOWS_VISTA_OR_LATER;
    }

    public static boolean isWin7OrLater() {
        return WINDOWS_7_OR_LATER;
    }

    public static boolean isMac() {
        return MAC;
    }

    public static boolean isLinux() {
        return LINUX;
    }

    public static boolean useEGL() {
        return useEGL;
    }

    public static boolean useEGLWindowComposition() {
        return doEGLCompositing;
    }

    public static boolean useGLES2() {
        String string = AccessController.doPrivileged(() -> System.getProperty("use.gles2"));
        return "true".equals(string);
    }

    public static boolean isSolaris() {
        return SOLARIS;
    }

    public static boolean isUnix() {
        return LINUX || SOLARIS;
    }

    public static boolean isEmbedded() {
        return embedded;
    }

    public static String getEmbeddedType() {
        return embeddedType;
    }

    public static boolean isIOS() {
        return IOS;
    }

    public static boolean isStaticBuild() {
        return STATIC_BUILD;
    }

    private static void loadPropertiesFromFile(File object) {
        Properties properties = new Properties();
        try {
            object = new FileInputStream((File)object);
            properties.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        if (javafxPlatform == null) {
            javafxPlatform = properties.getProperty("javafx.platform");
        }
        object = javafxPlatform + ".";
        int n2 = ((String)object).length();
        boolean bl2 = false;
        for (Object object2 : properties.keySet()) {
            if (!((String)(object2 = (String)object2)).startsWith((String)object)) continue;
            bl2 = true;
            String string = ((String)object2).substring(n2);
            if (System.getProperty(string) != null) continue;
            object2 = properties.getProperty((String)object2);
            System.setProperty(string, (String)object2);
        }
        if (!bl2) {
            System.err.println("Warning: No settings found for javafx.platform='" + javafxPlatform + "'");
        }
    }

    private static File getRTDir() {
        try {
            Object object = "PlatformUtil.class";
            Class<PlatformUtil> clazz = PlatformUtil.class;
            object = PlatformUtil.class.getResource((String)object);
            if (object == null) {
                return null;
            }
            if (!((String)(object = ((URL)object).toString())).startsWith("jar:file:") || ((String)object).indexOf(33) == -1) {
                return null;
            }
            object = ((String)object).substring(4, ((String)object).lastIndexOf(33));
            int n2 = Math.max(((String)object).lastIndexOf(47), ((String)object).lastIndexOf(92));
            return new File(new URL(((String)object).substring(0, n2 + 1)).getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static void loadProperties() {
        String string = System.getProperty("java.vm.name");
        String string2 = System.getProperty("os.arch");
        if (!(javafxPlatform != null || string2 != null && string2.equals("arm") || string != null && string.indexOf("Embedded") > 0)) {
            return;
        }
        AccessController.doPrivileged(() -> {
            Object object = PlatformUtil.getRTDir();
            if (((File)(object = new File((File)object, "javafx.platform.properties"))).exists()) {
                PlatformUtil.loadPropertiesFromFile((File)object);
                return null;
            }
            object = System.getProperty("java.home");
            if (((File)(object = new File((String)object, "lib" + File.separator + "javafx.platform.properties"))).exists()) {
                PlatformUtil.loadPropertiesFromFile((File)object);
                return null;
            }
            object = System.getProperty("javafx.runtime.path");
            if (((File)(object = new File((String)object, File.separator + "javafx.platform.properties"))).exists()) {
                PlatformUtil.loadPropertiesFromFile((File)object);
                return null;
            }
            return null;
        });
    }

    public static boolean isAndroid() {
        return ANDROID;
    }

    static {
        boolean bl2;
        String string;
        boolean bl3;
        String string2;
        os = System.getProperty("os.name");
        version = System.getProperty("os.version");
        javafxPlatform = string2 = AccessController.doPrivileged(() -> System.getProperty("javafx.platform"));
        PlatformUtil.loadProperties();
        embedded = bl3 = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.javafx.isEmbedded")).booleanValue();
        embeddedType = string = AccessController.doPrivileged(() -> System.getProperty("glass.platform", "").toLowerCase(Locale.ROOT));
        useEGL = bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("use.egl")).booleanValue();
        doEGLCompositing = bl2 ? (bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("doNativeComposite")).booleanValue()) : false;
        ANDROID = "android".equals(javafxPlatform) || "Dalvik".equals(System.getProperty("java.vm.name"));
        WINDOWS = os.startsWith("Windows");
        WINDOWS_VISTA_OR_LATER = WINDOWS && PlatformUtil.versionNumberGreaterThanOrEqualTo(6.0f);
        WINDOWS_7_OR_LATER = WINDOWS && PlatformUtil.versionNumberGreaterThanOrEqualTo(6.1f);
        MAC = os.startsWith("Mac");
        LINUX = os.startsWith("Linux") && !ANDROID;
        SOLARIS = os.startsWith("SunOS");
        IOS = os.startsWith("iOS");
        STATIC_BUILD = "Substrate VM".equals(System.getProperty("java.vm.name"));
    }
}

