/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import java.lang.module.ModuleDescriptor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;

public final class ModuleAccess {
    private final Object module;
    private static final Method bootLayerMethod;
    private static final Method getModuleNameMethod;
    private static final Method findModuleMethod;
    private static final Method getDescriptorMethod;
    private static final Method classForNameMethod;

    private ModuleAccess(Object object) {
        this.module = object;
    }

    final ModuleDescriptor getDescriptor() {
        try {
            return (ModuleDescriptor)getDescriptorMethod.invoke(this.module, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    final String getName() {
        try {
            return (String)getModuleNameMethod.invoke(this.module, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    final Class<?> classForName(String string) {
        try {
            return (Class)classForNameMethod.invoke(null, this.module, string);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    static ModuleAccess load(String string) {
        try {
            Object object = bootLayerMethod.invoke(null, new Object[0]);
            object = (Optional)findModuleMethod.invoke(object, string);
            if (!((Optional)object).isPresent()) {
                throw new InternalError("Module " + string + " not in boot Layer");
            }
            return new ModuleAccess(((Optional)object).get());
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    static {
        GenericDeclaration genericDeclaration;
        Method method;
        Method method2;
        Method method3;
        GenericDeclaration genericDeclaration2;
        try {
            genericDeclaration2 = Class.class.getMethod("getModule", new Class[0]);
            genericDeclaration2 = ((Method)genericDeclaration2).getReturnType();
            method3 = ((Class)genericDeclaration2).getMethod("getLayer", new Class[0]);
            method2 = ((Class)genericDeclaration2).getMethod("getDescriptor", new Class[0]);
            method = ((Class)genericDeclaration2).getMethod("getName", new Class[0]);
            genericDeclaration = method3.getReturnType();
            method3 = genericDeclaration.getMethod("boot", new Class[0]);
            genericDeclaration = genericDeclaration.getMethod("findModule", String.class);
            genericDeclaration2 = Class.class.getMethod("forName", new Class[]{genericDeclaration2, String.class});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError("Module reflection failed", noSuchMethodException);
        }
        bootLayerMethod = method3;
        getModuleNameMethod = method;
        getDescriptorMethod = method2;
        findModuleMethod = genericDeclaration;
        classForNameMethod = genericDeclaration2;
    }
}

