/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Application;
import javafx.application.Application$Parameters;

public class ParametersImpl
extends Application$Parameters {
    private List<String> rawArgs = new ArrayList<String>();
    private Map<String, String> namedParams = new HashMap<String, String>();
    private List<String> unnamedParams = new ArrayList<String>();
    private List<String> readonlyRawArgs = null;
    private Map<String, String> readonlyNamedParams = null;
    private List<String> readonlyUnnamedParams = null;
    private static Map<Application, Application$Parameters> params = new HashMap<Application, Application$Parameters>();

    public ParametersImpl() {
    }

    public ParametersImpl(List<String> list) {
        if (list != null) {
            this.init(list);
        }
    }

    public ParametersImpl(String[] stringArray) {
        if (stringArray != null) {
            this.init(Arrays.asList(stringArray));
        }
    }

    public ParametersImpl(Map map, String[] stringArray) {
        this.init(map, stringArray);
    }

    private void init(List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (string == null) continue;
            this.rawArgs.add(string);
        }
        this.computeNamedParams();
        this.computeUnnamedParams();
    }

    private void init(Map map, String[] stringArray) {
        Object object;
        for (Map.Entry entry : map.entrySet()) {
            Object k2 = entry.getKey();
            if (!this.validKey(k2) || !((object = map.get(k2)) instanceof String)) continue;
            this.namedParams.put((String)k2, (String)object);
        }
        this.computeRawArgs();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object = stringArray2[i2];
                this.unnamedParams.add((String)object);
                this.rawArgs.add((String)object);
            }
        }
    }

    private boolean validFirstChar(char c2) {
        return Character.isLetter(c2) || c2 == '_';
    }

    private boolean validKey(Object object) {
        if (object instanceof String && ((String)(object = (String)object)).length() > 0 && ((String)object).indexOf(61) < 0) {
            return this.validFirstChar(((String)object).charAt(0));
        }
        return false;
    }

    private boolean isNamedParam(String string) {
        if (string.startsWith("--")) {
            return string.indexOf(61) > 2 && this.validFirstChar(string.charAt(2));
        }
        return false;
    }

    private void computeUnnamedParams() {
        for (String string : this.rawArgs) {
            if (this.isNamedParam(string)) continue;
            this.unnamedParams.add(string);
        }
    }

    private void computeNamedParams() {
        for (String string : this.rawArgs) {
            if (!this.isNamedParam(string)) continue;
            int n2 = string.indexOf(61);
            String string2 = string.substring(2, n2);
            string = string.substring(n2 + 1);
            this.namedParams.put(string2, string);
        }
    }

    private void computeRawArgs() {
        Object object = new ArrayList<String>();
        ((ArrayList)object).addAll(this.namedParams.keySet());
        Collections.sort(object);
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.rawArgs.add("--" + string + "=" + this.namedParams.get(string));
        }
    }

    @Override
    public List<String> getRaw() {
        if (this.readonlyRawArgs == null) {
            this.readonlyRawArgs = Collections.unmodifiableList(this.rawArgs);
        }
        return this.readonlyRawArgs;
    }

    @Override
    public Map<String, String> getNamed() {
        if (this.readonlyNamedParams == null) {
            this.readonlyNamedParams = Collections.unmodifiableMap(this.namedParams);
        }
        return this.readonlyNamedParams;
    }

    @Override
    public List<String> getUnnamed() {
        if (this.readonlyUnnamedParams == null) {
            this.readonlyUnnamedParams = Collections.unmodifiableList(this.unnamedParams);
        }
        return this.readonlyUnnamedParams;
    }

    public static Application$Parameters getParameters(Application object) {
        object = params.get(object);
        return object;
    }

    public static void registerParameters(Application application, Application$Parameters application$Parameters) {
        params.put(application, application$Parameters);
    }
}

