/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.glass.ui.Application;
import com.sun.javafx.FXPermissions;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl$1;
import com.sun.javafx.application.PlatformImpl$FinishListener;
import com.sun.javafx.application.PlatformImpl$HighContrastScheme;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.tk.TKListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.ModuleHelper;
import com.sun.javafx.util.Utils;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.application.ConditionalFeature;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Scene;
import javafx.util.FXPermission;

public class PlatformImpl {
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static AtomicBoolean platformExit = new AtomicBoolean(false);
    private static AtomicBoolean toolkitExit = new AtomicBoolean(false);
    private static CountDownLatch startupLatch = new CountDownLatch(1);
    private static AtomicBoolean listenersRegistered = new AtomicBoolean(false);
    private static TKListener toolkitListener = null;
    private static volatile boolean implicitExit = true;
    private static boolean taskbarApplication = true;
    private static boolean contextual2DNavigation;
    private static AtomicInteger pendingRunnables;
    private static AtomicInteger numWindows;
    private static volatile boolean firstWindowShown;
    private static volatile boolean lastWindowClosed;
    private static AtomicBoolean reallyIdle;
    private static Set<PlatformImpl$FinishListener> finishListeners;
    private static final Object runLaterLock;
    private static Boolean isGraphicsSupported;
    private static Boolean isControlsSupported;
    private static Boolean isMediaSupported;
    private static Boolean isWebSupported;
    private static Boolean isSWTSupported;
    private static Boolean isSwingSupported;
    private static Boolean isFXMLSupported;
    private static Boolean hasTwoLevelFocus;
    private static Boolean hasVirtualKeyboard;
    private static Boolean hasTouch;
    private static Boolean hasMultiTouch;
    private static Boolean hasPointer;
    private static boolean isThreadMerged;
    private static String applicationType;
    private static BooleanProperty accessibilityActive;
    private static CountDownLatch allNestedLoopsExitedLatch;
    private static final boolean verbose;
    private static final boolean DEBUG;
    private static final FXPermission FXCANVAS_PERMISSION;
    private static final CountDownLatch platformExitLatch;
    private static boolean isModena;
    private static boolean isCaspian;
    private static String accessibilityTheme;

    public static void setTaskbarApplication(boolean bl2) {
        taskbarApplication = bl2;
    }

    public static boolean isTaskbarApplication() {
        return taskbarApplication;
    }

    public static void setApplicationName(Class clazz) {
        PlatformImpl.runLater(() -> Application.GetApplication().setName(clazz.getName()));
    }

    public static boolean isContextual2DNavigation() {
        return contextual2DNavigation;
    }

    public static void startup(Runnable runnable) {
        PlatformImpl.startup(runnable, false);
    }

    public static void startup(Runnable runnable, boolean bl2) {
        if (platformExit.get()) {
            throw new IllegalStateException("Platform.exit has been called");
        }
        if (initialized.getAndSet(true)) {
            if (bl2) {
                throw new IllegalStateException("Toolkit already initialized");
            }
            PlatformImpl.runLater(runnable);
            return;
        }
        Object object = PlatformImpl.class.getModule();
        ModuleDescriptor moduleDescriptor = ((Module)object).getDescriptor();
        if (!((Module)object).isNamed() || !"javafx.graphics".equals(((Module)object).getName()) || moduleDescriptor == null || moduleDescriptor.isAutomatic() || moduleDescriptor.isOpen()) {
            object = "Unsupported JavaFX configuration: classes were loaded from '" + String.valueOf(object) + "'";
            if (moduleDescriptor != null) {
                object = (String)object + ", isAutomatic: " + moduleDescriptor.isAutomatic();
                object = (String)object + ", isOpen: " + moduleDescriptor.isOpen();
            }
            Logging.getJavaFXLogger().warning((String)object);
        }
        AccessController.doPrivileged(() -> {
            applicationType = System.getProperty("com.sun.javafx.application.type");
            if (applicationType == null) {
                applicationType = "";
            }
            contextual2DNavigation = Boolean.getBoolean("com.sun.javafx.isContextual2DNavigation");
            String string = System.getProperty("com.sun.javafx.twoLevelFocus");
            if (string != null) {
                hasTwoLevelFocus = Boolean.valueOf(string);
            }
            if ((string = System.getProperty("com.sun.javafx.virtualKeyboard")) != null) {
                if (string.equalsIgnoreCase("none")) {
                    hasVirtualKeyboard = Boolean.FALSE;
                } else if (string.equalsIgnoreCase("javafx")) {
                    hasVirtualKeyboard = Boolean.TRUE;
                } else if (string.equalsIgnoreCase("native")) {
                    hasVirtualKeyboard = Boolean.TRUE;
                }
            }
            if ((string = System.getProperty("com.sun.javafx.touch")) != null) {
                hasTouch = Boolean.valueOf(string);
            }
            if ((string = System.getProperty("com.sun.javafx.multiTouch")) != null) {
                hasMultiTouch = Boolean.valueOf(string);
            }
            if ((string = System.getProperty("com.sun.javafx.pointer")) != null) {
                hasPointer = Boolean.valueOf(string);
            }
            if ((string = System.getProperty("javafx.embed.singleThread")) != null && (isThreadMerged = Boolean.valueOf(string).booleanValue()) && !PlatformImpl.isSupported(ConditionalFeature.SWING)) {
                isThreadMerged = false;
                if (verbose) {
                    System.err.println("WARNING: javafx.embed.singleThread ignored (javafx.swing module not found)");
                }
            }
            return null;
        });
        if (DEBUG) {
            System.err.println("PlatformImpl::startup : applicationType = " + applicationType);
        }
        if ("FXCanvas".equals(applicationType)) {
            PlatformImpl.initFXCanvas();
        }
        if (!taskbarApplication) {
            AccessController.doPrivileged(() -> {
                System.setProperty("glass.taskbarApplication", "false");
                return null;
            });
        }
        toolkitListener = new PlatformImpl$1();
        Toolkit.getToolkit().addTkListener(toolkitListener);
        Toolkit.getToolkit().startup(() -> {
            startupLatch.countDown();
            runnable.run();
        });
        if (isThreadMerged) {
            PlatformImpl.installFwEventQueue();
        }
    }

    private static void initDeviceDetailsFXCanvas() {
        long l2 = AccessController.doPrivileged(() -> Long.getLong("javafx.embed.eventProc", 0L));
        if (l2 != 0L) {
            HashMap<String, Long> hashMap = Application.getDeviceDetails();
            if (hashMap == null) {
                hashMap = new HashMap<String, Long>();
                Application.setDeviceDetails(hashMap);
            }
            if (hashMap.get("javafx.embed.eventProc") == null) {
                hashMap.put("javafx.embed.eventProc", l2);
            }
        }
    }

    private static void addExportsToFXCanvas(Class<?> object) {
        String[] stringArray = new String[]{"com.sun.glass.ui", "com.sun.javafx.cursor", "com.sun.javafx.embed", "com.sun.javafx.stage", "com.sun.javafx.tk"};
        if (DEBUG) {
            System.err.println("addExportsToFXCanvas: class = " + String.valueOf(object));
        }
        Object object2 = ModuleHelper.getModule(PlatformImpl.class);
        object = ModuleHelper.getModule(object);
        int cfr_ignored_0 = stringArray.length;
        for (int i2 = 0; i2 < 5; ++i2) {
            String string = stringArray[i2];
            if (DEBUG) {
                System.err.println("add export of " + string + " from " + String.valueOf(object2) + " to " + String.valueOf(object));
            }
            ModuleHelper.addExports(object2, string, object);
        }
    }

    private static void initFXCanvas() {
        Object object = System.getSecurityManager();
        if (object != null) {
            try {
                ((SecurityManager)object).checkPermission(FXCANVAS_PERMISSION);
            }
            catch (SecurityException securityException) {
                System.err.println("FXCanvas: no permission to access JavaFX internals");
                securityException.printStackTrace();
                return;
            }
        }
        object = stackFrame -> !stackFrame.getClassName().startsWith("javafx.application.") && !stackFrame.getClassName().startsWith("com.sun.javafx.application.");
        StackWalker stackWalker = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
        object = stackWalker.walk(arg_0 -> PlatformImpl.lambda$initFXCanvas$9((Predicate)object, arg_0));
        if (((Optional)object).isPresent()) {
            object = ((StackWalker.StackFrame)((Optional)object).get()).getDeclaringClass();
            if (DEBUG) {
                System.err.println("callerClassName = " + String.valueOf(object));
            }
            if ("javafx.embed.swt.FXCanvas".equals(((Class)object).getName())) {
                PlatformImpl.initDeviceDetailsFXCanvas();
                PlatformImpl.addExportsToFXCanvas(object);
            }
        }
    }

    private static void installFwEventQueue() {
        PlatformImpl.invokeSwingFXUtilsMethod("installFwEventQueue");
    }

    private static void removeFwEventQueue() {
        PlatformImpl.invokeSwingFXUtilsMethod("removeFwEventQueue");
    }

    private static void invokeSwingFXUtilsMethod(String object) {
        try {
            Class<?> clazz = Class.forName("com.sun.javafx.embed.swing.SwingFXUtilsImpl");
            object = clazz.getDeclaredMethod((String)object, new Class[0]);
            PlatformImpl.waitForStart();
            ((Method)object).invoke(null, new Object[0]);
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new RuntimeException("Property javafx.embed.singleThread is not supported");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    private static void waitForStart() {
        if (startupLatch.getCount() > 0L) {
            try {
                startupLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
        }
    }

    public static boolean isFxApplicationThread() {
        return Toolkit.getToolkit().isFxUserThread();
    }

    public static void runLater(Runnable runnable) {
        PlatformImpl.runLater(runnable, false);
    }

    private static void runLater(Runnable runnable, boolean bl2) {
        if (!initialized.get()) {
            throw new IllegalStateException("Toolkit not initialized");
        }
        pendingRunnables.incrementAndGet();
        PlatformImpl.waitForStart();
        Object object = runLaterLock;
        synchronized (object) {
            if (!bl2 && toolkitExit.get()) {
                pendingRunnables.decrementAndGet();
                return;
            }
            AccessControlContext accessControlContext = AccessController.getContext();
            Toolkit.getToolkit().defer(() -> {
                try {
                    AccessController.doPrivileged(() -> {
                        runnable.run();
                        return null;
                    }, accessControlContext);
                    return;
                }
                finally {
                    pendingRunnables.decrementAndGet();
                    PlatformImpl.checkIdle();
                }
            });
            return;
        }
    }

    public static void runAndWait(Runnable runnable) {
        PlatformImpl.runAndWait(runnable, false);
    }

    private static void runAndWait(Runnable object, boolean bl2) {
        if (PlatformImpl.isFxApplicationThread()) {
            try {
                object.run();
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Exception in runnable");
                throwable.printStackTrace();
                return;
            }
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        PlatformImpl.runLater(() -> PlatformImpl.lambda$runAndWait$12((Runnable)object, countDownLatch), bl2);
        if (!bl2 && toolkitExit.get()) {
            throw new IllegalStateException("Toolkit has exited");
        }
        try {
            countDownLatch.await();
            return;
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
    }

    public static void setImplicitExit(boolean bl2) {
        implicitExit = bl2;
        PlatformImpl.checkIdle();
    }

    public static boolean isImplicitExit() {
        return implicitExit;
    }

    public static void addListener(PlatformImpl$FinishListener platformImpl$FinishListener) {
        listenersRegistered.set(true);
        finishListeners.add(platformImpl$FinishListener);
    }

    public static void removeListener(PlatformImpl$FinishListener platformImpl$FinishListener) {
        finishListeners.remove(platformImpl$FinishListener);
        listenersRegistered.set(!finishListeners.isEmpty());
        if (!listenersRegistered.get()) {
            PlatformImpl.checkIdle();
        }
    }

    private static void notifyFinishListeners(boolean bl2) {
        if (listenersRegistered.get()) {
            for (PlatformImpl$FinishListener platformImpl$FinishListener : finishListeners) {
                if (bl2) {
                    platformImpl$FinishListener.exitCalled();
                    continue;
                }
                platformImpl$FinishListener.idle(implicitExit);
            }
            return;
        }
        if (implicitExit || platformExit.get()) {
            PlatformImpl.tkExit();
        }
    }

    private static void checkIdle() {
        if (!initialized.get()) {
            return;
        }
        if (!PlatformImpl.isFxApplicationThread()) {
            PlatformImpl.runLater(() -> {});
            return;
        }
        boolean bl2 = false;
        Class<PlatformImpl> clazz = PlatformImpl.class;
        synchronized (PlatformImpl.class) {
            int n2 = numWindows.get();
            if (n2 > 0) {
                firstWindowShown = true;
                lastWindowClosed = false;
                reallyIdle.set(false);
            } else if (n2 == 0 && firstWindowShown) {
                lastWindowClosed = true;
            }
            if (lastWindowClosed && pendingRunnables.get() == 0 && (toolkitExit.get() || !Toolkit.getToolkit().isNestedLoopRunning())) {
                if (reallyIdle.getAndSet(true)) {
                    bl2 = true;
                    lastWindowClosed = false;
                } else {
                    PlatformImpl.runLater(() -> {});
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            if (bl2) {
                PlatformImpl.notifyFinishListeners(false);
            }
            return;
        }
    }

    static CountDownLatch test_getPlatformExitLatch() {
        return platformExitLatch;
    }

    public static void tkExit() {
        if (toolkitExit.getAndSet(true)) {
            return;
        }
        if (initialized.get()) {
            if (platformExit.get()) {
                PlatformImpl.runAndWait(() -> {
                    if (Toolkit.getToolkit().isNestedLoopRunning()) {
                        Toolkit.getToolkit().exitAllNestedEventLoops();
                        return;
                    }
                    allNestedLoopsExitedLatch.countDown();
                }, true);
                try {
                    allNestedLoopsExitedLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Could not exit all nested event loops");
                }
            }
            PlatformImpl.runAndWait(() -> Toolkit.getToolkit().exit(), true);
            if (isThreadMerged) {
                PlatformImpl.removeFwEventQueue();
            }
            Toolkit.getToolkit().removeTkListener(toolkitListener);
            toolkitListener = null;
            platformExitLatch.countDown();
        }
    }

    public static BooleanProperty accessibilityActiveProperty() {
        return accessibilityActive;
    }

    public static void exit() {
        platformExit.set(true);
        PlatformImpl.notifyFinishListeners(true);
    }

    private static Boolean checkForClass(String string) {
        try {
            Class.forName(string, false, PlatformImpl.class.getClassLoader());
            return Boolean.TRUE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Boolean.FALSE;
        }
    }

    public static boolean isSupported(ConditionalFeature object) {
        boolean bl2 = PlatformImpl.isSupportedImpl((ConditionalFeature)((Object)object));
        if (bl2 && object == ConditionalFeature.TRANSPARENT_WINDOW) {
            object = System.getSecurityManager();
            if (object != null) {
                try {
                    ((SecurityManager)object).checkPermission(FXPermissions.CREATE_TRANSPARENT_WINDOW_PERMISSION);
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
            return true;
        }
        return bl2;
    }

    public static void setDefaultPlatformUserAgentStylesheet() {
        PlatformImpl.setPlatformUserAgentStylesheet("MODENA");
    }

    public static boolean isModena() {
        return isModena;
    }

    public static boolean isCaspian() {
        return isCaspian;
    }

    public static void setPlatformUserAgentStylesheet(String string) {
        if (PlatformImpl.isFxApplicationThread()) {
            PlatformImpl._setPlatformUserAgentStylesheet(string);
            return;
        }
        PlatformImpl.runLater(() -> PlatformImpl._setPlatformUserAgentStylesheet(string));
    }

    public static boolean setAccessibilityTheme(String string) {
        if (accessibilityTheme != null) {
            StyleManager.getInstance().removeUserAgentStylesheet(accessibilityTheme);
            accessibilityTheme = null;
        }
        PlatformImpl._setAccessibilityTheme(string);
        if (accessibilityTheme != null) {
            StyleManager.getInstance().addUserAgentStylesheet(accessibilityTheme);
            return true;
        }
        return false;
    }

    private static void _setAccessibilityTheme(String string) {
        block18: {
            block19: {
                String string2;
                block17: {
                    string2 = AccessController.doPrivileged(() -> System.getProperty("com.sun.javafx.highContrastTheme"));
                    if (!PlatformImpl.isCaspian()) break block17;
                    if (string != null || string2 != null) {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/caspian/highcontrast.css";
                        return;
                    }
                    break block18;
                }
                if (!PlatformImpl.isModena()) break block18;
                if (string2 == null) break block19;
                switch (string2.toUpperCase()) {
                    case "BLACKONWHITE": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css";
                        break block18;
                    }
                    case "WHITEONBLACK": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css";
                        break block18;
                    }
                    case "YELLOWONBLACK": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css";
                    }
                    default: {
                        return;
                    }
                }
            }
            if (string != null) {
                switch (PlatformImpl$HighContrastScheme.valueOf(string)) {
                    case HIGH_CONTRAST_WHITE: {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css";
                        return;
                    }
                    case HIGH_CONTRAST_BLACK: {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css";
                        return;
                    }
                    case HIGH_CONTRAST_1: 
                    case HIGH_CONTRAST_2: {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css";
                    }
                }
            }
        }
    }

    private static void _setPlatformUserAgentStylesheet(String string) {
        isCaspian = false;
        isModena = false;
        Object object = AccessController.doPrivileged(() -> System.getProperty("javafx.userAgentStylesheetUrl"));
        if (object != null) {
            string = object;
        }
        object = new ArrayList();
        if ("CASPIAN".equalsIgnoreCase(string)) {
            isCaspian = true;
            object.add("com/sun/javafx/scene/control/skin/caspian/caspian.css");
            if (PlatformImpl.isSupported(ConditionalFeature.INPUT_TOUCH)) {
                object.add("com/sun/javafx/scene/control/skin/caspian/embedded.css");
                if (Utils.isQVGAScreen()) {
                    object.add("com/sun/javafx/scene/control/skin/caspian/embedded-qvga.css");
                }
                if (PlatformUtil.isAndroid()) {
                    object.add("com/sun/javafx/scene/control/skin/caspian/android.css");
                }
                if (PlatformUtil.isIOS()) {
                    object.add("com/sun/javafx/scene/control/skin/caspian/ios.css");
                }
            }
            if (PlatformImpl.isSupported(ConditionalFeature.TWO_LEVEL_FOCUS)) {
                object.add("com/sun/javafx/scene/control/skin/caspian/two-level-focus.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD)) {
                object.add("com/sun/javafx/scene/control/skin/caspian/fxvk.css");
            }
            if (!PlatformImpl.isSupported(ConditionalFeature.TRANSPARENT_WINDOW)) {
                object.add("com/sun/javafx/scene/control/skin/caspian/caspian-no-transparency.css");
            }
        } else if ("MODENA".equalsIgnoreCase(string)) {
            isModena = true;
            object.add("com/sun/javafx/scene/control/skin/modena/modena.css");
            if (PlatformImpl.isSupported(ConditionalFeature.INPUT_TOUCH)) {
                object.add("com/sun/javafx/scene/control/skin/modena/touch.css");
            }
            if (PlatformUtil.isEmbedded()) {
                object.add("com/sun/javafx/scene/control/skin/modena/modena-embedded-performance.css");
            }
            if (PlatformUtil.isAndroid()) {
                object.add("com/sun/javafx/scene/control/skin/modena/android.css");
            }
            if (PlatformUtil.isIOS()) {
                object.add("com/sun/javafx/scene/control/skin/modena/ios.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.TWO_LEVEL_FOCUS)) {
                object.add("com/sun/javafx/scene/control/skin/modena/two-level-focus.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD)) {
                object.add("com/sun/javafx/scene/control/skin/caspian/fxvk.css");
            }
            if (!PlatformImpl.isSupported(ConditionalFeature.TRANSPARENT_WINDOW)) {
                object.add("com/sun/javafx/scene/control/skin/modena/modena-no-transparency.css");
            }
        } else {
            object.add(string);
        }
        PlatformImpl._setAccessibilityTheme(Toolkit.getToolkit().getThemeName());
        if (accessibilityTheme != null) {
            object.add(accessibilityTheme);
        }
        AccessController.doPrivileged(() -> PlatformImpl.lambda$_setPlatformUserAgentStylesheet$20((List)object));
    }

    public static void addNoTransparencyStylesheetToScene(Scene scene) {
        if (PlatformImpl.isCaspian()) {
            AccessController.doPrivileged(() -> {
                StyleManager.getInstance().addUserAgentStylesheet(scene, "com/sun/javafx/scene/control/skin/caspian/caspian-no-transparency.css");
                return null;
            });
            return;
        }
        if (PlatformImpl.isModena()) {
            AccessController.doPrivileged(() -> {
                StyleManager.getInstance().addUserAgentStylesheet(scene, "com/sun/javafx/scene/control/skin/modena/modena-no-transparency.css");
                return null;
            });
        }
    }

    private static boolean isSupportedImpl(ConditionalFeature conditionalFeature) {
        switch (conditionalFeature) {
            case GRAPHICS: {
                if (isGraphicsSupported == null) {
                    isGraphicsSupported = PlatformImpl.checkForClass("javafx.stage.Stage");
                }
                return isGraphicsSupported;
            }
            case CONTROLS: {
                if (isControlsSupported == null) {
                    isControlsSupported = PlatformImpl.checkForClass("javafx.scene.control.Control");
                }
                return isControlsSupported;
            }
            case MEDIA: {
                if (isMediaSupported == null && (isMediaSupported = PlatformImpl.checkForClass("javafx.scene.media.MediaView")).booleanValue() && PlatformUtil.isEmbedded()) {
                    AccessController.doPrivileged(() -> {
                        String string = System.getProperty("com.sun.javafx.experimental.embedded.media", "false");
                        isMediaSupported = Boolean.valueOf(string);
                        return null;
                    });
                }
                return isMediaSupported;
            }
            case WEB: {
                if (isWebSupported == null && (isWebSupported = PlatformImpl.checkForClass("javafx.scene.web.WebView")).booleanValue() && PlatformUtil.isEmbedded()) {
                    AccessController.doPrivileged(() -> {
                        String string = System.getProperty("com.sun.javafx.experimental.embedded.web", "false");
                        isWebSupported = Boolean.valueOf(string);
                        return null;
                    });
                }
                return isWebSupported;
            }
            case SWT: {
                if (isSWTSupported == null) {
                    isSWTSupported = PlatformImpl.checkForClass("javafx.embed.swt.FXCanvas");
                }
                return isSWTSupported;
            }
            case SWING: {
                if (isSwingSupported == null) {
                    isSwingSupported = PlatformImpl.checkForClass("javax.swing.JComponent") != false && PlatformImpl.checkForClass("javafx.embed.swing.JFXPanel") != false;
                }
                return isSwingSupported;
            }
            case FXML: {
                if (isFXMLSupported == null) {
                    isFXMLSupported = PlatformImpl.checkForClass("javafx.fxml.FXMLLoader") != false && PlatformImpl.checkForClass("javax.xml.stream.XMLInputFactory") != false;
                }
                return isFXMLSupported;
            }
            case TWO_LEVEL_FOCUS: {
                if (hasTwoLevelFocus == null) {
                    return Toolkit.getToolkit().isSupported(conditionalFeature);
                }
                return hasTwoLevelFocus;
            }
            case VIRTUAL_KEYBOARD: {
                if (hasVirtualKeyboard == null) {
                    return Toolkit.getToolkit().isSupported(conditionalFeature);
                }
                return hasVirtualKeyboard;
            }
            case INPUT_TOUCH: {
                if (hasTouch == null) {
                    return Toolkit.getToolkit().isSupported(conditionalFeature);
                }
                return hasTouch;
            }
            case INPUT_MULTITOUCH: {
                if (hasMultiTouch == null) {
                    return Toolkit.getToolkit().isSupported(conditionalFeature);
                }
                return hasMultiTouch;
            }
            case INPUT_POINTER: {
                if (hasPointer == null) {
                    return Toolkit.getToolkit().isSupported(conditionalFeature);
                }
                return hasPointer;
            }
        }
        return Toolkit.getToolkit().isSupported(conditionalFeature);
    }

    private static /* synthetic */ Object lambda$_setPlatformUserAgentStylesheet$20(List list) {
        StyleManager.getInstance().setUserAgentStylesheets(list);
        return null;
    }

    private static /* synthetic */ void lambda$runAndWait$12(Runnable runnable, CountDownLatch countDownLatch) {
        try {
            runnable.run();
            return;
        }
        finally {
            countDownLatch.countDown();
        }
    }

    private static /* synthetic */ Optional lambda$initFXCanvas$9(Predicate predicate, Stream stream) {
        return stream.filter(predicate).findFirst();
    }

    static {
        pendingRunnables = new AtomicInteger(0);
        numWindows = new AtomicInteger(0);
        firstWindowShown = false;
        lastWindowClosed = false;
        reallyIdle = new AtomicBoolean(false);
        finishListeners = new CopyOnWriteArraySet<PlatformImpl$FinishListener>();
        runLaterLock = new Object();
        isThreadMerged = false;
        applicationType = "";
        accessibilityActive = new SimpleBooleanProperty();
        allNestedLoopsExitedLatch = new CountDownLatch(1);
        verbose = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.verbose"));
        DEBUG = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.javafx.application.debug"));
        FXCANVAS_PERMISSION = new FXPermission("accessFXCanvasInternals");
        platformExitLatch = new CountDownLatch(1);
        isModena = false;
        isCaspian = false;
    }
}

