/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.LazyObjectBinding;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.util.Subscription;

public class ConditionalBinding<T>
extends LazyObjectBinding<T> {
    private final ObservableValue<T> source;
    private final ObservableValue<Boolean> nonNullCondition;
    private Subscription subscription;

    public ConditionalBinding(ObservableValue<T> observableValue, ObservableValue<Boolean> observableValue2) {
        this.source = Objects.requireNonNull(observableValue, "source cannot be null");
        this.nonNullCondition = Objects.requireNonNull(observableValue2, "condition cannot be null").orElse(Boolean.FALSE);
        this.nonNullCondition.subscribe(this::conditionChanged);
    }

    private void conditionChanged(boolean bl2) {
        if (!bl2 && !this.isValid()) {
            this.getValue();
        } else if (this.isValid() && this.source.getValue() != this.getValue()) {
            this.invalidate();
        }
        this.updateSubscription();
    }

    @Override
    protected boolean allowValidation() {
        return super.allowValidation() || !this.isActive();
    }

    @Override
    protected T computeValue() {
        this.updateSubscription();
        return this.source.getValue();
    }

    private void updateSubscription() {
        if (this.isObserved() && this.isActive()) {
            if (this.subscription == null) {
                this.subscription = this.source.subscribe(this::invalidate);
                return;
            }
        } else {
            this.unsubscribe();
        }
    }

    @Override
    protected Subscription observeSources() {
        return this::unsubscribe;
    }

    private boolean isActive() {
        return this.nonNullCondition.getValue();
    }

    private void unsubscribe() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
}

