/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.ContentBinding$ListContentBinding;
import com.sun.javafx.binding.ContentBinding$MapContentBinding;
import com.sun.javafx.binding.ContentBinding$SetContentBinding;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.WeakListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;

public class ContentBinding {
    private static void checkParameters(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException("Both parameters must be specified.");
        }
        if (object == object2) {
            throw new IllegalArgumentException("Cannot bind object to itself");
        }
    }

    public static <E> Object bind(List<E> observableList, ObservableList<? extends E> observableList2) {
        ContentBinding.checkParameters(observableList, observableList2);
        ContentBinding$ListContentBinding<E> contentBinding$ListContentBinding = new ContentBinding$ListContentBinding<E>(observableList);
        if (observableList instanceof ObservableList) {
            observableList = observableList;
            observableList.setAll(observableList2);
        } else {
            observableList.clear();
            observableList.addAll(observableList2);
        }
        observableList2.removeListener(contentBinding$ListContentBinding);
        observableList2.addListener(contentBinding$ListContentBinding);
        return contentBinding$ListContentBinding;
    }

    public static <E> Object bind(Set<E> set, ObservableSet<? extends E> observableSet) {
        ContentBinding.checkParameters(set, observableSet);
        ContentBinding$SetContentBinding<E> contentBinding$SetContentBinding = new ContentBinding$SetContentBinding<E>(set);
        set.clear();
        set.addAll(observableSet);
        observableSet.removeListener(contentBinding$SetContentBinding);
        observableSet.addListener(contentBinding$SetContentBinding);
        return contentBinding$SetContentBinding;
    }

    public static <K, V> Object bind(Map<K, V> map, ObservableMap<? extends K, ? extends V> observableMap) {
        ContentBinding.checkParameters(map, observableMap);
        ContentBinding$MapContentBinding<K, V> contentBinding$MapContentBinding = new ContentBinding$MapContentBinding<K, V>(map);
        map.clear();
        map.putAll(observableMap);
        observableMap.removeListener(contentBinding$MapContentBinding);
        observableMap.addListener(contentBinding$MapContentBinding);
        return contentBinding$MapContentBinding;
    }

    public static void unbind(Object object, Object object2) {
        WeakListener weakListener;
        ContentBinding.checkParameters(object, object2);
        if (object instanceof List) {
            weakListener = (List)object;
            if (object2 instanceof ObservableList) {
                object = (ObservableList)object2;
                weakListener = new ContentBinding$ListContentBinding(weakListener);
                object.removeListener(weakListener);
                return;
            }
        }
        if (object instanceof Set) {
            weakListener = (Set)object;
            if (object2 instanceof ObservableSet) {
                object = (ObservableSet)object2;
                weakListener = new ContentBinding$SetContentBinding(weakListener);
                object.removeListener(weakListener);
                return;
            }
        }
        if (object instanceof Map) {
            object = (Map)object;
            if (object2 instanceof ObservableMap) {
                object2 = (ObservableMap)object2;
                weakListener = new ContentBinding$MapContentBinding(object);
                object2.removeListener(weakListener);
            }
        }
    }
}

