/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.Logging;
import com.sun.javafx.binding.Logging$ErrorLogger;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.property.JavaBeanAccessHelper;
import com.sun.javafx.property.PropertyReference;
import java.util.Arrays;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Binding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

class SelectBinding$SelectBindingHelper
implements InvalidationListener {
    private final Binding<?> binding;
    private final String[] propertyNames;
    private final ObservableValue<?>[] properties;
    private final PropertyReference<?>[] propRefs;
    private final WeakInvalidationListener observer;
    private ObservableList<ObservableValue<?>> dependencies;

    private SelectBinding$SelectBindingHelper(Binding<?> binding, ObservableValue<?> observableValue, String ... stringArray) {
        if (observableValue == null) {
            throw new NullPointerException("Must specify the root");
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.binding = binding;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != null) continue;
            throw new NullPointerException("all steps must be specified");
        }
        this.observer = new WeakInvalidationListener(this);
        this.propertyNames = new String[n2];
        System.arraycopy(stringArray, 0, this.propertyNames, 0, n2);
        this.propRefs = new PropertyReference[n2];
        this.properties = new ObservableValue[n2 + 1];
        this.properties[0] = observableValue;
        this.properties[0].addListener(this.observer);
    }

    private static ObservableValue<?> checkAndCreateFirstStep(Object object, String[] stringArray) {
        if (object == null || stringArray == null || stringArray[0] == null) {
            throw new NullPointerException("Must specify the root and the first property");
        }
        try {
            return JavaBeanAccessHelper.createReadOnlyJavaBeanProperty(object, stringArray[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("The first property '" + stringArray[0] + "' doesn't exist");
        }
    }

    private SelectBinding$SelectBindingHelper(Binding<?> binding, Object object, String ... stringArray) {
        this(binding, SelectBinding$SelectBindingHelper.checkAndCreateFirstStep(object, stringArray), Arrays.copyOfRange(stringArray, 1, stringArray.length));
    }

    @Override
    public void invalidated(Observable observable) {
        this.binding.invalidate();
    }

    public ObservableValue<?> getObservableValue() {
        int n2 = this.properties.length;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            Object obj = this.properties[i2].getValue();
            try {
                if (this.propRefs[i2] == null || !obj.getClass().equals(this.propRefs[i2].getContainingClass())) {
                    this.propRefs[i2] = new PropertyReference(obj.getClass(), this.propertyNames[i2]);
                }
                this.properties[i2 + 1] = this.propRefs[i2].hasProperty() ? this.propRefs[i2].getProperty(obj) : JavaBeanAccessHelper.createReadOnlyJavaBeanProperty(obj, this.propRefs[i2].getName());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ((PlatformLogger)Logging.getLogger()).warning("Exception while evaluating select-binding " + this.stepsToString(), noSuchMethodException);
                this.updateDependencies();
                return null;
            }
            catch (RuntimeException runtimeException) {
                Logging$ErrorLogger logging$ErrorLogger = Logging.getLogger();
                if (logging$ErrorLogger.isLoggable(PlatformLogger$Level.WARNING)) {
                    String string = "Exception while evaluating select-binding " + this.stepsToString();
                    if (runtimeException instanceof IllegalStateException) {
                        logging$ErrorLogger.warning(string);
                        ((PlatformLogger)logging$ErrorLogger).warning("Property '" + this.propertyNames[i2] + "' does not exist in " + String.valueOf(obj.getClass()), runtimeException);
                    } else if (runtimeException instanceof NullPointerException) {
                        logging$ErrorLogger.fine(string);
                        ((PlatformLogger)logging$ErrorLogger).fine("Property '" + this.propertyNames[i2] + "' in " + String.valueOf(this.properties[i2]) + " is null", runtimeException);
                    } else {
                        ((PlatformLogger)logging$ErrorLogger).warning(string, runtimeException);
                    }
                }
                this.updateDependencies();
                return null;
            }
            this.properties[i2 + 1].addListener(this.observer);
        }
        this.updateDependencies();
        ObservableValue<?> observableValue = this.properties[n2 - 1];
        if (observableValue == null) {
            ((PlatformLogger)Logging.getLogger()).fine("Property '" + this.propertyNames[n2 - 1] + "' in " + String.valueOf(this.properties[n2 - 1]) + " is null", new NullPointerException());
        }
        return observableValue;
    }

    private String stepsToString() {
        return Arrays.toString(this.propertyNames);
    }

    private void unregisterListener() {
        int n2 = this.properties.length;
        for (int i2 = 1; i2 < n2 && this.properties[i2] != null; ++i2) {
            this.properties[i2].removeListener(this.observer);
            this.properties[i2] = null;
        }
        this.updateDependencies();
    }

    private void updateDependencies() {
        if (this.dependencies != null) {
            this.dependencies.clear();
            int n2 = this.properties.length;
            for (int i2 = 0; i2 < n2 && this.properties[i2] != null; ++i2) {
                this.dependencies.add(this.properties[i2]);
            }
        }
    }

    public ObservableList<ObservableValue<?>> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = FXCollections.observableArrayList();
            this.updateDependencies();
        }
        return FXCollections.unmodifiableObservableList(this.dependencies);
    }
}

