/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.charts;

import java.util.HashMap;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.chart.Axis;

public final class ChartLayoutAnimator
extends AnimationTimer
implements EventHandler<ActionEvent> {
    private Parent nodeToLayout;
    private final Map<Object, Animation> activeTimeLines = new HashMap<Object, Animation>();
    private final boolean isAxis;

    public ChartLayoutAnimator(Parent parent) {
        this.nodeToLayout = parent;
        this.isAxis = parent instanceof Axis;
    }

    @Override
    public final void handle(long l2) {
        if (this.isAxis) {
            ((Axis)this.nodeToLayout).requestAxisLayout();
            return;
        }
        this.nodeToLayout.requestLayout();
    }

    @Override
    public final void handle(ActionEvent actionEvent) {
        this.activeTimeLines.remove(actionEvent.getSource());
        if (this.activeTimeLines.isEmpty()) {
            this.stop();
        }
        ((AnimationTimer)this).handle(0L);
    }

    public final void stop(Object object) {
        if ((object = this.activeTimeLines.remove(object)) != null) {
            ((Animation)object).stop();
        }
        if (this.activeTimeLines.isEmpty()) {
            this.stop();
        }
    }

    public final Object animate(KeyFrame ... keyFrameArray) {
        Timeline timeline = new Timeline();
        timeline.setAutoReverse(false);
        timeline.setCycleCount(1);
        timeline.getKeyFrames().addAll((KeyFrame[])keyFrameArray);
        timeline.setOnFinished(this);
        if (this.activeTimeLines.isEmpty()) {
            this.start();
        }
        Timeline timeline2 = timeline;
        this.activeTimeLines.put(timeline2, timeline2);
        timeline.play();
        return timeline;
    }

    public final Object animate(Animation animation) {
        SequentialTransition sequentialTransition = new SequentialTransition();
        sequentialTransition.getChildren().add(animation);
        sequentialTransition.setOnFinished(this);
        if (this.activeTimeLines.isEmpty()) {
            this.start();
        }
        SequentialTransition sequentialTransition2 = sequentialTransition;
        this.activeTimeLines.put(sequentialTransition2, sequentialTransition2);
        sequentialTransition.play();
        return sequentialTransition;
    }
}

