/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ElementObserver;
import com.sun.javafx.collections.NonIterableChange$SimplePermutationChange;
import com.sun.javafx.collections.ObservableSequentialListWrapper$1;
import com.sun.javafx.collections.ObservableSequentialListWrapper$2;
import com.sun.javafx.collections.SortHelper;
import com.sun.javafx.collections.SortableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javafx.beans.Observable;
import javafx.collections.ModifiableObservableListBase;
import javafx.util.Callback;

public class ObservableSequentialListWrapper<E>
extends ModifiableObservableListBase<E>
implements SortableList<E> {
    private final List<E> backingList;
    private final ElementObserver<E> elementObserver;
    private SortHelper helper;

    public ObservableSequentialListWrapper(List<E> list) {
        this.backingList = list;
        this.elementObserver = null;
    }

    public ObservableSequentialListWrapper(List<E> object, Callback<E, Observable[]> callback2) {
        this.backingList = object;
        this.elementObserver = new ElementObserver<E>(callback2, new ObservableSequentialListWrapper$1(this), this);
        for (Callback<Object, Object> callback2 : this.backingList) {
            this.elementObserver.attachListener(callback2);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.backingList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backingList.containsAll(collection);
    }

    @Override
    public int indexOf(Object object) {
        return this.backingList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.backingList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        return new ObservableSequentialListWrapper$2(this, n2);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public E get(int n2) {
        try {
            return this.backingList.listIterator(n2).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> object) {
        if (n2 < 0 || n2 > ((ModifiableObservableListBase)this).size()) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        if (object.isEmpty()) {
            return false;
        }
        try {
            this.beginChange();
            boolean bl2 = false;
            ListIterator listIterator = this.listIterator(n2);
            object = object.iterator();
            while (object.hasNext()) {
                listIterator.add(object.next());
                bl2 = true;
            }
            this.endChange();
            return bl2;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    protected void doAdd(int n2, E e2) {
        try {
            this.backingList.listIterator(n2).add(e2);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    protected E doSet(int n2, E e2) {
        try {
            ListIterator<E> listIterator = this.backingList.listIterator(n2);
            E e3 = listIterator.next();
            listIterator.set(e2);
            return e3;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    protected E doRemove(int n2) {
        try {
            ListIterator<E> listIterator = this.backingList.listIterator(n2);
            E e2 = listIterator.next();
            listIterator.remove();
            return e2;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    public void doSort(Comparator<? super E> object) {
        object = this.getSortHelper().sort(this.backingList, object);
        this.fireChange(new NonIterableChange$SimplePermutationChange(0, ((ModifiableObservableListBase)this).size(), (int[])object, this));
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }

    static /* synthetic */ void access$000(ObservableSequentialListWrapper observableSequentialListWrapper) {
        observableSequentialListWrapper.beginChange();
    }

    static /* synthetic */ void access$100(ObservableSequentialListWrapper observableSequentialListWrapper, int n2) {
        observableSequentialListWrapper.nextUpdate(n2);
    }

    static /* synthetic */ void access$200(ObservableSequentialListWrapper observableSequentialListWrapper) {
        observableSequentialListWrapper.endChange();
    }

    static /* synthetic */ void access$300(ObservableSequentialListWrapper observableSequentialListWrapper) {
        observableSequentialListWrapper.beginChange();
    }

    static /* synthetic */ void access$400(ObservableSequentialListWrapper observableSequentialListWrapper, int n2, Object object) {
        observableSequentialListWrapper.nextRemove(n2, object);
    }

    static /* synthetic */ void access$500(ObservableSequentialListWrapper observableSequentialListWrapper) {
        observableSequentialListWrapper.endChange();
    }

    static /* synthetic */ void access$600(ObservableSequentialListWrapper observableSequentialListWrapper) {
        observableSequentialListWrapper.beginChange();
    }

    static /* synthetic */ void access$700(ObservableSequentialListWrapper observableSequentialListWrapper, int n2, Object object) {
        observableSequentialListWrapper.nextSet(n2, object);
    }

    static /* synthetic */ void access$800(ObservableSequentialListWrapper observableSequentialListWrapper) {
        observableSequentialListWrapper.endChange();
    }

    static /* synthetic */ void access$900(ObservableSequentialListWrapper observableSequentialListWrapper) {
        observableSequentialListWrapper.beginChange();
    }

    static /* synthetic */ void access$1000(ObservableSequentialListWrapper observableSequentialListWrapper, int n2, int n3) {
        observableSequentialListWrapper.nextAdd(n2, n3);
    }

    static /* synthetic */ void access$1100(ObservableSequentialListWrapper observableSequentialListWrapper) {
        observableSequentialListWrapper.endChange();
    }
}

