/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ObservableSetWrapper$1;
import com.sun.javafx.collections.ObservableSetWrapper$SimpleAddChange;
import com.sun.javafx.collections.ObservableSetWrapper$SimpleRemoveChange;
import com.sun.javafx.collections.SetListenerHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.collections.SetChangeListener$Change;

public class ObservableSetWrapper<E>
implements ObservableSet<E> {
    private final Set<E> backingSet;
    private SetListenerHelper<E> listenerHelper;

    public ObservableSetWrapper(Set<E> set) {
        this.backingSet = set;
    }

    private void callObservers(SetChangeListener$Change<E> setChangeListener$Change) {
        SetListenerHelper.fireValueChangedEvent(this.listenerHelper, setChangeListener$Change);
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void addListener(SetChangeListener<? super E> setChangeListener) {
        this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, setChangeListener);
    }

    @Override
    public void removeListener(SetChangeListener<? super E> setChangeListener) {
        this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, setChangeListener);
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingSet.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingSet.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return new ObservableSetWrapper$1(this);
    }

    @Override
    public Object[] toArray() {
        return this.backingSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.backingSet.toArray(TArray);
    }

    @Override
    public boolean add(E e2) {
        boolean bl2 = this.backingSet.add(e2);
        if (bl2) {
            this.callObservers(new ObservableSetWrapper$SimpleAddChange(this, e2));
        }
        return bl2;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl2 = this.backingSet.remove(object);
        if (bl2) {
            this.callObservers(new ObservableSetWrapper$SimpleRemoveChange(this, object));
        }
        return bl2;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backingSet.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> object) {
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            bl2 |= this.add(e2);
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection.isEmpty() && !this.backingSet.isEmpty()) {
            this.clear();
            return true;
        }
        if (this.backingSet.isEmpty()) {
            return false;
        }
        return this.removeRetain(collection, false);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection.isEmpty() || this.backingSet.isEmpty()) {
            return false;
        }
        return this.removeRetain(collection, true);
    }

    private boolean removeRetain(Collection<?> collection, boolean bl2) {
        boolean bl3 = false;
        Iterator<E> iterator = this.backingSet.iterator();
        while (iterator.hasNext()) {
            E e2 = iterator.next();
            if (bl2 != collection.contains(e2)) continue;
            bl3 = true;
            iterator.remove();
            this.callObservers(new ObservableSetWrapper$SimpleRemoveChange(this, e2));
        }
        return bl3;
    }

    @Override
    public void clear() {
        Iterator<E> iterator = this.backingSet.iterator();
        while (iterator.hasNext()) {
            E e2 = iterator.next();
            iterator.remove();
            this.callObservers(new ObservableSetWrapper$SimpleRemoveChange(this, e2));
        }
    }

    public String toString() {
        return this.backingSet.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this.backingSet.equals(object);
    }

    @Override
    public int hashCode() {
        return this.backingSet.hashCode();
    }
}

