/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.VetoableListDecorator;
import com.sun.javafx.collections.VetoableListDecorator$ModCountAccessor;
import com.sun.javafx.collections.VetoableListDecorator$VetoableIteratorDecorator;
import com.sun.javafx.collections.VetoableListDecorator$VetoableListIteratorDecorator;
import com.sun.javafx.collections.VetoableListDecorator$VetoableSubListDecorator$ModCountAccessorImplSub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

class VetoableListDecorator$VetoableSubListDecorator
implements List<E> {
    private final List<E> subList;
    private final int offset;
    private final VetoableListDecorator$ModCountAccessor modCountAccessor;
    private int modCount;
    final /* synthetic */ VetoableListDecorator this$0;

    public VetoableListDecorator$VetoableSubListDecorator(VetoableListDecorator vetoableListDecorator, VetoableListDecorator$ModCountAccessor vetoableListDecorator$ModCountAccessor, List<E> list, int n2) {
        this.this$0 = vetoableListDecorator;
        this.modCountAccessor = vetoableListDecorator$ModCountAccessor;
        this.modCount = vetoableListDecorator$ModCountAccessor.get();
        this.subList = list;
        this.offset = n2;
    }

    @Override
    public int size() {
        this.checkForComodification();
        return this.subList.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkForComodification();
        return this.subList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        this.checkForComodification();
        return this.subList.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        this.checkForComodification();
        return new VetoableListDecorator$VetoableIteratorDecorator(this.this$0, new VetoableListDecorator$VetoableSubListDecorator$ModCountAccessorImplSub(this), this.subList.iterator(), this.offset);
    }

    @Override
    public Object[] toArray() {
        this.checkForComodification();
        return this.subList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        this.checkForComodification();
        return this.subList.toArray(TArray);
    }

    @Override
    public boolean add(E e2) {
        this.checkForComodification();
        this.this$0.onProposedChange(Collections.singletonList(e2), this.offset + this.size(), this.offset + this.size());
        try {
            this.incrementModCount();
            this.subList.add(e2);
        }
        catch (Exception exception) {
            this.decrementModCount();
            throw exception;
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        this.checkForComodification();
        int n2 = this.indexOf(object);
        if (n2 != -1) {
            this.remove(n2);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.checkForComodification();
        return this.subList.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Objects.requireNonNull(collection);
        this.checkForComodification();
        this.this$0.onProposedChange(Collections.unmodifiableList(new ArrayList(collection)), this.offset + this.size(), this.offset + this.size());
        try {
            this.incrementModCount();
            boolean bl2 = this.subList.addAll(collection);
            if (!bl2) {
                this.decrementModCount();
            }
            return bl2;
        }
        catch (Exception exception) {
            this.decrementModCount();
            throw exception;
        }
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        Objects.requireNonNull(collection);
        Objects.checkIndex(n2, this.size() + 1);
        this.checkForComodification();
        this.this$0.onProposedChange(Collections.unmodifiableList(new ArrayList(collection)), this.offset + n2, this.offset + n2);
        try {
            this.incrementModCount();
            boolean bl2 = this.subList.addAll(n2, collection);
            n2 = bl2 ? 1 : 0;
            if (!bl2) {
                this.decrementModCount();
            }
            return n2 != 0;
        }
        catch (Exception exception) {
            this.decrementModCount();
            throw exception;
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        this.checkForComodification();
        VetoableListDecorator$VetoableSubListDecorator vetoableListDecorator$VetoableSubListDecorator = this;
        this.this$0.removeFromList(vetoableListDecorator$VetoableSubListDecorator, vetoableListDecorator$VetoableSubListDecorator.offset, collection, false);
        try {
            this.incrementModCount();
            boolean bl2 = this.subList.removeAll(collection);
            if (!bl2) {
                this.decrementModCount();
            }
            return bl2;
        }
        catch (Exception exception) {
            this.decrementModCount();
            throw exception;
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        this.checkForComodification();
        VetoableListDecorator$VetoableSubListDecorator vetoableListDecorator$VetoableSubListDecorator = this;
        this.this$0.removeFromList(vetoableListDecorator$VetoableSubListDecorator, vetoableListDecorator$VetoableSubListDecorator.offset, collection, true);
        try {
            this.incrementModCount();
            boolean bl2 = this.subList.retainAll(collection);
            if (!bl2) {
                this.decrementModCount();
            }
            return bl2;
        }
        catch (Exception exception) {
            this.decrementModCount();
            throw exception;
        }
    }

    @Override
    public void clear() {
        this.checkForComodification();
        this.this$0.onProposedChange(Collections.emptyList(), this.offset, this.offset + this.size());
        try {
            this.incrementModCount();
            this.subList.clear();
            return;
        }
        catch (Exception exception) {
            this.decrementModCount();
            throw exception;
        }
    }

    @Override
    public E get(int n2) {
        this.checkForComodification();
        return this.subList.get(n2);
    }

    @Override
    public E set(int n2, E e2) {
        this.checkForComodification();
        this.this$0.onProposedChange(Collections.singletonList(e2), this.offset + n2, this.offset + n2 + 1);
        return this.subList.set(n2, e2);
    }

    @Override
    public void add(int n2, E e2) {
        Objects.checkIndex(n2, this.size() + 1);
        this.checkForComodification();
        this.this$0.onProposedChange(Collections.singletonList(e2), this.offset + n2, this.offset + n2);
        try {
            this.incrementModCount();
            this.subList.add(n2, e2);
            return;
        }
        catch (Exception exception) {
            this.decrementModCount();
            throw exception;
        }
    }

    @Override
    public E remove(int n2) {
        Objects.checkIndex(n2, this.size());
        this.checkForComodification();
        this.this$0.onProposedChange(Collections.emptyList(), this.offset + n2, this.offset + n2 + 1);
        try {
            this.incrementModCount();
            Object e2 = this.subList.remove(n2);
            return e2;
        }
        catch (Exception exception) {
            this.decrementModCount();
            throw exception;
        }
    }

    @Override
    public int indexOf(Object object) {
        this.checkForComodification();
        return this.subList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        this.checkForComodification();
        return this.subList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.checkForComodification();
        return new VetoableListDecorator$VetoableListIteratorDecorator(this.this$0, (VetoableListDecorator$ModCountAccessor)new VetoableListDecorator$VetoableSubListDecorator$ModCountAccessorImplSub(this), this.subList.listIterator(), this.offset);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        this.checkForComodification();
        return new VetoableListDecorator$VetoableListIteratorDecorator(this.this$0, (VetoableListDecorator$ModCountAccessor)new VetoableListDecorator$VetoableSubListDecorator$ModCountAccessorImplSub(this), this.subList.listIterator(n2), this.offset + n2);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        this.checkForComodification();
        return new VetoableListDecorator$VetoableSubListDecorator(this.this$0, new VetoableListDecorator$VetoableSubListDecorator$ModCountAccessorImplSub(this), this.subList.subList(n2, n3), this.offset + n2);
    }

    public String toString() {
        this.checkForComodification();
        return this.subList.toString();
    }

    @Override
    public boolean equals(Object object) {
        this.checkForComodification();
        return this.subList.equals(object);
    }

    @Override
    public int hashCode() {
        this.checkForComodification();
        return this.subList.hashCode();
    }

    private void checkForComodification() {
        if (this.modCount != this.modCountAccessor.get()) {
            throw new ConcurrentModificationException();
        }
    }

    private void incrementModCount() {
        this.modCount = this.modCountAccessor.incrementAndGet();
    }

    private void decrementModCount() {
        this.modCount = this.modCountAccessor.decrementAndGet();
    }
}

