/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;
import javafx.css.StyleConverter$StringStore;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class ParsedValueImpl<V, T>
extends ParsedValue<V, T> {
    private final boolean lookup;
    private final boolean containsLookups;
    private static int indent = 0;
    private int hash = Integer.MIN_VALUE;
    private static final byte NULL_VALUE = 0;
    private static final byte VALUE = 1;
    private static final byte VALUE_ARRAY = 2;
    private static final byte ARRAY_OF_VALUE_ARRAY = 3;
    private static final byte STRING = 4;
    private static final byte COLOR = 5;
    private static final byte ENUM = 6;
    private static final byte BOOLEAN = 7;
    private static final byte URL = 8;
    private static final byte SIZE = 9;

    @Override
    public final boolean isLookup() {
        return this.lookup;
    }

    @Override
    public final boolean isContainsLookups() {
        return this.containsLookups;
    }

    private static boolean getContainsLookupsFlag(Object parsedValueImplArray) {
        boolean bl2;
        block4: {
            block6: {
                block5: {
                    block3: {
                        bl2 = false;
                        if (!(parsedValueImplArray instanceof Size)) break block3;
                        bl2 = false;
                        break block4;
                    }
                    if (!(parsedValueImplArray instanceof ParsedValueImpl)) break block5;
                    parsedValueImplArray = (ParsedValueImpl)parsedValueImplArray;
                    bl2 = parsedValueImplArray.lookup || parsedValueImplArray.containsLookups;
                    break block4;
                }
                if (!(parsedValueImplArray instanceof ParsedValueImpl[])) break block6;
                parsedValueImplArray = parsedValueImplArray;
                for (int i2 = 0; i2 < parsedValueImplArray.length && !bl2; ++i2) {
                    if (parsedValueImplArray[i2] == null) continue;
                    bl2 = bl2 || parsedValueImplArray[i2].lookup || parsedValueImplArray[i2].containsLookups;
                }
                break block4;
            }
            if (!(parsedValueImplArray instanceof ParsedValueImpl[][])) break block4;
            parsedValueImplArray = (ParsedValueImpl[][])parsedValueImplArray;
            for (int i3 = 0; i3 < parsedValueImplArray.length && !bl2; ++i3) {
                if (parsedValueImplArray[i3] == null) continue;
                for (int i4 = 0; i4 < ((ParsedValueImpl)parsedValueImplArray[i3]).length && !bl2; ++i4) {
                    if (parsedValueImplArray[i3][i4] == null) continue;
                    bl2 = bl2 || parsedValueImplArray[i3][i4].lookup || parsedValueImplArray[i3][i4].containsLookups;
                }
            }
        }
        return bl2;
    }

    public static boolean containsFontRelativeSize(ParsedValue parsedValueArray, boolean bl2) {
        boolean bl3;
        block4: {
            block6: {
                block5: {
                    block3: {
                        bl3 = false;
                        if (!((parsedValueArray = parsedValueArray.getValue()) instanceof Size)) break block3;
                        bl3 = (parsedValueArray = (Size)parsedValueArray).getUnits() == SizeUnits.PERCENT ? bl2 : !parsedValueArray.isAbsolute();
                        break block4;
                    }
                    if (!(parsedValueArray instanceof ParsedValue)) break block5;
                    parsedValueArray = (ParsedValueImpl)parsedValueArray;
                    bl3 = ParsedValueImpl.containsFontRelativeSize((ParsedValue)parsedValueArray, bl2);
                    break block4;
                }
                if (!(parsedValueArray instanceof ParsedValue[])) break block6;
                parsedValueArray = parsedValueArray;
                for (int i2 = 0; i2 < parsedValueArray.length && !bl3; ++i2) {
                    if (parsedValueArray[i2] == null) continue;
                    bl3 = ParsedValueImpl.containsFontRelativeSize(parsedValueArray[i2], bl2);
                }
                break block4;
            }
            if (!(parsedValueArray instanceof ParsedValueImpl[][])) break block4;
            parsedValueArray = (ParsedValueImpl[][])parsedValueArray;
            for (int i3 = 0; i3 < parsedValueArray.length && !bl3; ++i3) {
                if (parsedValueArray[i3] == null) continue;
                for (int i4 = 0; i4 < ((ParsedValue)parsedValueArray[i3]).length && !bl3; ++i4) {
                    if (parsedValueArray[i3][i4] == null) continue;
                    bl3 = ParsedValueImpl.containsFontRelativeSize(parsedValueArray[i3][i4], bl2);
                }
            }
        }
        return bl3;
    }

    public ParsedValueImpl(V v2, StyleConverter<V, T> styleConverter, boolean bl2) {
        super(v2, styleConverter);
        this.lookup = bl2;
        this.containsLookups = bl2 || ParsedValueImpl.getContainsLookupsFlag(v2);
    }

    public ParsedValueImpl(V v2, StyleConverter<V, T> styleConverter) {
        this(v2, styleConverter, false);
    }

    @Override
    public T convert(Font font) {
        if (this.converter != null) {
            return this.converter.convert(this, font);
        }
        return (T)this.value;
    }

    private static String spaces() {
        return new String(new char[indent]).replace('\u0000', ' ');
    }

    private static void indent() {
        indent += 2;
    }

    private static void outdent() {
        indent = Math.max(0, indent - 2);
    }

    public String toString() {
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ParsedValueImpl.spaces()).append(this.lookup ? "<Value lookup=\"true\">" : "<Value>").append(string);
        ParsedValueImpl.indent();
        if (this.value != null) {
            this.appendValue(stringBuilder, this.value, "value");
        } else {
            this.appendValue(stringBuilder, "null", "value");
        }
        stringBuilder.append(ParsedValueImpl.spaces()).append("<converter>").append(this.converter).append("</converter>").append(string);
        ParsedValueImpl.outdent();
        stringBuilder.append(ParsedValueImpl.spaces()).append("</Value>");
        return stringBuilder.toString();
    }

    private void appendValue(StringBuilder stringBuilder, Object parsedValueImplArray, String string) {
        String string2 = System.lineSeparator();
        if (parsedValueImplArray instanceof ParsedValueImpl[][]) {
            parsedValueImplArray = parsedValueImplArray;
            stringBuilder.append(ParsedValueImpl.spaces()).append('<').append(string).append(" layers=\"").append(parsedValueImplArray.length).append("\">").append(string2);
            ParsedValueImpl.indent();
            for (ParsedValueImpl[] parsedValueImplArray2 : parsedValueImplArray) {
                stringBuilder.append(ParsedValueImpl.spaces()).append("<layer>").append(string2);
                ParsedValueImpl.indent();
                if (parsedValueImplArray2 == null) {
                    stringBuilder.append(ParsedValueImpl.spaces()).append("null").append(string2);
                    continue;
                }
                int n2 = parsedValueImplArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ParsedValueImpl parsedValueImpl = parsedValueImplArray2[i2];
                    if (parsedValueImpl == null) {
                        stringBuilder.append(ParsedValueImpl.spaces()).append("null").append(string2);
                        continue;
                    }
                    stringBuilder.append(parsedValueImpl);
                }
                ParsedValueImpl.outdent();
                stringBuilder.append(ParsedValueImpl.spaces()).append("</layer>").append(string2);
            }
            ParsedValueImpl.outdent();
            stringBuilder.append(ParsedValueImpl.spaces()).append("</").append(string).append('>').append(string2);
            return;
        }
        if (parsedValueImplArray instanceof ParsedValueImpl[]) {
            parsedValueImplArray = (ParsedValueImpl[])parsedValueImplArray;
            stringBuilder.append(ParsedValueImpl.spaces()).append('<').append(string).append(" values=\"").append(parsedValueImplArray.length).append("\">").append(string2);
            ParsedValueImpl.indent();
            for (ParsedValueImpl[] parsedValueImplArray3 : parsedValueImplArray) {
                if (parsedValueImplArray3 == null) {
                    stringBuilder.append(ParsedValueImpl.spaces()).append("null").append(string2);
                    continue;
                }
                stringBuilder.append(parsedValueImplArray3);
            }
            ParsedValueImpl.outdent();
            stringBuilder.append(ParsedValueImpl.spaces()).append("</").append(string).append('>').append(string2);
            return;
        }
        if (parsedValueImplArray instanceof ParsedValueImpl) {
            stringBuilder.append(ParsedValueImpl.spaces()).append('<').append(string).append('>').append(string2);
            ParsedValueImpl.indent();
            stringBuilder.append(parsedValueImplArray);
            ParsedValueImpl.outdent();
            stringBuilder.append(ParsedValueImpl.spaces()).append("</").append(string).append('>').append(string2);
            return;
        }
        stringBuilder.append(ParsedValueImpl.spaces()).append('<').append(string).append('>');
        stringBuilder.append(parsedValueImplArray);
        stringBuilder.append("</").append(string).append('>').append(string2);
    }

    public boolean equals(Object parsedValueImplArray) {
        if (parsedValueImplArray == this) {
            return true;
        }
        if (parsedValueImplArray == null || parsedValueImplArray.getClass() != this.getClass()) {
            return false;
        }
        parsedValueImplArray = (ParsedValueImpl)parsedValueImplArray;
        if (this.hash != parsedValueImplArray.hash) {
            return false;
        }
        if (this.value instanceof ParsedValueImpl[][]) {
            if (!(parsedValueImplArray.value instanceof ParsedValueImpl[][])) {
                return false;
            }
            ParsedValueImpl[][] parsedValueImplArray2 = (ParsedValueImpl[][])this.value;
            parsedValueImplArray = (ParsedValueImpl[][])parsedValueImplArray.value;
            if (parsedValueImplArray2.length != parsedValueImplArray.length) {
                return false;
            }
            for (int i2 = 0; i2 < parsedValueImplArray2.length; ++i2) {
                if (parsedValueImplArray2[i2] == null && parsedValueImplArray[i2] == null) continue;
                if (parsedValueImplArray2[i2] == null || parsedValueImplArray[i2] == null) {
                    return false;
                }
                if (parsedValueImplArray2[i2].length != parsedValueImplArray[i2].length) {
                    return false;
                }
                for (int i3 = 0; i3 < parsedValueImplArray2[i2].length; ++i3) {
                    ParsedValueImpl parsedValueImpl = parsedValueImplArray2[i2][i3];
                    ParsedValueImpl parsedValueImpl2 = parsedValueImplArray[i2][i3];
                    if (!(parsedValueImpl != null ? !parsedValueImpl.equals(parsedValueImpl2) : parsedValueImpl2 != null)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.value instanceof ParsedValueImpl[]) {
            if (!(parsedValueImplArray.value instanceof ParsedValueImpl[])) {
                return false;
            }
            ParsedValueImpl[] parsedValueImplArray3 = (ParsedValueImpl[])this.value;
            parsedValueImplArray = (ParsedValueImpl[])parsedValueImplArray.value;
            if (parsedValueImplArray3.length != parsedValueImplArray.length) {
                return false;
            }
            for (int i4 = 0; i4 < parsedValueImplArray3.length; ++i4) {
                ParsedValueImpl parsedValueImpl = parsedValueImplArray3[i4];
                ParsedValueImpl[] parsedValueImplArray4 = parsedValueImplArray[i4];
                if (!(parsedValueImpl != null ? !parsedValueImpl.equals(parsedValueImplArray4) : parsedValueImplArray4 != null)) continue;
                return false;
            }
            return true;
        }
        if (this.value instanceof String && parsedValueImplArray.value instanceof String) {
            return this.value.toString().equalsIgnoreCase(parsedValueImplArray.value.toString());
        }
        if (this.value != null) {
            return this.value.equals(parsedValueImplArray.value);
        }
        return parsedValueImplArray.value == null;
    }

    public int hashCode() {
        if (this.hash == Integer.MIN_VALUE) {
            this.hash = 17;
            if (this.value instanceof ParsedValueImpl[][]) {
                ParsedValueImpl[][] parsedValueImplArray = (ParsedValueImpl[][])this.value;
                for (int i2 = 0; i2 < parsedValueImplArray.length; ++i2) {
                    for (int i3 = 0; i3 < parsedValueImplArray[i2].length; ++i3) {
                        ParsedValueImpl parsedValueImpl = parsedValueImplArray[i2][i3];
                        this.hash = 37 * this.hash + (parsedValueImpl != null && parsedValueImpl.value != null ? parsedValueImpl.value.hashCode() : 0);
                    }
                }
            } else if (this.value instanceof ParsedValueImpl[]) {
                ParsedValueImpl[] parsedValueImplArray = (ParsedValueImpl[])this.value;
                for (int i4 = 0; i4 < parsedValueImplArray.length; ++i4) {
                    if (parsedValueImplArray[i4] == null || parsedValueImplArray[i4].value == null) continue;
                    ParsedValueImpl parsedValueImpl = parsedValueImplArray[i4];
                    this.hash = 37 * this.hash + (parsedValueImpl != null && parsedValueImpl.value != null ? parsedValueImpl.value.hashCode() : 0);
                }
            } else {
                this.hash = 37 * this.hash + (this.value != null ? this.value.hashCode() : 0);
            }
        }
        return this.hash;
    }

    public final void writeBinary(DataOutputStream dataOutputStream, StyleConverter$StringStore styleConverter$StringStore) throws IOException {
        ParsedValue parsedValue;
        dataOutputStream.writeBoolean(this.lookup);
        if (this.converter != null) {
            dataOutputStream.writeBoolean(true);
            this.converter.writeBinary(dataOutputStream, styleConverter$StringStore);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this.value instanceof ParsedValue) {
            dataOutputStream.writeByte(1);
            parsedValue = (ParsedValue)this.value;
            if (!(parsedValue instanceof ParsedValueImpl)) {
                ParsedValueImpl parsedValueImpl = new ParsedValueImpl(parsedValue.getValue(), parsedValue.getConverter());
                parsedValueImpl.writeBinary(dataOutputStream, styleConverter$StringStore);
                return;
            }
        } else {
            if (this.value instanceof ParsedValue[]) {
                dataOutputStream.writeByte(2);
                ParsedValue[] parsedValueArray = (ParsedValue[])this.value;
                if (parsedValueArray != null) {
                    dataOutputStream.writeByte(1);
                } else {
                    dataOutputStream.writeByte(0);
                }
                int n2 = parsedValueArray != null ? parsedValueArray.length : 0;
                dataOutputStream.writeInt(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (parsedValueArray[i2] != null) {
                        dataOutputStream.writeByte(1);
                        ParsedValue parsedValue2 = parsedValueArray[i2];
                        if (parsedValue2 instanceof ParsedValueImpl) {
                            ((ParsedValueImpl)parsedValue2).writeBinary(dataOutputStream, styleConverter$StringStore);
                            continue;
                        }
                        ParsedValueImpl parsedValueImpl = new ParsedValueImpl(parsedValue2.getValue(), parsedValue2.getConverter());
                        parsedValueImpl.writeBinary(dataOutputStream, styleConverter$StringStore);
                        continue;
                    }
                    dataOutputStream.writeByte(0);
                }
                return;
            }
            if (this.value instanceof ParsedValue[][]) {
                dataOutputStream.writeByte(3);
                ParsedValue[][] parsedValueArray = (ParsedValue[][])this.value;
                if (parsedValueArray != null) {
                    dataOutputStream.writeByte(1);
                } else {
                    dataOutputStream.writeByte(0);
                }
                int n3 = parsedValueArray != null ? parsedValueArray.length : 0;
                dataOutputStream.writeInt(n3);
                for (int i3 = 0; i3 < n3; ++i3) {
                    ParsedValue[] parsedValueArray2 = parsedValueArray[i3];
                    if (parsedValueArray2 != null) {
                        dataOutputStream.writeByte(1);
                    } else {
                        dataOutputStream.writeByte(0);
                    }
                    int n4 = parsedValueArray2 != null ? parsedValueArray2.length : 0;
                    dataOutputStream.writeInt(n4);
                    for (int i4 = 0; i4 < n4; ++i4) {
                        if (parsedValueArray2[i4] != null) {
                            dataOutputStream.writeByte(1);
                            ParsedValueImpl parsedValueImpl = parsedValueArray2[i4];
                            if (parsedValueImpl instanceof ParsedValueImpl) {
                                ((ParsedValueImpl)parsedValueImpl).writeBinary(dataOutputStream, styleConverter$StringStore);
                                continue;
                            }
                            parsedValueImpl = new ParsedValueImpl(parsedValueImpl.getValue(), parsedValueImpl.getConverter());
                            parsedValueImpl.writeBinary(dataOutputStream, styleConverter$StringStore);
                            continue;
                        }
                        dataOutputStream.writeByte(0);
                    }
                }
                return;
            }
            if (this.value instanceof Color) {
                Color color = (Color)this.value;
                dataOutputStream.writeByte(5);
                dataOutputStream.writeLong(Double.doubleToLongBits(color.getRed()));
                dataOutputStream.writeLong(Double.doubleToLongBits(color.getGreen()));
                dataOutputStream.writeLong(Double.doubleToLongBits(color.getBlue()));
                dataOutputStream.writeLong(Double.doubleToLongBits(color.getOpacity()));
                return;
            }
            if (this.value instanceof Enum) {
                Enum enum_ = (Enum)this.value;
                int n5 = styleConverter$StringStore.addString(enum_.name());
                dataOutputStream.writeByte(6);
                dataOutputStream.writeShort(n5);
                return;
            }
            if (this.value instanceof Boolean) {
                Boolean bl2 = (Boolean)this.value;
                dataOutputStream.writeByte(7);
                dataOutputStream.writeBoolean(bl2);
                return;
            }
            if (this.value instanceof Size) {
                Size size = (Size)this.value;
                dataOutputStream.writeByte(9);
                double d2 = size.getValue();
                long l2 = Double.doubleToLongBits(d2);
                dataOutputStream.writeLong(l2);
                int n6 = styleConverter$StringStore.addString(size.getUnits().name());
                dataOutputStream.writeShort(n6);
                return;
            }
            if (this.value instanceof String) {
                dataOutputStream.writeByte(4);
                int n7 = styleConverter$StringStore.addString((String)this.value);
                dataOutputStream.writeShort(n7);
                return;
            }
            if (this.value instanceof URL) {
                dataOutputStream.writeByte(8);
                int n8 = styleConverter$StringStore.addString(this.value.toString());
                dataOutputStream.writeShort(n8);
                return;
            }
            if (this.value == null) {
                dataOutputStream.writeByte(0);
                return;
            }
            throw new InternalError("cannot writeBinary " + String.valueOf(this));
        }
        ((ParsedValueImpl)parsedValue).writeBinary(dataOutputStream, styleConverter$StringStore);
    }

    public static ParsedValueImpl readBinary(int n2, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        boolean bl2 = dataInputStream.readBoolean();
        boolean bl3 = dataInputStream.readBoolean();
        StyleConverter<?, ?> styleConverter = bl3 ? StyleConverter.readBinary(dataInputStream, stringArray) : null;
        byte by2 = dataInputStream.readByte();
        if (by2 == 1) {
            ParsedValueImpl parsedValueImpl = ParsedValueImpl.readBinary(n2, dataInputStream, stringArray);
            return new ParsedValueImpl(parsedValueImpl, styleConverter, bl2);
        }
        if (by2 == 2) {
            int n3;
            if (n2 >= 4) {
                dataInputStream.readByte();
            }
            ParsedValueImpl[] parsedValueImplArray = (n3 = dataInputStream.readInt()) > 0 ? new ParsedValueImpl[n3] : null;
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by3 = dataInputStream.readByte();
                parsedValueImplArray[i2] = by3 == 1 ? ParsedValueImpl.readBinary(n2, dataInputStream, stringArray) : null;
            }
            return new ParsedValueImpl(parsedValueImplArray, styleConverter, bl2);
        }
        if (by2 == 3) {
            int n4;
            if (n2 >= 4) {
                dataInputStream.readByte();
            }
            ParsedValueImpl[][] parsedValueImplArray = (n4 = dataInputStream.readInt()) > 0 ? new ParsedValueImpl[n4][0] : null;
            for (int i3 = 0; i3 < n4; ++i3) {
                int n5;
                if (n2 >= 4) {
                    dataInputStream.readByte();
                }
                parsedValueImplArray[i3] = (n5 = dataInputStream.readInt()) > 0 ? new ParsedValueImpl[n5] : null;
                for (int i4 = 0; i4 < n5; ++i4) {
                    byte by4 = dataInputStream.readByte();
                    parsedValueImplArray[i3][i4] = by4 == 1 ? ParsedValueImpl.readBinary(n2, dataInputStream, stringArray) : null;
                }
            }
            return new ParsedValueImpl(parsedValueImplArray, styleConverter, bl2);
        }
        if (by2 == 5) {
            double d2 = Double.longBitsToDouble(dataInputStream.readLong());
            double d3 = Double.longBitsToDouble(dataInputStream.readLong());
            double d4 = Double.longBitsToDouble(dataInputStream.readLong());
            double d5 = Double.longBitsToDouble(dataInputStream.readLong());
            return new ParsedValueImpl(Color.color(d2, d3, d4, d5), styleConverter, bl2);
        }
        if (by2 == 6) {
            short s2;
            short s3 = dataInputStream.readShort();
            String string = stringArray[s3];
            if (n2 == 2 && (s2 = dataInputStream.readShort()) >= stringArray.length) {
                throw new IllegalArgumentException("bad version " + n2);
            }
            ParsedValueImpl parsedValueImpl = new ParsedValueImpl(string, styleConverter, bl2);
            return parsedValueImpl;
        }
        if (by2 == 7) {
            Boolean bl4 = dataInputStream.readBoolean();
            return new ParsedValueImpl(bl4, styleConverter, bl2);
        }
        if (by2 == 9) {
            double d6 = Double.longBitsToDouble(dataInputStream.readLong());
            SizeUnits sizeUnits = SizeUnits.PX;
            String string = stringArray[dataInputStream.readShort()];
            try {
                sizeUnits = Enum.valueOf(SizeUnits.class, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.toString());
            }
            catch (NullPointerException nullPointerException) {
                System.err.println(nullPointerException.toString());
            }
            return new ParsedValueImpl(new Size(d6, sizeUnits), styleConverter, bl2);
        }
        if (by2 == 4) {
            String string = stringArray[dataInputStream.readShort()];
            return new ParsedValueImpl(string, styleConverter, bl2);
        }
        if (by2 == 8) {
            String string = stringArray[dataInputStream.readShort()];
            try {
                URL uRL = new URL(string);
                return new ParsedValueImpl(uRL, styleConverter, bl2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new InternalError("Exception in Value.readBinary: " + String.valueOf(malformedURLException));
            }
        }
        if (by2 == 0) {
            return new ParsedValueImpl(null, styleConverter, bl2);
        }
        throw new InternalError("unknown type: " + by2);
    }
}

