/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing;

import com.sun.javafx.embed.swing.DataFlavorUtils$ByteBufferInputStream;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.input.DataFormat;

final class DataFlavorUtils {
    DataFlavorUtils() {
    }

    static String getFxMimeType(DataFlavor dataFlavor) {
        return dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
    }

    static DataFlavor[] getDataFlavors(String[] stringArray) {
        ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(stringArray.length);
        for (String string : stringArray) {
            DataFlavor dataFlavor;
            try {
                dataFlavor = new DataFlavor(string);
            }
            catch (ClassNotFoundException | IllegalArgumentException exception) {
                continue;
            }
            arrayList.add(dataFlavor);
        }
        return arrayList.toArray(new DataFlavor[0]);
    }

    static DataFlavor getDataFlavor(DataFormat dataFlavorArray) {
        if ((dataFlavorArray = DataFlavorUtils.getDataFlavors(dataFlavorArray.getIdentifiers().toArray(new String[1]))).length == 0) {
            return null;
        }
        return dataFlavorArray[0];
    }

    static String getMimeType(DataFormat object) {
        if ((object = ((DataFormat)object).getIdentifiers().iterator()).hasNext()) {
            object = (String)object.next();
            return object;
        }
        return null;
    }

    static DataFormat getDataFormat(DataFlavor object) {
        DataFormat dataFormat = DataFormat.lookupMimeType((String)(object = DataFlavorUtils.getFxMimeType((DataFlavor)object)));
        if (dataFormat == null) {
            dataFormat = new DataFormat(new String[]{object});
        }
        return dataFormat;
    }

    static Object adjustFxData(DataFlavor object, Object object2) throws UnsupportedEncodingException {
        if (object2 instanceof String) {
            if (((DataFlavor)object).isRepresentationClassInputStream()) {
                return new ByteArrayInputStream((object = ((DataFlavor)object).getParameter("charset")) != null ? ((String)object2).getBytes((String)object) : ((String)object2).getBytes());
            }
            ((DataFlavor)object).isRepresentationClassByteBuffer();
        }
        if (object2 instanceof ByteBuffer && ((DataFlavor)object).isRepresentationClassInputStream()) {
            return new DataFlavorUtils$ByteBufferInputStream((ByteBuffer)object2);
        }
        return object2;
    }

    static Object adjustSwingData(DataFlavor object, String object2, Object object3) {
        if (object3 == null) {
            return object3;
        }
        if (((DataFlavor)object).isFlavorJavaFileListType()) {
            object2 = (List)object3;
            object = new String[object2.size()];
            int n2 = 0;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                File file = (File)object2.next();
                object[n2++] = file.getPath();
            }
            return object;
        }
        if (DataFormat.PLAIN_TEXT.equals(object2 = DataFormat.lookupMimeType((String)object2))) {
            if (((DataFlavor)object).isFlavorTextType()) {
                if (object3 instanceof InputStream) {
                    object = (InputStream)object3;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    object2 = new byte[64];
                    try {
                        int n3 = ((InputStream)object).read((byte[])object2);
                        while (n3 != -1) {
                            byteArrayOutputStream.write((byte[])object2, 0, n3);
                            n3 = ((InputStream)object).read((byte[])object2);
                        }
                        byteArrayOutputStream.close();
                        return new String(byteArrayOutputStream.toByteArray());
                    }
                    catch (Exception exception) {}
                }
            } else if (object3 != null) {
                return object3.toString();
            }
        }
        return object3;
    }

    static Map<String, DataFlavor> adjustSwingDataFlavors(DataFlavor[] object) {
        HashMap hashMap = new HashMap(((DataFlavor[])object).length);
        for (DataFlavor[] dataFlavorArray : object) {
            Set<Object> set;
            String string = DataFlavorUtils.getFxMimeType((DataFlavor)dataFlavorArray);
            if (hashMap.containsKey(string)) {
                set = (Set)hashMap.get(string);
                try {
                    set.add(dataFlavorArray);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            set = new HashSet();
            if (dataFlavorArray.isFlavorTextType()) {
                set.add(DataFlavor.stringFlavor);
                set = Collections.unmodifiableSet(set);
            } else {
                set.add(dataFlavorArray);
            }
            hashMap.put(string, set);
        }
        object = new HashMap();
        for (String string : hashMap.keySet()) {
            DataFlavor[] dataFlavorArray;
            dataFlavorArray = ((Set)hashMap.get(string)).toArray(new DataFlavor[0]);
            if (dataFlavorArray.length == 1) {
                object.put(string, dataFlavorArray[0]);
                continue;
            }
            object.put(string, dataFlavorArray[0]);
        }
        return object;
    }

    private static Object readData(Transferable object, DataFlavor dataFlavor) {
        Object object2 = null;
        try {
            object2 = object.getTransferData(dataFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            object = unsupportedFlavorException;
            unsupportedFlavorException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace(System.err);
        }
        return object2;
    }

    static Map<String, Object> readAllData(Transferable transferable, Map<String, DataFlavor> map, boolean bl2) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            object = bl2 ? DataFlavorUtils.readData(transferable, dataFlavor) : null;
            if (object == null && bl2) continue;
            String string = DataFlavorUtils.getFxMimeType(dataFlavor);
            object = DataFlavorUtils.adjustSwingData(dataFlavor, string, object);
            hashMap.put(string, object);
        }
        for (Map.Entry entry : map.entrySet()) {
            DataFlavor dataFlavor;
            String string = (String)entry.getKey();
            dataFlavor = (DataFlavor)entry.getValue();
            object = bl2 ? DataFlavorUtils.readData(transferable, dataFlavor) : null;
            if (object == null && bl2) continue;
            object = DataFlavorUtils.adjustSwingData(dataFlavor, string, object);
            hashMap.put((String)entry.getKey(), object);
        }
        return hashMap;
    }
}

