/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing;

import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostDragStartListener;
import com.sun.javafx.embed.swing.SwingDnD$1;
import com.sun.javafx.embed.swing.SwingDnD$1StubDragGestureRecognizer;
import com.sun.javafx.embed.swing.SwingDnD$2;
import com.sun.javafx.embed.swing.SwingDnD$3;
import com.sun.javafx.embed.swing.SwingDnD$DnDTransferable;
import com.sun.javafx.embed.swing.SwingDragSource;
import com.sun.javafx.tk.Toolkit;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javafx.scene.input.TransferMode;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class SwingDnD {
    private final Transferable dndTransferable = new SwingDnD$DnDTransferable(this);
    private final DragSource dragSource;
    private final DragSourceListener dragSourceListener;
    private SwingDragSource swingDragSource;
    private EmbeddedSceneDTInterface fxDropTarget;
    private EmbeddedSceneDSInterface fxDragSource;
    private MouseEvent me;

    public SwingDnD(JComponent jComponent, EmbeddedSceneInterface object) {
        jComponent.addMouseListener(new SwingDnD$1(this));
        this.dragSource = new DragSource();
        this.dragSourceListener = new SwingDnD$2(this);
        object = new SwingDnD$3(this, (EmbeddedSceneInterface)object, jComponent);
        jComponent.setDropTarget(new DropTarget(jComponent, 0x40000003, (DropTargetListener)object));
    }

    public final void addNotify() {
        this.dragSource.addDragSourceListener(this.dragSourceListener);
    }

    public final void removeNotify() {
        this.dragSource.removeDragSourceListener(this.dragSourceListener);
    }

    public final HostDragStartListener getDragStartListener() {
        return (embeddedSceneDSInterface, transferMode) -> {
            assert (Toolkit.getToolkit().isFxUserThread());
            assert (embeddedSceneDSInterface != null);
            SwingUtilities.invokeLater(() -> {
                assert (this.fxDragSource == null);
                assert (this.swingDragSource == null);
                assert (this.fxDropTarget == null);
                this.fxDragSource = embeddedSceneDSInterface;
                SwingDnD swingDnD = this;
                swingDnD.startDrag(swingDnD.me, this.dndTransferable, embeddedSceneDSInterface.getSupportedActions(), transferMode);
            });
        };
    }

    private void startDrag(MouseEvent serializable, Transferable transferable, Set<TransferMode> collection, TransferMode transferMode) {
        assert (collection.contains((Object)transferMode));
        Point point = new Point(((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
        int n2 = SwingDnD.transferModeToDropAction(transferMode);
        SwingDnD swingDnD = this;
        serializable = new SwingDnD$1StubDragGestureRecognizer(swingDnD, swingDnD.dragSource, (MouseEvent)serializable, collection);
        collection = Arrays.asList(((DragGestureRecognizer)serializable).getTriggerEvent());
        serializable = new DragGestureEvent((DragGestureRecognizer)serializable, n2, point, (List<? extends InputEvent>)collection);
        ((DragGestureEvent)serializable).startDrag(null, transferable);
    }

    private void endDnD() {
        assert (this.swingDragSource != null);
        assert (this.fxDropTarget != null);
        this.fxDropTarget = null;
        this.swingDragSource = null;
    }

    private void storeMouseEvent(MouseEvent mouseEvent) {
        this.me = mouseEvent;
    }

    private void applyDragResult(TransferMode transferMode, DropTargetDragEvent dropTargetDragEvent) {
        if (transferMode == null) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(SwingDnD.transferModeToDropAction(transferMode));
    }

    private void applyDropResult(TransferMode transferMode, DropTargetDropEvent dropTargetDropEvent) {
        if (transferMode == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        dropTargetDropEvent.acceptDrop(SwingDnD.transferModeToDropAction(transferMode));
    }

    public static TransferMode dropActionToTransferMode(int n2) {
        switch (n2) {
            case 1: {
                return TransferMode.COPY;
            }
            case 2: {
                return TransferMode.MOVE;
            }
            case 0x40000000: {
                return TransferMode.LINK;
            }
            case 0: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int transferModeToDropAction(TransferMode transferMode) {
        switch (transferMode) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Set<TransferMode> dropActionsToTransferModes(int n2) {
        EnumSet<TransferMode> enumSet = EnumSet.noneOf(TransferMode.class);
        if ((n2 & 1) != 0) {
            enumSet.add(TransferMode.COPY);
        }
        if ((n2 & 2) != 0) {
            enumSet.add(TransferMode.MOVE);
        }
        if ((n2 & 0x40000000) != 0) {
            enumSet.add(TransferMode.LINK);
        }
        return Collections.unmodifiableSet(enumSet);
    }

    public static int transferModesToDropActions(Set<TransferMode> object) {
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            TransferMode transferMode = (TransferMode)((Object)object.next());
            n2 |= SwingDnD.transferModeToDropAction(transferMode);
        }
        return n2;
    }
}

