/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.event;

import com.sun.javafx.event.EventDispatchTree;
import javafx.event.Event;
import javafx.event.EventDispatcher;

public final class EventDispatchTreeImpl
implements EventDispatchTree {
    private static final int CAPACITY_GROWTH_FACTOR = 8;
    private static final int NULL_INDEX = -1;
    private EventDispatcher[] dispatchers;
    private int[] nextChildren;
    private int[] nextSiblings;
    private int reservedCount;
    private int rootIndex = -1;
    private int tailFirstIndex = -1;
    private int tailLastIndex = -1;
    private boolean expandTailFirstPath;

    public final void reset() {
        for (int i2 = 0; i2 < this.reservedCount; ++i2) {
            this.dispatchers[i2] = null;
        }
        this.reservedCount = 0;
        this.rootIndex = -1;
        this.tailFirstIndex = -1;
        this.tailLastIndex = -1;
    }

    @Override
    public final EventDispatchTree createTree() {
        return new EventDispatchTreeImpl();
    }

    @Override
    public final EventDispatchTree mergeTree(EventDispatchTree eventDispatchTree) {
        int n2;
        if (this.tailFirstIndex != -1) {
            if (this.rootIndex != -1) {
                this.expandTailFirstPath = true;
                EventDispatchTreeImpl eventDispatchTreeImpl = this;
                eventDispatchTreeImpl.expandTail(eventDispatchTreeImpl.rootIndex);
            } else {
                this.rootIndex = this.tailFirstIndex;
            }
            this.tailFirstIndex = -1;
            this.tailLastIndex = -1;
        }
        eventDispatchTree = (EventDispatchTreeImpl)eventDispatchTree;
        int n3 = n2 = ((EventDispatchTreeImpl)eventDispatchTree).rootIndex != -1 ? ((EventDispatchTreeImpl)eventDispatchTree).rootIndex : ((EventDispatchTreeImpl)eventDispatchTree).tailFirstIndex;
        if (this.rootIndex == -1) {
            this.rootIndex = this.copyTreeLevel((EventDispatchTreeImpl)eventDispatchTree, n2);
        } else {
            this.mergeTreeLevel((EventDispatchTreeImpl)eventDispatchTree, this.rootIndex, n2);
        }
        return this;
    }

    @Override
    public final EventDispatchTree append(EventDispatcher eventDispatcher) {
        EventDispatchTreeImpl eventDispatchTreeImpl = this;
        eventDispatchTreeImpl.ensureCapacity(eventDispatchTreeImpl.reservedCount + 1);
        this.dispatchers[this.reservedCount] = eventDispatcher;
        this.nextSiblings[this.reservedCount] = -1;
        this.nextChildren[this.reservedCount] = -1;
        if (this.tailFirstIndex == -1) {
            this.tailFirstIndex = this.reservedCount;
        } else {
            this.nextChildren[this.tailLastIndex] = this.reservedCount;
        }
        this.tailLastIndex = this.reservedCount++;
        return this;
    }

    @Override
    public final EventDispatchTree prepend(EventDispatcher eventDispatcher) {
        EventDispatchTreeImpl eventDispatchTreeImpl = this;
        eventDispatchTreeImpl.ensureCapacity(eventDispatchTreeImpl.reservedCount + 1);
        this.dispatchers[this.reservedCount] = eventDispatcher;
        this.nextSiblings[this.reservedCount] = -1;
        this.nextChildren[this.reservedCount] = this.rootIndex;
        this.rootIndex = this.reservedCount++;
        return this;
    }

    @Override
    public final Event dispatchEvent(Event event) {
        if (this.rootIndex == -1) {
            if (this.tailFirstIndex == -1) {
                return event;
            }
            this.rootIndex = this.tailFirstIndex;
            this.tailFirstIndex = -1;
            this.tailLastIndex = -1;
        }
        int n2 = this.reservedCount;
        int n3 = this.rootIndex;
        int n4 = this.tailFirstIndex;
        int n5 = this.tailLastIndex;
        Event event2 = null;
        int n6 = this.rootIndex;
        do {
            this.rootIndex = this.nextChildren[n6];
            Event event3 = this.dispatchers[n6].dispatchEvent(event, this);
            if (event3 == null) continue;
            Event event4 = event2 = event2 != null ? event : event3;
        } while ((n6 = this.nextSiblings[n6]) != -1);
        this.reservedCount = n2;
        this.rootIndex = n3;
        this.tailFirstIndex = n4;
        this.tailLastIndex = n5;
        return event2;
    }

    public final String toString() {
        int n2 = this.rootIndex != -1 ? this.rootIndex : this.tailFirstIndex;
        if (n2 == -1) {
            return "()";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendTreeLevel(stringBuilder, n2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n2) {
        if ((n2 = n2 + 8 - 1 & 0xFFFFFFF8) == 0) {
            return;
        }
        if (this.dispatchers == null || this.dispatchers.length < n2) {
            EventDispatcher[] eventDispatcherArray = new EventDispatcher[n2];
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            if (this.reservedCount > 0) {
                System.arraycopy(this.dispatchers, 0, eventDispatcherArray, 0, this.reservedCount);
                System.arraycopy(this.nextChildren, 0, nArray, 0, this.reservedCount);
                System.arraycopy(this.nextSiblings, 0, nArray2, 0, this.reservedCount);
            }
            this.dispatchers = eventDispatcherArray;
            this.nextChildren = nArray;
            this.nextSiblings = nArray2;
        }
    }

    private void expandTail(int n2) {
        while (n2 != -1) {
            if (this.nextChildren[n2] != -1) {
                EventDispatchTreeImpl eventDispatchTreeImpl = this;
                eventDispatchTreeImpl.expandTail(eventDispatchTreeImpl.nextChildren[n2]);
            } else if (this.expandTailFirstPath) {
                this.nextChildren[n2] = this.tailFirstIndex;
                this.expandTailFirstPath = false;
            } else {
                int n3;
                EventDispatchTreeImpl eventDispatchTreeImpl = this;
                this.nextChildren[n2] = n3 = eventDispatchTreeImpl.copyTreeLevel(eventDispatchTreeImpl, this.tailFirstIndex);
            }
            n2 = this.nextSiblings[n2];
        }
    }

    private void mergeTreeLevel(EventDispatchTreeImpl eventDispatchTreeImpl, int n2, int n3) {
        while (n3 != -1) {
            EventDispatcher eventDispatcher = eventDispatchTreeImpl.dispatchers[n3];
            int n4 = n2;
            int n5 = n2;
            while (n4 != -1 && eventDispatcher != this.dispatchers[n4]) {
                n5 = n4;
                n4 = this.nextSiblings[n4];
            }
            if (n4 == -1) {
                this.nextSiblings[n5] = var4_4 = this.copySubtree(eventDispatchTreeImpl, n3);
                this.nextSiblings[var4_4] = -1;
            } else {
                var4_4 = this.nextChildren[n4];
                n5 = EventDispatchTreeImpl.getChildIndex(eventDispatchTreeImpl, n3);
                if (var4_4 != -1) {
                    this.mergeTreeLevel(eventDispatchTreeImpl, var4_4, n5);
                } else {
                    this.nextChildren[n4] = var4_4 = this.copyTreeLevel(eventDispatchTreeImpl, n5);
                }
            }
            n3 = eventDispatchTreeImpl.nextSiblings[n3];
        }
    }

    private int copyTreeLevel(EventDispatchTreeImpl eventDispatchTreeImpl, int n2) {
        int n3;
        if (n2 == -1) {
            return -1;
        }
        int n4 = n3 = this.copySubtree(eventDispatchTreeImpl, n2);
        n2 = eventDispatchTreeImpl.nextSiblings[n2];
        while (n2 != -1) {
            int n5;
            this.nextSiblings[n4] = n5 = this.copySubtree(eventDispatchTreeImpl, n2);
            n4 = n5;
            n2 = eventDispatchTreeImpl.nextSiblings[n2];
        }
        this.nextSiblings[n4] = -1;
        return n3;
    }

    private int copySubtree(EventDispatchTreeImpl eventDispatchTreeImpl, int n2) {
        EventDispatchTreeImpl eventDispatchTreeImpl2 = this;
        eventDispatchTreeImpl2.ensureCapacity(eventDispatchTreeImpl2.reservedCount + 1);
        int n3 = this.reservedCount++;
        EventDispatchTreeImpl eventDispatchTreeImpl3 = eventDispatchTreeImpl;
        int n4 = this.copyTreeLevel(eventDispatchTreeImpl3, EventDispatchTreeImpl.getChildIndex(eventDispatchTreeImpl3, n2));
        this.dispatchers[n3] = eventDispatchTreeImpl.dispatchers[n2];
        this.nextChildren[n3] = n4;
        return n3;
    }

    private void appendTreeLevel(StringBuilder stringBuilder, int n2) {
        stringBuilder.append('(');
        this.appendSubtree(stringBuilder, n2);
        n2 = this.nextSiblings[n2];
        while (n2 != -1) {
            stringBuilder.append(",");
            this.appendSubtree(stringBuilder, n2);
            n2 = this.nextSiblings[n2];
        }
        stringBuilder.append(')');
    }

    private void appendSubtree(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(this.dispatchers[n2]);
        n2 = EventDispatchTreeImpl.getChildIndex(this, n2);
        if (n2 != -1) {
            stringBuilder.append("->");
            this.appendTreeLevel(stringBuilder, n2);
        }
    }

    private static int getChildIndex(EventDispatchTreeImpl eventDispatchTreeImpl, int n2) {
        int n3 = eventDispatchTreeImpl.nextChildren[n2];
        if (n3 == -1 && n2 != eventDispatchTreeImpl.tailLastIndex) {
            n3 = eventDispatchTreeImpl.tailFirstIndex;
        }
        return n3;
    }
}

