/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.event;

import com.sun.javafx.event.CompositeEventTargetImpl;
import com.sun.javafx.event.EventDispatchChainImpl;
import com.sun.javafx.event.EventDispatchTreeImpl;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventTarget;

public final class EventUtil {
    private static final EventDispatchChainImpl eventDispatchChain = new EventDispatchChainImpl();
    private static final AtomicBoolean eventDispatchChainInUse = new AtomicBoolean();

    public static Event fireEvent(EventTarget object, Event event) {
        if (event.getTarget() != object) {
            Event event2 = event;
            event = event2.copyFor(event2.getSource(), (EventTarget)object);
        }
        if (eventDispatchChainInUse.getAndSet(true)) {
            return EventUtil.fireEventImpl(new EventDispatchChainImpl(), (EventTarget)object, event);
        }
        try {
            object = EventUtil.fireEventImpl(eventDispatchChain, (EventTarget)object, event);
            return object;
        }
        finally {
            eventDispatchChain.reset();
            eventDispatchChainInUse.set(false);
        }
    }

    public static Event fireEvent(Event event, EventTarget ... eventTargetArray) {
        return EventUtil.fireEventImpl(new EventDispatchTreeImpl(), new CompositeEventTargetImpl(eventTargetArray), event);
    }

    private static Event fireEventImpl(EventDispatchChain eventDispatchChain, EventTarget eventTarget, Event event) {
        eventDispatchChain = eventTarget.buildEventDispatchChain(eventDispatchChain);
        return eventDispatchChain.dispatchEvent(event);
    }
}

