/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConstants;
import com.sun.javafx.font.FontFileWriter$FontTracker;
import com.sun.javafx.font.PrismFontFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;

class FontFileWriter
implements FontConstants {
    byte[] header;
    int pos;
    int headerPos;
    int writtenBytes;
    FontFileWriter$FontTracker tracker;
    File file;
    RandomAccessFile raFile;

    public FontFileWriter() {
        if (!FontFileWriter.hasTempPermission()) {
            this.tracker = FontFileWriter$FontTracker.getTracker();
        }
    }

    protected void setLength(int n2) throws IOException {
        if (this.raFile == null) {
            throw new IOException("File not open");
        }
        this.checkTracker(n2);
        this.raFile.setLength(n2);
    }

    public void seek(int n2) throws IOException {
        if (this.raFile == null) {
            throw new IOException("File not open");
        }
        if (n2 != this.pos) {
            this.raFile.seek(n2);
            this.pos = n2;
        }
    }

    public File getFile() {
        return this.file;
    }

    public File openFile() throws PrivilegedActionException {
        this.pos = 0;
        this.writtenBytes = 0;
        this.file = AccessController.doPrivileged(() -> {
            try {
                return Files.createTempFile("+JXF", ".tmp", new FileAttribute[0]).toFile();
            }
            catch (IOException iOException) {
                throw new IOException("Unable to create temporary file");
            }
        });
        if (this.tracker != null) {
            this.tracker.add(this.file);
        }
        this.raFile = AccessController.doPrivileged(() -> new RandomAccessFile(this.file, "rw"));
        if (this.tracker != null) {
            this.tracker.set(this.file, this.raFile);
        }
        if (PrismFontFactory.debugFonts) {
            System.err.println("Temp file created: " + this.file.getPath());
        }
        return this.file;
    }

    public void closeFile() throws IOException {
        if (this.header != null) {
            this.raFile.seek(0L);
            this.raFile.write(this.header);
            this.header = null;
        }
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
        }
        if (this.tracker != null) {
            this.tracker.remove(this.file);
        }
    }

    public void deleteFile() {
        if (this.file != null) {
            if (this.tracker != null) {
                this.tracker.subBytes(this.writtenBytes);
            }
            try {
                this.closeFile();
            }
            catch (Exception exception) {}
            try {
                AccessController.doPrivileged(() -> {
                    this.file.delete();
                    return null;
                });
                if (PrismFontFactory.debugFonts) {
                    System.err.println("Temp file delete: " + this.file.getPath());
                }
            }
            catch (Exception exception) {}
            this.file = null;
            this.raFile = null;
        }
    }

    public boolean isTracking() {
        return this.tracker != null;
    }

    private void checkTracker(int n2) throws IOException {
        if (this.tracker != null) {
            if (n2 < 0 || this.pos > 0x2000000 - n2) {
                throw new IOException("File too big.");
            }
            if (this.tracker.getNumBytes() > 0x14000000 - n2) {
                throw new IOException("Total files too big.");
            }
        }
    }

    private void checkSize(int n2) throws IOException {
        if (this.tracker != null) {
            this.checkTracker(n2);
            this.tracker.addBytes(n2);
            this.writtenBytes += n2;
        }
    }

    private void setHeaderPos(int n2) {
        this.headerPos = n2;
    }

    public void writeHeader(int n2, short s2) throws IOException {
        short s3 = 12 + s2 * 16;
        this.checkSize(s3);
        this.header = new byte[s3];
        short s4 = s2;
        s3 = s4;
        short s5 = (short)(s4 | s3 >> 1);
        s3 = s5;
        short s6 = (short)(s5 | s3 >> 2);
        s3 = s6;
        short s7 = (short)(s6 | s3 >> 4);
        s3 = s7;
        short s8 = (short)(s7 | s3 >> 8);
        s3 = s8;
        short s9 = (short)(s8 & ~(s3 >> 1));
        short s10 = (short)(s9 << 4);
        short s11 = 0;
        for (s3 = (short)(v330847); s3 > 1; s3 = (short)((short)(s3 >> 1))) {
            s11 = (short)(s11 + 1);
        }
        s3 = (short)((s2 << 4) - s10);
        this.setHeaderPos(0);
        this.writeInt(n2);
        this.writeShort(s2);
        this.writeShort(s10);
        this.writeShort(s11);
        this.writeShort(s3);
    }

    public void writeDirectoryEntry(int n2, int n3, int n4, int n5, int n6) {
        this.setHeaderPos(12 + n2 * 16);
        this.writeInt(n3);
        this.writeInt(n4);
        this.writeInt(n5);
        this.writeInt(n6);
    }

    private void writeInt(int n2) {
        this.header[this.headerPos++] = (byte)(n2 >> 24);
        this.header[this.headerPos++] = (byte)(n2 >> 16 & 0xFF);
        this.header[this.headerPos++] = (byte)(n2 >> 8 & 0xFF);
        this.header[this.headerPos++] = (byte)n2;
    }

    private void writeShort(short s2) {
        this.header[this.headerPos++] = (byte)(s2 >> 8 & 0xFF);
        this.header[this.headerPos++] = (byte)s2;
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.checkSize(n3);
        this.raFile.write(byArray, n2, n3);
        this.pos += n3;
    }

    static boolean hasTempPermission() {
        if (System.getSecurityManager() == null) {
            return true;
        }
        boolean bl2 = false;
        try {
            File file = Files.createTempFile("+JXF", ".tmp", new FileAttribute[0]).toFile();
            file.delete();
            bl2 = true;
        }
        catch (Throwable throwable) {}
        return bl2;
    }
}

