/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.glass.ui.Screen;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.FXPermissions;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.font.AndroidFontFinder;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.DFontDecoder;
import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontFileWriter;
import com.sun.javafx.font.FontFileWriter$FontTracker;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.LogicalFont;
import com.sun.javafx.font.MacFontFinder;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismCompositeFontResource;
import com.sun.javafx.font.PrismFont;
import com.sun.javafx.font.PrismFontFactory$1;
import com.sun.javafx.font.PrismFontFactory$TTFilter;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.WindowsFontMap;
import com.sun.javafx.text.GlyphLayout;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public abstract class PrismFontFactory
implements FontFactory {
    public static final boolean debugFonts;
    public static final boolean isWindows;
    public static final boolean isLinux;
    public static final boolean isMacOSX;
    public static final boolean isIOS;
    public static final boolean isAndroid;
    public static final boolean isEmbedded;
    public static final int cacheLayoutSize;
    private static int subPixelMode;
    public static final int SUB_PIXEL_ON = 1;
    public static final int SUB_PIXEL_Y = 2;
    public static final int SUB_PIXEL_NATIVE = 4;
    private static float fontSizeLimit;
    private static boolean lcdEnabled;
    private static float lcdContrast;
    private static String jreFontDir;
    private static final String jreDefaultFont = "Lucida Sans Regular";
    private static final String jreDefaultFontLC = "lucida sans regular";
    private static final String jreDefaultFontFile = "LucidaSansRegular.ttf";
    private static final String CT_FACTORY = "com.sun.javafx.font.coretext.CTFactory";
    private static final String DW_FACTORY = "com.sun.javafx.font.directwrite.DWFactory";
    private static final String FT_FACTORY = "com.sun.javafx.font.freetype.FTFactory";
    HashMap<String, FontResource> fontResourceMap = new HashMap();
    HashMap<String, CompositeFontResource> compResourceMap = new HashMap();
    private static PrismFontFactory theFontFactory;
    private HashMap<String, PrismFontFile> fileNameToFontResourceMap = new HashMap();
    private ArrayList<WeakReference<PrismFontFile>> tmpFonts;
    private static final String[] STR_ARRAY;
    private volatile HashMap<String, String> fontToFileMap = null;
    private HashMap<String, String> fileToFontMap = null;
    private HashMap<String, String> fontToFamilyNameMap = null;
    private HashMap<String, ArrayList<String>> familyToFontListMap = null;
    private static String sysFontDir;
    private static String userFontDir;
    private static ArrayList<String> allFamilyNames;
    private static ArrayList<String> allFontNames;
    private static Thread fileCloser;
    private HashMap<String, PrismFontFile> embeddedFonts;
    private int numEmbeddedFonts = 0;
    private static float systemFontSize;
    private static String systemFontFamily;
    private static String monospaceFontFamily;

    private static String getJDKFontDir() {
        String string = File.separator;
        return System.getProperty("java.home", "") + string + "lib" + string + "fonts";
    }

    private static String getNativeFactoryName() {
        if (isWindows) {
            return DW_FACTORY;
        }
        if (isMacOSX || isIOS) {
            return CT_FACTORY;
        }
        if (isLinux || isAndroid) {
            return FT_FACTORY;
        }
        return null;
    }

    public static float getFontSizeLimit() {
        return fontSizeLimit;
    }

    public static synchronized PrismFontFactory getFontFactory() {
        if (theFontFactory != null) {
            return theFontFactory;
        }
        String string = PrismFontFactory.getNativeFactoryName();
        if (string == null) {
            throw new InternalError("cannot find a native font factory");
        }
        if (debugFonts) {
            System.err.println("Loading FontFactory " + string);
            if (subPixelMode != 0) {
                Object object = "Subpixel: enabled";
                if ((subPixelMode & 2) != 0) {
                    object = (String)object + ", vertical";
                }
                if ((subPixelMode & 4) != 0) {
                    object = (String)object + ", native";
                }
                System.err.println((String)object);
            }
        }
        if ((theFontFactory = PrismFontFactory.getFontFactory(string)) == null) {
            throw new InternalError("cannot load font factory: " + string);
        }
        return theFontFactory;
    }

    private static synchronized PrismFontFactory getFontFactory(String string) {
        try {
            GenericDeclaration genericDeclaration = Class.forName(string);
            genericDeclaration = genericDeclaration.getMethod("getFactory", null);
            return (PrismFontFactory)((Method)genericDeclaration).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            if (debugFonts) {
                System.err.println("Loading font factory failed " + string);
            }
            return null;
        }
    }

    protected abstract PrismFontFile createFontFile(String var1, String var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7) throws Exception;

    public abstract GlyphLayout createGlyphLayout();

    private PrismFontFile createFontResource(String string, int n2) {
        return this.createFontResource(null, string, n2, true, false, false, false);
    }

    private PrismFontFile createFontResource(String string, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        PrismFontFile prismFontFile;
        Object object = (string2 + n2).toLowerCase();
        if (isMacOSX && string != null && string.startsWith("System ")) {
            object = (String)object + string;
        }
        if ((prismFontFile = this.fileNameToFontResourceMap.get(object)) != null) {
            return prismFontFile;
        }
        try {
            prismFontFile = this.createFontFile(string, string2, n2, bl2, bl3, bl4, bl5);
            if (bl2) {
                this.storeInMap(prismFontFile.getFullName(), prismFontFile);
                this.fileNameToFontResourceMap.put((String)object, prismFontFile);
            }
            return prismFontFile;
        }
        catch (Exception exception) {
            if (debugFonts) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    public int findFontIndex(String string, String string2) {
        block4: {
            try {
                Object object = this.createFontFile(null, string2, 0, false, false, false, false);
                int n2 = ((PrismFontFile)object).getFontCount();
                if (n2 == 1 || ((PrismFontFile)object).getFullName().equalsIgnoreCase(string)) {
                    return 0;
                }
                int n3 = 1;
                do {
                    object = this.createFontFile(null, string2, n3, false, false, false, false);
                    if (!((String)(object = ((PrismFontFile)object).getFullName())).equalsIgnoreCase(string)) continue;
                    return n3;
                } while (++n3 < n2);
            }
            catch (Exception exception) {
                if (!debugFonts) break block4;
                exception.printStackTrace();
            }
        }
        return -1;
    }

    private PrismFontFile createFontResource(String string, String string2) {
        PrismFontFile[] prismFontFileArray = this.createFontResources(string, string2, true, false, false, false, true);
        if (prismFontFileArray == null || prismFontFileArray.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < prismFontFileArray.length; ++i2) {
            if (!prismFontFileArray[i2].getFullName().equalsIgnoreCase(string)) continue;
            return prismFontFileArray[i2];
        }
        this.storeInMap(string, prismFontFileArray[0]);
        if (debugFonts) {
            System.err.println("No match for name " + string + " in " + string2);
        }
        return prismFontFileArray[0];
    }

    private PrismFontFile[] createFontResources(String prismFontFileArray, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean n2) {
        if (string == null) {
            return null;
        }
        PrismFontFile prismFontFile = this.createFontResource((String)prismFontFileArray, string, 0, bl2, bl3, bl4, bl5);
        if (prismFontFile == null) {
            return null;
        }
        n2 = n2 == 0 ? 1 : prismFontFile.getFontCount();
        PrismFontFile[] prismFontFileArray2 = new PrismFontFile[n2];
        prismFontFileArray = prismFontFileArray2;
        prismFontFileArray2[0] = prismFontFile;
        if (n2 == 1) {
            return prismFontFileArray;
        }
        PrismFontFile.FileRefCounter fileRefCounter = null;
        if (bl4) {
            fileRefCounter = prismFontFile.createFileRefCounter();
        }
        int n3 = 1;
        do {
            String string2 = (string + n3).toLowerCase();
            try {
                prismFontFile = this.fileNameToFontResourceMap.get(string2);
                if (prismFontFile != null) {
                    prismFontFileArray[n3] = prismFontFile;
                    continue;
                }
                prismFontFile = this.createFontFile(null, string, n3, bl2, bl3, bl4, bl5);
                if (prismFontFile == null) {
                    return null;
                }
                if (fileRefCounter != null) {
                    prismFontFile.setAndIncFileRefCounter(fileRefCounter);
                }
                prismFontFileArray[n3] = prismFontFile;
                String string3 = prismFontFile.getFullName();
                if (!bl2) continue;
                this.storeInMap(string3, prismFontFile);
                this.fileNameToFontResourceMap.put(string2, prismFontFile);
            }
            catch (Exception exception) {
                if (debugFonts) {
                    exception.printStackTrace();
                }
                return null;
            }
        } while (++n3 < n2);
        return prismFontFileArray;
    }

    private String dotStyleStr(boolean bl2, boolean bl3) {
        if (!bl2) {
            if (!bl3) {
                return "";
            }
            return ".italic";
        }
        if (!bl3) {
            return ".bold";
        }
        return ".bolditalic";
    }

    protected void storeInMap(String string, FontResource fontResource) {
        if (string == null || fontResource == null) {
            return;
        }
        if (fontResource instanceof PrismCompositeFontResource) {
            System.err.println(string + " is a composite " + String.valueOf(fontResource));
            Thread.dumpStack();
            return;
        }
        this.fontResourceMap.put(string.toLowerCase(), fontResource);
    }

    synchronized void addDecodedFont(PrismFontFile prismFontFile) {
        prismFontFile.setIsDecoded(true);
        this.addTmpFont(prismFontFile);
    }

    private synchronized void addTmpFont(PrismFontFile weakReference) {
        if (this.tmpFonts == null) {
            this.tmpFonts = new ArrayList();
        }
        weakReference = ((PrismFontFile)((Object)weakReference)).isRegistered() ? new WeakReference<PrismFontFile>((PrismFontFile)((Object)weakReference)) : ((PrismFontFile)((Object)weakReference)).createFileDisposer(this, ((PrismFontFile)((Object)weakReference)).getFileRefCounter());
        this.tmpFonts.add(weakReference);
        this.addFileCloserHook();
    }

    synchronized void removeTmpFont(WeakReference<PrismFontFile> weakReference) {
        if (this.tmpFonts != null) {
            this.tmpFonts.remove(weakReference);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public synchronized FontResource getFontResource(String var1_1, boolean var2_2, boolean var3_3, boolean var4_4) {
        block24: {
            block26: {
                block27: {
                    block25: {
                        block23: {
                            if (var1_1 == null || var1_1.isEmpty()) {
                                return null;
                            }
                            var6_6 = this.lookupResource((var1_1 = var1_1.toLowerCase()) + (var5_5 = this.dotStyleStr(var2_2, var3_3)), var4_4);
                            if (var6_6 != null) {
                                return var6_6;
                            }
                            if (this.embeddedFonts != null && var4_4) {
                                var6_6 = this.lookupResource(var1_1 + var5_5, false);
                                if (var6_6 != null) {
                                    return new PrismCompositeFontResource((FontResource)var6_6, var1_1 + var5_5);
                                }
                                for (Object var7_10 : this.embeddedFonts.values()) {
                                    var8_11 = var7_10.getFamilyName().toLowerCase();
                                    if (!var8_11.equals(var1_1)) continue;
                                    return new PrismCompositeFontResource((FontResource)var7_10, var1_1 + var5_5);
                                }
                            }
                            if (PrismFontFactory.isWindows && (var7_10 = WindowsFontMap.findFontFile(var1_1, var6_7 = (var2_2 != false ? 1 : 0) + (var3_3 != false ? 2 : 0))) != null && (var6_8 /* !! */  = this.createFontResource(null, (String)var7_10)) != null) {
                                if (var2_2 == var6_8 /* !! */ .isBold() && var3_3 == var6_8 /* !! */ .isItalic() && !var5_5.isEmpty()) {
                                    this.storeInMap(var1_1 + var5_5, var6_8 /* !! */ );
                                }
                                if (var4_4) {
                                    var6_8 /* !! */  = new PrismCompositeFontResource(var6_8 /* !! */ , var1_1 + var5_5);
                                }
                                return var6_8 /* !! */ ;
                            }
                            this.getFullNameToFileMap();
                            var6_9 = this.familyToFontListMap.get(var1_1);
                            if (var6_9 == null) {
                                return null;
                            }
                            var7_10 = null;
                            var8_11 = null;
                            var9_12 = null;
                            var10_13 = null;
                            var11_14 = var6_9.iterator();
                            while (var11_14.hasNext()) {
                                var12_15 = var11_14.next();
                                var13_16 = var12_15.toLowerCase();
                                var6_9 = this.fontResourceMap.get(var13_16);
                                if (var6_9 == null) {
                                    var14_17 = this.findFile(var13_16);
                                    if (var14_17 != null) {
                                        var6_9 = this.getFontResource(var12_15, var14_17);
                                    }
                                    if (var6_9 == null) continue;
                                    this.storeInMap(var13_16, (FontResource)var6_9);
                                }
                                if (var2_2 == var6_9.isBold() && var3_3 == var6_9.isItalic()) {
                                    this.storeInMap(var1_1 + var5_5, (FontResource)var6_9);
                                    if (var4_4) {
                                        var6_9 = new PrismCompositeFontResource((FontResource)var6_9, var1_1 + var5_5);
                                    }
                                    return var6_9;
                                }
                                if (!var6_9.isBold()) {
                                    if (!var6_9.isItalic()) {
                                        var7_10 = var6_9;
                                        continue;
                                    }
                                    var9_12 = var6_9;
                                    continue;
                                }
                                if (!var6_9.isItalic()) {
                                    var8_11 = var6_9;
                                    continue;
                                }
                                var10_13 = var6_9;
                            }
                            if (var2_2 || var3_3) break block23;
                            var6_9 = var8_11 != null ? var8_11 : (var9_12 != null ? var9_12 : var10_13);
                            break block24;
                        }
                        if (!var2_2 || var3_3) break block25;
                        if (var7_10 != null) ** GOTO lbl-1000
                        var6_9 = var10_13 != null ? var10_13 : var9_12;
                        break block24;
                    }
                    if (var2_2 || !var3_3) break block26;
                    if (var10_13 == null) break block27;
                    var6_9 = var10_13;
                    break block24;
                }
                if (var7_10 != null) ** GOTO lbl-1000
                var6_9 = var8_11;
                break block24;
            }
            if (var9_12 != null) {
                var6_9 = var9_12;
            } else if (var8_11 != null) {
                var6_9 = var8_11;
            } else lbl-1000:
            // 3 sources

            {
                var6_9 = var7_10;
            }
        }
        if (var6_9 != null) {
            this.storeInMap(var1_1 + var5_5, (FontResource)var6_9);
            if (var4_4) {
                var6_9 = new PrismCompositeFontResource((FontResource)var6_9, var1_1 + var5_5);
            }
        }
        return var6_9;
    }

    @Override
    public synchronized PGFont createFont(String string, boolean bl2, boolean bl3, float f2) {
        Object object = null;
        if (string != null && !string.isEmpty() && !this.isExcluded(string)) {
            object = LogicalFont.getLogicalFont(string, bl2, bl3, f2);
            if (object != null) {
                return object;
            }
            object = this.getFontResource(string, bl2, bl3, true);
        }
        if (object == null) {
            return LogicalFont.getLogicalFont("System", bl2, bl3, f2);
        }
        FontResource fontResource = object;
        return new PrismFont(fontResource, fontResource.getFullName(), f2);
    }

    @Override
    public synchronized PGFont createFont(String string, float f2) {
        Object object = null;
        if (string != null && !string.isEmpty() && !this.isExcluded(string)) {
            object = LogicalFont.getLogicalFont(string, f2);
            if (object != null) {
                return object;
            }
            object = this.getFontResource(string, null, true);
        }
        if (object == null) {
            return LogicalFont.getLogicalFont("System Regular", f2);
        }
        FontResource fontResource = object;
        return new PrismFont(fontResource, fontResource.getFullName(), f2);
    }

    private PrismFontFile getFontResource(String string, String string2) {
        PrismFontFile prismFontFile = null;
        if (isMacOSX) {
            DFontDecoder dFontDecoder;
            block9: {
                dFontDecoder = null;
                if (string != null && string2.endsWith(".dfont")) {
                    dFontDecoder = new DFontDecoder();
                    try {
                        dFontDecoder.openFile();
                        dFontDecoder.decode(string);
                        dFontDecoder.closeFile();
                        string2 = dFontDecoder.getFile().getPath();
                    }
                    catch (Exception exception) {
                        string2 = null;
                        dFontDecoder.deleteFile();
                        dFontDecoder = null;
                        if (!debugFonts) break block9;
                        exception.printStackTrace();
                    }
                }
            }
            if (string2 != null) {
                prismFontFile = this.createFontResource(string, string2);
            }
            if (dFontDecoder != null) {
                if (prismFontFile != null) {
                    this.addDecodedFont(prismFontFile);
                } else {
                    dFontDecoder.deleteFile();
                }
            }
        } else {
            prismFontFile = this.createFontResource(string, string2);
        }
        return prismFontFile;
    }

    @Override
    public synchronized PGFont deriveFont(PGFont object, boolean bl2, boolean bl3, float f2) {
        Object object2 = object = object.getFontResource();
        return new PrismFont((FontResource)object2, object2.getFullName(), f2);
    }

    private FontResource lookupResource(String string, boolean bl2) {
        if (bl2) {
            return this.compResourceMap.get(string);
        }
        return this.fontResourceMap.get(string);
    }

    public synchronized FontResource getFontResource(String string, String string2, boolean bl2) {
        Object object;
        String string3;
        if (string != null) {
            string3 = string.toLowerCase();
            object = this.lookupResource(string3, bl2);
            if (object != null) {
                return object;
            }
            if (this.embeddedFonts != null && bl2) {
                object = this.lookupResource(string3, false);
                if (object != null) {
                    object = new PrismCompositeFontResource((FontResource)object, string3);
                }
                if (object != null) {
                    return object;
                }
            }
        }
        if (isWindows && string != null && (object = WindowsFontMap.findFontFile(string3 = string.toLowerCase(), -1)) != null && (object = this.createFontResource(null, (String)object)) != null) {
            if (bl2) {
                object = new PrismCompositeFontResource((FontResource)object, string3);
            }
            return object;
        }
        this.getFullNameToFileMap();
        if (string != null && string2 != null && (object = this.getFontResource(string, string2)) != null) {
            if (bl2) {
                object = new PrismCompositeFontResource((FontResource)object, string.toLowerCase());
            }
            return object;
        }
        if (string != null && (object = this.getFontResourceByFullName(string, bl2)) != null) {
            return object;
        }
        if (string2 != null && (object = this.getFontResourceByFileName(string2, bl2)) != null) {
            return object;
        }
        return null;
    }

    private synchronized FontResource getFontResourceByFileName(String object, boolean bl2) {
        if (this.fontToFileMap.size() <= 1) {
            return null;
        }
        String string = this.fileToFontMap.get(((String)object).toLowerCase());
        if (string == null) {
            if ((object = this.createFontResource((String)object, 0)) != null) {
                String string2 = object.getFullName().toLowerCase();
                this.storeInMap(string2, (FontResource)object);
                if (bl2) {
                    object = new PrismCompositeFontResource((FontResource)object, string2);
                }
            }
        } else {
            String string3;
            String string4 = string.toLowerCase();
            object = this.lookupResource(string4, bl2);
            if (object == null && (string3 = this.findFile(string4)) != null) {
                object = this.getFontResource(string, string3);
                if (object != null) {
                    this.storeInMap(string4, (FontResource)object);
                }
                if (bl2) {
                    object = new PrismCompositeFontResource((FontResource)object, string4);
                }
            }
        }
        return object;
    }

    private synchronized FontResource getFontResourceByFullName(String string, boolean bl2) {
        String string2 = string.toLowerCase();
        if (this.fontToFileMap.size() <= 1) {
            string = jreDefaultFont;
        }
        FontResource fontResource = null;
        String string3 = this.findFile(string2);
        if (string3 != null && (fontResource = this.getFontResource(string, string3)) != null) {
            this.storeInMap(string2, fontResource);
            if (bl2) {
                fontResource = new PrismCompositeFontResource(fontResource, string2);
            }
        }
        return fontResource;
    }

    FontResource getDefaultFontResource(boolean bl2) {
        Object object = this.lookupResource(jreDefaultFontLC, bl2);
        if (object == null) {
            object = this.createFontResource(jreDefaultFont, jreFontDir + jreDefaultFontFile);
            if (object == null) {
                Object object2 = this.fontToFileMap.keySet().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    object = this.findFile((String)object);
                    if ((object = this.createFontResource(jreDefaultFontLC, (String)object)) == null) continue;
                }
                if (object == null && isLinux && (object2 = FontConfigManager.getDefaultFontPath()) != null) {
                    object = this.createFontResource(jreDefaultFontLC, (String)object2);
                }
                if (object == null) {
                    return null;
                }
            }
            this.storeInMap(jreDefaultFontLC, (FontResource)object);
            if (bl2) {
                object = new PrismCompositeFontResource((FontResource)object, jreDefaultFontLC);
            }
        }
        return object;
    }

    private String findFile(String string) {
        if (string.equals(jreDefaultFontLC)) {
            return jreFontDir + jreDefaultFontFile;
        }
        this.getFullNameToFileMap();
        string = this.fontToFileMap.get(string);
        if (isWindows) {
            string = PrismFontFactory.getPathNameWindows(string);
        }
        return string;
    }

    private static native String getFontPath();

    private static void getPlatformFontDirs() {
        if (userFontDir != null || sysFontDir != null) {
            return;
        }
        String string = PrismFontFactory.getFontPath();
        int n2 = string.indexOf(59);
        if (n2 < 0) {
            sysFontDir = string;
            return;
        }
        sysFontDir = string.substring(0, n2);
        userFontDir = string.substring(n2 + 1, string.length());
    }

    private void resolveWindowsFonts(HashMap<String, String> object, HashMap<String, String> hashMap, HashMap<String, ArrayList<String>> hashMap2) {
        String string;
        ArrayList<String> arrayList = null;
        for (String object2 : hashMap.keySet()) {
            Object n3 = (String)((HashMap)object).get(object2);
            if (n3 != null) continue;
            int string2 = object2.indexOf("  ");
            if (string2 > 0) {
                string = object2.substring(0, string2);
                n3 = (String)((HashMap)object).get(string = string.concat(object2.substring(string2 + 1)));
                if (n3 == null || hashMap.containsKey(string)) continue;
                ((HashMap)object).remove(string);
                ((HashMap)object).put(object2, n3);
                continue;
            }
            if (object2.equals("marlett")) {
                ((HashMap)object).put(object2, "marlett.ttf");
                continue;
            }
            if (object2.equals("david")) {
                n3 = (String)((HashMap)object).get("david regular");
                if (n3 == null) continue;
                ((HashMap)object).remove("david regular");
                ((HashMap)object).put("david", n3);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(object2);
        }
        if (arrayList != null) {
            ArrayList<String> arrayList2 = new HashSet();
            HashMap hashMap3 = new HashMap();
            hashMap3.putAll(object);
            for (String string3 : hashMap.keySet()) {
                hashMap3.remove(string3);
            }
            for (String i2 : hashMap3.keySet()) {
                ((HashSet)((Object)arrayList2)).add((String)hashMap3.get(i2));
                ((HashMap)object).remove(i2);
            }
            this.resolveFontFiles((HashSet<String>)((Object)arrayList2), arrayList, (HashMap<String, String>)object, hashMap, hashMap2);
            if (arrayList.size() > 0) {
                int n2 = arrayList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    string = arrayList.get(i2);
                    object = hashMap.get(string);
                    if (object != null && (arrayList2 = hashMap2.get(object)) != null && arrayList2.size() <= 1) {
                        hashMap2.remove(object);
                    }
                    hashMap.remove(string);
                }
            }
        }
    }

    private void resolveFontFiles(HashSet<String> object, ArrayList<String> arrayList, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        object = ((HashSet)object).iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                PrismFontFile prismFontFile;
                int n2 = 0;
                String string2 = PrismFontFactory.getPathNameWindows(string);
                while ((prismFontFile = this.createFontResource(string2, n2++)) != null) {
                    ArrayList<String> arrayList2 = prismFontFile.getFullName().toLowerCase();
                    String string3 = prismFontFile.getLocaleFullName().toLowerCase();
                    if (arrayList.contains(arrayList2) || arrayList.contains(string3)) {
                        hashMap.put((String)((Object)arrayList2), string);
                        arrayList.remove(arrayList2);
                        if (arrayList.contains(string3)) {
                            arrayList.remove(string3);
                            String string4 = prismFontFile.getFamilyName();
                            String string5 = string4.toLowerCase();
                            hashMap2.remove(string3);
                            hashMap2.put((String)((Object)arrayList2), string4);
                            arrayList2 = hashMap3.get(string5);
                            if (arrayList2 != null) {
                                arrayList2.remove(prismFontFile.getLocaleFullName());
                            } else {
                                string3 = prismFontFile.getLocaleFamilyName().toLowerCase();
                                arrayList2 = hashMap3.get(string3);
                                if (arrayList2 != null) {
                                    hashMap3.remove(string3);
                                }
                                arrayList2 = new ArrayList();
                                hashMap3.put(string5, arrayList2);
                            }
                            arrayList2.add(prismFontFile.getFullName());
                        }
                    }
                    if (n2 < prismFontFile.getFontCount()) continue;
                }
            }
            catch (Exception exception) {
                if (!debugFonts) continue;
                exception.printStackTrace();
            }
        }
    }

    static native void populateFontFileNameMap(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    protected static String getPathNameWindows(String string) {
        if (string == null) {
            return null;
        }
        PrismFontFactory.getPlatformFontDirs();
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        if (userFontDir == null) {
            return sysFontDir + "\\" + string;
        }
        if ((string = AccessController.doPrivileged(new PrismFontFactory$1(string))) != null) {
            return string;
        }
        return null;
    }

    public boolean isExcluded(String string) {
        return false;
    }

    @Override
    public String[] getFontFamilyNames() {
        if (allFamilyNames == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            LogicalFont.addFamilies(arrayList);
            if (this.embeddedFonts != null) {
                for (PrismFontFile object : this.embeddedFonts.values()) {
                    if (arrayList.contains(object.getFamilyName())) continue;
                    arrayList.add(object.getFamilyName());
                }
            }
            this.getFullNameToFileMap();
            for (String string : this.fontToFamilyNameMap.values()) {
                if (arrayList.contains(string) || this.isExcluded(string)) continue;
                arrayList.add(string);
            }
            Collections.sort(arrayList);
            allFamilyNames = new ArrayList<String>(arrayList);
        }
        return allFamilyNames.toArray(STR_ARRAY);
    }

    @Override
    public String[] getFontFullNames() {
        if (allFontNames == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            LogicalFont.addFullNames(arrayList);
            if (this.embeddedFonts != null) {
                for (PrismFontFile object : this.embeddedFonts.values()) {
                    if (arrayList.contains(object.getFullName())) continue;
                    arrayList.add(object.getFullName());
                }
            }
            this.getFullNameToFileMap();
            for (ArrayList arrayList2 : this.familyToFontListMap.values()) {
                for (String string : arrayList2) {
                    if (this.isExcluded(string)) continue;
                    arrayList.add(string);
                }
            }
            Collections.sort(arrayList);
            allFontNames = arrayList;
        }
        return allFontNames.toArray(STR_ARRAY);
    }

    @Override
    public String[] getFontFullNames(String string) {
        if (this.isExcluded(string)) {
            return STR_ARRAY;
        }
        Object object = LogicalFont.getFontsInFamily(string);
        if (object != null) {
            return object;
        }
        if (this.embeddedFonts != null) {
            object = null;
            for (PrismFontFile prismFontFile : this.embeddedFonts.values()) {
                if (!prismFontFile.getFamilyName().equalsIgnoreCase(string)) continue;
                if (object == null) {
                    object = new ArrayList();
                }
                ((ArrayList)object).add(prismFontFile.getFullName());
            }
            if (object != null) {
                return ((ArrayList)object).toArray(STR_ARRAY);
            }
        }
        this.getFullNameToFileMap();
        string = string.toLowerCase();
        object = this.familyToFontListMap.get(string);
        if (object != null) {
            return ((ArrayList)object).toArray(STR_ARRAY);
        }
        return STR_ARRAY;
    }

    public final int getSubPixelMode() {
        return subPixelMode;
    }

    public boolean isLCDTextSupported() {
        return lcdEnabled;
    }

    @Override
    public boolean isPlatformFont(String string) {
        if (string == null) {
            return false;
        }
        if (LogicalFont.isLogicalFont(string = string.toLowerCase())) {
            return true;
        }
        if (string.startsWith("lucida sans")) {
            return true;
        }
        String string2 = PrismFontFactory.getSystemFont("System").toLowerCase();
        return string.startsWith(string2);
    }

    public static boolean isJreFont(FontResource object) {
        object = object.getFileName();
        return ((String)object).startsWith(jreFontDir);
    }

    public static float getLCDContrast() {
        if (lcdContrast == -1.0f) {
            lcdContrast = isWindows ? (float)PrismFontFactory.getLCDContrastWin32() / 1000.0f : 1.3f;
        }
        return lcdContrast;
    }

    private synchronized void addFileCloserHook() {
        if (fileCloser == null) {
            Runnable runnable = () -> {
                if (this.embeddedFonts != null) {
                    for (PrismFontFile object : this.embeddedFonts.values()) {
                        object.disposeOnShutdown();
                    }
                }
                if (this.tmpFonts != null) {
                    for (WeakReference weakReference : this.tmpFonts) {
                        PrismFontFile prismFontFile = (PrismFontFile)weakReference.get();
                        if (prismFontFile == null) continue;
                        prismFontFile.disposeOnShutdown();
                    }
                }
            };
            AccessController.doPrivileged(() -> {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                fileCloser = new Thread(threadGroup, runnable);
                fileCloser.setContextClassLoader(null);
                Runtime.getRuntime().addShutdownHook(fileCloser);
                return null;
            });
        }
    }

    @Override
    public PGFont[] loadEmbeddedFont(String pGFontArray, InputStream inputStream, float f2, boolean bl2, boolean bl3) {
        if (!this.hasPermission()) {
            return new PGFont[]{this.createFont("System Regular", f2)};
        }
        if (FontFileWriter.hasTempPermission()) {
            return this.loadEmbeddedFont0((String)pGFontArray, inputStream, f2, bl2, bl3);
        }
        FontFileWriter$FontTracker fontFileWriter$FontTracker = FontFileWriter$FontTracker.getTracker();
        boolean bl4 = false;
        try {
            bl4 = fontFileWriter$FontTracker.acquirePermit();
            if (!bl4) {
                return null;
            }
            pGFontArray = this.loadEmbeddedFont0((String)pGFontArray, inputStream, f2, bl2, bl3);
            return pGFontArray;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        finally {
            if (bl4) {
                fontFileWriter$FontTracker.releasePermit();
            }
        }
    }

    private PGFont[] loadEmbeddedFont0(String string, InputStream inputStream, float f2, boolean bl2, boolean bl3) {
        int n2;
        Object[] objectArray;
        PrismFontFile[] prismFontFileArray = null;
        FontFileWriter fontFileWriter = new FontFileWriter();
        try {
            File file = fontFileWriter.openFile();
            objectArray = new byte[8192];
            while ((n2 = inputStream.read((byte[])objectArray)) >= 0) {
                fontFileWriter.writeBytes((byte[])objectArray, 0, n2);
            }
            fontFileWriter.closeFile();
            prismFontFileArray = this.loadEmbeddedFont1(string, file.getPath(), bl2, true, fontFileWriter.isTracking(), bl3);
            if (prismFontFileArray != null && prismFontFileArray.length > 0 && prismFontFileArray[0].isDecoded()) {
                fontFileWriter.deleteFile();
            }
            this.addFileCloserHook();
        }
        catch (Exception exception) {
            fontFileWriter.deleteFile();
        }
        finally {
            if (prismFontFileArray == null) {
                fontFileWriter.deleteFile();
            }
        }
        if (prismFontFileArray != null && prismFontFileArray.length > 0) {
            if (f2 <= 0.0f) {
                f2 = PrismFontFactory.getSystemFontSize();
            }
            int n3 = prismFontFileArray.length;
            objectArray = new PrismFont[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray[n2] = (byte)new PrismFont(prismFontFileArray[n2], prismFontFileArray[n2].getFullName(), f2);
            }
            return objectArray;
        }
        return null;
    }

    @Override
    public PGFont[] loadEmbeddedFont(String prismFontFileArray, String string, float f2, boolean bl2, boolean n2) {
        if (!this.hasPermission()) {
            return new PGFont[]{this.createFont("System Regular", f2)};
        }
        this.addFileCloserHook();
        prismFontFileArray = this.loadEmbeddedFont1((String)prismFontFileArray, string, bl2, false, false, n2 != 0);
        if (prismFontFileArray != null && prismFontFileArray.length > 0) {
            if (f2 <= 0.0f) {
                f2 = PrismFontFactory.getSystemFontSize();
            }
            int n3 = prismFontFileArray.length;
            PGFont[] pGFontArray = new PGFont[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                pGFontArray[n2] = new PrismFont(prismFontFileArray[n2], prismFontFileArray[n2].getFullName(), f2);
            }
            return pGFontArray;
        }
        return null;
    }

    private void removeEmbeddedFont(String object) {
        PrismFontFile prismFontFile = this.embeddedFonts.get(object);
        if (prismFontFile == null) {
            return;
        }
        this.embeddedFonts.remove(object);
        object = ((String)object).toLowerCase();
        this.fontResourceMap.remove(object);
        this.compResourceMap.remove(object);
        object = this.compResourceMap.values().iterator();
        while (object.hasNext()) {
            CompositeFontResource compositeFontResource = (CompositeFontResource)object.next();
            if (compositeFontResource.getSlotResource(0) != prismFontFile) continue;
            object.remove();
        }
    }

    protected boolean registerEmbeddedFont(String string) {
        return true;
    }

    public int test_getNumEmbeddedFonts() {
        return this.numEmbeddedFonts;
    }

    private synchronized PrismFontFile[] loadEmbeddedFont1(String string, String prismFontFileArray, boolean bl2, boolean bl3, boolean bl4, boolean n2) {
        String string2;
        Object object;
        PrismFontFile prismFontFile;
        ++this.numEmbeddedFonts;
        if ((prismFontFileArray = this.createFontResources(string, (String)prismFontFileArray, bl2, true, bl3, bl4, n2 != 0)) == null || prismFontFileArray.length == 0) {
            return null;
        }
        if (this.embeddedFonts == null) {
            this.embeddedFonts = new HashMap();
        }
        bl4 = true;
        for (n2 = 0; n2 < prismFontFileArray.length; ++n2) {
            prismFontFile = prismFontFileArray[n2];
            object = prismFontFile.getFamilyName();
            if (object == null || ((String)object).length() == 0) {
                return null;
            }
            string2 = prismFontFile.getFullName();
            if (string2 == null || string2.length() == 0) {
                return null;
            }
            object = prismFontFile.getPSName();
            if (object == null || ((String)object).length() == 0) {
                return null;
            }
            object = this.embeddedFonts.get(string2);
            if (object == null || !prismFontFile.equals(object)) continue;
            bl4 = false;
        }
        if (bl4 && !this.registerEmbeddedFont(prismFontFileArray[0].getFileName())) {
            return null;
        }
        if (bl3 && !prismFontFileArray[0].isDecoded()) {
            this.addTmpFont(prismFontFileArray[0]);
        }
        if (!bl2) {
            return prismFontFileArray;
        }
        if (string != null && !string.isEmpty()) {
            this.embeddedFonts.put(string, prismFontFileArray[0]);
            this.storeInMap(string, prismFontFileArray[0]);
        }
        for (n2 = 0; n2 < prismFontFileArray.length; ++n2) {
            prismFontFile = prismFontFileArray[n2];
            object = prismFontFile.getFamilyName();
            string2 = prismFontFile.getFullName();
            this.removeEmbeddedFont(string2);
            this.embeddedFonts.put(string2, prismFontFile);
            this.storeInMap(string2, prismFontFile);
            object = (String)object + this.dotStyleStr(prismFontFile.isBold(), prismFontFile.isItalic());
            this.storeInMap((String)object, prismFontFile);
            this.compResourceMap.remove(((String)object).toLowerCase());
        }
        return prismFontFileArray;
    }

    private void logFontInfo(String iterator, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        System.err.println((String)((Object)iterator));
        for (String string : hashMap.keySet()) {
            System.err.println("font=" + string + " file=" + hashMap.get(string));
        }
        for (String string : hashMap2.keySet()) {
            System.err.println("font=" + string + " family=" + hashMap2.get(string));
        }
        for (String string : hashMap3.keySet()) {
            System.err.println("family=" + string + " fonts=" + String.valueOf(hashMap3.get(string)));
        }
    }

    private synchronized HashMap<String, String> getFullNameToFileMap() {
        if (this.fontToFileMap == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(100);
            this.fontToFamilyNameMap = new HashMap(100);
            this.familyToFontListMap = new HashMap(50);
            this.fileToFontMap = new HashMap(100);
            if (isWindows) {
                PrismFontFactory.getPlatformFontDirs();
                PrismFontFactory.populateFontFileNameMap(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
                if (debugFonts) {
                    System.err.println("Windows Locale ID=" + PrismFontFactory.getSystemLCID());
                    this.logFontInfo(" *** WINDOWS FONTS BEFORE RESOLVING", hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
                this.resolveWindowsFonts(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                if (debugFonts) {
                    this.logFontInfo(" *** WINDOWS FONTS AFTER RESOLVING", hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
            } else if (isMacOSX || isIOS) {
                MacFontFinder.populateFontFileNameMap(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
                if (debugFonts) {
                    this.logFontInfo(" *** MACOS LOCATED FONTS:", hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
            } else if (isLinux) {
                FontConfigManager.populateMaps(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.getDefault());
                if (debugFonts) {
                    this.logFontInfo(" *** FONTCONFIG LOCATED FONTS:", hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
            } else if (isAndroid) {
                AndroidFontFinder.populateFontFileNameMap(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
            } else {
                this.fontToFileMap = hashMap;
                return this.fontToFileMap;
            }
            for (String string : hashMap.keySet()) {
                String string2 = hashMap.get(string);
                this.fileToFontMap.put(string2.toLowerCase(), string);
            }
            this.fontToFileMap = hashMap;
            if (isAndroid) {
                this.populateFontFileNameMapGeneric(AndroidFontFinder.getSystemFontsDir());
            }
            this.populateFontFileNameMapGeneric(jreFontDir);
        }
        return this.fontToFileMap;
    }

    @Override
    public final boolean hasPermission() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(FXPermissions.LOAD_FONT_PERMISSION);
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    void addToMaps(PrismFontFile arrayList) {
        if (arrayList == null) {
            return;
        }
        String string = ((PrismFontFile)((Object)arrayList)).getFullName();
        String string2 = ((PrismFontFile)((Object)arrayList)).getFamilyName();
        if (string == null || string2 == null) {
            return;
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        this.fontToFileMap.put(string3, ((PrismFontFile)((Object)arrayList)).getFileName());
        this.fontToFamilyNameMap.put(string3, string2);
        arrayList = this.familyToFontListMap.get(string4);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.familyToFontListMap.put(string4, arrayList);
        }
        arrayList.add(string);
    }

    void populateFontFileNameMapGeneric(String string) {
        String[] stringArray = new File(string);
        String[] stringArray2 = null;
        try {
            stringArray2 = stringArray = AccessController.doPrivileged(() -> PrismFontFactory.lambda$populateFontFileNameMapGeneric$3((File)stringArray));
        }
        catch (Exception exception) {}
        if (stringArray2 == null) {
            return;
        }
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            try {
                String string2 = string + File.separator + stringArray2[i2];
                if (!this.registerEmbeddedFont(string2)) continue;
                int n2 = 0;
                ++n2;
                PrismFontFile prismFontFile = this.createFontResource(string2, 0);
                if (prismFontFile == null) continue;
                this.addToMaps(prismFontFile);
                while (n2 < prismFontFile.getFontCount() && (prismFontFile = this.createFontResource(string2, n2++)) != null) {
                    this.addToMaps(prismFontFile);
                }
                continue;
            }
            catch (Exception exception) {}
        }
    }

    static native int getLCDContrastWin32();

    private static native float getSystemFontSizeNative();

    private static native String getSystemFontNative();

    public static float getSystemFontSize() {
        if (systemFontSize == -1.0f) {
            if (isWindows) {
                systemFontSize = PrismFontFactory.getSystemFontSizeNative();
            } else if (isMacOSX || isIOS) {
                systemFontSize = MacFontFinder.getSystemFontSize();
            } else if (isAndroid) {
                systemFontSize = AndroidFontFinder.getSystemFontSize();
            } else {
                if (isEmbedded) {
                    try {
                        int n2 = Screen.getMainScreen().getResolutionY();
                        systemFontSize = (float)n2 / 6.0f;
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                systemFontSize = 13.0f;
            }
        }
        return systemFontSize;
    }

    public static String getSystemFont(String string) {
        if (string.equals("System")) {
            if (systemFontFamily == null) {
                if (isWindows) {
                    systemFontFamily = PrismFontFactory.getSystemFontNative();
                    if (systemFontFamily == null) {
                        systemFontFamily = "Arial";
                    }
                } else if (isMacOSX || isIOS) {
                    systemFontFamily = MacFontFinder.getSystemFont();
                    if (systemFontFamily == null) {
                        systemFontFamily = "Lucida Grande";
                    }
                } else {
                    systemFontFamily = isAndroid ? AndroidFontFinder.getSystemFont() : "Lucida Sans";
                }
            }
            return systemFontFamily;
        }
        if (string.equals("SansSerif")) {
            return "Arial";
        }
        if (string.equals("Serif")) {
            return "Times New Roman";
        }
        if (monospaceFontFamily == null) {
            monospaceFontFamily = "Courier New";
        }
        return monospaceFontFamily;
    }

    static native short getSystemLCID();

    public abstract FontFallbackInfo getFallbacks(FontResource var1);

    private static /* synthetic */ String[] lambda$populateFontFileNameMapGeneric$3(File file) throws Exception {
        return file.list(PrismFontFactory$TTFilter.getInstance());
    }

    static {
        boolean bl2;
        fontSizeLimit = 80.0f;
        lcdContrast = -1.0f;
        isWindows = PlatformUtil.isWindows();
        isMacOSX = PlatformUtil.isMac();
        isLinux = PlatformUtil.isLinux();
        isIOS = PlatformUtil.isIOS();
        isAndroid = PlatformUtil.isAndroid();
        isEmbedded = PlatformUtil.isEmbedded();
        int[] nArray = new int[]{65536};
        debugFonts = bl2 = AccessController.doPrivileged(() -> {
            NativeLibLoader.loadLibrary("javafx_font");
            String string = System.getProperty("prism.debugfonts", "");
            boolean bl2 = "true".equals(string);
            jreFontDir = PrismFontFactory.getJDKFontDir();
            String string2 = System.getProperty("com.sun.javafx.fontSize");
            systemFontSize = -1.0f;
            if (string2 != null) {
                try {
                    systemFontSize = Float.parseFloat(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Cannot parse font size '" + string2 + "'");
                }
            }
            if ((string2 = System.getProperty("prism.subpixeltext", "on")).indexOf("on") != -1 || string2.indexOf("true") != -1) {
                subPixelMode = 1;
            }
            if (string2.indexOf("native") != -1) {
                subPixelMode |= 5;
            }
            if (string2.indexOf("vertical") != -1) {
                subPixelMode |= 7;
            }
            if ((string2 = System.getProperty("prism.fontSizeLimit")) != null) {
                try {
                    float f2;
                    fontSizeLimit = Float.parseFloat(string2);
                    if (f2 <= 0.0f) {
                        fontSizeLimit = Float.POSITIVE_INFINITY;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Cannot parse fontSizeLimit '" + string2 + "'");
                }
            }
            boolean bl3 = isMacOSX || isIOS || isAndroid || isEmbedded;
            String string3 = bl3 ? "false" : "true";
            string3 = System.getProperty("prism.lcdtext", string3);
            lcdEnabled = string3.equals("true");
            string3 = System.getProperty("prism.cacheLayoutSize");
            if (string3 != null) {
                try {
                    nArray[0] = Integer.parseInt(string3);
                    if (nArray[0] < 0) {
                        nArray[0] = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Cannot parse cache layout size '" + string3 + "'");
                }
            }
            return bl2;
        }).booleanValue();
        cacheLayoutSize = nArray[0];
        theFontFactory = null;
        STR_ARRAY = new String[0];
        sysFontDir = null;
        userFontDir = null;
        fileCloser = null;
        systemFontFamily = null;
        monospaceFontFamily = null;
    }
}

