/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.freetype.FTDisposer;
import com.sun.javafx.font.freetype.FTFactory;
import com.sun.javafx.font.freetype.FTFontStrike;
import com.sun.javafx.font.freetype.FTGlyph;
import com.sun.javafx.font.freetype.FT_Bitmap;
import com.sun.javafx.font.freetype.FT_GlyphSlotRec;
import com.sun.javafx.font.freetype.FT_Glyph_Metrics;
import com.sun.javafx.font.freetype.FT_Matrix;
import com.sun.javafx.font.freetype.OSFreetype;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;

class FTFontFile
extends PrismFontFile {
    private long library;
    private long face;
    private FTDisposer disposer;

    FTFontFile(String string, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws Exception {
        super(string, string2, n2, bl2, bl3, bl4, bl5);
        this.init();
    }

    private synchronized void init() throws Exception {
        long[] lArray = new long[1];
        int n2 = OSFreetype.FT_Init_FreeType(lArray);
        if (n2 != 0) {
            throw new Exception("FT_Init_FreeType Failed error " + n2);
        }
        this.library = lArray[0];
        if (FTFactory.LCD_SUPPORT) {
            OSFreetype.FT_Library_SetLcdFilter(this.library, 1);
        }
        String string = this.getFileName();
        int n3 = this.getFontIndex();
        byte[] byArray = (string + "\u0000").getBytes();
        int n4 = OSFreetype.FT_New_Face(this.library, byArray, n3, lArray);
        if (n4 != 0) {
            throw new Exception("FT_New_Face Failed error " + n4 + " Font File " + string + " Font Index " + n3);
        }
        this.face = lArray[0];
        if (!this.isRegistered()) {
            this.disposer = new FTDisposer(this.library, this.face);
            FTFontFile fTFontFile = this;
            Disposer.addRecord(fTFontFile, fTFontFile.disposer);
        }
    }

    @Override
    protected PrismFontStrike<?> createStrike(float f2, BaseTransform baseTransform, int n2, FontStrikeDesc fontStrikeDesc) {
        return new FTFontStrike(this, f2, baseTransform, n2, fontStrikeDesc);
    }

    @Override
    protected synchronized int[] createGlyphBoundingBox(int n2) {
        OSFreetype.FT_Load_Glyph(this.face, n2, 1);
        int[] nArray = new int[4];
        Object object = OSFreetype.getGlyphSlot(this.face);
        if (object != null && ((FT_GlyphSlotRec)object).metrics != null) {
            object = ((FT_GlyphSlotRec)object).metrics;
            nArray[0] = (int)((FT_Glyph_Metrics)object).horiBearingX;
            nArray[1] = (int)(((FT_Glyph_Metrics)object).horiBearingY - ((FT_Glyph_Metrics)object).height);
            nArray[2] = (int)(((FT_Glyph_Metrics)object).horiBearingX + ((FT_Glyph_Metrics)object).width);
            nArray[3] = (int)((FT_Glyph_Metrics)object).horiBearingY;
        }
        return nArray;
    }

    synchronized Path2D createGlyphOutline(int n2, float f2) {
        int n3 = (int)(f2 * 64.0f);
        OSFreetype.FT_Set_Char_Size(this.face, 0L, n3, 72, 72);
        OSFreetype.FT_Load_Glyph(this.face, n2, 2058);
        return OSFreetype.FT_Outline_Decompose(this.face);
    }

    synchronized void initGlyph(FTGlyph fTGlyph, FTFontStrike object) {
        byte[] byArray;
        float f2 = ((PrismFontStrike)object).getSize();
        if (f2 == 0.0f) {
            fTGlyph.buffer = new byte[0];
            fTGlyph.bitmap = new FT_Bitmap();
            return;
        }
        int n2 = (int)(f2 * 64.0f);
        OSFreetype.FT_Set_Char_Size(this.face, 0L, n2, 72, 72);
        n2 = ((PrismFontStrike)object).getAAMode() == 1 && FTFactory.LCD_SUPPORT ? 1 : 0;
        int n3 = 14;
        object = ((FTFontStrike)object).matrix;
        if (object != null) {
            OSFreetype.FT_Set_Transform(this.face, (FT_Matrix)object, 0L, 0L);
        } else {
            n3 = 2062;
        }
        if (n2 != 0) {
            n3 |= 0x30000;
        }
        int n4 = fTGlyph.getGlyphCode();
        int n5 = OSFreetype.FT_Load_Glyph(this.face, n4, n3);
        if (n5 != 0) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("FT_Load_Glyph failed " + n5 + " glyph code " + n4 + " load falgs " + n3);
            }
            return;
        }
        FT_GlyphSlotRec fT_GlyphSlotRec = OSFreetype.getGlyphSlot(this.face);
        if (fT_GlyphSlotRec == null) {
            return;
        }
        FT_Bitmap fT_Bitmap = fT_GlyphSlotRec.bitmap;
        if (fT_Bitmap == null) {
            return;
        }
        int n6 = fT_Bitmap.pixel_mode;
        int n7 = fT_Bitmap.width;
        int n8 = fT_Bitmap.rows;
        int n9 = fT_Bitmap.pitch;
        if (n6 != 2 && n6 != 5) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("Unexpected pixel mode: " + n6 + " glyph code " + n4 + " load falgs " + n3);
            }
            return;
        }
        if (n7 != 0 && n8 != 0) {
            byArray = OSFreetype.getBitmapData(this.face);
            if (byArray != null && n9 != n7) {
                byte[] byArray2 = new byte[n7 * n8];
                n6 = 0;
                int n10 = 0;
                for (int i2 = 0; i2 < n8; ++i2) {
                    for (int i3 = 0; i3 < n7; ++i3) {
                        byArray2[n10 + i3] = byArray[n6 + i3];
                    }
                    n10 += n7;
                    n6 += n9;
                }
                byArray = byArray2;
            }
        } else {
            byArray = new byte[]{};
        }
        fTGlyph.buffer = byArray;
        fTGlyph.bitmap = fT_Bitmap;
        fTGlyph.bitmap_left = fT_GlyphSlotRec.bitmap_left;
        fTGlyph.bitmap_top = fT_GlyphSlotRec.bitmap_top;
        fTGlyph.advanceX = (float)fT_GlyphSlotRec.advance_x / 64.0f;
        fTGlyph.advanceY = (float)fT_GlyphSlotRec.advance_y / 64.0f;
        fTGlyph.userAdvance = (float)fT_GlyphSlotRec.linearHoriAdvance / 65536.0f;
        fTGlyph.lcd = n2;
    }
}

