/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.EllipseIterator;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RectangularShape;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;

public class Ellipse2D
extends RectangularShape {
    public float x;
    public float y;
    public float width;
    public float height;

    public Ellipse2D() {
    }

    public Ellipse2D(float f2, float f3, float f4, float f5) {
        ((RectangularShape)this).setFrame(f2, f3, f4, f5);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    @Override
    public void setFrame(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.width = f4;
        this.height = f5;
    }

    @Override
    public RectBounds getBounds() {
        return new RectBounds(this.x, this.y, this.x + this.width, this.y + this.height);
    }

    @Override
    public boolean contains(float f2, float f3) {
        float f4;
        float f5;
        float f6 = this.width;
        if (f5 <= 0.0f) {
            return false;
        }
        f2 = (f2 - this.x) / f6 - 0.5f;
        f6 = this.height;
        if (f4 <= 0.0f) {
            return false;
        }
        f3 = (f3 - this.y) / f6 - 0.5f;
        float f7 = f2;
        float f8 = f3;
        return f7 * f7 + f8 * f8 < 0.25f;
    }

    @Override
    public boolean intersects(float f2, float f3, float f4, float f5) {
        float f6;
        float f7;
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return false;
        }
        float f8 = this.width;
        if (f7 <= 0.0f) {
            return false;
        }
        f2 = (f2 - this.x) / f8 - 0.5f;
        f4 = f2 + f4 / f8;
        f8 = this.height;
        if (f6 <= 0.0f) {
            return false;
        }
        f3 = (f3 - this.y) / f8 - 0.5f;
        f5 = f3 + f5 / f8;
        if (!(f2 > 0.0f)) {
            f2 = f4 < 0.0f ? f4 : 0.0f;
        }
        if (!(f3 > 0.0f)) {
            f3 = f5 < 0.0f ? f5 : 0.0f;
        }
        float f9 = f2;
        float f10 = f3;
        return f9 * f9 + f10 * f10 < 0.25f;
    }

    @Override
    public boolean contains(float f2, float f3, float f4, float f5) {
        return ((Shape)this).contains(f2, f3) && ((Shape)this).contains(f2 + f4, f3) && ((Shape)this).contains(f2, f3 + f5) && ((Shape)this).contains(f2 + f4, f3 + f5);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform) {
        return new EllipseIterator(this, baseTransform);
    }

    @Override
    public Ellipse2D copy() {
        return new Ellipse2D(this.x, this.y, this.width, this.height);
    }

    public int hashCode() {
        int n2 = Float.floatToIntBits(this.x);
        n2 += Float.floatToIntBits(this.y) * 37;
        n2 += Float.floatToIntBits(this.width) * 43;
        return n2 += Float.floatToIntBits(this.height) * 47;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Ellipse2D) {
            object = (Ellipse2D)object;
            return this.x == ((Ellipse2D)object).x && this.y == ((Ellipse2D)object).y && this.width == ((Ellipse2D)object).width && this.height == ((Ellipse2D)object).height;
        }
        return false;
    }
}

