/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Crossings;
import com.sun.javafx.geom.Curve;
import com.sun.javafx.geom.RectBounds;

final class Order1
extends Curve {
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;

    public Order1(double d2, double d3, double d4, double d5, int n2) {
        super(n2);
        this.x0 = d2;
        this.y0 = d3;
        this.x1 = d4;
        this.y1 = d5;
        if (d2 < d4) {
            this.xmin = d2;
            this.xmax = d4;
            return;
        }
        this.xmin = d4;
        this.xmax = d2;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public final double getXTop() {
        return this.x0;
    }

    @Override
    public final double getYTop() {
        return this.y0;
    }

    @Override
    public final double getXBot() {
        return this.x1;
    }

    @Override
    public final double getYBot() {
        return this.y1;
    }

    @Override
    public final double getXMin() {
        return this.xmin;
    }

    @Override
    public final double getXMax() {
        return this.xmax;
    }

    @Override
    public final double getX0() {
        if (this.direction == 1) {
            return this.x0;
        }
        return this.x1;
    }

    @Override
    public final double getY0() {
        if (this.direction == 1) {
            return this.y0;
        }
        return this.y1;
    }

    @Override
    public final double getX1() {
        if (this.direction == -1) {
            return this.x0;
        }
        return this.x1;
    }

    @Override
    public final double getY1() {
        if (this.direction == -1) {
            return this.y0;
        }
        return this.y1;
    }

    @Override
    public final double XforY(double d2) {
        if (this.x0 == this.x1 || d2 <= this.y0) {
            return this.x0;
        }
        if (d2 >= this.y1) {
            return this.x1;
        }
        return this.x0 + (d2 - this.y0) * (this.x1 - this.x0) / (this.y1 - this.y0);
    }

    @Override
    public final double TforY(double d2) {
        if (d2 <= this.y0) {
            return 0.0;
        }
        if (d2 >= this.y1) {
            return 1.0;
        }
        return (d2 - this.y0) / (this.y1 - this.y0);
    }

    @Override
    public final double XforT(double d2) {
        return this.x0 + d2 * (this.x1 - this.x0);
    }

    @Override
    public final double YforT(double d2) {
        return this.y0 + d2 * (this.y1 - this.y0);
    }

    @Override
    public final double dXforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return this.x0 + d2 * (this.x1 - this.x0);
            }
            case 1: {
                return this.x1 - this.x0;
            }
        }
        return 0.0;
    }

    @Override
    public final double dYforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return this.y0 + d2 * (this.y1 - this.y0);
            }
            case 1: {
                return this.y1 - this.y0;
            }
        }
        return 0.0;
    }

    @Override
    public final double nextVertical(double d2, double d3) {
        return d3;
    }

    @Override
    public final boolean accumulateCrossings(Crossings crossings) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = crossings.getXLo();
        double d7 = crossings.getYLo();
        double d8 = crossings.getXHi();
        double d9 = crossings.getYHi();
        if (this.xmin >= d8) {
            return false;
        }
        if (this.y0 < d7) {
            if (this.y1 <= d7) {
                return false;
            }
            d5 = d7;
            d4 = ((Curve)this).XforY(d7);
        } else {
            if (this.y0 >= d9) {
                return false;
            }
            d5 = this.y0;
            d4 = this.x0;
        }
        if (this.y1 > d9) {
            d3 = d9;
            d2 = ((Curve)this).XforY(d9);
        } else {
            d3 = this.y1;
            d2 = this.x1;
        }
        if (d4 >= d8 && d2 >= d8) {
            return false;
        }
        if (d4 > d6 || d2 > d6) {
            return true;
        }
        crossings.record(d5, d3, this.direction);
        return false;
    }

    @Override
    public final void enlarge(RectBounds rectBounds) {
        rectBounds.add((float)this.x0, (float)this.y0);
        rectBounds.add((float)this.x1, (float)this.y1);
    }

    @Override
    public final Curve getSubCurve(double d2, double d3, int n2) {
        if (d2 == this.y0 && d3 == this.y1) {
            return this.getWithDirection(n2);
        }
        if (this.x0 == this.x1) {
            return new Order1(this.x0, d2, this.x1, d3, n2);
        }
        double d4 = this.x0 - this.x1;
        double d5 = this.y0 - this.y1;
        double d6 = this.x0 + (d2 - this.y0) * d4 / d5;
        double d7 = this.x0 + (d3 - this.y0) * d4 / d5;
        return new Order1(d6, d2, d7, d3, n2);
    }

    @Override
    public final Curve getReversedCurve() {
        return new Order1(this.x0, this.y0, this.x1, this.y1, -this.direction);
    }

    @Override
    public final int compareTo(Curve curve, double[] dArray) {
        double d2;
        if (!(curve instanceof Order1)) {
            return super.compareTo(curve, dArray);
        }
        curve = (Order1)curve;
        if (dArray[1] <= dArray[0]) {
            throw new InternalError("yrange already screwed up...");
        }
        dArray[1] = Math.min(Math.min(dArray[1], this.y1), ((Order1)curve).y1);
        if (dArray[1] <= dArray[0]) {
            throw new InternalError("backstepping from " + dArray[0] + " to " + dArray[1]);
        }
        if (this.xmax <= ((Order1)curve).xmin) {
            if (this.xmin == ((Order1)curve).xmax) {
                return 0;
            }
            return -1;
        }
        if (this.xmin >= ((Order1)curve).xmax) {
            return 1;
        }
        double d3 = ((Order1)curve).x1 - ((Order1)curve).x0;
        double d4 = this.y1 - this.y0;
        double d5 = this.x1 - this.x0;
        double d6 = ((Order1)curve).y1 - ((Order1)curve).y0;
        double d7 = d3 * d4 - d5 * d6;
        if (d7 != 0.0) {
            double d8;
            double d9 = (this.x0 - ((Order1)curve).x0) * d4 * d6 - this.y0 * d5 * d6 + ((Order1)curve).y0 * d3 * d4;
            d2 = d9 / d7;
            if (d8 <= dArray[0]) {
                d2 = Math.min(this.y1, ((Order1)curve).y1);
            } else {
                if (d2 < dArray[1]) {
                    dArray[1] = d2;
                }
                d2 = Math.max(this.y0, ((Order1)curve).y0);
            }
        } else {
            d2 = Math.max(this.y0, ((Order1)curve).y0);
        }
        return Order1.orderof(((Curve)this).XforY(d2), curve.XforY(d2));
    }

    @Override
    public final int getSegment(float[] fArray) {
        if (this.direction == 1) {
            fArray[0] = (float)this.x1;
            fArray[1] = (float)this.y1;
        } else {
            fArray[0] = (float)this.x0;
            fArray[1] = (float)this.y0;
        }
        return 1;
    }
}

