/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.CubicCurve2D;
import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.QuadIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;

public class QuadCurve2D
extends Shape {
    public float x1;
    public float y1;
    public float ctrlx;
    public float ctrly;
    public float x2;
    public float y2;
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    public QuadCurve2D() {
    }

    public QuadCurve2D(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.setCurve(f2, f3, f4, f5, f6, f7);
    }

    public void setCurve(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.x1 = f2;
        this.y1 = f3;
        this.ctrlx = f4;
        this.ctrly = f5;
        this.x2 = f6;
        this.y2 = f7;
    }

    @Override
    public RectBounds getBounds() {
        float f2 = Math.min(Math.min(this.x1, this.x2), this.ctrlx);
        float f3 = Math.min(Math.min(this.y1, this.y2), this.ctrly);
        float f4 = Math.max(Math.max(this.x1, this.x2), this.ctrlx);
        float f5 = Math.max(Math.max(this.y1, this.y2), this.ctrly);
        return new RectBounds(f2, f3, f4, f5);
    }

    public CubicCurve2D toCubic() {
        return new CubicCurve2D(this.x1, this.y1, (this.x1 + 2.0f * this.ctrlx) / 3.0f, (this.y1 + 2.0f * this.ctrly) / 3.0f, (2.0f * this.ctrlx + this.x2) / 3.0f, (2.0f * this.ctrly + this.y2) / 3.0f, this.x2, this.y2);
    }

    public void setCurve(float[] fArray, int n2) {
        this.setCurve(fArray[n2], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3], fArray[n2 + 4], fArray[n2 + 5]);
    }

    public void setCurve(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        this.setCurve(point2D.x, point2D.y, point2D2.x, point2D2.y, point2D3.x, point2D3.y);
    }

    public void setCurve(Point2D[] point2DArray, int n2) {
        this.setCurve(point2DArray[n2].x, point2DArray[n2].y, point2DArray[n2 + 1].x, point2DArray[n2 + 1].y, point2DArray[n2 + 2].x, point2DArray[n2 + 2].y);
    }

    public void setCurve(QuadCurve2D quadCurve2D) {
        this.setCurve(quadCurve2D.x1, quadCurve2D.y1, quadCurve2D.ctrlx, quadCurve2D.ctrly, quadCurve2D.x2, quadCurve2D.y2);
    }

    public static float getFlatnessSq(float f2, float f3, float f4, float f5, float f6, float f7) {
        return Line2D.ptSegDistSq(f2, f3, f6, f7, f4, f5);
    }

    public static float getFlatness(float f2, float f3, float f4, float f5, float f6, float f7) {
        return Line2D.ptSegDist(f2, f3, f6, f7, f4, f5);
    }

    public static float getFlatnessSq(float[] fArray, int n2) {
        return Line2D.ptSegDistSq(fArray[n2], fArray[n2 + 1], fArray[n2 + 4], fArray[n2 + 5], fArray[n2 + 2], fArray[n2 + 3]);
    }

    public static float getFlatness(float[] fArray, int n2) {
        return Line2D.ptSegDist(fArray[n2], fArray[n2 + 1], fArray[n2 + 4], fArray[n2 + 5], fArray[n2 + 2], fArray[n2 + 3]);
    }

    public float getFlatnessSq() {
        return Line2D.ptSegDistSq(this.x1, this.y1, this.x2, this.y2, this.ctrlx, this.ctrly);
    }

    public float getFlatness() {
        return Line2D.ptSegDist(this.x1, this.y1, this.x2, this.y2, this.ctrlx, this.ctrly);
    }

    public void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2) {
        QuadCurve2D.subdivide(this, quadCurve2D, quadCurve2D2);
    }

    public static void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2, QuadCurve2D quadCurve2D3) {
        float f2 = quadCurve2D.x1;
        float f3 = quadCurve2D.y1;
        float f4 = quadCurve2D.ctrlx;
        float f5 = quadCurve2D.ctrly;
        float f6 = quadCurve2D.x2;
        float f7 = quadCurve2D.y2;
        float f8 = (f2 + f4) / 2.0f;
        float f9 = (f3 + f5) / 2.0f;
        float f10 = (f6 + f4) / 2.0f;
        float f11 = (f7 + f5) / 2.0f;
        f4 = (f8 + f10) / 2.0f;
        f5 = (f9 + f11) / 2.0f;
        if (quadCurve2D2 != null) {
            quadCurve2D2.setCurve(f2, f3, f8, f9, f4, f5);
        }
        if (quadCurve2D3 != null) {
            quadCurve2D3.setCurve(f4, f5, f10, f11, f6, f7);
        }
    }

    public static void subdivide(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        float f2 = fArray[n2];
        float f3 = fArray[n2 + 1];
        float f4 = fArray[n2 + 2];
        float f5 = fArray[n2 + 3];
        float f6 = fArray[n2 + 4];
        float f7 = fArray[n2 + 5];
        if (fArray2 != null) {
            fArray2[n3] = f2;
            fArray2[n3 + 1] = f3;
        }
        if (fArray3 != null) {
            fArray3[n4 + 4] = f6;
            fArray3[n4 + 5] = f7;
        }
        f2 = (f2 + f4) / 2.0f;
        f3 = (f3 + f5) / 2.0f;
        f6 = (f6 + f4) / 2.0f;
        f7 = (f7 + f5) / 2.0f;
        f4 = (f2 + f6) / 2.0f;
        f5 = (f3 + f7) / 2.0f;
        if (fArray2 != null) {
            fArray2[n3 + 2] = f2;
            fArray2[n3 + 3] = f3;
            fArray2[n3 + 4] = f4;
            fArray2[n3 + 5] = f5;
        }
        if (fArray3 != null) {
            fArray3[n4] = f4;
            fArray3[n4 + 1] = f5;
            fArray3[n4 + 2] = f6;
            fArray3[n4 + 3] = f7;
        }
    }

    public static int solveQuadratic(float[] fArray) {
        return QuadCurve2D.solveQuadratic(fArray, fArray);
    }

    public static int solveQuadratic(float[] fArray, float[] fArray2) {
        float f2 = fArray[2];
        float f3 = fArray[1];
        float f4 = fArray[0];
        int n2 = 0;
        if (f2 == 0.0f) {
            if (f3 == 0.0f) {
                return -1;
            }
            ++n2;
            fArray2[0] = -f4 / f3;
        } else {
            float f5;
            float f6 = f3;
            float f7 = f6 * f6 - 4.0f * f2 * f4;
            if (f5 < 0.0f) {
                return 0;
            }
            f7 = (float)Math.sqrt(f7);
            if (f3 < 0.0f) {
                f7 = -f7;
            }
            f3 = (f3 + f7) / -2.0f;
            ++n2;
            fArray2[0] = f3 / f2;
            if (f3 != 0.0f) {
                ++n2;
                fArray2[1] = f4 / f3;
            }
        }
        return n2;
    }

    @Override
    public boolean contains(float f2, float f3) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        block3: {
            block2: {
                f12 = this.x1;
                f11 = this.y1;
                f10 = this.ctrlx;
                f9 = this.ctrly;
                f8 = this.x2;
                f7 = this.y2;
                f6 = f12 - f10 * 2.0f + f8;
                f5 = f11 - f9 * 2.0f + f7;
                f4 = f2 - f12;
                float f13 = f3 - f11;
                if ((f4 = (f4 * f5 - f13 * f6) / ((f8 -= f12) * f5 - (f7 -= f11) * f6)) < 0.0f || f4 > 1.0f) break block2;
                float f14 = f4;
                if (f14 == f14) break block3;
            }
            return false;
        }
        f10 = f6 * f4 * f4 + 2.0f * (f10 - f12) * f4 + f12;
        f9 = f5 * f4 * f4 + 2.0f * (f9 - f11) * f4 + f11;
        f12 = f8 * f4 + f12;
        f11 = f7 * f4 + f11;
        return f2 >= f10 && f2 < f12 || f2 >= f12 && f2 < f10 || f3 >= f9 && f3 < f11 || f3 >= f11 && f3 < f9;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return ((Shape)this).contains(point2D.x, point2D.y);
    }

    private static void fillEqn(float[] fArray, float f2, float f3, float f4, float f5) {
        fArray[0] = f3 - f2;
        float f6 = f4;
        fArray[1] = f6 + f6 - f3 - f3;
        fArray[2] = f3 - f4 - f4 + f5;
    }

    private static int evalQuadratic(float[] fArray, int n2, boolean bl2, boolean bl3, float[] fArray2, float f2, float f3, float f4) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f5 = fArray[i2];
            if (!(bl2 ? f5 >= 0.0f : f5 > 0.0f) || !(bl3 ? f5 <= 1.0f : f5 < 1.0f) || fArray2 != null && fArray2[1] + 2.0f * fArray2[2] * f5 == 0.0f) continue;
            float f6 = 1.0f - f5;
            fArray[n3++] = f2 * f6 * f6 + f3 * 2.0f * f5 * f6 + f4 * f5 * f5;
        }
        return n3;
    }

    private static int getTag(float f2, float f3, float f4) {
        if (f2 <= f3) {
            if (f2 < f3) {
                return -2;
            }
            return -1;
        }
        if (f2 >= f4) {
            if (f2 > f4) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static boolean inwards(int n2, int n3, int n4) {
        switch (n2) {
            default: {
                return false;
            }
            case -1: {
                return n3 >= 0 || n4 >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return n3 <= 0 || n4 <= 0;
    }

    @Override
    public boolean intersects(float f2, float f3, float f4, float f5) {
        int n2;
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return false;
        }
        float f6 = this.x1;
        float f7 = this.y1;
        float f8 = f2;
        int n3 = QuadCurve2D.getTag(f6, f8, f8 + f4);
        float f9 = f3;
        int n4 = QuadCurve2D.getTag(f7, f9, f9 + f5);
        if (n3 == 0 && n4 == 0) {
            return true;
        }
        float f10 = this.x2;
        float f11 = this.y2;
        float f12 = f2;
        int n5 = QuadCurve2D.getTag(f10, f12, f12 + f4);
        float f13 = f3;
        int n6 = QuadCurve2D.getTag(f11, f13, f13 + f5);
        if (n5 == 0 && n6 == 0) {
            return true;
        }
        float f14 = this.ctrlx;
        float f15 = this.ctrly;
        float f16 = f2;
        int n7 = QuadCurve2D.getTag(f14, f16, f16 + f4);
        float f17 = f3;
        int n8 = QuadCurve2D.getTag(f15, f17, f17 + f5);
        if (n3 < 0 && n5 < 0 && n7 < 0) {
            return false;
        }
        if (n4 < 0 && n6 < 0 && n8 < 0) {
            return false;
        }
        if (n3 > 0 && n5 > 0 && n7 > 0) {
            return false;
        }
        if (n4 > 0 && n6 > 0 && n8 > 0) {
            return false;
        }
        if (QuadCurve2D.inwards(n3, n5, n7) && QuadCurve2D.inwards(n4, n6, n8)) {
            return true;
        }
        if (QuadCurve2D.inwards(n5, n3, n7) && QuadCurve2D.inwards(n6, n4, n8)) {
            return true;
        }
        n7 = n3 * n5 <= 0 ? 1 : 0;
        int n9 = n8 = n4 * n6 <= 0 ? 1 : 0;
        if (n3 == 0 && n5 == 0 && n8 != 0) {
            return true;
        }
        if (n4 == 0 && n6 == 0 && n7 != 0) {
            return true;
        }
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        if (n8 == 0) {
            QuadCurve2D.fillEqn(fArray, n4 < 0 ? f3 : f3 + f5, f7, f15, f11);
            if (QuadCurve2D.solveQuadratic(fArray, fArray2) == 2 && QuadCurve2D.evalQuadratic(fArray2, 2, true, true, null, f6, f14, f10) == 2) {
                float f18 = f2;
                float f19 = f2;
                if (QuadCurve2D.getTag(fArray2[0], f18, f18 + f4) * QuadCurve2D.getTag(fArray2[1], f19, f19 + f4) <= 0) {
                    return true;
                }
            }
            return false;
        }
        if (n7 == 0) {
            QuadCurve2D.fillEqn(fArray, n3 < 0 ? f2 : f2 + f4, f6, f14, f10);
            if (QuadCurve2D.solveQuadratic(fArray, fArray2) == 2 && QuadCurve2D.evalQuadratic(fArray2, 2, true, true, null, f7, f15, f11) == 2) {
                float f20 = f3;
                float f21 = f3;
                if (QuadCurve2D.getTag(fArray2[0], f20, f20 + f5) * QuadCurve2D.getTag(fArray2[1], f21, f21 + f5) <= 0) {
                    return true;
                }
            }
            return false;
        }
        float f22 = f10 - f6;
        float f23 = f11 - f7;
        float f24 = f11 * f6 - f10 * f7;
        if (n4 == 0) {
            n2 = n3;
        } else {
            float f25 = f2;
            n2 = QuadCurve2D.getTag((f24 + f22 * (n4 < 0 ? f3 : f3 + f5)) / f23, f25, f25 + f4);
        }
        if (n6 != 0) {
            float f26 = f2;
            n5 = QuadCurve2D.getTag((f24 + f22 * (n6 < 0 ? f3 : f3 + f5)) / f23, f26, f26 + f4);
        }
        if (n2 * n5 <= 0) {
            return true;
        }
        n2 = n2 * n3 <= 0 ? n4 : n6;
        QuadCurve2D.fillEqn(fArray, n5 < 0 ? f2 : f2 + f4, f6, f14, f10);
        int n10 = QuadCurve2D.solveQuadratic(fArray, fArray2);
        QuadCurve2D.evalQuadratic(fArray2, n10, true, true, null, f7, f15, f11);
        float f27 = f3;
        n5 = QuadCurve2D.getTag(fArray2[0], f27, f27 + f5);
        return n2 * n5 <= 0;
    }

    @Override
    public boolean contains(float f2, float f3, float f4, float f5) {
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return false;
        }
        return ((Shape)this).contains(f2, f3) && ((Shape)this).contains(f2 + f4, f3) && ((Shape)this).contains(f2 + f4, f3 + f5) && ((Shape)this).contains(f2, f3 + f5);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform) {
        return new QuadIterator(this, baseTransform);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform, float f2) {
        return new FlatteningPathIterator(((Shape)this).getPathIterator(baseTransform), f2);
    }

    @Override
    public QuadCurve2D copy() {
        return new QuadCurve2D(this.x1, this.y1, this.ctrlx, this.ctrly, this.x2, this.y2);
    }

    public int hashCode() {
        int n2 = Float.floatToIntBits(this.x1);
        n2 += Float.floatToIntBits(this.y1) * 37;
        n2 += Float.floatToIntBits(this.x2) * 43;
        n2 += Float.floatToIntBits(this.y2) * 47;
        n2 += Float.floatToIntBits(this.ctrlx) * 53;
        return n2 += Float.floatToIntBits(this.ctrly) * 59;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof QuadCurve2D) {
            object = (QuadCurve2D)object;
            return this.x1 == ((QuadCurve2D)object).x1 && this.y1 == ((QuadCurve2D)object).y1 && this.x2 == ((QuadCurve2D)object).x2 && this.y2 == ((QuadCurve2D)object).y2 && this.ctrlx == ((QuadCurve2D)object).ctrlx && this.ctrly == ((QuadCurve2D)object).ctrly;
        }
        return false;
    }
}

