/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BaseBounds$BoundsType;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec2f;
import com.sun.javafx.geom.Vec3f;

public final class RectBounds
extends BaseBounds {
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;

    public RectBounds() {
        RectBounds rectBounds = this;
        rectBounds.minY = 0.0f;
        rectBounds.minX = 0.0f;
        RectBounds rectBounds2 = this;
        rectBounds2.maxY = -1.0f;
        rectBounds2.maxX = -1.0f;
    }

    @Override
    public final BaseBounds copy() {
        return new RectBounds(this.minX, this.minY, this.maxX, this.maxY);
    }

    public RectBounds(float f2, float f3, float f4, float f5) {
        this.setBounds(f2, f3, f4, f5);
    }

    public RectBounds(RectBounds rectBounds) {
        this.setBounds(rectBounds);
    }

    public RectBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    @Override
    public final BaseBounds$BoundsType getBoundsType() {
        return BaseBounds$BoundsType.RECTANGLE;
    }

    @Override
    public final boolean is2D() {
        return true;
    }

    @Override
    public final float getWidth() {
        return this.maxX - this.minX;
    }

    @Override
    public final float getHeight() {
        return this.maxY - this.minY;
    }

    @Override
    public final float getDepth() {
        return 0.0f;
    }

    @Override
    public final float getMinX() {
        return this.minX;
    }

    public final void setMinX(float f2) {
        this.minX = f2;
    }

    @Override
    public final float getMinY() {
        return this.minY;
    }

    public final void setMinY(float f2) {
        this.minY = f2;
    }

    @Override
    public final float getMinZ() {
        return 0.0f;
    }

    @Override
    public final float getMaxX() {
        return this.maxX;
    }

    public final void setMaxX(float f2) {
        this.maxX = f2;
    }

    @Override
    public final float getMaxY() {
        return this.maxY;
    }

    public final void setMaxY(float f2) {
        this.maxY = f2;
    }

    @Override
    public final float getMaxZ() {
        return 0.0f;
    }

    @Override
    public final Vec2f getMin(Vec2f vec2f) {
        if (vec2f == null) {
            vec2f = new Vec2f();
        }
        vec2f.x = this.minX;
        vec2f.y = this.minY;
        return vec2f;
    }

    @Override
    public final Vec2f getMax(Vec2f vec2f) {
        if (vec2f == null) {
            vec2f = new Vec2f();
        }
        vec2f.x = this.maxX;
        vec2f.y = this.maxY;
        return vec2f;
    }

    @Override
    public final Vec3f getMin(Vec3f vec3f) {
        if (vec3f == null) {
            vec3f = new Vec3f();
        }
        vec3f.x = this.minX;
        vec3f.y = this.minY;
        vec3f.z = 0.0f;
        return vec3f;
    }

    @Override
    public final Vec3f getMax(Vec3f vec3f) {
        if (vec3f == null) {
            vec3f = new Vec3f();
        }
        vec3f.x = this.maxX;
        vec3f.y = this.maxY;
        vec3f.z = 0.0f;
        return vec3f;
    }

    @Override
    public final BaseBounds deriveWithUnion(BaseBounds baseBounds) {
        if (baseBounds.getBoundsType() != BaseBounds$BoundsType.RECTANGLE) {
            if (baseBounds.getBoundsType() == BaseBounds$BoundsType.BOX) {
                baseBounds = new BoxBounds((BoxBounds)baseBounds);
                ((BoxBounds)baseBounds).unionWith(this);
                return baseBounds;
            }
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        baseBounds = (RectBounds)baseBounds;
        this.unionWith((RectBounds)baseBounds);
        return this;
    }

    @Override
    public final BaseBounds deriveWithNewBounds(Rectangle rectangle) {
        if (rectangle.width < 0 || rectangle.height < 0) {
            return this.makeEmpty();
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        return this;
    }

    @Override
    public final BaseBounds deriveWithNewBounds(BaseBounds baseBounds) {
        if (baseBounds.isEmpty()) {
            return this.makeEmpty();
        }
        if (baseBounds.getBoundsType() != BaseBounds$BoundsType.RECTANGLE) {
            if (baseBounds.getBoundsType() == BaseBounds$BoundsType.BOX) {
                return new BoxBounds((BoxBounds)baseBounds);
            }
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        baseBounds = (RectBounds)baseBounds;
        this.minX = baseBounds.getMinX();
        this.minY = baseBounds.getMinY();
        this.maxX = baseBounds.getMaxX();
        this.maxY = baseBounds.getMaxY();
        return this;
    }

    @Override
    public final BaseBounds deriveWithNewBounds(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f5 < f2 || f6 < f3 || f7 < f4) {
            return this.makeEmpty();
        }
        if (f4 == 0.0f && f7 == 0.0f) {
            this.minX = f2;
            this.minY = f3;
            this.maxX = f5;
            this.maxY = f6;
            return this;
        }
        return new BoxBounds(f2, f3, f4, f5, f6, f7);
    }

    @Override
    public final BaseBounds deriveWithNewBoundsAndSort(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f4 == 0.0f && f7 == 0.0f) {
            ((BaseBounds)this).setBoundsAndSort(f2, f3, f4, f5, f6, f7);
            return this;
        }
        BoxBounds boxBounds = new BoxBounds();
        ((BaseBounds)boxBounds).setBoundsAndSort(f2, f3, f4, f5, f6, f7);
        return boxBounds;
    }

    public final void setBounds(RectBounds rectBounds) {
        this.minX = ((BaseBounds)rectBounds).getMinX();
        this.minY = ((BaseBounds)rectBounds).getMinY();
        this.maxX = ((BaseBounds)rectBounds).getMaxX();
        this.maxY = ((BaseBounds)rectBounds).getMaxY();
    }

    public final void setBounds(float f2, float f3, float f4, float f5) {
        this.minX = f2;
        this.minY = f3;
        this.maxX = f4;
        this.maxY = f5;
    }

    public final void setBoundsAndSort(float f2, float f3, float f4, float f5) {
        this.setBounds(f2, f3, f4, f5);
        this.sortMinMax();
    }

    @Override
    public final void setBoundsAndSort(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f4 != 0.0f || f7 != 0.0f) {
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        this.setBounds(f2, f3, f5, f6);
        this.sortMinMax();
    }

    @Override
    public final void setBoundsAndSort(Point2D point2D, Point2D point2D2) {
        this.setBoundsAndSort(point2D.x, point2D.y, point2D2.x, point2D2.y);
    }

    @Override
    public final RectBounds flattenInto(RectBounds rectBounds) {
        if (rectBounds == null) {
            rectBounds = new RectBounds();
        }
        if (((BaseBounds)this).isEmpty()) {
            return rectBounds.makeEmpty();
        }
        rectBounds.setBounds(this.minX, this.minY, this.maxX, this.maxY);
        return rectBounds;
    }

    public final void unionWith(RectBounds rectBounds) {
        if (((BaseBounds)rectBounds).isEmpty()) {
            return;
        }
        if (((BaseBounds)this).isEmpty()) {
            this.setBounds(rectBounds);
            return;
        }
        this.minX = Math.min(this.minX, ((BaseBounds)rectBounds).getMinX());
        this.minY = Math.min(this.minY, ((BaseBounds)rectBounds).getMinY());
        this.maxX = Math.max(this.maxX, ((BaseBounds)rectBounds).getMaxX());
        this.maxY = Math.max(this.maxY, ((BaseBounds)rectBounds).getMaxY());
    }

    public final void unionWith(float f2, float f3, float f4, float f5) {
        if (f4 < f2 || f5 < f3) {
            return;
        }
        if (((BaseBounds)this).isEmpty()) {
            this.setBounds(f2, f3, f4, f5);
            return;
        }
        this.minX = Math.min(this.minX, f2);
        this.minY = Math.min(this.minY, f3);
        this.maxX = Math.max(this.maxX, f4);
        this.maxY = Math.max(this.maxY, f5);
    }

    @Override
    public final void add(float f2, float f3, float f4) {
        if (f4 != 0.0f) {
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        this.unionWith(f2, f3, f2, f3);
    }

    public final void add(float f2, float f3) {
        this.unionWith(f2, f3, f2, f3);
    }

    @Override
    public final void add(Point2D point2D) {
        this.add(point2D.x, point2D.y);
    }

    @Override
    public final void intersectWith(BaseBounds baseBounds) {
        if (((BaseBounds)this).isEmpty()) {
            return;
        }
        if (baseBounds.isEmpty()) {
            this.makeEmpty();
            return;
        }
        this.minX = Math.max(this.minX, baseBounds.getMinX());
        this.minY = Math.max(this.minY, baseBounds.getMinY());
        this.maxX = Math.min(this.maxX, baseBounds.getMaxX());
        this.maxY = Math.min(this.maxY, baseBounds.getMaxY());
    }

    @Override
    public final void intersectWith(Rectangle rectangle) {
        float f2 = rectangle.x;
        float f3 = rectangle.y;
        this.intersectWith(f2, f3, f2 + (float)rectangle.width, f3 + (float)rectangle.height);
    }

    public final void intersectWith(float f2, float f3, float f4, float f5) {
        if (((BaseBounds)this).isEmpty()) {
            return;
        }
        if (f4 < f2 || f5 < f3) {
            this.makeEmpty();
            return;
        }
        this.minX = Math.max(this.minX, f2);
        this.minY = Math.max(this.minY, f3);
        this.maxX = Math.min(this.maxX, f4);
        this.maxY = Math.min(this.maxY, f5);
    }

    @Override
    public final void intersectWith(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (((BaseBounds)this).isEmpty()) {
            return;
        }
        if (f5 < f2 || f6 < f3 || f7 < f4) {
            this.makeEmpty();
            return;
        }
        this.minX = Math.max(this.minX, f2);
        this.minY = Math.max(this.minY, f3);
        this.maxX = Math.min(this.maxX, f5);
        this.maxY = Math.min(this.maxY, f6);
    }

    @Override
    public final boolean contains(Point2D point2D) {
        if (point2D == null || ((BaseBounds)this).isEmpty()) {
            return false;
        }
        return point2D.x >= this.minX && point2D.x <= this.maxX && point2D.y >= this.minY && point2D.y <= this.maxY;
    }

    @Override
    public final boolean contains(float f2, float f3) {
        if (((BaseBounds)this).isEmpty()) {
            return false;
        }
        return f2 >= this.minX && f2 <= this.maxX && f3 >= this.minY && f3 <= this.maxY;
    }

    public final boolean contains(RectBounds rectBounds) {
        if (((BaseBounds)this).isEmpty() || ((BaseBounds)rectBounds).isEmpty()) {
            return false;
        }
        return this.minX <= rectBounds.minX && this.maxX >= rectBounds.maxX && this.minY <= rectBounds.minY && this.maxY >= rectBounds.maxY;
    }

    @Override
    public final boolean intersects(float f2, float f3, float f4, float f5) {
        if (((BaseBounds)this).isEmpty()) {
            return false;
        }
        return f2 + f4 >= this.minX && f3 + f5 >= this.minY && f2 <= this.maxX && f3 <= this.maxY;
    }

    public final boolean intersects(BaseBounds baseBounds) {
        if (baseBounds == null || baseBounds.isEmpty() || ((BaseBounds)this).isEmpty()) {
            return false;
        }
        return baseBounds.getMaxX() >= this.minX && baseBounds.getMaxY() >= this.minY && baseBounds.getMaxZ() >= ((BaseBounds)this).getMinZ() && baseBounds.getMinX() <= this.maxX && baseBounds.getMinY() <= this.maxY && baseBounds.getMinZ() <= ((BaseBounds)this).getMaxZ();
    }

    @Override
    public final boolean disjoint(float f2, float f3, float f4, float f5) {
        if (((BaseBounds)this).isEmpty()) {
            return true;
        }
        return f2 + f4 < this.minX || f3 + f5 < this.minY || f2 > this.maxX || f3 > this.maxY;
    }

    public final boolean disjoint(RectBounds rectBounds) {
        if (rectBounds == null || ((BaseBounds)rectBounds).isEmpty() || ((BaseBounds)this).isEmpty()) {
            return true;
        }
        return ((BaseBounds)rectBounds).getMaxX() < this.minX || ((BaseBounds)rectBounds).getMaxY() < this.minY || ((BaseBounds)rectBounds).getMinX() > this.maxX || ((BaseBounds)rectBounds).getMinY() > this.maxY;
    }

    @Override
    public final boolean isEmpty() {
        return !(this.maxX >= this.minX) || !(this.maxY >= this.minY);
    }

    @Override
    public final void roundOut() {
        this.minX = (float)Math.floor(this.minX);
        this.minY = (float)Math.floor(this.minY);
        this.maxX = (float)Math.ceil(this.maxX);
        this.maxY = (float)Math.ceil(this.maxY);
    }

    public final void grow(float f2, float f3) {
        this.minX -= f2;
        this.maxX += f2;
        this.minY -= f3;
        this.maxY += f3;
    }

    @Override
    public final BaseBounds deriveWithPadding(float f2, float f3, float f4) {
        if (f4 == 0.0f) {
            this.grow(f2, f3);
            return this;
        }
        BoxBounds boxBounds = new BoxBounds(this.minX, this.minY, 0.0f, this.maxX, this.maxY, 0.0f);
        boxBounds.grow(f2, f3, f4);
        return boxBounds;
    }

    @Override
    public final RectBounds makeEmpty() {
        RectBounds rectBounds = this;
        rectBounds.minY = 0.0f;
        rectBounds.minX = 0.0f;
        RectBounds rectBounds2 = this;
        rectBounds2.maxY = -1.0f;
        rectBounds2.maxX = -1.0f;
        return this;
    }

    @Override
    protected final void sortMinMax() {
        float f2;
        if (this.minX > this.maxX) {
            f2 = this.maxX;
            this.maxX = this.minX;
            this.minX = f2;
        }
        if (this.minY > this.maxY) {
            f2 = this.maxY;
            this.maxY = this.minY;
            this.minY = f2;
        }
    }

    @Override
    public final void translate(float f2, float f3, float f4) {
        RectBounds rectBounds = this;
        rectBounds.setMinX(((BaseBounds)rectBounds).getMinX() + f2);
        RectBounds rectBounds2 = this;
        rectBounds2.setMinY(((BaseBounds)rectBounds2).getMinY() + f3);
        RectBounds rectBounds3 = this;
        rectBounds3.setMaxX(((BaseBounds)rectBounds3).getMaxX() + f2);
        RectBounds rectBounds4 = this;
        rectBounds4.setMaxY(((BaseBounds)rectBounds4).getMaxY() + f3);
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.minX != ((BaseBounds)(object = (RectBounds)object)).getMinX()) {
            return false;
        }
        if (this.minY != ((BaseBounds)object).getMinY()) {
            return false;
        }
        if (this.maxX != ((BaseBounds)object).getMaxX()) {
            return false;
        }
        return this.maxY == ((BaseBounds)object).getMaxY();
    }

    public final int hashCode() {
        int n2 = 553 + Float.floatToIntBits(this.minX);
        n2 = n2 * 79 + Float.floatToIntBits(this.minY);
        n2 = n2 * 79 + Float.floatToIntBits(this.maxX);
        n2 = n2 * 79 + Float.floatToIntBits(this.maxY);
        return n2;
    }

    public final String toString() {
        return "RectBounds { minX:" + this.minX + ", minY:" + this.minY + ", maxX:" + this.maxX + ", maxY:" + this.maxY + "} (w:" + (this.maxX - this.minX) + ", h:" + (this.maxY - this.minY) + ")";
    }
}

