/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.TransformedShape$General;
import com.sun.javafx.geom.TransformedShape$Translate;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;

public abstract class TransformedShape
extends Shape {
    protected final Shape delegate;
    private Shape cachedTransformedShape;

    public static TransformedShape transformedShape(Shape shape, BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            return TransformedShape.translatedShape(shape, baseTransform.getMxt(), baseTransform.getMyt());
        }
        return new TransformedShape$General(shape, baseTransform.copy());
    }

    public static TransformedShape translatedShape(Shape shape, double d2, double d3) {
        return new TransformedShape$Translate(shape, (float)d2, (float)d3);
    }

    protected TransformedShape(Shape shape) {
        this.delegate = shape;
    }

    public Shape getDelegateNoClone() {
        return this.delegate;
    }

    public abstract BaseTransform getTransformNoClone();

    public abstract BaseTransform adjust(BaseTransform var1);

    protected Point2D untransform(float f2, float f3) {
        Point2D point2D = new Point2D(f2, f3);
        try {
            Point2D point2D2 = point2D;
            point2D = this.getTransformNoClone().inverseTransform(point2D2, point2D2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        return point2D;
    }

    protected BaseBounds untransformedBounds(float f2, float f3, float f4, float f5) {
        RectBounds rectBounds = new RectBounds(f2, f3, f2 + f4, f3 + f5);
        try {
            RectBounds rectBounds2 = rectBounds;
            return this.getTransformNoClone().inverseTransform(rectBounds2, rectBounds2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return rectBounds.makeEmpty();
        }
    }

    @Override
    public RectBounds getBounds() {
        float[] fArray = new float[4];
        Shape.accumulate(fArray, this.delegate, this.getTransformNoClone());
        return new RectBounds(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    @Override
    public boolean contains(float f2, float f3) {
        return this.delegate.contains(this.untransform(f2, f3));
    }

    private Shape getCachedTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = ((Shape)this).copy();
        }
        return this.cachedTransformedShape;
    }

    @Override
    public boolean intersects(float f2, float f3, float f4, float f5) {
        return this.getCachedTransformedShape().intersects(f2, f3, f4, f5);
    }

    @Override
    public boolean contains(float f2, float f3, float f4, float f5) {
        return this.getCachedTransformedShape().contains(f2, f3, f4, f5);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform) {
        return this.delegate.getPathIterator(this.adjust(baseTransform));
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform, float f2) {
        return this.delegate.getPathIterator(this.adjust(baseTransform), f2);
    }

    @Override
    public Shape copy() {
        return this.getTransformNoClone().createTransformedShape(this.delegate);
    }
}

