/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFormatDescription$Signature;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorage$ImageType;
import com.sun.javafx.iio.ImageStorage$InstanceHolder;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.bmp.BMPImageLoaderFactory;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFImageLoaderFactory;
import com.sun.javafx.iio.ios.IosImageLoaderFactory;
import com.sun.javafx.iio.jpeg.JPEGImageLoaderFactory;
import com.sun.javafx.iio.png.PNGImageLoaderFactory;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.util.DataURI;
import com.sun.javafx.util.Logging;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImageStorage {
    private final HashMap<ImageFormatDescription$Signature, ImageLoaderFactory> loaderFactoriesBySignature;
    private final HashMap<String, ImageLoaderFactory> loaderFactoriesByMimeSubtype;
    private final ImageLoaderFactory[] loaderFactories = isIOS ? new ImageLoaderFactory[]{IosImageLoaderFactory.getInstance()} : new ImageLoaderFactory[]{GIFImageLoaderFactory.getInstance(), JPEGImageLoaderFactory.getInstance(), PNGImageLoaderFactory.getInstance(), BMPImageLoaderFactory.getInstance()};
    private int maxSignatureLength;
    private static final boolean isIOS = PlatformUtil.isIOS();

    public static ImageStorage getInstance() {
        return ImageStorage$InstanceHolder.INSTANCE;
    }

    public ImageStorage() {
        this.loaderFactoriesBySignature = new HashMap(this.loaderFactories.length);
        this.loaderFactoriesByMimeSubtype = new HashMap(this.loaderFactories.length);
        for (int i2 = 0; i2 < this.loaderFactories.length; ++i2) {
            ImageStorage imageStorage = this;
            imageStorage.addImageLoaderFactory(imageStorage.loaderFactories[i2]);
        }
    }

    public ImageFormatDescription[] getSupportedDescriptions() {
        ImageFormatDescription[] imageFormatDescriptionArray = new ImageFormatDescription[this.loaderFactories.length];
        for (int i2 = 0; i2 < this.loaderFactories.length; ++i2) {
            imageFormatDescriptionArray[i2] = this.loaderFactories[i2].getFormatDescription();
        }
        return imageFormatDescriptionArray;
    }

    public int getNumBands(ImageStorage$ImageType imageStorage$ImageType) {
        return switch (imageStorage$ImageType) {
            case ImageStorage$ImageType.GRAY, ImageStorage$ImageType.PALETTE, ImageStorage$ImageType.PALETTE_ALPHA, ImageStorage$ImageType.PALETTE_ALPHA_PRE, ImageStorage$ImageType.PALETTE_TRANS -> 1;
            case ImageStorage$ImageType.GRAY_ALPHA, ImageStorage$ImageType.GRAY_ALPHA_PRE -> 2;
            case ImageStorage$ImageType.RGB -> 3;
            case ImageStorage$ImageType.RGBA, ImageStorage$ImageType.RGBA_PRE -> 4;
            default -> throw new IllegalArgumentException("Unknown ImageType " + String.valueOf((Object)imageStorage$ImageType));
        };
    }

    public void addImageLoaderFactory(ImageLoaderFactory imageLoaderFactory) {
        ImageFormatDescription imageFormatDescription = imageLoaderFactory.getFormatDescription();
        for (ImageFormatDescription$Signature object : imageFormatDescription.getSignatures()) {
            this.loaderFactoriesBySignature.put(object, imageLoaderFactory);
        }
        for (String string : imageFormatDescription.getMIMESubtypes()) {
            this.loaderFactoriesByMimeSubtype.put(string.toLowerCase(), imageLoaderFactory);
        }
        Class<ImageStorage> clazz = ImageStorage.class;
        synchronized (ImageStorage.class) {
            this.maxSignatureLength = -1;
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    public ImageFrame[] loadAll(InputStream imageFrameArray, ImageLoadListener imageLoadListener, double d2, double d3, boolean bl2, float f2, boolean bl3) throws ImageStorageException {
        block8: {
            ImageLoader imageLoader = null;
            try {
                imageLoader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader((InputStream)imageFrameArray) : this.getLoaderBySignature((InputStream)imageFrameArray, imageLoadListener);
                if (imageLoader != null) {
                    imageFrameArray = this.loadAll(imageLoader, d2, d3, bl2, f2, bl3);
                    break block8;
                }
                throw new ImageStorageException("No loader for image data");
            }
            catch (ImageStorageException imageStorageException) {
                imageFrameArray = imageStorageException;
                throw imageStorageException;
            }
            catch (IOException iOException) {
                throw new ImageStorageException(iOException.getMessage(), iOException);
            }
            finally {
                if (imageLoader != null) {
                    imageLoader.dispose();
                }
            }
        }
        return imageFrameArray;
    }

    public ImageFrame[] loadAll(String object, ImageLoadListener imageLoadListener, double d2, double d3, boolean bl2, float f2, boolean bl3) throws ImageStorageException {
        InputStream inputStream;
        block24: {
            if (object == null || ((String)object).isEmpty()) {
                throw new ImageStorageException("URL can't be null or empty");
            }
            inputStream = null;
            Object object2 = null;
            try {
                float f3;
                block23: {
                    f3 = 1.0f;
                    try {
                        DataURI dataURI = DataURI.tryParse((String)object);
                        if (dataURI != null) {
                            if (!"image".equalsIgnoreCase(dataURI.getMimeType())) {
                                throw new IllegalArgumentException("Unexpected MIME type: " + dataURI.getMimeType());
                            }
                            ImageLoaderFactory imageLoaderFactory = this.loaderFactoriesByMimeSubtype.get(dataURI.getMimeSubtype().toLowerCase());
                            if (imageLoaderFactory == null) {
                                throw new IllegalArgumentException("Unsupported MIME subtype: image/" + dataURI.getMimeSubtype());
                            }
                            inputStream = new ByteArrayInputStream(dataURI.getData());
                            object = this.getLoaderBySignature(inputStream, imageLoadListener);
                            if (object != null) {
                                PlatformLogger platformLogger;
                                boolean bl4 = !imageLoaderFactory.getFormatDescription().getFormatName().equals(object.getFormatDescription().getFormatName());
                                if (bl4 && (platformLogger = Logging.getJavaFXLogger()).isLoggable(PlatformLogger$Level.WARNING)) {
                                    platformLogger.warning(String.format("Image format '%s' does not match MIME type '%s/%s' in URI '%s'", object.getFormatDescription().getFormatName(), dataURI.getMimeType(), dataURI.getMimeSubtype(), dataURI));
                                }
                                object2 = object;
                            } else {
                                inputStream.close();
                                inputStream = new ByteArrayInputStream(dataURI.getData());
                                object2 = imageLoaderFactory.createImageLoader(inputStream);
                            }
                            break block23;
                        }
                        if (f2 >= 1.5f) {
                            try {
                                String string = ImageTools.getScaledImageName((String)object);
                                inputStream = ImageTools.createInputStream(string);
                                f3 = 2.0f;
                            }
                            catch (IOException iOException) {}
                        }
                        if (inputStream == null) {
                            inputStream = ImageTools.createInputStream((String)object);
                        }
                        object2 = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(inputStream) : this.getLoaderBySignature(inputStream, imageLoadListener);
                    }
                    catch (Exception exception) {
                        throw new ImageStorageException(exception.getMessage(), exception);
                    }
                }
                if (object2 == null) {
                    throw new ImageStorageException("No loader for image data");
                }
                object = this.loadAll((ImageLoader)object2, d2, d3, bl2, f3, bl3);
                if (object2 == null) break block24;
                object2.dispose();
            }
            catch (Throwable throwable) {
                if (object2 != null) {
                    object2.dispose();
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        return object;
    }

    private synchronized int getMaxSignatureLength() {
        if (this.maxSignatureLength < 0) {
            this.maxSignatureLength = 0;
            for (ImageFormatDescription$Signature imageFormatDescription$Signature : this.loaderFactoriesBySignature.keySet()) {
                int n2 = imageFormatDescription$Signature.getLength();
                if (this.maxSignatureLength >= n2) continue;
                this.maxSignatureLength = n2;
            }
        }
        return this.maxSignatureLength;
    }

    private ImageFrame[] loadAll(ImageLoader imageLoader, double d2, double d3, boolean bl2, float f2, boolean bl3) throws ImageStorageException {
        int n2;
        ImageFrame[] imageFrameArray = null;
        ArrayList<ImageFrame> arrayList = new ArrayList<ImageFrame>();
        int n3 = 0;
        int n4 = (int)Math.round(d2 * (double)f2);
        int n5 = (int)Math.round(d3 * (double)f2);
        while (true) {
            ImageFrame imageFrame;
            try {
                imageFrame = imageLoader.load(n3++, n4, n5, bl2, bl3);
            }
            catch (Exception exception) {
                if (n3 > 1) break;
                throw new ImageStorageException(exception.getMessage(), exception);
            }
            if (imageFrame == null) break;
            imageFrame.setPixelScale(f2);
            arrayList.add(imageFrame);
        }
        if ((n2 = arrayList.size()) > 0) {
            imageFrameArray = new ImageFrame[n2];
            arrayList.toArray(imageFrameArray);
        }
        return imageFrameArray;
    }

    private ImageLoader getLoaderBySignature(InputStream object, ImageLoadListener imageLoadListener) throws IOException {
        Object object2 = new byte[this.getMaxSignatureLength()];
        try {
            ImageTools.readFully((InputStream)object, object2);
        }
        catch (EOFException eOFException) {
            return null;
        }
        for (Map.Entry<ImageFormatDescription$Signature, ImageLoaderFactory> entry : this.loaderFactoriesBySignature.entrySet()) {
            if (!entry.getKey().matches((byte[])object2)) continue;
            object2 = new ByteArrayInputStream((byte[])object2);
            object = new SequenceInputStream((InputStream)object2, (InputStream)object);
            object = entry.getValue().createImageLoader((InputStream)object);
            if (imageLoadListener != null) {
                object.addListener(imageLoadListener);
            }
            return object;
        }
        return null;
    }
}

