/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorage$ImageType;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;

public class ImageTools {
    public static final int PROGRESS_INTERVAL = 5;

    public static int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3;
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        while (n3 > 0) {
            int n5 = inputStream.read(byArray, n2, n3);
            if (n5 == -1) {
                throw new EOFException();
            }
            n2 += n5;
            n3 -= n5;
        }
        return n4;
    }

    public static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        return ImageTools.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void skipFully(InputStream inputStream, long l2) throws IOException {
        while (l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 <= 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException();
                }
                --l2;
                continue;
            }
            l2 -= l3;
        }
    }

    public static ImageStorage$ImageType getConvertedType(ImageStorage$ImageType imageStorage$ImageType) {
        switch (imageStorage$ImageType) {
            case GRAY: {
                imageStorage$ImageType = ImageStorage$ImageType.GRAY;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE_TRANS: 
            case RGBA: {
                imageStorage$ImageType = ImageStorage$ImageType.RGBA_PRE;
                break;
            }
            case PALETTE: 
            case RGB: {
                imageStorage$ImageType = ImageStorage$ImageType.RGB;
                break;
            }
            case RGBA_PRE: {
                imageStorage$ImageType = ImageStorage$ImageType.RGBA_PRE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ImageType " + String.valueOf((Object)imageStorage$ImageType));
            }
        }
        return imageStorage$ImageType;
    }

    public static byte[] createImageArray(ImageStorage$ImageType imageStorage$ImageType, int n2, int n3) {
        return new byte[n2 * n3 * (switch (imageStorage$ImageType) {
            case ImageStorage$ImageType.GRAY, ImageStorage$ImageType.PALETTE_ALPHA, ImageStorage$ImageType.PALETTE_ALPHA_PRE, ImageStorage$ImageType.PALETTE -> 1;
            case ImageStorage$ImageType.GRAY_ALPHA, ImageStorage$ImageType.GRAY_ALPHA_PRE -> 2;
            case ImageStorage$ImageType.RGB -> 3;
            case ImageStorage$ImageType.RGBA, ImageStorage$ImageType.RGBA_PRE -> 4;
            default -> throw new IllegalArgumentException("Unsupported ImageType " + String.valueOf((Object)imageStorage$ImageType));
        })];
    }

    public static ImageFrame convertImageFrame(ImageFrame object) {
        ImageStorage$ImageType imageStorage$ImageType = ((ImageFrame)object).getImageType();
        ImageStorage$ImageType imageStorage$ImageType2 = ImageTools.getConvertedType(imageStorage$ImageType);
        if (imageStorage$ImageType2 != imageStorage$ImageType) {
            Object object2 = ((ImageFrame)object).getImageData();
            if (!(object2 instanceof ByteBuffer)) {
                throw new IllegalArgumentException("!(frame.getImageData() instanceof ByteBuffer)");
            }
            ByteBuffer byteBuffer = (ByteBuffer)object2;
            if (byteBuffer.hasArray()) {
                object2 = byteBuffer.array();
            } else {
                object2 = new byte[byteBuffer.capacity()];
                byteBuffer.get((byte[])object2);
            }
            int n2 = ((ImageFrame)object).getWidth();
            int n3 = ((ImageFrame)object).getHeight();
            int n4 = ((ImageFrame)object).getStride();
            byte[] byArray = ImageTools.createImageArray(imageStorage$ImageType2, n2, n3);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            int n5 = byArray.length / n3;
            byte[][] byArray2 = ((ImageFrame)object).getPalette();
            object = ((ImageFrame)object).getMetadata();
            int n6 = ((ImageMetadata)object).transparentIndex != null ? ((ImageMetadata)object).transparentIndex : 0;
            ImageTools.convert(n2, n3, imageStorage$ImageType, (byte[])object2, 0, n4, byArray, 0, n5, byArray2, n6, false);
            object = new ImageMetadata(((ImageMetadata)object).gamma, ((ImageMetadata)object).blackIsZero, null, ((ImageMetadata)object).backgroundColor, null, ((ImageMetadata)object).delayTime, ((ImageMetadata)object).loopCount, ((ImageMetadata)object).imageWidth, ((ImageMetadata)object).imageHeight, ((ImageMetadata)object).imageLeftPosition, ((ImageMetadata)object).imageTopPosition, ((ImageMetadata)object).disposalMethod);
            object = new ImageFrame(imageStorage$ImageType2, byteBuffer2, n2, n3, n5, null, (ImageMetadata)object);
        }
        return object;
    }

    public static byte[] convert(int n2, int n3, ImageStorage$ImageType object, byte[] byArray, int n4, int n5, byte[] byArray2, int n6, int n7, byte[][] byArray3, int n8, boolean bl2) {
        if (object == ImageStorage$ImageType.GRAY || object == ImageStorage$ImageType.RGB || object == ImageStorage$ImageType.RGBA_PRE) {
            if (byArray != byArray2) {
                int n9 = n2;
                if (object == ImageStorage$ImageType.RGB) {
                    n9 *= 3;
                } else if (object == ImageStorage$ImageType.RGBA_PRE) {
                    n9 <<= 2;
                }
                if (n3 == 1) {
                    System.arraycopy(byArray, n4, byArray2, n6, n9);
                } else {
                    int n10 = n6;
                    for (n6 = 0; n6 < n3; ++n6) {
                        System.arraycopy(byArray, n4, byArray2, n10, n9);
                        n4 += n5;
                        n10 += n7;
                    }
                }
            }
        } else if (object == ImageStorage$ImageType.GRAY_ALPHA || object == ImageStorage$ImageType.GRAY_ALPHA_PRE) {
            int n11 = n4;
            n4 = n6;
            if (object == ImageStorage$ImageType.GRAY_ALPHA) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    n6 = n11;
                    int n12 = n4;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        byte by2 = byArray[n6++];
                        int n13 = byArray[n6++] & 0xFF;
                        float f2 = (float)n13 / 255.0f;
                        by2 = (byte)(f2 * (float)(by2 & 0xFF));
                        byArray2[n12++] = by2;
                        byArray2[n12++] = by2;
                        byArray2[n12++] = by2;
                        byArray2[n12++] = (byte)n13;
                    }
                    n11 += n5;
                    n4 += n7;
                }
            } else {
                for (int i4 = 0; i4 < n3; ++i4) {
                    n6 = n11;
                    int n14 = n4;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        byte by3 = byArray[n6++];
                        byArray2[n14++] = by3;
                        byArray2[n14++] = by3;
                        byArray2[n14++] = by3;
                        byArray2[n14++] = byArray[n6++];
                    }
                    n11 += n5;
                    n4 += n7;
                }
            }
        } else if (object == ImageStorage$ImageType.PALETTE) {
            int n15 = n4;
            n4 = n6;
            object = byArray3[0];
            byte[] byArray4 = byArray3[1];
            byte[] byArray5 = byArray3[2];
            int n16 = n15;
            int n17 = n4;
            for (int i6 = 0; i6 < n2; ++i6) {
                int n18 = byArray[n16++] & 0xFF;
                byArray2[n17++] = (byte)object[n18];
                byArray2[n17++] = byArray4[n18];
                byArray2[n17++] = byArray5[n18];
            }
        } else if (object == ImageStorage$ImageType.PALETTE_ALPHA) {
            int n19 = n4;
            n4 = n6;
            object = byArray3[0];
            byte[] byArray6 = byArray3[1];
            byte[] byArray7 = byArray3[2];
            byte[] byArray8 = byArray3[3];
            int n20 = n19;
            int n21 = n4;
            for (int i7 = 0; i7 < n2; ++i7) {
                int n22 = byArray[n20++] & 0xFF;
                ImageStorage$ImageType imageStorage$ImageType = object[n22];
                n3 = byArray6[n22];
                n4 = byArray7[n22];
                n5 = byArray8[n22] & 0xFF;
                float f3 = (float)n5 / 255.0f;
                byArray2[n21++] = (byte)(f3 * (float)(imageStorage$ImageType & 0xFF));
                byArray2[n21++] = (byte)(f3 * (float)(n3 & 0xFF));
                byArray2[n21++] = (byte)(f3 * (float)(n4 & 0xFF));
                byArray2[n21++] = (byte)n5;
            }
        } else if (object == ImageStorage$ImageType.PALETTE_ALPHA_PRE) {
            int n23 = n4;
            n4 = n6;
            object = byArray3[0];
            byte[] byArray9 = byArray3[1];
            byte[] byArray10 = byArray3[2];
            byte[] byArray11 = byArray3[3];
            for (int i8 = 0; i8 < n3; ++i8) {
                int n24 = n23;
                int n25 = n4;
                for (int i9 = 0; i9 < n2; ++i9) {
                    int n26 = byArray[n24++] & 0xFF;
                    byArray2[n25++] = (byte)object[n26];
                    byArray2[n25++] = byArray9[n26];
                    byArray2[n25++] = byArray10[n26];
                    byArray2[n25++] = byArray11[n26];
                }
                n23 += n5;
                n4 += n7;
            }
        } else if (object == ImageStorage$ImageType.PALETTE_TRANS) {
            int n27 = n4;
            n4 = n6;
            for (int i10 = 0; i10 < n3; ++i10) {
                n6 = n27;
                int n28 = n4;
                byte[] byArray12 = byArray3[0];
                byte[] byArray13 = byArray3[1];
                byte[] byArray14 = byArray3[2];
                for (int i11 = 0; i11 < n2; ++i11) {
                    int n29;
                    if ((n29 = byArray[n6++] & 0xFF) == n8) {
                        if (bl2) {
                            n28 += 4;
                            continue;
                        }
                        byArray2[n28++] = 0;
                        byArray2[n28++] = 0;
                        byArray2[n28++] = 0;
                        byArray2[n28++] = 0;
                        continue;
                    }
                    byArray2[n28++] = byArray12[n29];
                    byArray2[n28++] = byArray13[n29];
                    byArray2[n28++] = byArray14[n29];
                    byArray2[n28++] = -1;
                }
                n27 += n5;
                n4 += n7;
            }
        } else if (object == ImageStorage$ImageType.RGBA) {
            int n30 = n4;
            n4 = n6;
            for (int i12 = 0; i12 < n3; ++i12) {
                n6 = n30;
                int n31 = n4;
                for (int i13 = 0; i13 < n2; ++i13) {
                    byte by4 = byArray[n6++];
                    byte by5 = byArray[n6++];
                    byte by6 = byArray[n6++];
                    int n32 = byArray[n6++] & 0xFF;
                    float f4 = (float)n32 / 255.0f;
                    byArray2[n31++] = (byte)(f4 * (float)(by4 & 0xFF));
                    byArray2[n31++] = (byte)(f4 * (float)(by5 & 0xFF));
                    byArray2[n31++] = (byte)(f4 * (float)(by6 & 0xFF));
                    byArray2[n31++] = (byte)n32;
                }
                n30 += n5;
                n4 += n7;
            }
        } else {
            throw new UnsupportedOperationException("Unsupported ImageType " + String.valueOf(object));
        }
        return byArray2;
    }

    public static String getScaledImageName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.lastIndexOf(47);
        String string2 = n2 < 0 ? string : string.substring(n2 + 1);
        int n3 = string2.lastIndexOf(".");
        if (n3 < 0) {
            n3 = string2.length();
        }
        if (n2 >= 0) {
            stringBuilder.append(string.substring(0, n2 + 1));
        }
        stringBuilder.append(string2.substring(0, n3));
        stringBuilder.append("@2x");
        stringBuilder.append(string2.substring(n3));
        return stringBuilder.toString();
    }

    public static InputStream createInputStream(String string) throws IOException {
        Serializable serializable;
        InputStream inputStream = null;
        try {
            serializable = new File(string);
            if (serializable.exists()) {
                inputStream = new FileInputStream((File)serializable);
            }
        }
        catch (Exception exception) {}
        if (inputStream == null) {
            serializable = new URL(string);
            inputStream = ((URL)serializable).openStream();
        }
        return inputStream;
    }

    private static void computeUpdatedPixels(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray, int n11) {
        boolean bl2 = false;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        for (int i2 = 0; i2 < n9; ++i2) {
            int n15 = n8 + i2 * n10;
            if (n15 < n2 || (n15 - n2) % n7 != 0) continue;
            if (n15 >= n2 + n3) break;
            if ((n15 = n4 + (n15 - n2) / n7) < n5) continue;
            if (n15 > n6) break;
            if (!bl2) {
                n12 = n15;
                bl2 = true;
            } else if (n13 == -1) {
                n13 = n15;
            }
            n14 = n15;
        }
        nArray[n11] = n12;
        nArray[n11 + 2] = !bl2 ? 0 : n14 - n12 + 1;
        nArray[n11 + 4] = Math.max(n13 - n12, 1);
    }

    public static int[] computeUpdatedPixels(Rectangle rectangle, Point2D point2D, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        int[] nArray = new int[6];
        ImageTools.computeUpdatedPixels(rectangle.x, rectangle.width, (int)(point2D.x + 0.5f), n2, n4, n6, n8, n10, n12, nArray, 0);
        ImageTools.computeUpdatedPixels(rectangle.y, rectangle.height, (int)(point2D.y + 0.5f), n3, n5, n7, n9, n11, n13, nArray, 1);
        return nArray;
    }

    public static int[] computeDimensions(int n2, int n3, int n4, int n5, boolean bl2) {
        n4 = n4 < 0 ? 0 : n4;
        int n6 = n5 = n5 < 0 ? 0 : n5;
        if (n4 == 0 && n5 == 0) {
            n4 = n2;
            n5 = n3;
        } else if (n4 != n2 || n5 != n3) {
            if (bl2) {
                if (n4 == 0) {
                    n4 = Math.round((float)n2 * (float)n5 / (float)n3);
                } else if (n5 == 0) {
                    n5 = Math.round((float)n3 * (float)n4 / (float)n2);
                } else {
                    float f2 = Math.min((float)n4 / (float)n2, (float)n5 / (float)n3);
                    n4 = Math.round((float)n2 * f2);
                    n5 = Math.round((float)n3 * f2);
                }
            } else {
                if (n5 == 0) {
                    n5 = n3;
                }
                if (n4 == 0) {
                    n4 = n2;
                }
            }
            if (n4 <= 0) {
                n4 = 1;
            }
            if (n5 <= 0) {
                n5 = 1;
            }
        }
        return new int[]{n4, n5};
    }

    public static ImageFrame scaleImageFrame(ImageFrame imageFrame, int n2, int n3, boolean bl2) {
        int n4 = ImageStorage.getInstance().getNumBands(imageFrame.getImageType());
        ByteBuffer byteBuffer = ImageTools.scaleImage((ByteBuffer)imageFrame.getImageData(), imageFrame.getWidth(), imageFrame.getHeight(), n4, n2, n3, bl2);
        return new ImageFrame(imageFrame.getImageType(), byteBuffer, n2, n3, n2 * n4, null, imageFrame.getMetadata());
    }

    public static ByteBuffer scaleImage(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        PushbroomScaler pushbroomScaler = ScalerFactory.createScaler(n2, n3, n4, n5, n6, bl2);
        n2 *= n4;
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            for (n6 = 0; n6 != n3; ++n6) {
                pushbroomScaler.putSourceScanline(byArray, n6 * n2);
            }
        } else {
            byte[] byArray = new byte[n2];
            for (n6 = 0; n6 != n3; ++n6) {
                byteBuffer.get(byArray);
                pushbroomScaler.putSourceScanline(byArray, 0);
            }
        }
        return pushbroomScaler.getDestination();
    }
}

