/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.iio.common.PushbroomScaler;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SmoothMinifier
implements PushbroomScaler {
    protected int sourceWidth;
    protected int sourceHeight;
    protected int numBands;
    protected int destWidth;
    protected int destHeight;
    protected double scaleY;
    protected ByteBuffer destBuf;
    protected int boxHeight;
    protected byte[][] sourceData;
    protected int[] leftPoints;
    protected int[] rightPoints;
    protected int[] topPoints;
    protected int[] bottomPoints;
    protected int sourceLine;
    protected int sourceDataLine;
    protected int destLine;
    protected int[] tmpBuf;

    SmoothMinifier(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        if (n2 <= 0 || n3 <= 0 || n4 <= 0 || n5 <= 0 || n6 <= 0 || n5 > n2 || n6 > n3) {
            throw new IllegalArgumentException();
        }
        this.sourceWidth = n2;
        this.sourceHeight = n3;
        this.numBands = n4;
        this.destWidth = n5;
        this.destHeight = n6;
        this.destBuf = ByteBuffer.wrap(new byte[n6 * n5 * n4]);
        double d2 = (double)n2 / (double)n5;
        this.scaleY = (double)n3 / (double)n6;
        n2 = (n2 + n5 - 1) / n5;
        this.boxHeight = (n3 + n6 - 1) / n6;
        n3 = n2 / 2;
        n2 = n2 - n3 - 1;
        int n9 = this.boxHeight / 2;
        int n10 = this.boxHeight - n9 - 1;
        this.sourceData = new byte[this.boxHeight][n5 * n4];
        this.leftPoints = new int[n5];
        this.rightPoints = new int[n5];
        for (n8 = 0; n8 < n5; ++n8) {
            n7 = (int)((double)n8 * d2);
            this.leftPoints[n8] = n7 - n3;
            this.rightPoints[n8] = n7 + n2;
        }
        this.topPoints = new int[n6];
        this.bottomPoints = new int[n6];
        for (n8 = 0; n8 < n6; ++n8) {
            n7 = (int)((double)n8 * this.scaleY);
            this.topPoints[n8] = n7 - n9;
            this.bottomPoints[n8] = n7 + n10;
        }
        this.sourceLine = 0;
        this.sourceDataLine = 0;
        this.destLine = 0;
        this.tmpBuf = new int[n5 * n4];
    }

    @Override
    public ByteBuffer getDestination() {
        return this.destBuf;
    }

    @Override
    public boolean putSourceScanline(byte[] byArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 0) {
            throw new IllegalArgumentException("off < 0!");
        }
        if (this.numBands == 1) {
            var3_3 = byArray[n2] & 0xFF;
            n7 = byArray[n2 + this.sourceWidth - 1] & 0xFF;
            for (n6 = 0; n6 < this.destWidth; ++n6) {
                n5 = 0;
                var7_8 = this.rightPoints[n6];
                for (n4 = this.leftPoints[n6]; n4 <= var7_8; ++n4) {
                    if (n4 < 0) {
                        n5 += var3_3;
                        continue;
                    }
                    if (n4 >= this.sourceWidth) {
                        n5 += n7;
                        continue;
                    }
                    n5 += byArray[n2 + n4] & 0xFF;
                }
                this.sourceData[this.sourceDataLine][n6] = (byte)(n5 /= var7_8 - this.leftPoints[n6] + 1);
            }
        } else {
            var3_3 = n2 + (this.sourceWidth - 1) * this.numBands;
            for (n7 = 0; n7 < this.destWidth; ++n7) {
                n6 = this.leftPoints[n7];
                n5 = this.rightPoints[n7];
                var7_8 = n5 - n6 + 1;
                n4 = n7 * this.numBands;
                for (n3 = 0; n3 < this.numBands; ++n3) {
                    int n8 = byArray[n2 + n3] & 0xFF;
                    int n9 = byArray[var3_3 + n3] & 0xFF;
                    int n10 = 0;
                    for (int i2 = n6; i2 <= n5; ++i2) {
                        if (i2 < 0) {
                            n10 += n8;
                            continue;
                        }
                        if (i2 >= this.sourceWidth) {
                            n10 += n9;
                            continue;
                        }
                        n10 += byArray[n2 + i2 * this.numBands + n3] & 0xFF;
                    }
                    this.sourceData[this.sourceDataLine][n4 + n3] = (byte)(n10 /= var7_8);
                }
            }
        }
        if (this.sourceLine == this.bottomPoints[this.destLine] || this.destLine == this.destHeight - 1 && this.sourceLine == this.sourceHeight - 1) {
            assert (this.destBuf.hasArray()) : "destBuf.hasArray() == false => destBuf is direct";
            byte[] byArray2 = this.destBuf.array();
            n7 = this.destLine * this.destWidth * this.numBands;
            Arrays.fill(this.tmpBuf, 0);
            for (n6 = this.topPoints[this.destLine]; n6 <= this.bottomPoints[this.destLine]; ++n6) {
                n5 = n6 < 0 ? 0 - this.sourceLine + this.sourceDataLine : (n6 >= this.sourceHeight ? (this.sourceHeight - 1 - this.sourceLine + this.sourceDataLine) % this.boxHeight : (n6 - this.sourceLine + this.sourceDataLine) % this.boxHeight);
                if (n5 < 0) {
                    n5 += this.boxHeight;
                }
                byte[] byArray3 = this.sourceData[n5];
                n4 = byArray3.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    int n11 = n3;
                    this.tmpBuf[n11] = this.tmpBuf[n11] + (byArray3[n3] & 0xFF);
                }
            }
            n6 = this.tmpBuf.length;
            for (n5 = 0; n5 < n6; ++n5) {
                byArray2[n7 + n5] = (byte)(this.tmpBuf[n5] / this.boxHeight);
            }
            if (this.destLine < this.destHeight - 1) {
                ++this.destLine;
            }
        }
        if (++this.sourceLine != this.sourceHeight) {
            this.sourceDataLine = (this.sourceDataLine + 1) % this.boxHeight;
        }
        return this.destLine == this.destHeight;
    }
}

