/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.gif;

import com.sun.javafx.iio.gif.GIFImageLoader2;
import java.io.EOFException;
import java.io.IOException;

class GIFImageLoader2$LZWDecoder {
    private final int initCodeSize;
    private final int clearCode;
    private final int eofCode;
    private int codeSize;
    private int codeMask;
    private int tableIndex;
    private int oldCode;
    private int blockLength = 0;
    private int blockPos = 0;
    private byte[] block = new byte[255];
    private int inData = 0;
    private int inBits = 0;
    private int[] prefix = new int[4096];
    private byte[] suffix = new byte[4096];
    private byte[] initial = new byte[4096];
    private int[] length = new int[4096];
    private byte[] string = new byte[4096];
    final /* synthetic */ GIFImageLoader2 this$0;

    public GIFImageLoader2$LZWDecoder(GIFImageLoader2 gIFImageLoader2) throws IOException {
        this.this$0 = gIFImageLoader2;
        this.initCodeSize = gIFImageLoader2.readByte();
        this.clearCode = 1 << this.initCodeSize;
        this.eofCode = this.clearCode + 1;
        this.initTable();
    }

    public final int readString() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.getCode();
        if (n5 == this.eofCode) {
            return -1;
        }
        if (n5 == this.clearCode) {
            this.initTable();
            n5 = this.getCode();
            if (n5 == this.eofCode) {
                return -1;
            }
        } else {
            if (n5 < this.tableIndex) {
                n4 = n5;
            } else {
                n4 = this.oldCode;
                if (n5 != this.tableIndex) {
                    throw new IOException("Bad GIF LZW: Out-of-sequence code!");
                }
            }
            if (this.tableIndex < 4096) {
                n3 = this.tableIndex++;
                this.prefix[n3] = n2 = this.oldCode;
                this.suffix[n3] = this.initial[n4];
                this.initial[n3] = this.initial[n2];
                this.length[n3] = this.length[n2] + 1;
                if (this.tableIndex == 1 << this.codeSize && this.tableIndex < 4096) {
                    ++this.codeSize;
                    this.codeMask = (1 << this.codeSize) - 1;
                }
            }
        }
        n4 = n5;
        n3 = this.length[n4];
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            this.string[n2] = this.suffix[n4];
            n4 = this.prefix[n4];
        }
        this.oldCode = n5;
        return n3;
    }

    public final byte[] getString() {
        return this.string;
    }

    public final void waitForTerminator() throws IOException {
        this.this$0.consumeAnExtension();
    }

    private void initTable() {
        int n2;
        int n3 = 1 << this.initCodeSize;
        for (n2 = 0; n2 < n3; ++n2) {
            this.prefix[n2] = -1;
            int n4 = n2;
            this.suffix[n4] = (byte)n4;
            int n5 = n2;
            this.initial[n5] = (byte)n5;
            this.length[n2] = 1;
        }
        for (n2 = n3; n2 < 4096; ++n2) {
            this.prefix[n2] = -1;
            this.length[n2] = 1;
        }
        this.codeSize = this.initCodeSize + 1;
        this.codeMask = (1 << this.codeSize) - 1;
        this.tableIndex = n3 + 2;
        this.oldCode = 0;
    }

    private int getCode() throws IOException {
        while (this.inBits < this.codeSize) {
            this.inData |= this.nextByte() << this.inBits;
            this.inBits += 8;
        }
        int n2 = this.inData & this.codeMask;
        this.inBits -= this.codeSize;
        this.inData >>>= this.codeSize;
        return n2;
    }

    private int nextByte() throws IOException {
        if (this.blockPos == this.blockLength) {
            this.readData();
        }
        return this.block[this.blockPos++] & 0xFF;
    }

    private void readData() throws IOException {
        this.blockPos = 0;
        this.blockLength = this.this$0.readByte();
        if (this.blockLength > 0) {
            this.this$0.readBytes(this.block, 0, this.blockLength);
            return;
        }
        throw new EOFException();
    }
}

