/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.jpeg;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage$ImageType;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.jpeg.JPEGDescriptor;
import com.sun.javafx.iio.jpeg.JPEGImageLoader$Lock;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;

public class JPEGImageLoader
extends ImageLoaderImpl {
    public static final int JCS_UNKNOWN = 0;
    public static final int JCS_GRAYSCALE = 1;
    public static final int JCS_RGB = 2;
    public static final int JCS_YCbCr = 3;
    public static final int JCS_CMYK = 4;
    public static final int JCS_YCC = 5;
    public static final int JCS_RGBA = 6;
    public static final int JCS_YCbCrA = 7;
    public static final int JCS_YCCA = 10;
    public static final int JCS_YCCK = 11;
    private long structPointer = 0L;
    private int inWidth;
    private int inHeight;
    private int inColorSpaceCode;
    private int outColorSpaceCode;
    private byte[] iccData;
    private int outWidth;
    private int outHeight;
    private ImageStorage$ImageType outImageType;
    private boolean isDisposed = false;
    private JPEGImageLoader$Lock accessLock = new JPEGImageLoader$Lock();

    private static native void initJPEGMethodIDs(Class var0);

    private static native void disposeNative(long var0);

    private native long initDecompressor(InputStream var1) throws IOException;

    private native int startDecompression(long var1, int var3, int var4, int var5);

    private native boolean decompressIndirect(long var1, boolean var3, byte[] var4) throws IOException;

    private void setInputAttributes(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.inWidth = n2;
        this.inHeight = n3;
        this.inColorSpaceCode = n4;
        this.outColorSpaceCode = n5;
        this.iccData = byArray;
        switch (n5) {
            case 1: {
                this.outImageType = ImageStorage$ImageType.GRAY;
                return;
            }
            case 2: 
            case 3: 
            case 5: {
                this.outImageType = ImageStorage$ImageType.RGB;
                return;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                this.outImageType = ImageStorage$ImageType.RGBA_PRE;
                return;
            }
            case 0: {
                switch (n6) {
                    case 1: {
                        this.outImageType = ImageStorage$ImageType.GRAY;
                        return;
                    }
                    case 3: {
                        this.outImageType = ImageStorage$ImageType.RGB;
                        return;
                    }
                    case 4: {
                        this.outImageType = ImageStorage$ImageType.RGBA_PRE;
                        return;
                    }
                }
                assert (false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void setOutputAttributes(int n2, int n3) {
        this.outWidth = n2;
        this.outHeight = n3;
    }

    private void updateImageProgress(int n2) {
        this.updateImageProgress(100.0f * (float)n2 / (float)this.outHeight);
    }

    JPEGImageLoader(InputStream inputStream) throws IOException {
        super(JPEGDescriptor.getInstance());
        if (inputStream == null) {
            throw new IllegalArgumentException("input == null!");
        }
        try {
            this.structPointer = this.initDecompressor(inputStream);
        }
        catch (IOException iOException) {
            this.dispose();
            throw iOException;
        }
        if (this.structPointer == 0L) {
            throw new IOException("Unable to initialize JPEG decompressor");
        }
    }

    @Override
    public synchronized void dispose() {
        if (!this.accessLock.isLocked() && !this.isDisposed && this.structPointer != 0L) {
            this.isDisposed = true;
            JPEGImageLoader.disposeNative(this.structPointer);
            this.structPointer = 0L;
        }
    }

    @Override
    public ImageFrame load(int n2, int n3, int n4, boolean n5, boolean bl2) throws IOException {
        Object object;
        int n6;
        if (n2 != 0) {
            return null;
        }
        this.accessLock.lock();
        Object object2 = ImageTools.computeDimensions(this.inWidth, this.inHeight, n3, n4, n5 != 0);
        n3 = object2[0];
        n4 = object2[1];
        object2 = new ImageMetadata(null, Boolean.TRUE, null, null, null, null, null, n3, n4, null, null, null);
        this.updateImageMetadata((ImageMetadata)object2);
        try {
            JPEGImageLoader jPEGImageLoader = this;
            n6 = jPEGImageLoader.startDecompression(jPEGImageLoader.structPointer, this.outColorSpaceCode, n3, n4);
            if (this.outWidth < 0 || this.outHeight < 0 || n6 < 0) {
                throw new IOException("negative dimension.");
            }
            if (this.outWidth > Integer.MAX_VALUE / n6) {
                throw new IOException("bad width.");
            }
            n5 = this.outWidth * n6;
            if (n5 > Integer.MAX_VALUE / this.outHeight) {
                throw new IOException("bad height.");
            }
            object = new byte[n5 * this.outHeight];
            object = ByteBuffer.wrap((byte[])object);
            JPEGImageLoader jPEGImageLoader2 = this;
            jPEGImageLoader2.decompressIndirect(jPEGImageLoader2.structPointer, this.listeners != null && !this.listeners.isEmpty(), ((ByteBuffer)object).array());
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        finally {
            this.accessLock.unlock();
            this.dispose();
        }
        if (object == null) {
            throw new IOException("Error decompressing JPEG stream!");
        }
        if (this.outWidth != n3 || this.outHeight != n4) {
            object = ImageTools.scaleImage((ByteBuffer)object, this.outWidth, this.outHeight, n6, n3, n4, bl2);
        }
        return new ImageFrame(this.outImageType, (ByteBuffer)object, n3, n4, n3 * n6, null, (ImageMetadata)object2);
    }

    static {
        AccessController.doPrivileged(() -> {
            NativeLibLoader.loadLibrary("javafx_iio");
            return null;
        });
        JPEGImageLoader.initJPEGMethodIDs(InputStream.class);
    }
}

