/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.glass.ui.Accessible;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper$NodeAccessor;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalMethod;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.util.Utils;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.css.CssMetaData;
import javafx.css.Style;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SubScene;
import javafx.scene.shape.Shape;
import javafx.scene.shape.Shape3D;
import javafx.scene.text.Font;

public abstract class NodeHelper {
    private static NodeHelper$NodeAccessor nodeAccessor;

    protected NodeHelper() {
    }

    protected static NodeHelper getHelper(Node object) {
        NodeHelper nodeHelper = nodeAccessor.getHelper((Node)object);
        if (nodeHelper == null) {
            object = object instanceof Shape ? "Shape" : (object instanceof Shape3D ? "Shape3D" : "Node");
            throw new UnsupportedOperationException("Applications should not extend the " + (String)object + " class directly.");
        }
        return nodeHelper;
    }

    protected static void setHelper(Node node, NodeHelper nodeHelper) {
        nodeAccessor.setHelper(node, nodeHelper);
    }

    public static NGNode createPeer(Node node) {
        return NodeHelper.getHelper(node).createPeerImpl(node);
    }

    public static void markDirty(Node node, DirtyBits dirtyBits) {
        NodeHelper.getHelper(node).markDirtyImpl(node, dirtyBits);
    }

    public static void updatePeer(Node node) {
        NodeHelper.getHelper(node).updatePeerImpl(node);
    }

    public static Bounds computeLayoutBounds(Node node) {
        return NodeHelper.getHelper(node).computeLayoutBoundsImpl(node);
    }

    public static BaseBounds computeGeomBounds(Node node, BaseBounds baseBounds, BaseTransform baseTransform) {
        return NodeHelper.getHelper(node).computeGeomBoundsImpl(node, baseBounds, baseTransform);
    }

    public static void transformsChanged(Node node) {
        NodeHelper.getHelper(node).transformsChangedImpl(node);
    }

    public static boolean computeContains(Node node, double d2, double d3) {
        return NodeHelper.getHelper(node).computeContainsImpl(node, d2, d3);
    }

    public static void pickNodeLocal(Node node, PickRay pickRay, PickResultChooser pickResultChooser) {
        NodeHelper.getHelper(node).pickNodeLocalImpl(node, pickRay, pickResultChooser);
    }

    public static boolean computeIntersects(Node node, PickRay pickRay, PickResultChooser pickResultChooser) {
        return NodeHelper.getHelper(node).computeIntersectsImpl(node, pickRay, pickResultChooser);
    }

    public static void geomChanged(Node node) {
        NodeHelper.getHelper(node).geomChangedImpl(node);
    }

    public static void notifyLayoutBoundsChanged(Node node) {
        NodeHelper.getHelper(node).notifyLayoutBoundsChangedImpl(node);
    }

    public static void processCSS(Node node) {
        NodeHelper.getHelper(node).processCSSImpl(node);
    }

    protected abstract NGNode createPeerImpl(Node var1);

    protected abstract boolean computeContainsImpl(Node var1, double var2, double var4);

    protected abstract BaseBounds computeGeomBoundsImpl(Node var1, BaseBounds var2, BaseTransform var3);

    protected void markDirtyImpl(Node node, DirtyBits dirtyBits) {
        nodeAccessor.doMarkDirty(node, dirtyBits);
    }

    protected void updatePeerImpl(Node node) {
        nodeAccessor.doUpdatePeer(node);
    }

    protected Bounds computeLayoutBoundsImpl(Node node) {
        return nodeAccessor.doComputeLayoutBounds(node);
    }

    protected void transformsChangedImpl(Node node) {
        nodeAccessor.doTransformsChanged(node);
    }

    protected void pickNodeLocalImpl(Node node, PickRay pickRay, PickResultChooser pickResultChooser) {
        nodeAccessor.doPickNodeLocal(node, pickRay, pickResultChooser);
    }

    protected boolean computeIntersectsImpl(Node node, PickRay pickRay, PickResultChooser pickResultChooser) {
        return nodeAccessor.doComputeIntersects(node, pickRay, pickResultChooser);
    }

    protected void geomChangedImpl(Node node) {
        nodeAccessor.doGeomChanged(node);
    }

    protected void notifyLayoutBoundsChangedImpl(Node node) {
        nodeAccessor.doNotifyLayoutBoundsChanged(node);
    }

    protected void processCSSImpl(Node node) {
        nodeAccessor.doProcessCSS(node);
    }

    public static boolean isDirty(Node node, DirtyBits dirtyBits) {
        return nodeAccessor.isDirty(node, dirtyBits);
    }

    public static boolean isDirtyEmpty(Node node) {
        return nodeAccessor.isDirtyEmpty(node);
    }

    public static void syncPeer(Node node) {
        nodeAccessor.syncPeer(node);
    }

    public static <P extends NGNode> P getPeer(Node node) {
        return nodeAccessor.getPeer(node);
    }

    public static BaseTransform getLeafTransform(Node node) {
        return nodeAccessor.getLeafTransform(node);
    }

    public static void layoutBoundsChanged(Node node) {
        nodeAccessor.layoutBoundsChanged(node);
    }

    public static void setShowMnemonics(Node node, boolean bl2) {
        nodeAccessor.setShowMnemonics(node, bl2);
    }

    public static boolean isShowMnemonics(Node node) {
        return nodeAccessor.isShowMnemonics(node);
    }

    public static BooleanProperty showMnemonicsProperty(Node node) {
        return nodeAccessor.showMnemonicsProperty(node);
    }

    public static boolean traverse(Node node, Direction direction, TraversalMethod traversalMethod) {
        return nodeAccessor.traverse(node, direction, traversalMethod);
    }

    public static double getPivotX(Node node) {
        return nodeAccessor.getPivotX(node);
    }

    public static double getPivotY(Node node) {
        return nodeAccessor.getPivotY(node);
    }

    public static double getPivotZ(Node node) {
        return nodeAccessor.getPivotZ(node);
    }

    public static void pickNode(Node node, PickRay pickRay, PickResultChooser pickResultChooser) {
        nodeAccessor.pickNode(node, pickRay, pickResultChooser);
    }

    public static boolean intersects(Node node, PickRay pickRay, PickResultChooser pickResultChooser) {
        return nodeAccessor.intersects(node, pickRay, pickResultChooser);
    }

    public static double intersectsBounds(Node node, PickRay pickRay) {
        return nodeAccessor.intersectsBounds(node, pickRay);
    }

    public static void layoutNodeForPrinting(Node node) {
        nodeAccessor.layoutNodeForPrinting(node);
    }

    public static boolean isDerivedDepthTest(Node node) {
        return nodeAccessor.isDerivedDepthTest(node);
    }

    public static SubScene getSubScene(Node node) {
        return nodeAccessor.getSubScene(node);
    }

    public static Accessible getAccessible(Node node) {
        return nodeAccessor.getAccessible(node);
    }

    public static void reapplyCSS(Node node) {
        nodeAccessor.reapplyCSS(node);
    }

    public static void recalculateRelativeSizeProperties(Node node, Font font) {
        nodeAccessor.recalculateRelativeSizeProperties(node, font);
    }

    public static boolean isTreeVisible(Node node) {
        return nodeAccessor.isTreeVisible(node);
    }

    public static BooleanExpression treeVisibleProperty(Node node) {
        return nodeAccessor.treeVisibleProperty(node);
    }

    public static boolean isTreeShowing(Node node) {
        return nodeAccessor.isTreeShowing(node);
    }

    public static List<Style> getMatchingStyles(CssMetaData cssMetaData, Styleable styleable) {
        return nodeAccessor.getMatchingStyles(cssMetaData, styleable);
    }

    public static Map<StyleableProperty<?>, List<Style>> findStyles(Node node, Map<StyleableProperty<?>, List<Style>> map) {
        return nodeAccessor.findStyles(node, map);
    }

    public static void requestFocusVisible(Node node) {
        nodeAccessor.requestFocusVisible(node);
    }

    public static void setNodeAccessor(NodeHelper$NodeAccessor nodeHelper$NodeAccessor) {
        if (nodeAccessor != null) {
            throw new IllegalStateException();
        }
        nodeAccessor = nodeHelper$NodeAccessor;
    }

    public static NodeHelper$NodeAccessor getNodeAccessor() {
        if (nodeAccessor == null) {
            throw new IllegalStateException();
        }
        return nodeAccessor;
    }

    static {
        Utils.forceInit(Node.class);
    }
}

