/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.ContextMenuContent$1;
import com.sun.javafx.scene.control.ContextMenuContent$ArrowMenuItem;
import com.sun.javafx.scene.control.ContextMenuContent$MenuBox;
import com.sun.javafx.scene.control.ContextMenuContent$MenuItemContainer;
import com.sun.javafx.scene.control.ContextMenuContent$StyleableProperties;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusPopupBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.Direction;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;

public class ContextMenuContent
extends Region {
    private static final String ITEM_STYLE_CLASS_LISTENER = "itemStyleClassListener";
    private ContextMenu contextMenu;
    private double maxGraphicWidth = 0.0;
    private double maxRightWidth = 0.0;
    private double maxLabelWidth = 0.0;
    private double maxRowHeight = 0.0;
    private double maxLeftWidth = 0.0;
    private double oldWidth = 0.0;
    private Rectangle clipRect;
    ContextMenuContent$MenuBox itemsContainer;
    private ContextMenuContent$ArrowMenuItem upArrow;
    private ContextMenuContent$ArrowMenuItem downArrow;
    private int currentFocusedIndex = -1;
    private boolean itemsDirty = true;
    private InvalidationListener popupShowingListener = observable -> this.updateItems();
    private WeakInvalidationListener weakPopupShowingListener = new WeakInvalidationListener(this.popupShowingListener);
    private boolean isFirstShow = true;
    private double ty;
    private ChangeListener<Boolean> menuShowingListener = (object, bl2, bl3) -> {
        object = (ReadOnlyBooleanProperty)object;
        object = (Menu)object.getBean();
        if (bl2.booleanValue() && !bl3.booleanValue()) {
            this.hideSubmenu();
            return;
        }
        if (!bl2.booleanValue() && bl3.booleanValue()) {
            this.showSubmenu((Menu)((Object)object));
        }
    };
    private ListChangeListener<MenuItem> contextMenuItemsListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            this.updateMenuShowingListeners(listChangeListener$Change.getRemoved(), false);
            this.updateMenuShowingListeners(listChangeListener$Change.getAddedSubList(), true);
        }
        this.itemsDirty = true;
        this.updateItems();
    };
    private ChangeListener<Boolean> menuItemVisibleListener = (observableValue, bl2, bl3) -> this.requestLayout();
    private ChangeListener<Boolean> subMenuShowingListener = (iterator, object2, bl2) -> {
        iterator = (ReadOnlyBooleanProperty)((Object)iterator);
        if (!((Window)((Object)(iterator = (ContextMenu)iterator.getBean()))).isShowing()) {
            for (Node node : this.itemsContainer.getChildren()) {
                Menu menu;
                if (!(node instanceof ContextMenuContent$MenuItemContainer) || !(((ContextMenuContent$MenuItemContainer)node).item instanceof Menu) || !(menu = (Menu)((ContextMenuContent$MenuItemContainer)node).item).isShowing()) continue;
                menu.hide();
            }
        }
    };
    private Menu openSubmenu;
    private ContextMenu submenu;
    Region selectedBackground;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("selected");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("disabled");
    private static final PseudoClass CHECKED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("checked");

    public ContextMenuContent(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
        this.clipRect = new Rectangle();
        this.clipRect.setSmooth(false);
        this.itemsContainer = new ContextMenuContent$MenuBox(this);
        this.itemsContainer.setClip(this.clipRect);
        ContextMenuContent contextMenuContent = this;
        this.upArrow = new ContextMenuContent$ArrowMenuItem(contextMenuContent, contextMenuContent);
        this.upArrow.setUp(true);
        this.upArrow.setFocusTraversable(false);
        ContextMenuContent contextMenuContent2 = this;
        this.downArrow = new ContextMenuContent$ArrowMenuItem(contextMenuContent2, contextMenuContent2);
        this.downArrow.setUp(false);
        this.downArrow.setFocusTraversable(false);
        this.getChildren().add(this.itemsContainer);
        this.getChildren().add(this.upArrow);
        this.getChildren().add(this.downArrow);
        this.initialize();
        this.setUpBinds();
        this.updateItems();
        contextMenu.showingProperty().addListener(this.weakPopupShowingListener);
        if (Utils.isTwoLevelFocus()) {
            new TwoLevelFocusPopupBehavior(this);
        }
    }

    public VBox getItemsContainer() {
        return this.itemsContainer;
    }

    int getCurrentFocusIndex() {
        return this.currentFocusedIndex;
    }

    void setCurrentFocusedIndex(int n2) {
        if (n2 < this.itemsContainer.getChildren().size()) {
            this.currentFocusedIndex = n2;
        }
    }

    private void updateItems() {
        if (this.itemsDirty) {
            this.updateVisualItems();
            this.itemsDirty = false;
        }
    }

    private void computeVisualMetrics() {
        EventTarget eventTarget;
        this.maxRightWidth = 0.0;
        this.maxLabelWidth = 0.0;
        this.maxRowHeight = 0.0;
        this.maxGraphicWidth = 0.0;
        this.maxLeftWidth = 0.0;
        for (int i2 = 0; i2 < this.itemsContainer.getChildren().size(); ++i2) {
            double d2;
            Node node = (Node)this.itemsContainer.getChildren().get(i2);
            if (!(node instanceof ContextMenuContent$MenuItemContainer) || !((Node)(eventTarget = (ContextMenuContent$MenuItemContainer)this.itemsContainer.getChildren().get(i2))).isVisible()) continue;
            node = ((ContextMenuContent$MenuItemContainer)eventTarget).left;
            if (node != null) {
                d2 = node.getContentBias() == Orientation.VERTICAL ? this.snapSizeY(node.prefHeight(-1.0)) : -1.0;
                this.maxLeftWidth = Math.max(this.maxLeftWidth, this.snapSizeX(node.prefWidth(d2)));
                this.maxRowHeight = Math.max(this.maxRowHeight, node.prefHeight(-1.0));
            }
            if ((node = ((ContextMenuContent$MenuItemContainer)eventTarget).graphic) != null) {
                d2 = node.getContentBias() == Orientation.VERTICAL ? this.snapSizeY(node.prefHeight(-1.0)) : -1.0;
                this.maxGraphicWidth = Math.max(this.maxGraphicWidth, this.snapSizeX(node.prefWidth(d2)));
                this.maxRowHeight = Math.max(this.maxRowHeight, node.prefHeight(-1.0));
            }
            if ((node = ((ContextMenuContent$MenuItemContainer)eventTarget).label) != null) {
                d2 = node.getContentBias() == Orientation.VERTICAL ? this.snapSizeY(node.prefHeight(-1.0)) : -1.0;
                this.maxLabelWidth = Math.max(this.maxLabelWidth, this.snapSizeX(node.prefWidth(d2)));
                this.maxRowHeight = Math.max(this.maxRowHeight, node.prefHeight(-1.0));
            }
            if ((node = ((ContextMenuContent$MenuItemContainer)eventTarget).right) == null) continue;
            d2 = node.getContentBias() == Orientation.VERTICAL ? this.snapSizeY(node.prefHeight(-1.0)) : -1.0;
            this.maxRightWidth = Math.max(this.maxRightWidth, this.snapSizeX(node.prefWidth(d2)));
            this.maxRowHeight = Math.max(this.maxRowHeight, node.prefHeight(-1.0));
        }
        double d3 = this.maxRightWidth + this.maxLabelWidth + this.maxGraphicWidth + this.maxLeftWidth;
        eventTarget = this.contextMenu.getOwnerWindow();
        if (eventTarget instanceof ContextMenu && this.contextMenu.getX() < ((Window)eventTarget).getX() && this.oldWidth != d3) {
            this.contextMenu.setX(this.contextMenu.getX() + this.oldWidth - d3);
        }
        this.oldWidth = d3;
    }

    private void updateVisualItems() {
        ObservableList<Node> observableList = this.itemsContainer.getChildren();
        this.disposeVisualItems();
        for (int i2 = 0; i2 < this.getItems().size(); ++i2) {
            Node node;
            MenuItem menuItem = (MenuItem)this.getItems().get(i2);
            if (menuItem instanceof CustomMenuItem && ((CustomMenuItem)menuItem).getContent() == null) continue;
            if (menuItem instanceof SeparatorMenuItem) {
                node = ((CustomMenuItem)menuItem).getContent();
                node.visibleProperty().bind(menuItem.visibleProperty());
                observableList.add(node);
                node.getProperties().put(MenuItem.class, menuItem);
                continue;
            }
            node = new ContextMenuContent$MenuItemContainer(this, menuItem);
            node.visibleProperty().bind(menuItem.visibleProperty());
            observableList.add(node);
        }
        if (this.getItems().size() > 0) {
            MenuItem menuItem = (MenuItem)this.getItems().get(0);
            this.getProperties().put(Menu.class, menuItem.getParentMenu());
        }
        NodeHelper.reapplyCSS(this);
    }

    private void disposeVisualItems() {
        ObservableList<Node> observableList = this.itemsContainer.getChildren();
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)observableList.get(i2);
            if (!(node instanceof ContextMenuContent$MenuItemContainer)) continue;
            node = (ContextMenuContent$MenuItemContainer)node;
            node.visibleProperty().unbind();
            ((ContextMenuContent$MenuItemContainer)node).dispose();
        }
        observableList.clear();
    }

    public void dispose() {
        this.disposeBinds();
        this.disposeVisualItems();
        ContextMenuContent contextMenuContent = this;
        contextMenuContent.disposeContextMenu(contextMenuContent.submenu);
        this.submenu = null;
        this.openSubmenu = null;
        this.selectedBackground = null;
        if (this.contextMenu != null) {
            this.contextMenu.getItems().clear();
            this.contextMenu = null;
        }
    }

    public void disposeContextMenu(ContextMenu eventTarget) {
        if (eventTarget == null) {
            return;
        }
        Skin<?> skin = ((PopupControl)eventTarget).getSkin();
        if (skin == null) {
            return;
        }
        ((Window)eventTarget).showingProperty().removeListener(this.subMenuShowingListener);
        eventTarget = (ContextMenuContent)skin.getNode();
        if (eventTarget == null) {
            return;
        }
        ((ContextMenuContent)eventTarget).dispose();
    }

    @Override
    protected void layoutChildren() {
        double d2;
        if (this.itemsContainer.getChildren().size() == 0) {
            return;
        }
        double d3 = this.snappedLeftInset();
        double d4 = this.snappedTopInset();
        double d5 = this.getWidth() - d3 - this.snappedRightInset();
        double d6 = this.getHeight() - d4 - this.snappedBottomInset();
        ContextMenuContent contextMenuContent = this;
        double d7 = contextMenuContent.snapSizeY(contextMenuContent.getContentHeight());
        ((Node)this.itemsContainer).resize(d5, d7);
        this.itemsContainer.relocate(d3, d4);
        if (d7 < Math.abs(this.ty)) {
            ContextMenuContent contextMenuContent2 = this;
            contextMenuContent2.scroll(Math.abs(contextMenuContent2.ty));
        }
        if (this.isFirstShow && this.ty == 0.0) {
            this.upArrow.setVisible(false);
            this.isFirstShow = false;
        } else {
            this.upArrow.setVisible(this.ty < d4 && this.ty < 0.0);
        }
        this.downArrow.setVisible(this.ty + d7 > d4 + d6);
        this.clipRect.setX(0.0);
        this.clipRect.setY(0.0);
        this.clipRect.setWidth(d5);
        this.clipRect.setHeight(d6);
        if (this.upArrow.isVisible()) {
            ContextMenuContent contextMenuContent3 = this;
            d2 = contextMenuContent3.snapSizeY(((Node)contextMenuContent3.upArrow).prefHeight(-1.0));
            ContextMenuContent contextMenuContent4 = this;
            this.clipRect.setHeight(contextMenuContent4.snapSizeY(contextMenuContent4.clipRect.getHeight() - d2));
            ContextMenuContent contextMenuContent5 = this;
            this.clipRect.setY(contextMenuContent5.snapSizeY(contextMenuContent5.clipRect.getY()) + d2);
            ContextMenuContent contextMenuContent6 = this;
            ((Node)this.upArrow).resize(contextMenuContent6.snapSizeX(((Node)contextMenuContent6.upArrow).prefWidth(-1.0)), d2);
            ContextMenuContent contextMenuContent7 = this;
            contextMenuContent7.positionInArea(contextMenuContent7.upArrow, d3, d4, d5, d2, 0.0, HPos.CENTER, VPos.CENTER);
        }
        if (this.downArrow.isVisible()) {
            ContextMenuContent contextMenuContent8 = this;
            d2 = contextMenuContent8.snapSizeY(((Node)contextMenuContent8.downArrow).prefHeight(-1.0));
            ContextMenuContent contextMenuContent9 = this;
            this.clipRect.setHeight(contextMenuContent9.snapSizeY(contextMenuContent9.clipRect.getHeight()) - d2);
            ContextMenuContent contextMenuContent10 = this;
            ((Node)this.downArrow).resize(contextMenuContent10.snapSizeX(((Node)contextMenuContent10.downArrow).prefWidth(-1.0)), d2);
            ContextMenuContent contextMenuContent11 = this;
            contextMenuContent11.positionInArea(contextMenuContent11.downArrow, d3, d4 + d6 - d2, d5, d2, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    @Override
    protected double computePrefWidth(double d2) {
        this.computeVisualMetrics();
        double d3 = 0.0;
        if (this.itemsContainer.getChildren().size() == 0) {
            return 0.0;
        }
        for (Node node : this.itemsContainer.getChildren()) {
            if (!node.isVisible()) continue;
            d3 = Math.max(d3, this.snapSizeX(node.prefWidth(-1.0)));
        }
        return this.snappedLeftInset() + this.snapSizeX(d3) + this.snappedRightInset();
    }

    @Override
    protected double computePrefHeight(double d2) {
        if (this.itemsContainer.getChildren().size() == 0) {
            return 0.0;
        }
        double d3 = this.getScreenHeight();
        double d4 = this.getContentHeight();
        double d5 = this.snappedTopInset() + this.snapSizeY(d4) + this.snappedBottomInset();
        double d6 = d3 <= 0.0 ? d5 : Math.min(d5, d3);
        return d6;
    }

    @Override
    protected double computeMinHeight(double d2) {
        return 0.0;
    }

    @Override
    protected double computeMaxHeight(double d2) {
        return this.getScreenHeight();
    }

    private double getScreenHeight() {
        if (this.contextMenu == null || this.contextMenu.getOwnerWindow() == null || this.contextMenu.getOwnerWindow().getScene() == null) {
            return -1.0;
        }
        ContextMenuContent contextMenuContent = this;
        return contextMenuContent.snapSizeY(com.sun.javafx.util.Utils.getScreen(contextMenuContent.contextMenu.getOwnerWindow().getScene().getRoot()).getVisualBounds().getHeight());
    }

    private double getContentHeight() {
        double d2 = 0.0;
        for (Node node : this.itemsContainer.getChildren()) {
            if (!node.isVisible()) continue;
            d2 += this.snapSizeY(node.prefHeight(-1.0));
        }
        return d2;
    }

    private void ensureFocusedMenuItemIsVisible(Node object) {
        if (object == null) {
            return;
        }
        object = ((Node)object).getBoundsInParent();
        Bounds bounds = this.clipRect.getBoundsInParent();
        if (((Bounds)object).getMaxY() >= bounds.getMaxY()) {
            this.scroll(-((Bounds)object).getMaxY() + bounds.getMaxY());
            return;
        }
        if (((Bounds)object).getMinY() <= bounds.getMinY()) {
            this.scroll(-((Bounds)object).getMinY() + bounds.getMinY());
        }
    }

    protected ObservableList<MenuItem> getItems() {
        return this.contextMenu.getItems();
    }

    private int findFocusedIndex() {
        for (int i2 = 0; i2 < this.itemsContainer.getChildren().size(); ++i2) {
            Node node = (Node)this.itemsContainer.getChildren().get(i2);
            if (!node.isFocused()) continue;
            return i2;
        }
        return -1;
    }

    private void initialize() {
        this.contextMenu.addEventHandler(Menu.ON_SHOWN, (? super T object) -> {
            this.currentFocusedIndex = -1;
            for (Node node : this.itemsContainer.getChildren()) {
                MenuItem menuItem;
                if (!(node instanceof ContextMenuContent$MenuItemContainer) || !"choice-box-menu-item".equals((menuItem = ((ContextMenuContent$MenuItemContainer)node).item).getId()) || !((RadioMenuItem)menuItem).isSelected()) continue;
                node.requestFocus();
                return;
            }
        });
        this.setOnKeyPressed(new ContextMenuContent$1(this));
        this.addEventHandler(ScrollEvent.SCROLL, (? super T scrollEvent) -> {
            double d2 = scrollEvent.getTextDeltaY();
            double d3 = scrollEvent.getDeltaY();
            if (this.downArrow.isVisible() && (d2 < 0.0 || d3 < 0.0) || this.upArrow.isVisible() && (d2 > 0.0 || d3 > 0.0)) {
                switch (scrollEvent.getTextDeltaYUnits()) {
                    case LINES: {
                        int n2 = this.findFocusedIndex();
                        if (n2 == -1) {
                            n2 = 0;
                        }
                        double d4 = ((Node)this.itemsContainer.getChildren().get(n2)).prefHeight(-1.0);
                        this.scroll(d2 * d4);
                        break;
                    }
                    case PAGES: {
                        this.scroll(d2 * this.itemsContainer.getHeight());
                        break;
                    }
                    case NONE: {
                        this.scroll(d3);
                    }
                }
                scrollEvent.consume();
            }
        });
    }

    private Optional<Node> getFocusedNode() {
        ObservableList<Node> observableList = this.itemsContainer.getChildren();
        boolean bl2 = this.currentFocusedIndex >= 0 && this.currentFocusedIndex < observableList.size();
        if (bl2) {
            return Optional.of((Node)observableList.get(this.currentFocusedIndex));
        }
        return Optional.empty();
    }

    private void processLeftKey(KeyEvent keyEvent) {
        this.getFocusedNode().ifPresent(eventTarget -> {
            if (eventTarget instanceof ContextMenuContent$MenuItemContainer && (eventTarget = ((ContextMenuContent$MenuItemContainer)eventTarget).item) instanceof Menu && (eventTarget = (Menu)eventTarget) == this.openSubmenu && this.submenu != null && this.submenu.isShowing()) {
                this.hideSubmenu();
                keyEvent.consume();
            }
        });
    }

    private void processRightKey(KeyEvent keyEvent) {
        this.getFocusedNode().ifPresent(node -> {
            MenuItem menuItem;
            if (node instanceof ContextMenuContent$MenuItemContainer && (menuItem = ((ContextMenuContent$MenuItemContainer)node).item) instanceof Menu) {
                if ((menuItem = (Menu)menuItem).isDisable()) {
                    return;
                }
                this.selectedBackground = (ContextMenuContent$MenuItemContainer)node;
                if (this.openSubmenu == menuItem && this.submenu != null && this.submenu.isShowing()) {
                    return;
                }
                this.showMenu((Menu)menuItem);
                keyEvent.consume();
            }
        });
    }

    private void showMenu(Menu eventTarget) {
        ((Menu)eventTarget).show();
        if (this.submenu == null) {
            return;
        }
        eventTarget = (ContextMenuContent)this.submenu.getSkin().getNode();
        if (eventTarget != null) {
            if (((ContextMenuContent)eventTarget).itemsContainer.getChildren().size() > 0) {
                ((Node)((ContextMenuContent)eventTarget).itemsContainer.getChildren().get(0)).requestFocus();
                ((ContextMenuContent)eventTarget).currentFocusedIndex = 0;
                return;
            }
            ((Node)eventTarget).requestFocus();
        }
    }

    private void selectMenuItem() {
        this.getFocusedNode().ifPresent(node -> {
            if (node instanceof ContextMenuContent$MenuItemContainer) {
                MenuItem menuItem = ((ContextMenuContent$MenuItemContainer)node).item;
                if (menuItem instanceof Menu) {
                    menuItem = (Menu)menuItem;
                    if (this.openSubmenu != null) {
                        this.hideSubmenu();
                    }
                    if (menuItem.isDisable()) {
                        return;
                    }
                    this.selectedBackground = (ContextMenuContent$MenuItemContainer)node;
                    ((Menu)menuItem).show();
                    return;
                }
                ((ContextMenuContent$MenuItemContainer)node).doSelect();
            }
        });
    }

    private void move(Direction direction) {
        int n2 = this.currentFocusedIndex != -1 ? this.currentFocusedIndex : this.itemsContainer.getChildren().size();
        ContextMenuContent contextMenuContent = this;
        contextMenuContent.requestFocusOnIndex(contextMenuContent.findSibling(direction, n2));
    }

    private int findSibling(Direction direction, int n2) {
        int n3 = this.itemsContainer.getChildren().size();
        int n4 = n2;
        do {
            n4 = direction.isForward() && n4 >= n3 - 1 ? 0 : (!direction.isForward() && n4 == 0 ? n3 - 1 : (n4 += direction.isForward() ? 1 : -1));
            Node node = (Node)this.itemsContainer.getChildren().get(n4);
            if (!(node instanceof ContextMenuContent$MenuItemContainer) || !node.isVisible()) continue;
            return n4;
        } while (n4 != n2);
        return -1;
    }

    public void requestFocusOnIndex(int n2) {
        this.currentFocusedIndex = n2;
        Node node = (Node)this.itemsContainer.getChildren().get(n2);
        this.selectedBackground = (ContextMenuContent$MenuItemContainer)node;
        node.requestFocus();
        this.ensureFocusedMenuItemIsVisible(node);
    }

    public double getMenuYOffset(int n2) {
        double d2 = 0.0;
        if (this.itemsContainer.getChildren().size() > n2) {
            d2 = this.snappedTopInset();
            Node node = (Node)this.itemsContainer.getChildren().get(n2);
            d2 += node.getLayoutY() + node.prefHeight(-1.0);
        }
        return d2;
    }

    public void disposeListeners() {
        if (this.contextMenu != null) {
            this.disposeBinds();
            this.contextMenu.showingProperty().removeListener(this.weakPopupShowingListener);
        }
    }

    private void setUpBinds() {
        ContextMenuContent contextMenuContent = this;
        contextMenuContent.updateMenuShowingListeners(contextMenuContent.contextMenu.getItems(), true);
        this.contextMenu.getItems().addListener(this.contextMenuItemsListener);
    }

    private void disposeBinds() {
        ContextMenuContent contextMenuContent = this;
        contextMenuContent.updateMenuShowingListeners(contextMenuContent.contextMenu.getItems(), false);
        this.contextMenu.getItems().removeListener(this.contextMenuItemsListener);
    }

    private void updateMenuShowingListeners(List<? extends MenuItem> object, boolean bl2) {
        object = object.iterator();
        while (object.hasNext()) {
            MenuItem menuItem = (MenuItem)object.next();
            if (menuItem instanceof Menu) {
                Menu menu = (Menu)menuItem;
                if (bl2) {
                    menu.showingProperty().addListener(this.menuShowingListener);
                } else {
                    menu.showingProperty().removeListener(this.menuShowingListener);
                }
            }
            if (bl2) {
                menuItem.visibleProperty().addListener(this.menuItemVisibleListener);
                continue;
            }
            menuItem.visibleProperty().removeListener(this.menuItemVisibleListener);
        }
    }

    ContextMenu getSubMenu() {
        return this.submenu;
    }

    Menu getOpenSubMenu() {
        return this.openSubmenu;
    }

    boolean isUpArrowVisible() {
        return this.upArrow.isVisible();
    }

    boolean isDownArrowVisible() {
        return this.downArrow.isVisible();
    }

    private void createSubmenu() {
        if (this.submenu == null) {
            this.submenu = new ContextMenu();
            this.submenu.showingProperty().addListener(this.subMenuShowingListener);
        }
    }

    private void showSubmenu(Menu menu) {
        this.openSubmenu = menu;
        this.createSubmenu();
        this.submenu.getItems().setAll((Collection<MenuItem>)menu.getItems());
        this.submenu.show(this.selectedBackground, Side.RIGHT, 0.0, 0.0);
    }

    private void hideSubmenu() {
        if (this.submenu == null) {
            return;
        }
        ((Window)this.submenu).hide();
        this.openSubmenu = null;
        ContextMenuContent contextMenuContent = this;
        contextMenuContent.disposeContextMenu(contextMenuContent.submenu);
        this.submenu = null;
        this.getFocusedNode().ifPresent(node -> {
            this.requestFocus();
            node.requestFocus();
        });
    }

    private void hideAllMenus(MenuItem menuItem) {
        Menu menu;
        if (this.contextMenu != null) {
            ((Window)this.contextMenu).hide();
        }
        while ((menu = menuItem.getParentMenu()) != null) {
            menu.hide();
            menuItem = menu;
        }
        if (menuItem.getParentPopup() != null) {
            ((Window)menuItem.getParentPopup()).hide();
        }
    }

    void scroll(double d2) {
        double d3 = this.ty + d2;
        if (this.ty == d3) {
            return;
        }
        if (d3 > 0.0) {
            d3 = 0.0;
        }
        if (d2 < 0.0 && this.getHeight() - d3 > this.itemsContainer.getHeight() - this.downArrow.getHeight()) {
            d3 = this.getHeight() - this.itemsContainer.getHeight() - this.downArrow.getHeight();
        }
        this.ty = d3;
        ((Parent)this.itemsContainer).requestLayout();
    }

    @Override
    public Styleable getStyleableParent() {
        return this.contextMenu;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ContextMenuContent$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ContextMenuContent.getClassCssMetaData();
    }

    public Label getLabelAt(int n2) {
        return ((ContextMenuContent$MenuItemContainer)this.itemsContainer.getChildren().get(n2)).getLabel();
    }
}

