/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.CustomColorDialog;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$1;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$2;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$3;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$4;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$5;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$6;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$7;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$8;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane$9;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;

class CustomColorDialog$ColorRectPane
extends HBox {
    private Pane colorRect;
    private Pane colorBar;
    private Pane colorRectOverlayOne;
    private Pane colorRectOverlayTwo;
    private Region colorRectIndicator;
    private Region colorBarIndicator;
    private boolean changeIsLocal = false;
    private DoubleProperty hue = new CustomColorDialog$ColorRectPane$1(this, -1.0);
    private DoubleProperty sat = new CustomColorDialog$ColorRectPane$2(this, -1.0);
    private DoubleProperty bright = new CustomColorDialog$ColorRectPane$3(this, -1.0);
    private IntegerProperty red = new CustomColorDialog$ColorRectPane$4(this, -1);
    private IntegerProperty green = new CustomColorDialog$ColorRectPane$5(this, -1);
    private IntegerProperty blue = new CustomColorDialog$ColorRectPane$6(this, -1);
    private DoubleProperty alpha = new CustomColorDialog$ColorRectPane$7(this, 100.0);
    final /* synthetic */ CustomColorDialog this$0;

    private void updateRGBColor() {
        Color color = Color.rgb(this.red.get(), this.green.get(), this.blue.get(), CustomColorDialog.clamp(this.alpha.get() / 100.0));
        this.hue.set(color.getHue());
        this.sat.set(color.getSaturation() * 100.0);
        this.bright.set(color.getBrightness() * 100.0);
        this.this$0.setCustomColor(color);
    }

    private void updateHSBColor() {
        Color color = Color.hsb(this.hue.get(), CustomColorDialog.clamp(this.sat.get() / 100.0), CustomColorDialog.clamp(this.bright.get() / 100.0), CustomColorDialog.clamp(this.alpha.get() / 100.0));
        this.red.set(CustomColorDialog.doubleToInt(color.getRed()));
        this.green.set(CustomColorDialog.doubleToInt(color.getGreen()));
        this.blue.set(CustomColorDialog.doubleToInt(color.getBlue()));
        this.this$0.setCustomColor(color);
    }

    private void colorChanged() {
        if (!this.changeIsLocal) {
            this.changeIsLocal = true;
            this.hue.set(this.this$0.getCustomColor().getHue());
            this.sat.set(this.this$0.getCustomColor().getSaturation() * 100.0);
            this.bright.set(this.this$0.getCustomColor().getBrightness() * 100.0);
            this.red.set(CustomColorDialog.doubleToInt(this.this$0.getCustomColor().getRed()));
            this.green.set(CustomColorDialog.doubleToInt(this.this$0.getCustomColor().getGreen()));
            this.blue.set(CustomColorDialog.doubleToInt(this.this$0.getCustomColor().getBlue()));
            this.changeIsLocal = false;
        }
    }

    public CustomColorDialog$ColorRectPane(CustomColorDialog object) {
        this.this$0 = object;
        this.getStyleClass().add("color-rect-pane");
        ((CustomColorDialog)object).customColorProperty().addListener((observableValue, color, color2) -> this.colorChanged());
        this.colorRectIndicator = new Region();
        this.colorRectIndicator.setId("color-rect-indicator");
        this.colorRectIndicator.setManaged(false);
        this.colorRectIndicator.setMouseTransparent(true);
        this.colorRectIndicator.setCache(true);
        StackPane stackPane = new StackPane();
        this.colorRect = new CustomColorDialog$ColorRectPane$8(this, (CustomColorDialog)object);
        this.colorRect.getStyleClass().addAll((String[])new String[]{"color-rect", "transparent-pattern"});
        Pane pane = new Pane();
        pane.backgroundProperty().bind(new CustomColorDialog$ColorRectPane$9(this, (CustomColorDialog)object));
        this.colorRectOverlayOne = new Pane();
        this.colorRectOverlayOne.getStyleClass().add("color-rect");
        this.colorRectOverlayOne.setBackground(new Background(new BackgroundFill(new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(255, 255, 255, 1.0)), new Stop(1.0, Color.rgb(255, 255, 255, 0.0))), CornerRadii.EMPTY, Insets.EMPTY)));
        object = mouseEvent -> {
            double d2 = mouseEvent.getX();
            double d3 = mouseEvent.getY();
            this.sat.set(CustomColorDialog.clamp(d2 / this.colorRect.getWidth()) * 100.0);
            this.bright.set(100.0 - CustomColorDialog.clamp(d3 / this.colorRect.getHeight()) * 100.0);
        };
        this.colorRectOverlayTwo = new Pane();
        this.colorRectOverlayTwo.getStyleClass().addAll((String[])new String[]{"color-rect"});
        this.colorRectOverlayTwo.setBackground(new Background(new BackgroundFill(new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(0, 0, 0, 0.0)), new Stop(1.0, Color.rgb(0, 0, 0, 1.0))), CornerRadii.EMPTY, Insets.EMPTY)));
        this.colorRectOverlayTwo.setOnMouseDragged((EventHandler<? super MouseEvent>)object);
        this.colorRectOverlayTwo.setOnMousePressed((EventHandler<? super MouseEvent>)object);
        object = new Pane();
        ((Node)object).setMouseTransparent(true);
        ((Node)object).getStyleClass().addAll((String[])new String[]{"color-rect", "color-rect-border"});
        this.colorBar = new Pane();
        this.colorBar.getStyleClass().add("color-bar");
        this.colorBar.setBackground(new Background(new BackgroundFill(CustomColorDialog.createHueGradient(), CornerRadii.EMPTY, Insets.EMPTY)));
        this.colorBarIndicator = new Region();
        this.colorBarIndicator.setId("color-bar-indicator");
        this.colorBarIndicator.setMouseTransparent(true);
        this.colorBarIndicator.setCache(true);
        this.colorRectIndicator.layoutXProperty().bind(((DoubleExpression)this.sat.divide(100)).multiply(this.colorRect.widthProperty()));
        this.colorRectIndicator.layoutYProperty().bind(Bindings.subtract(1, (ObservableNumberValue)this.bright.divide(100)).multiply(this.colorRect.heightProperty()));
        this.colorBarIndicator.layoutYProperty().bind(((DoubleExpression)this.hue.divide(360)).multiply(this.colorBar.heightProperty()));
        stackPane.opacityProperty().bind(this.alpha.divide(100));
        EventHandler<MouseEvent> eventHandler = mouseEvent -> {
            double d2 = mouseEvent.getY();
            this.hue.set(CustomColorDialog.clamp(d2 / this.colorRect.getHeight()) * 360.0);
        };
        this.colorBar.setOnMouseDragged(eventHandler);
        this.colorBar.setOnMousePressed(eventHandler);
        this.colorBar.getChildren().setAll((Node[])new Node[]{this.colorBarIndicator});
        stackPane.getChildren().setAll((Node[])new Node[]{pane, this.colorRectOverlayOne, this.colorRectOverlayTwo});
        this.colorRect.getChildren().setAll((Node[])new Node[]{stackPane, object, this.colorRectIndicator});
        HBox.setHgrow(this.colorRect, Priority.SOMETIMES);
        this.getChildren().addAll((Node[])new Node[]{this.colorRect, this.colorBar});
    }

    private void updateValues() {
        if (this.this$0.getCurrentColor() == null) {
            this.this$0.setCurrentColor(Color.TRANSPARENT);
        }
        this.changeIsLocal = true;
        this.hue.set(this.this$0.getCurrentColor().getHue());
        this.sat.set(this.this$0.getCurrentColor().getSaturation() * 100.0);
        this.bright.set(this.this$0.getCurrentColor().getBrightness() * 100.0);
        this.alpha.set(this.this$0.getCurrentColor().getOpacity() * 100.0);
        this.this$0.setCustomColor(Color.hsb(this.hue.get(), CustomColorDialog.clamp(this.sat.get() / 100.0), CustomColorDialog.clamp(this.bright.get() / 100.0), CustomColorDialog.clamp(this.alpha.get() / 100.0)));
        this.red.set(CustomColorDialog.doubleToInt(this.this$0.getCustomColor().getRed()));
        this.green.set(CustomColorDialog.doubleToInt(this.this$0.getCustomColor().getGreen()));
        this.blue.set(CustomColorDialog.doubleToInt(this.this$0.getCustomColor().getBlue()));
        this.changeIsLocal = false;
    }

    @Override
    protected void layoutChildren() {
        double d2;
        super.layoutChildren();
        this.colorRectIndicator.autosize();
        double d3 = d2 = Math.min(this.colorRect.getWidth(), this.colorRect.getHeight());
        ((Node)this.colorRect).resize(d3, d3);
        ((Node)this.colorBar).resize(this.colorBar.getWidth(), d2);
    }
}

