/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.CustomColorDialog$1;
import com.sun.javafx.scene.control.CustomColorDialog$ColorRectPane;
import com.sun.javafx.scene.control.CustomColorDialog$ControlsPane;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.WebColorField;
import com.sun.javafx.util.Utils;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class CustomColorDialog
extends HBox {
    private final Stage dialog = new Stage();
    private CustomColorDialog$ColorRectPane colorRectPane;
    private CustomColorDialog$ControlsPane controlsPane;
    private ObjectProperty<Color> currentColorProperty = new SimpleObjectProperty<Color>(Color.WHITE);
    private ObjectProperty<Color> customColorProperty = new SimpleObjectProperty<Color>(Color.TRANSPARENT);
    private Runnable onSave;
    private Runnable onUse;
    private Runnable onCancel;
    private WebColorField webField = null;
    private Scene customScene;
    private String saveBtnText;
    private boolean showUseBtn = true;
    private boolean showOpacitySlider = true;
    private final EventHandler<KeyEvent> keyEventListener = keyEvent -> {
        switch (keyEvent.getCode()) {
            case ESCAPE: {
                this.dialog.setScene(null);
                this.dialog.close();
            }
        }
    };
    private InvalidationListener positionAdjuster = new CustomColorDialog$1(this);

    public CustomColorDialog(Window eventTarget) {
        this.getStyleClass().add("custom-color-dialog");
        if (eventTarget != null) {
            this.dialog.initOwner((Window)eventTarget);
        }
        this.dialog.setTitle(Properties.getColorPickerString("customColorDialogTitle"));
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.setResizable(false);
        this.dialog.addEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.customScene = new Scene(this);
        eventTarget = ((Window)eventTarget).getScene();
        if (eventTarget != null) {
            if (((Scene)eventTarget).getUserAgentStylesheet() != null) {
                this.customScene.setUserAgentStylesheet(((Scene)eventTarget).getUserAgentStylesheet());
            }
            this.customScene.getStylesheets().addAll((Collection<String>)((Scene)eventTarget).getStylesheets());
        }
        this.buildUI();
        this.dialog.setScene(this.customScene);
    }

    private void buildUI() {
        this.colorRectPane = new CustomColorDialog$ColorRectPane(this);
        this.controlsPane = new CustomColorDialog$ControlsPane(this);
        CustomColorDialog.setHgrow(this.controlsPane, Priority.ALWAYS);
        this.getChildren().setAll((Node[])new Node[]{this.colorRectPane, this.controlsPane});
    }

    public void setCurrentColor(Color color) {
        this.currentColorProperty.set(color);
    }

    public final Color getCurrentColor() {
        return (Color)this.currentColorProperty.get();
    }

    public final ObjectProperty<Color> customColorProperty() {
        return this.customColorProperty;
    }

    public final void setCustomColor(Color color) {
        this.customColorProperty.set(color);
    }

    public final Color getCustomColor() {
        return (Color)this.customColorProperty.get();
    }

    public Runnable getOnSave() {
        return this.onSave;
    }

    public void setOnSave(Runnable runnable) {
        this.onSave = runnable;
    }

    public void setSaveBtnToOk() {
        this.saveBtnText = Properties.getColorPickerString("OK");
        this.buildUI();
    }

    public Runnable getOnUse() {
        return this.onUse;
    }

    public void setOnUse(Runnable runnable) {
        this.onUse = runnable;
    }

    public void setShowUseBtn(boolean bl2) {
        this.showUseBtn = bl2;
        this.buildUI();
    }

    public void setShowOpacitySlider(boolean bl2) {
        this.showOpacitySlider = bl2;
        this.buildUI();
    }

    public Runnable getOnCancel() {
        return this.onCancel;
    }

    public void setOnCancel(Runnable runnable) {
        this.onCancel = runnable;
    }

    public void setOnHidden(EventHandler<WindowEvent> eventHandler) {
        this.dialog.setOnHidden(eventHandler);
    }

    public Stage getDialog() {
        return this.dialog;
    }

    public void show() {
        if (this.dialog.getOwner() != null) {
            this.dialog.widthProperty().addListener(this.positionAdjuster);
            this.dialog.heightProperty().addListener(this.positionAdjuster);
            this.positionAdjuster.invalidated(null);
        }
        if (this.dialog.getScene() == null) {
            this.dialog.setScene(this.customScene);
        }
        this.colorRectPane.updateValues();
        this.dialog.show();
    }

    public void hide() {
        if (this.dialog.getOwner() != null) {
            this.dialog.hide();
        }
    }

    private void fixPosition() {
        Window window = this.dialog.getOwner();
        Object object = Utils.getScreen(window);
        object = ((Screen)object).getBounds();
        double d2 = window.getX() + window.getWidth();
        double d3 = window.getX() - this.dialog.getWidth();
        double d4 = ((Rectangle2D)object).getMaxX() >= d2 + this.dialog.getWidth() ? d2 : (((Rectangle2D)object).getMinX() <= d3 ? d3 : Math.max(((Rectangle2D)object).getMinX(), ((Rectangle2D)object).getMaxX() - this.dialog.getWidth()));
        double d5 = Math.max(((Rectangle2D)object).getMinY(), Math.min(((Rectangle2D)object).getMaxY() - this.dialog.getHeight(), window.getY()));
        this.dialog.setX(d4);
        this.dialog.setY(d5);
    }

    @Override
    public void layoutChildren() {
        super.layoutChildren();
        if (this.dialog.getMinWidth() > 0.0 && this.dialog.getMinHeight() > 0.0) {
            return;
        }
        CustomColorDialog customColorDialog = this;
        double d2 = Math.max(0.0, customColorDialog.computeMinWidth(customColorDialog.getHeight()) + (this.dialog.getWidth() - this.customScene.getWidth()));
        CustomColorDialog customColorDialog2 = this;
        double d3 = Math.max(0.0, customColorDialog2.computeMinHeight(customColorDialog2.getWidth()) + (this.dialog.getHeight() - this.customScene.getHeight()));
        this.dialog.setMinWidth(d2);
        this.dialog.setMinHeight(d3);
    }

    static double clamp(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 1.0;
        }
        return d2;
    }

    private static LinearGradient createHueGradient() {
        Stop[] stopArray = new Stop[255];
        for (int i2 = 0; i2 < 255; ++i2) {
            double d2 = 1.0 - 0.00392156862745098 * (double)i2;
            int n2 = (int)((double)i2 / 255.0 * 360.0);
            stopArray[i2] = new Stop(d2, Color.hsb(n2, 1.0, 1.0));
        }
        return new LinearGradient(0.0, 1.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, stopArray);
    }

    private static int doubleToInt(double d2) {
        return (int)(d2 * 255.0 + 0.5);
    }
}

